ENT.Type = "anim"
ENT.Base = "base_anim"
ENT.PrintName = "Spendentruhe"
ENT.Category = "Spenden"
ENT.Spawnable = true

function ENT:SetupDataTables()
	self:NetworkVar("Int", 0, "price")
	self:NetworkVar("Entity", 1, "owning_ent")
	self:NetworkVar("Float", 0, "MoneyInput")
end

function ENT:PhysgunPickup(ply)
	return ply == self:Getowning_ent() or ply:IsAdmin()
end

function ENT:CanTool(ply, trace, mode)
	return mode == "remover" and ply == self:Getowning_ent() or mode == "remover" and ply:IsAdmin()
end

hook.Add("canLockpick", "donation_box_lockpick", function(ply, ent, trace)
	if IsValid(ent) and ent:GetClass() == "donation_box" and ent.GetMoneyInput and ent:GetMoneyInput() > 0 then
		return true
	end
end)

local stealtime = 20
hook.Add("lockpickTime", "donation_box_lockpick", function(ply, ent)
	if IsValid(ent) and ent:GetClass() == "donation_box" then
		return stealtime
	end
end, HOOK_MONITOR_HIGH or -2)

if SERVER then
	local steal_money = 10000
	hook.Add("onLockpickCompleted", "donation_box_lockpick", function(ply, success, ent)
		if !IsValid(ent) or ent:GetClass() != "donation_box" then return end
		if success and ent:GetMoneyInput() > 0 then
			local money = math.min(ent:GetMoneyInput(), steal_money)
			ent:SetMoneyInput(ent:GetMoneyInput() - money)
			ply:addMoney(money)
			DarkRP.notify(ply, 0, 5, "Du hast $"..string.Comma(money).." von dieser Spendentruhe erbeutet.")
			hook.Run("donation_box_lockpickcompleted", ply, true, ent, money)
		else
			hook.Run("donation_box_lockpickcompleted", ply, false, ent)
		end
	end)
end