include("shared.lua")

local Farming_MenuOpened = false
net.Receive("WeedPlant_OpenLampMenu", function(len, ply)
	local ent, setup = net.ReadEntity(), net.ReadBool()
	if !IsValid(ent) then return end
	Farming_MenuOpened = true
	gui.EnableScreenClicker(true)
	local min, max = ent:WorldSpaceAABB()
	local pos = ((min + max) * 0.5):ToScreen()
	pos.x = math.Clamp(pos.x, 250, ScrW() - 250)
	pos.y = math.Clamp(pos.y, 176, ScrH() - 176)
	local buttons = {}
	if setup then
		local num = #buttons + 1
		buttons[num] = vgui.Create("DButton")
		buttons[num]:SetText("")
		buttons[num].Text = ent:GetActivated() and "Lampe ausschalten" or "Lampe anschalten"
		buttons[num]:ParentToHUD()
		buttons[num].Paint = function(self, w, h)
			local color_hover = self.IsHoveringOver and 220 or 255
			surface.SetDrawColor(color_hover, color_hover, color_hover, 255)
			surface.DrawRect(0, 0, w, h)
			surface.SetDrawColor(color_black)
			surface.DrawOutlinedRect(0, 0, w, h)
			draw.SimpleText(self.Text, "DermaDefaultBold", w / 2, h / 2 - 1, color_black, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		end
		buttons[num].PaintOver = function()
		end
		buttons[num].OnCursorEntered = function(self)
			self.IsHoveringOver = true
		end
		buttons[num].OnCursorExited = function(self)
			self.IsHoveringOver = false
		end
		buttons[num].DoClick = function(self)
			if setup and IsValid(ent) then
				net.Start("WeedPlant_TurnLamp")
					net.WriteEntity(ent)
				net.SendToServer()
			end
			for _,v in ipairs(buttons) do
				v:Remove()
			end
			Farming_MenuOpened = false
			gui.EnableScreenClicker(false)
		end
	end
	local num = #buttons + 1
	buttons[num] = vgui.Create("DButton")
	buttons[num]:SetText("")
	buttons[num].Text = !setup and "Lampe montieren" or "Lampe abmontieren"
	buttons[num]:ParentToHUD()
	buttons[num].Paint = function(self, w, h)
		local color_hover = self.IsHoveringOver and 220 or 255
		surface.SetDrawColor(color_hover, color_hover, color_hover, 255)
		surface.DrawRect(0, 0, w, h)
		surface.SetDrawColor(color_black)
		surface.DrawOutlinedRect(0, 0, w, h)
		draw.SimpleText(self.Text, "DermaDefaultBold", w / 2, h / 2 - 1, color_black, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
	end
	buttons[num].PaintOver = function()
	end
	buttons[num].OnCursorEntered = function(self)
		self.IsHoveringOver = true
	end
	buttons[num].OnCursorExited = function(self)
		self.IsHoveringOver = false
	end
	buttons[num].DoClick = function(self)
		if IsValid(ent) then
			net.Start("WeedPlant_MountLamp")
				net.WriteEntity(ent)
			net.SendToServer()
		end
		for _,v in ipairs(buttons) do
			v:Remove()
		end
		Farming_MenuOpened = false
		gui.EnableScreenClicker(false)
	end
	local num = #buttons + 1
	buttons[num] = vgui.Create("DButton")
	buttons[num]:SetText("")
	buttons[num].Text = "Fenster schließen"
	buttons[num]:ParentToHUD()
	local ply = LocalPlayer()
	buttons[num].Paint = function(self, w, h)
		if !IsValid(ent) or ent:GetNoDraw() or !ply:Alive() or ply:EyePos():DistToSqr(ent:GetPos()) > 36000 then
			for _,v in ipairs(buttons) do
				v:Remove()
			end
			Farming_MenuOpened = false
			gui.EnableScreenClicker(false)
			return
		end
		local color_hover = self.IsHoveringOver and 220 or 255
		surface.SetDrawColor(color_hover, color_hover, color_hover, 255)
		surface.DrawRect(0, 0, w, h)
		surface.SetDrawColor(color_black)
		surface.DrawOutlinedRect(0, 0, w, h)
		draw.SimpleText(self.Text, "DermaDefaultBold", w / 2, h / 2 - 1, color_black, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
	end
	buttons[num].PaintOver = function()
	end
	buttons[num].OnCursorEntered = function(self)
		self.IsHoveringOver = true
	end
	buttons[num].OnCursorExited = function(self)
		self.IsHoveringOver = false
	end
	buttons[num].DoClick = function(self)
		for _,v in ipairs(buttons) do
			v:Remove()
		end
		Farming_MenuOpened = false
		gui.EnableScreenClicker(false)
	end
	local longest = 0
	for _, v in ipairs(buttons) do
		surface.SetFont("DermaDefaultBold")
		local txtsize = surface.GetTextSize(v.Text)
		longest = txtsize > longest and txtsize or longest
	end
	longest = longest + 8
	for k, v in ipairs(buttons) do
		v:SetSize(longest, 25)
		v:SetPos(pos.x - longest / 2, pos.y + (k * 25))
		v:MakePopup()
		v:SetKeyboardInputEnabled(true)
	end
end)

local mat = Material("effects/com_shield004a")
local local_ply, ang, right, forward, pos, pos1, pos2, pos3, pos4
function ENT:Draw()
	self:DrawModel()
	if !self:GetActivated() then return end
	render.SetMaterial(mat)
	ang = self:GetAngles()
	right, forward = ang:Right(), ang:Forward()
	pos = self:GetPos()
	pos1 = Vector(pos.x + right.x * 8 + forward.x * -32, pos.y + right.y * 8 + forward.y * -32, pos.z + right.z * 8 + forward.z * -32)
	pos2 = Vector(pos.x + right.x * 8 + forward.x * 32, pos.y + right.y * 8 + forward.y * 32, pos.z + right.z * 8 + forward.z * 32)
	pos3 = Vector(pos.x + right.x * -8 + forward.x * 32, pos.y + right.y * -8 + forward.y * 32, pos.z + right.z * -8 + forward.z * 32)
	pos4 = Vector(pos.x + right.x * -8 + forward.x * -32, pos.y + right.y * -8 + forward.y * -32, pos.z + right.z * -8 + forward.z * -32)
	render.DrawQuad(pos1, pos2, pos3, pos4)
	local_ply = local_ply or LocalPlayer()
	if (local_ply:EyePos():DistToSqr(self:GetPos()) < 90000) and (local_ply:GetEyeTrace().Entity == self) then
		render.SetMaterial(mat)
		render.DrawSphere(pos - Vector(0, 0, 90), 100, 32, 32, color_white)
		local c_trace = {}
		c_trace.start = pos
		local nearest_ents = {}
		for _, v in ipairs(ents.FindInSphere(pos - Vector(0, 0, 100), 100)) do
			if v:GetClass() != "weed_plant" then continue end
			local pos_2 = v:GetPos()
			local vnormdot = ((pos - pos_2):GetNormalized()):Dot(self:GetUp())
			if vnormdot > 0.8 then
				c_trace.endpos = pos_2
				c_trace.filter = self
				local trace = util.TraceLine(c_trace)
				if trace.Entity == v then
					table.insert(nearest_ents, {v, pos_2:DistToSqr(pos)})
				end
			end
		end
		table.sort(nearest_ents, function(a, b) return a[2] < b[2] end)
		for k, v in ipairs(nearest_ents) do
			if k >= 3 then break end
			render.DrawLine(pos, v[1]:GetPos(), color_white)
		end
	end
end