include("shared.lua")

surface.CreateFont("mg_money_printer_large", {
	font = "Roboto",
	weight = 800,
	size = 128,
	shadow = true
})

surface.CreateFont("mg_money_printer_small", {
	font = "Roboto",
	weight = 800,
	size = 50,
	shadow = true
})

local color_white, color_black = color_white, color_black
local draw, surface = draw, surface
local cam_Start3D2D = cam.Start3D2D
local cam_End3D2D = cam.End3D2D
local draw_SimpleText = draw.SimpleText
local draw_SimpleTextOutlined = draw.SimpleTextOutlined
local surface_SetDrawColor = surface.SetDrawColor
local surface_DrawRect = surface.DrawRect
local surface_DrawOutlinedRect = surface.DrawOutlinedRect
local local_ply, pos, tb, dt
local off_color = Color(205, 0, 0, 255)
local lev, tab, Clr, Ang, exp, req, money, storage, multi, heat, overclocker, goal_xp, goal_money, goal_heat, Name, Owner
function ENT:Draw()
	self:DrawModel()
	local_ply = local_ply or LocalPlayer()
	pos = self:GetPos()
	tb = self:GetTable()
	dt = tb.dt
	if !dt then return end
	self:VisualCutoff(local_ply, pos, tb)
	if tb.Distance < 250000 then
		lev = dt.Level
		tab = sh_printer.LvlTbl[lev]
		Clr = tab.Clr
		Ang = self:GetAngles()
		Ang:RotateAroundAxis(Ang:Up(), 90)
		if sh_printer.UseOld then
			cam_Start3D2D(pos + Ang:Up() * 10.7 + Ang:Right() * -11 + Ang:Forward() * -10.1, Ang, 0.03)
				surface_SetDrawColor(35, 35, 35, 255)
				surface_DrawRect(-150, -160, 985, 995)
				surface_SetDrawColor(Clr.r, Clr.g, Clr.b, Clr.a)
				surface_DrawRect(-150, -160, 985, 140)
				exp = dt.Experience
				req = tab.ExpReq
				money = dt.StoredMoney
				storage = dt.StorageSize
				multi = dt.Multiplier
				heat = dt.Temperature
				goal_xp = (exp / req) * 955
				if tb.ExpProgress != goal_xp then
					tb.ExpProgress = tb.ExpProgress or 0
					tb.ExpProgress = Lerp(FrameTime() * 8, tb.ExpProgress, goal_xp)
				end
				goal_money = (money / storage) * 955
				if tb.MoneyProgress != goal_money then
					tb.MoneyProgress = tb.MoneyProgress or 0
					tb.MoneyProgress = Lerp(FrameTime() * 8, tb.MoneyProgress, goal_money)
				end
				goal_heat = (heat / 100) * 955
				if tb.HeatProgress != goal_heat then
					tb.HeatProgress = tb.HeatProgress or 0
					tb.HeatProgress = Lerp(FrameTime() * 8, tb.HeatProgress, goal_heat)
				end
				Name = DarkRP.getPhrase("money_printer").." (Lv."..lev..")"
				Owner = IsValid(dt.owning_ent) and dt.owning_ent:Name() or "Niemand"
				if tb.Distance < 40000 then
					draw_SimpleTextOutlined(Name, "mg_money_printer_large", 342, -90, !dt.On and off_color or color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
				else
					draw_SimpleText(Name, "mg_money_printer_large", 342, -90, color_black, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
					draw_SimpleText(Name, "mg_money_printer_large", 340, -90, !dt.On and off_color or color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
				end
				draw_SimpleText("Besitzer: "..Owner, "mg_money_printer_small", -140, 20, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				draw_SimpleText("Druckmulti: x"..math.Round(multi, 2), "mg_money_printer_small", -140, 70, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				draw_SimpleText("Druckmenge: $"..math.ceil(sh_printer.PrintAmount * multi), "mg_money_printer_small", -140, 120, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				draw_SimpleText("Druckintervall: "..dt.PrintSpeed.."s", "mg_money_printer_small", -140, 170, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				local base = 20
				for i=1, sh_printer.MaxMods do
					if dt["Mod"..i] > 0 then
						local mod = sh_printer.ModTbl[dt["Mod"..i]]
						draw_SimpleText(mod.Name.." aktiv", "mg_money_printer_small", 820, base, color_white, TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
						base = base + 50
					end
				end

				surface_SetDrawColor(Clr.r, Clr.g, Clr.b, Clr.a)
				surface_DrawRect(-150, 250, 985, 140)
				surface_SetDrawColor(Clr.r, Clr.g, Clr.b, Clr.a)
				local OverviewText = "Übersicht"
				draw_SimpleText(OverviewText, "mg_money_printer_large", 342, 320, color_black, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
				draw_SimpleText(OverviewText, "mg_money_printer_large", 340, 320, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
				draw_SimpleText("Erfahrung: "..string.Comma(exp).."/"..string.Comma(req), "mg_money_printer_small", -140, 450, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				surface_DrawOutlinedRect(-135, 490, 955, 40)
				surface_DrawRect(-135, 490, tb.ExpProgress, 40)
				draw_SimpleText("Geld: $"..string.Comma(money).."/"..string.Comma(storage), "mg_money_printer_small", -140, 570, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				surface_DrawOutlinedRect(-135, 610, 955, 40)
				surface_DrawRect(-135, 610, tb.MoneyProgress, 40)
				draw_SimpleText("Temperatur", "mg_money_printer_small", -140, 690, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				if heat >= 75 then
					surface_SetDrawColor(225, 0, 0, 255)
				else
					surface_SetDrawColor(Clr.r, Clr.g, Clr.b, Clr.a)
				end
				surface_DrawOutlinedRect(-135, 730, 955, 40)
				surface_DrawRect(-135, 730, tb.HeatProgress, 40)
			cam_End3D2D()
		else
			cam_Start3D2D(pos + Ang:Up() * 17.2 + Ang:Right() * -6.8 + Ang:Forward() * -21.5, Ang, 0.03)
				surface_SetDrawColor(35, 35, 35, 255)
				surface_DrawRect(-150, -160, 1020, 392)
				surface_SetDrawColor(Clr.r, Clr.g, Clr.b, Clr.a)
				surface_DrawRect(-150, -160, 1020, 140)
				exp = dt.Experience
				req = tab.ExpReq
				money = dt.StoredMoney
				storage = dt.StorageSize
				multi = dt.Multiplier
				heat = dt.Temperature
				goal_xp = (exp / req) * 990
				if tb.ExpProgress != goal_xp then
					tb.ExpProgress = tb.ExpProgress or 0
					tb.ExpProgress = Lerp(FrameTime() * 8, tb.ExpProgress, goal_xp)
				end
				goal_money = (money / storage) * 990
				if tb.MoneyProgress != goal_money then
					tb.MoneyProgress = tb.MoneyProgress or 0
					tb.MoneyProgress = Lerp(FrameTime() * 8, tb.MoneyProgress, goal_money)
				end
				goal_heat = (heat / 100) * 990
				if tb.HeatProgress != goal_heat then
					tb.HeatProgress = tb.HeatProgress or 0
					tb.HeatProgress = Lerp(FrameTime() * 8, tb.HeatProgress, goal_heat)
				end
				Name = DarkRP.getPhrase("money_printer").." (Lv."..lev..")"
				Owner = IsValid(dt.owning_ent) and dt.owning_ent:Name() or "Niemand"
				draw_SimpleText(Name, "mg_money_printer_large", 362, -90, color_black, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
				draw_SimpleText(Name, "mg_money_printer_large", 360, -90, !dt.On and off_color or color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
				draw_SimpleText("Besitzer: "..Owner, "mg_money_printer_small", -140, 20, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				draw_SimpleText("Druckmulti: x"..math.Round(multi, 2), "mg_money_printer_small", -140, 70, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				draw_SimpleText("Druckmenge: $"..math.ceil(sh_printer.PrintAmount * multi).." in "..dt.PrintSpeed.."s", "mg_money_printer_small", -140, 120, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				local base = 20
				for i=1, sh_printer.MaxMods do
					if dt["Mod"..i] > 0 then
						local mod = sh_printer.ModTbl[dt["Mod"..i]]
						draw_SimpleText(mod.Name.." aktiv", "mg_money_printer_small", 860, base, color_white, TEXT_ALIGN_RIGHT, TEXT_ALIGN_CENTER)
						base = base + 50
					end
				end
			cam_End3D2D()

			Ang:RotateAroundAxis(Ang:Forward(), 90)
			cam_Start3D2D(pos + Ang:Up() * 17.5 + Ang:Right() * -8.1 + Ang:Forward() * -20.85, Ang, 0.03)
				surface_SetDrawColor(35, 35, 35, 255)
				surface_DrawRect(-150, -160, 1020, 392)
				surface_SetDrawColor(Clr.r, Clr.g, Clr.b, Clr.a)
				draw_SimpleText("Erfahrung: "..string.Comma(exp).."/"..string.Comma(req), "mg_money_printer_small", -140, -90, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				surface_DrawOutlinedRect(-135, -60, 990, 40)
				surface_DrawRect(-135, -60, tb.ExpProgress, 40)
				draw_SimpleText("Geld: $"..string.Comma(money).."/"..string.Comma(storage), "mg_money_printer_small", -140, 10, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				surface_DrawOutlinedRect(-135, 40, 990, 40)
				surface_DrawRect(-135, 40, tb.MoneyProgress, 40)
				draw_SimpleText("Temperatur", "mg_money_printer_small", -140, 110, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
				if heat >= 75 then
					surface_SetDrawColor(225, 0, 0, 255)
				else
					surface_SetDrawColor(Clr.r, Clr.g, Clr.b, Clr.a)
				end
				surface_DrawOutlinedRect(-135, 140, 990, 40)
				surface_DrawRect(-135, 140, tb.HeatProgress, 40)
			cam_End3D2D()
		end
	end
end

function ENT:VisualCutoff(local_ply, pos, tb)
	local cur_time = CurTime()
	if (tb.LastDistanceCheck or 0) > cur_time then return end
	tb.LastDistanceCheck = cur_time + 0.1
	tb.Distance = pos:DistToSqr(local_ply:EyePos())
end

local printsound = Sound("ambient/levels/labs/equipment_printer_loop1.wav")
function ENT:StartSounds(tb, dt)
	self:StopSounds(tb)
	tb.PrintSound = CreateSound(self, printsound)
	tb.PrintSound:SetSoundLevel(dt.Noise)
	tb.PrintSound:PlayEx(1, 100)
end

function ENT:ActivateSounds(tb, dt)
	if tb.PrintSound and tb.PrintSound:GetSoundLevel() == dt.Noise then
		if tb.PrintSound:IsPlaying() then
			tb.PrintSound:ChangeVolume(1, 0.1)
		end
	else
		self:StartSounds(tb, dt)
	end
end

function ENT:StopSounds(tb)
	tb = tb or self:GetTable()
	if tb.PrintSound then
		tb.PrintSound:Stop()
		tb.PrintSound = nil
	end
end

function ENT:Think()
	local tb = self:GetTable()
	if !tb then return end
	local dt = tb.dt
	if !dt then return end
	if dt.On then
		self:ActivateSounds(tb, dt)
	else
		self:StopSounds(tb)
	end
end

function ENT:OnRemove()
	self:StopSounds()
end

local use_font = system.IsWindows() and "Tahoma" or "Verdana"
surface.CreateFont("mg_money_printer_close", {
	font = use_font,
	size = 13,
	weight = 1000
})

surface.CreateFont("mg_money_printer_upgrade", {
	font = use_font,
	size = 16,
	weight = 500
})

surface.CreateFont("mg_money_printer_upgrade_desc", {
	font = use_font,
	size = 12,
	weight = 500
})

local cl_printer = {}
function cl_printer.OpenMenu()
	local Printer = net.ReadEntity()
	if !IsValid(Printer) then return end
	if IsValid(cl_printer.Menu) then return end
	local mods_count = #sh_printer.ModTbl
	local Tab = sh_printer.LvlTbl[Printer:GetLevel()]
	if !Tab then return end
	local Clr = Tab.Clr
	cl_printer.Menu = vgui.Create("DFrame")
	cl_printer.Menu:SetSize(200, mods_count > 0 and 120 or 100)
	cl_printer.Menu:SetTitle("Gelddrucker Lv. "..Printer:GetLevel().." ("..math.floor((Printer:GetExperience() / Tab.ExpReq) * 100).."%)")
	cl_printer.Menu:SetPos(ScrW() / 2 - cl_printer.Menu:GetWide() / 2, ScrH())
	cl_printer.Menu:MoveTo(ScrW() / 2 - cl_printer.Menu:GetWide() / 2, ScrH() / 2 - cl_printer.Menu:GetTall() / 2, 0.25, 0, 0.5)
	cl_printer.Menu:MakePopup()
	cl_printer.Menu:ShowCloseButton(false)
	cl_printer.Menu:ParentToHUD()
	local ply = LocalPlayer()
	cl_printer.Menu.Think = function()
		if !IsValid(Printer) or Printer:GetNoDraw() or !ply:Alive() or ply:EyePos():DistToSqr(Printer:GetPos()) > 12000 then
			cl_printer.Menu:Remove()
		else
			cl_printer.Menu:SetTitle("Gelddrucker Lv. "..Printer:GetLevel().." ("..math.floor((Printer:GetExperience() / Tab.ExpReq) * 100).."%)")
			Clr = sh_printer.LvlTbl[Printer:GetLevel()].Clr
		end
	end
	function cl_printer.Menu:Paint(w, h)
		draw.RoundedBox(2, 0, 0, w, h, Color(Clr.r, Clr.g, Clr.b, Clr.a))
		draw.RoundedBox(2, 2, 2, w - 4, h - 4, Color(35, 35, 35, 255))
	end
	local Close = vgui.Create("DButton", cl_printer.Menu)
	Close:SetSize(50, 20)
	Close:SetPos(cl_printer.Menu:GetWide() - 52, 2)
	Close:SetText("X")
	Close:SetFont("mg_money_printer_close")
	Close:SetTextColor(color_white)
	Close.Paint = function(self, w, h)
		local col
		if self:IsHovered() then
			col = Color(255, 100, 100)
		else
			col = Color(200, 50, 50)
		end
		draw.RoundedBox(0, 0, 0, w, h, col)
	end
	Close.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		cl_printer.Menu:Remove()
	end
	local StartStopButton = vgui.Create("DButton", cl_printer.Menu)
	StartStopButton:SetSize(180, 20)
	StartStopButton:SetPos(10, 30)
	StartStopButton.DoClick = function()
		if IsValid(Printer) then
			net.Start("MoneyPrinter_DoPrinterAction")
				net.WriteEntity(Printer)
				net.WriteUInt(1, 16)
			net.SendToServer()
		end
		if IsValid(cl_printer.Menu) then
			surface.PlaySound("ui/buttonclick.wav")
			cl_printer.Menu:Remove()
		end
	end
	StartStopButton.Think = function()
		if IsValid(Printer) then
			if Printer:GetOn() then
				StartStopButton:SetText("Drucker stoppen")
			else
				StartStopButton:SetText("Drucker starten")
			end
		end
	end
	local PickupMoneyButton = vgui.Create("DButton", cl_printer.Menu)
	PickupMoneyButton:SetSize(180, 20)
	PickupMoneyButton:SetPos(10, 50)
	PickupMoneyButton:SetText("Geld entnehmen ($"..string.Comma(Printer:GetStoredMoney())..")")
	PickupMoneyButton.DoClick = function()
		if IsValid(Printer) then
			net.Start("MoneyPrinter_DoPrinterAction")
				net.WriteEntity(Printer)
				net.WriteUInt(2, 16)
			net.SendToServer()
		end
		if IsValid(cl_printer.Menu) then
			cl_printer.Menu:Remove()
		end
	end
	PickupMoneyButton.Think = function()
		if IsValid(Printer) then
			PickupMoneyButton:SetText("Geld entnehmen ($"..string.Comma(Printer:GetStoredMoney())..")")
			if Printer:GetStoredMoney() > 0 then
				PickupMoneyButton:SetDisabled(false)
			elseif Printer:GetStoredMoney() <= 0 then
				PickupMoneyButton:SetDisabled(true)
			end
		end
	end
	local PickStartStop = vgui.Create("DButton", cl_printer.Menu)
	PickStartStop:SetSize(180, 20)
	PickStartStop:SetPos(10, 70)
	PickStartStop:SetText("Geld nehmen & "..(Printer:GetOn() and "stoppen" or "starten"))
	PickStartStop.DoClick = function()
		if IsValid(Printer) then
			net.Start("MoneyPrinter_DoPrinterAction")
				net.WriteEntity(Printer)
				net.WriteUInt(5, 16)
			net.SendToServer()
		end
		if IsValid(cl_printer.Menu) then
			cl_printer.Menu:Remove()
		end
	end
	PickStartStop.Think = function()
		if IsValid(Printer) then
			PickStartStop:SetText("Geld nehmen & "..(Printer:GetOn() and "stoppen" or "starten"))
			if Printer:GetStoredMoney() > 0 then
				PickStartStop:SetDisabled(false)
			elseif Printer:GetStoredMoney() <= 0 then
				PickStartStop:SetDisabled(true)
			end
		end
	end
	if mods_count > 0 then
		local ManageButton = vgui.Create("DButton", cl_printer.Menu)
		ManageButton:SetSize(180, 20)
		ManageButton:SetPos(10, 90)
		ManageButton:SetText("Mods verwalten")
		ManageButton.DoClick = function()
			if IsValid(cl_printer.ModFrame) then return end
			surface.PlaySound("ui/buttonclick.wav")
			cl_printer.ModFrame = vgui.Create("DFrame")
			cl_printer.ModFrame:SetSize(500, 50 + (mods_count * 66))
			cl_printer.ModFrame:SetTitle("Gelddrucker Lv. "..Printer:GetLevel()..": Mods verwalten")
			cl_printer.ModFrame:SetPos(ScrW() / 2 - cl_printer.ModFrame:GetWide() / 2, ScrH())
			cl_printer.ModFrame:MoveTo(ScrW() / 2 - cl_printer.ModFrame:GetWide() / 2, ScrH() / 2 - cl_printer.ModFrame:GetTall() / 2, 0.25, 0, 0.5)
			cl_printer.ModFrame:MakePopup()
			cl_printer.ModFrame:ShowCloseButton(false)
			cl_printer.ModFrame:ParentToHUD()
			cl_printer.ModFrame.Think = function()
				if !IsValid(cl_printer.Menu) or !IsValid(Printer) or Printer:GetNoDraw() or !ply:Alive() or ply:EyePos():DistToSqr(Printer:GetPos()) > 12000 then
					cl_printer.ModFrame:Remove()
				else
					cl_printer.ModFrame:SetTitle("Gelddrucker Lv. "..Printer:GetLevel()..": Mods verwalten")
				end
			end
			function cl_printer.ModFrame:Paint(w, h)
				draw.RoundedBox(2, 0, 0, w, h, Color(Clr.r, Clr.g, Clr.b, Clr.a))
				draw.RoundedBox(2, 2, 2, w - 4, h - 4, Color(35, 35, 35, 255))
			end
			local Close = vgui.Create("DButton", cl_printer.ModFrame)
			Close:SetSize(50, 20)
			Close:SetPos(cl_printer.ModFrame:GetWide() - 52, 2)
			Close:SetText("X")
			Close:SetFont("mg_money_printer_close")
			Close:SetTextColor(color_white)
			Close.Paint = function(self, w, h)
				local col
				if self:IsHovered() then
					col = Color(255, 100, 100)
				else
					col = Color(200, 50, 50)
				end
				draw.RoundedBox(0, 0, 0, w, h, col)
			end
			Close.DoClick = function()
				surface.PlaySound("ui/buttonclick.wav")
				cl_printer.ModFrame:Remove()
			end
			local Installed = vgui.Create("DLabel", cl_printer.ModFrame)
			Installed:SetPos(10, cl_printer.ModFrame:GetTall() - 20)
			Installed:SetFont("mg_money_printer_upgrade")
			Installed:SetText("Installierte Mods: "..Printer:GetModsInstalled().." / "..sh_printer.MaxMods)
			Installed:SizeToContents()
			Installed.Think = function()
				if IsValid(Printer) then
					Installed:SetText("Installierte Mods: "..Printer:GetModsInstalled().." / "..sh_printer.MaxMods)
				end
			end
			local ModList = vgui.Create("DScrollPanel", cl_printer.ModFrame)
			ModList:SetPos(10, 30)
			ModList:SetSize(cl_printer.ModFrame:GetWide() - 20, cl_printer.ModFrame:GetTall() - 50)
			ModList.Paint = function(self, w, h)
				draw.RoundedBox(0, 1, 1, w, h, Color(50, 50, 50, 100))
			end
			for k, v in ipairs(sh_printer.ModTbl) do
				local ModPanel = vgui.Create("DFrame", ModList)
				ModPanel:SetTall(55 + 11)
				ModPanel:Dock(TOP)
				ModPanel:SetTitle("")
				ModPanel:ShowCloseButton(false)
				ModPanel:SetDraggable(false)
				ModPanel.Paint = function(self, w, h)
					draw.RoundedBox(0, 0, 0, w - 1, h - 1, Color(60, 60, 60, 255))
				end
				local Icon = vgui.Create("SpawnIcon", ModPanel)
				Icon:SetModel(v.Model)
				Icon:SetSize(55, 55)
				Icon:SetPos(5, 5)
				Icon:SetMouseInputEnabled(false)
				local Name = vgui.Create("DLabel", ModPanel)
				Name:SetPos(55 + 15, 5)
				Name:SetFont("mg_money_printer_upgrade")
				Name:SetText(v.Name..(v.VIP and " ★" or ""))
				Name:SizeToContents()
				local Desc = vgui.Create("DLabel", ModPanel)
				Desc:SetPos(55 + 15, 20)
				Desc:SetFont("mg_money_printer_upgrade_desc")
				Desc:SetText(v.Desc)
				Desc:SizeToContents()
				local Price = vgui.Create("DLabel", ModPanel)
				Price:SetPos(55 + 15, 45)
				Price:SetFont("mg_money_printer_upgrade")
				Price:SetText("Preis: $"..string.Comma(v.Price))
				Price:SizeToContents()
				Price.Think = function()
					if IsValid(Printer) and Printer:HasInstalled(k) then
						Price:SetText("Verkaufspreis: $"..string.Comma(math.floor(v.Price * sh_printer.SellMult)))
					else
						Price:SetText("Preis: $"..string.Comma(v.Price))
					end
					Price:SizeToContents()
				end
				local Buy = vgui.Create("DButton", ModPanel)
				Buy:SetSize(70, 20)
				Buy:SetPos(ModList:GetWide() - 150, 35)
				Buy:SetText("Kaufen")
				Buy.Think = function()
					if IsValid(Printer) and !Printer:HasInstalled(k) and Printer:GetModsInstalled() < sh_printer.MaxMods and ply:canAfford(v.Price) then
						Buy:SetDisabled(false)
					else
						Buy:SetDisabled(true)
					end
				end
				Buy.DoClick = function()
					if IsValid(Printer) then
						net.Start("MoneyPrinter_DoPrinterAction")
							net.WriteEntity(Printer)
							net.WriteUInt(3, 16)
							net.WriteUInt(k, 16)
						net.SendToServer()
					end
				end
				local Sell = vgui.Create("DButton", ModPanel)
				Sell:SetSize(70, 20)
				Sell:SetPos(ModList:GetWide() - 75, 35)
				Sell:SetText("Verkaufen")
				Sell.Think = function()
					if IsValid(Printer) and Printer:HasInstalled(k) then
						Sell:SetDisabled(false)
					else
						Sell:SetDisabled(true)
					end
				end
				Sell.DoClick = function()
					if IsValid(Printer) then
						net.Start("MoneyPrinter_DoPrinterAction")
							net.WriteEntity(Printer)
							net.WriteUInt(4, 16)
							net.WriteUInt(k, 16)
						net.SendToServer()
					end
				end
			end
		end
	end
end
net.Receive("MoneyPrinter_OpenPrinterMenu", cl_printer.OpenMenu)