ENT.Type = "anim"
ENT.Base = "base_anim"
ENT.PrintName = "Gelddrucker"
ENT.Category = "Gelddrucker"
ENT.Spawnable = true
ENT.IsMoneyPrinter = true

sh_printer = {}
sh_printer.PrintAmount = 30
sh_printer.HeatAmount = 1
sh_printer.FullHeatMult = 1
sh_printer.CoolMult = 5
sh_printer.InactiveHeatMult = 0.5
sh_printer.ExpAmount = 25
sh_printer.PrintDelay = 10
sh_printer.MaxMods = 3
sh_printer.SellMult = 0.5

sh_printer.Accessable = true
sh_printer.Safe = true

sh_printer.UseOld = true
sh_printer.ColorCase = false

sh_printer.LvlTbl = {}
sh_printer.LvlTbl[1] = {ExpReq = 250, PrintMul = 1, StorageSize = 3000, Clr = Color(0, 205, 0, 255)}
sh_printer.LvlTbl[2] = {ExpReq = 500, PrintMul = 1.25, StorageSize = 3500, Clr = Color(55, 180, 205, 255)}
sh_printer.LvlTbl[3] = {ExpReq = 750, PrintMul = 1.5, StorageSize = 4000, Clr = Color(200, 200, 100, 255)}
sh_printer.LvlTbl[4] = {ExpReq = 1000, PrintMul = 1.75, StorageSize = 4500, Clr = Color(170, 0, 165, 255)}
sh_printer.LvlTbl[5] = {ExpReq = 1250, PrintMul = 2, StorageSize = 5000, Clr = Color(190, 50, 50, 255)}
sh_printer.LvlTbl[6] = {ExpReq = 1500, PrintMul = 2.25, StorageSize = 5500, Clr = Color(0, 175, 100, 255)}
sh_printer.LvlTbl[7] = {ExpReq = 1750, PrintMul = 2.5, StorageSize = 6000, Clr = Color(55, 100, 100, 255)}
sh_printer.LvlTbl[8] = {ExpReq = 2000, PrintMul = 2.75, StorageSize = 6500, Clr = Color(255, 150, 0, 255)}
sh_printer.LvlTbl[9] = {ExpReq = 2250, PrintMul = 3, StorageSize = 7000, Clr = Color(200, 50, 165, 25)}
sh_printer.LvlTbl[10] = {ExpReq = 2500, PrintMul = 3.5, StorageSize = 8000, Clr = Color(255, 0, 0, 155), CaseClr = Color(200, 0, 0, 255)}

sh_printer.ModTbl = {}
sh_printer.ModTbl[1] = {Name = "Tuner", Model = "models/props_lab/reciever01d.mdl", Desc = "x0.5 erhöhter Multi", Price = 2000, Mult = 0.5}
sh_printer.ModTbl[2] = {Name = "Kühler", Model = "models/props_lab/reciever01a.mdl", Desc = "50% reduzierte Hitze", Price = 3000, Cool = 0.5}
sh_printer.ModTbl[3] = {Name = "Overclocker", Model = "models/props_lab/reciever01b.mdl", Desc = "25% erhöhte Geschwindigkeit\n10% mehr Hitze", Price = 6000, Speed = 2.5, Cool = -0.1, VIP = true}
sh_printer.ModTbl[4] = {Name = "Großer Speicher", Model = "models/props_c17/suitcase_passenger_physics.mdl", Desc = "100% mehr Speicher", Storage = 1, Price = 3000}
sh_printer.ModTbl[5] = {Name = "Leiser Motor", Model = "models/props_c17/trappropeller_engine.mdl", Desc = "Verringerte Lautstärke", Noise = 15, Price = 4000}
sh_printer.ModTbl[6] = {Name = "Sicherung", Model = "models/props_wasteland/prison_padlock001a.mdl", Desc = "Schaltet Drucker bei 75% Hitze automatisch aus", Safe = true, Price = 8000}
sh_printer.ModTbl[7] = {Name = "Lernmodul", Model = "models/props_lab/labpart.mdl", Desc = "20% erhöhter XP-Gewinn", XPMult = 0.2, Price = 4000}

function ENT:SetupDataTables()
	self:NetworkVar("Int", 0, "price")
	self:NetworkVar("Entity", 0, "owning_ent")
	self:NetworkVar("Bool", 0, "On")
	self:NetworkVar("Float", 0, "PrintSpeed")
	self:NetworkVar("Float", 1, "Multiplier")
	self:NetworkVar("Float", 2, "Temperature")
	self:NetworkVar("Float", 3, "Noise")
	self:NetworkVar("Int", 1, "Experience")
	self:NetworkVar("Int", 2, "Level")
	self:NetworkVar("Int", 3, "StoredMoney")
	self:NetworkVar("Int", 4, "StorageSize")
	local cnt = 4
	for i=1, sh_printer.MaxMods do
		cnt = cnt + 1
		self:NetworkVar("Int", cnt, "Mod"..i)
	end
	self:NetworkVar("Int", cnt + 1, "ModsInstalled")
end

function ENT:HasInstalled(id)
	for i=1, sh_printer.MaxMods do
		if self.dt and self.dt["Mod"..i] == id then
			return i
		end
	end
	return false
end

function ENT:PhysgunPickup(ply)
	return ply:IsAdmin()
end

function ENT:CanTool(ply, trace, mode)
	return mode == "remover" and ply:IsAdmin()
end