﻿include("shared.lua")

local use_font = system.IsWindows() and "Tahoma" or "Verdana"
surface.CreateFont("dark_dealer_font", {font = "BebasNeue", size = 40, weight = 0, antialias = true, shadow = false})
surface.CreateFont("dark_dealer_font2", {font = "Roboto", size = 18, weight = 1000, antialias = true, shadow = true})
surface.CreateFont("dark_dealer_font3", {font = "Roboto", size = 13, weight = 1000, antialias = true, shadow = true})

surface.CreateFont("dark_dealer_default", {font = use_font, size = 12, weight = 1000, antialias = true, shadow = false}) 
surface.CreateFont("dark_dealer_close", {font = use_font, size = 24, weight = 500, antialias = true, shadow = false}) 

local ThiefPanel
net.Receive("Dealer_ShowShop", function()
	if IsValid(ThiefPanel) then return end
	local ent = net.ReadEntity()
	if !IsValid(ent) then return end
	ThiefPanel = vgui.Create("DFrame")
	ThiefPanel:SetSize(400, ScrH() - 100)
	ThiefPanel:Center()
	ThiefPanel:SetTitle("")
	ThiefPanel:SetVisible(true)
	ThiefPanel:SetDraggable(false)
	ThiefPanel:ShowCloseButton(false)
	ThiefPanel:MakePopup()
	ThiefPanel:ParentToHUD()
	local ply = LocalPlayer()
	ThiefPanel.Think = function()
		if !IsValid(ent) or !ply:Alive() or ply:EyePos():DistToSqr(ent:GetPos()) > 90000 then
			ThiefPanel:Close()
		end
	end
	local Close = vgui.Create("DButton", ThiefPanel)
	Close:SetSize(60, 31)
	Close:SetPos(ThiefPanel:GetWide() - 62, 2)
	Close:SetText("X")
	Close:SetFont("dark_dealer_close")
	Close:SetTextColor(color_white)
	Close.Paint = function(self, w, h)
		if self:IsHovered() then
			draw.RoundedBox(0, 0, 0, w, h, Color(200, 200, 200, 10))
		else
			return
		end
	end
	Close.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		ThiefPanel:Remove()
	end
	local model = vgui.Create("DModelPanel", ThiefPanel)
	model:SetSize(128, 128)
	model:SetPos(10, 65)
	model:SetModel("models/humans/group01/male_03.mdl")
	model:SetFOV(9)
	model.LayoutEntity = function()
	end
	local mdl_ent = model:GetEntity()
	mdl_ent:SetAngles(Angle(-10, 55, 0))
	mdl_ent:SetPos(Vector(0, 3, -25))
	local dlist = vgui.Create("DPanelList", ThiefPanel)
	dlist:SetPos(2, 220)
	dlist:SetSize(390, ThiefPanel:GetTall() - 270)
	dlist:SetSpacing(5)
	dlist:EnableHorizontal(false)
	dlist:EnableVerticalScrollbar(true)

	local scroll = dlist.VBar
	if scroll:IsValid() then
		scroll.Paint = function(self, w, h)
			draw.RoundedBox(4, 0, 0, w, h, Color(65, 65, 65, 250))
		end

		scroll.btnGrip.Paint = function(self, w, h)
			draw.RoundedBox(4, 0, 0, w, h, Color(65, 65, 65, 250))
			draw.RoundedBox(0, 1, 1, w - 2, h - 2, Color(35, 35, 35, 250))
		end

		scroll.btnUp.Paint = function(self, w, h)
			draw.RoundedBoxEx(4, 0, 0, w, h, Color(65, 65, 65, 250), true, true, false, false)
			draw.RoundedBoxEx(4, 1, 1, w - 2, h - 2, Color(35, 35, 35, 250), true, true, false, false)
			draw.DrawText("▲", "dark_dealer_default", 1, 0, color_white)
		end

		scroll.btnDown.Paint = function(self, w, h)
			draw.RoundedBoxEx(4, 0, 0, w, h, Color(65, 65, 65, 250), false, false, true, true)
			draw.RoundedBoxEx(4, 1, 1, w - 2, h - 2, Color(35, 35, 35, 250), false, false, true, true)
			draw.DrawText("▼", "dark_dealer_default", 1, 1, color_white)
		end
	end

	local ShopPanel = {}
	local Prices = {}
	local Cnt = 0
	for k, v in pairs(darkdealer.GetPriceList()) do
		Cnt = Cnt + 1
		table.insert(Prices, {v, k})
	end
	table.sort(Prices, function(a, b) return (tonumber(a[1].price) or math.huge) > (tonumber(b[1].price) or math.huge) end)
	local thiefjob = darkdealer.jobs[ply:Team()] == true
	for i, v in ipairs(Prices) do
		local k = v[2]
		local v =  v[1]
		local price = v.price
		ShopPanel[i]= vgui.Create("DPanel", dlist)
		local panel = ShopPanel[i]
		panel:SetSize(386, 50)
		panel:SetPos(4, 0)
		panel.Color = Color(15, 15, 15, 155)
		local is_wep = (string.find(k, "weapon_") or string.find(k, "m9k_")) and "Waffe" or "Gegenstand"
		panel.Paint = function(self, w, h)
			surface.SetDrawColor(35, 35, 35, 250)
			local wide = w
			local tall = h
			surface.DrawRect(0, 0, wide, tall)
			draw.RoundedBox(0, wide - 2, 0, 2, tall, panel.Color)
			draw.RoundedBox(0, 0, 0, 2, tall, panel.Color)
			draw.RoundedBox(0, 0, 0, wide, 2, panel.Color)
			draw.RoundedBox(0, 0, tall - 2, wide, 2, panel.Color)
			surface.SetTextColor(255, 255, 255, 255)
			surface.SetTextPos(15, 8)
			surface.SetFont("dark_dealer_font2") 
			surface.DrawText(v.name or v.ent or i or "Unbekannt")
			surface.SetTextPos(15, 28)
			surface.SetFont("dark_dealer_font3")
			surface.SetTextPos(16, 28)
			surface.DrawText(is_wep)
			surface.SetFont("dark_dealer_font2") 
			local txt = (type(price) == "function" and "Qualitätsabhängig") or ("$"..(thiefjob and string.Comma(price) or string.Comma(math.ceil(price / 2))))
			local size = surface.GetTextSize(txt)
			surface.SetTextPos(360 - size, 16) 
			surface.DrawText(txt)
		end
		dlist:AddItem(ShopPanel[i])
	end
	local jealous
	for _, v in ipairs(ents.FindByClass("npc_dealer")) do
		if v.WantsHat and v:GetWealth() >= v.HatMoney then
			jealous = true
		end
	end
	local hat_money = ent.WantsHat and ent:GetWealth() >= ent.HatMoney
	local header = "Alleskäufer im Schwarzmarktgeschäft"..(hat_money and ", der sehr stolz auf seinen Hut ist" or jealous and ", der gerne einen Hut hätte..." or "")
	function ThiefPanel:Paint(w, h)
		draw.RoundedBox(0, 0, 0, w, h, Color(35, 35, 35, 250))
		draw.RoundedBox(0, 0, 0, w, 35, Color(5, 5, 5, 255))
		draw.RoundedBox(0, 0, 40, 610, 20, Color(5, 5, 5,255))
		draw.RoundedBox(0, 0, 195, 410, 15, Color(5, 5, 5,255))
		surface.SetTextColor(255, 255, 255, 255)
		surface.SetTextPos(10, 0)
		surface.SetFont("dark_dealer_font")
		surface.DrawText("Der Händler")
		surface.SetFont("dark_dealer_default")
		surface.SetTextPos(10, 43)
		surface.DrawText(header)
		surface.SetTextPos(10, 196)
		surface.DrawText("Kaufliste: ("..Cnt.." Sachen)")
		local text1 = "Hey, hast du Sachen zu verticken?"
		local text2 = "Ich wäre bereit, welche abzunehmen."
		local text3
		if thiefjob then
			text3 = "Komm schon, zeig mir was du dabei hast!"
		else
			text3 = "Solange sie nicht geklaut sind, kaufe ich alles."
		end
		surface.SetTextPos(160, 70)
		surface.DrawText(text1)
		surface.SetTextPos(160, 85)
		surface.DrawText(text2)
		surface.SetTextPos(160, 100)
		surface.DrawText(text3)
		surface.SetTextColor(Color(100, 255, 100))
		surface.SetTextPos(160, 175)
		surface.DrawText("Heutige Gesamteinnahmen: $"..string.Comma(ent:GetWealth()))
	end
	local buy = vgui.Create("DButton", ThiefPanel)
	buy:SetSize(ThiefPanel:GetWide() / 2, 25)
	buy:SetPos(ThiefPanel:GetWide() / 2 - buy:GetWide() / 2, ThiefPanel:GetTall() - 40)
	buy:SetText("Ja, ich hätte da etwas!")
	buy.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		if IsValid(ent) then
			net.Start("Dealer_GetUp") 
				net.WriteEntity(ent)
			net.SendToServer()
		end
		ThiefPanel:Remove()
	end
end)

function ENT:Draw()
	self:DrawModel()
	if !self.WantsHat then return end
	local is_solid = self:IsSolid()
	local tophat = self.TopHat
	local isvalid_tophat = IsValid(tophat)
	if self:GetWealth() >= self.HatMoney then
		if !isvalid_tophat then
			if is_solid then
				self.TopHat = ClientsideModel("models/player/items/humans/top_hat.mdl")
				tophat = self.TopHat
				if IsValid(tophat) then
					local attach = self:GetAttachment(1)
					if !attach then return end
					local ang = attach.Ang
					local pos = attach.Pos + ang:Forward() * -1.5 + ang:Up() * -4.2
					ang:RotateAroundAxis(ang:Right(), 15)
					tophat:SetPos(pos)
					tophat:SetAngles(ang)
					tophat:SetModelScale(0.95)
				end
			end
		else
			if !is_solid then
				tophat:Remove()
			else
				local attach = self:GetAttachment(1)
				if !attach then return end
				local ang = attach.Ang
				local pos = attach.Pos + ang:Forward() * -1.5 + ang:Up() * -4.2
				ang:RotateAroundAxis(ang:Right(), 15)
				tophat:SetPos(pos)
				tophat:SetAngles(ang)
			end
		end
	elseif isvalid_tophat then
		tophat:Remove()
	end
end

function ENT:OnRemove()
	SafeRemoveEntity(self.TopHat)
end