ENT.Base = "base_nextbot"
ENT.AutomaticFrameAdvance = true
ENT.PrintName = "Händler"
ENT.Spawnable = true
ENT.Category = "Mapobjekte"
ENT.WantsHat = true
ENT.HatMoney = 2500000

function ENT:SetupDataTables()
	self:NetworkVar("Int", 0, "Wealth")
end

function ENT:PhysgunPickup(ply)
	return !GetConVar("mg_movemode") or GetConVar("mg_movemode"):GetInt() > 1 and ply:IsAdmin() or GetConVar("mg_movemode") and GetConVar("mg_movemode"):GetInt() > 0 and ply:IsSuperAdmin()
end

function ENT:CanTool(ply, trace, mode)
	return !GetConVar("mg_movemode") or GetConVar("mg_movemode"):GetInt() > 1 and ply:IsAdmin() or GetConVar("mg_movemode") and GetConVar("mg_movemode"):GetInt() > 0 and ply:IsSuperAdmin()
end

darkdealer = {}

darkdealer.WhitelistedEntities = {}
darkdealer.WhitelistedEntities["spawned_food"] = true
darkdealer.WhitelistedEntities["food"] = true
darkdealer.WhitelistedEntities["spawned_weapon"] = true
darkdealer.WhitelistedEntities["spawned_shipment"] = true
darkdealer.WhitelistedEntities["spawned_ammo"] = true

local function SearchForDarkRPEntity(class, model)
	for _,v in pairs(CustomShipments) do
		if v.entity == class then
			return (v.pricesep and math.floor(v.pricesep / 2.5) or math.floor((v.price / v.amount) / 2.5)), v.name
		end
	end
	for _,v in pairs(DarkRPEntities) do
		if v.ent == class then
			return v.price, v.name
		end
	end
end

local price_list
function darkdealer.GetPriceList()
	if price_list then return price_list end
	price_list = {}
	local tocheck = {}
	table.Merge(tocheck, scripted_ents.GetList())
	table.Merge(tocheck, weapons.GetList())
	for c, ent in pairs(tocheck) do
		local tbl = ent.t or ent
		local class = tbl.ClassName or ent.ClassName or c
		if !class then continue end
		if (darkdealer.ents_blacklist[class] != true) then
			local price, rpname = SearchForDarkRPEntity(class)
			local name = tbl.PrintName or rpname or class
			local custom = darkdealer.custom_ents[class]
			if custom then
				name = custom.name or name
				price = custom.price or price
			end
			if price then
				price_list[class] = {price = price, name = name}
			end
		end
	end
	return price_list
end

function darkdealer.GetEntityPrice(ent)
	local class = ent
	local multiplier = 1
	if IsEntity(ent) then
		class = ent:GetClass()
		if class == "spawned_weapon" then
			class = ent:GetWeaponClass()
			multiplier = ent:Getamount()
		elseif class == "spawned_shipment" then
			class = CustomShipments[ent:Getcontents()].entity
			multiplier = ent:Getcount()
		end
	end
	local classtbl = darkdealer.GetPriceList()[class]
	if !classtbl then return end
	local price = classtbl.price
	return (type(price) == "function" and IsEntity(ent) and price(ent) or tonumber(price)) * multiplier
end

darkdealer.ents_blacklist = {
	["metal_detector"] = true
}

darkdealer.custom_ents = {}
function darkdealer.AddCustomEntity(class, price, name)
	darkdealer.custom_ents[class] = {price = price, name = name}
end

darkdealer.AddCustomEntity("food", function(ent)
	return GAMEMODE.Config.microwavefoodcost
end)

darkdealer.AddCustomEntity("spawned_food", function(ent)
	return ent.FoodPrice or 0
end)

darkdealer.AddCustomEntity("donation_box", function(ent)
	local money = SearchForDarkRPEntity(ent:GetClass())
	return money + ent:GetMoneyInput()
end)

darkdealer.AddCustomEntity("money_printer", function(ent)
	return ent:SellPrice()
end)

darkdealer.AddCustomEntity("weed_plant", function(ent)
	return ent:SellPrice()
end)

darkdealer.AddCustomEntity("sell_container", function(ent)
	local money = SearchForDarkRPEntity(ent:GetClass())
	if FarmingCFG then
		for k, v in ipairs(FarmingCFG.Crops) do
			local crops = ent.Crops[k]
			if crops then
				money = money + (crops * FarmingCFG.SellPrices[k])
			end
		end
	end
	return money
end)

darkdealer.AddCustomEntity("plant_seeds", function(ent)
	return ent:GetWorth()
end)

darkdealer.AddCustomEntity("mining_crate", function(ent)
	local money = SearchForDarkRPEntity(ent:GetClass())
	money = math.floor(money + ent:GetWorth())
	money = money + (ent:AddonMoney() / 4)
	return money
end)

darkdealer.AddCustomEntity("zrush_machinecrate", function(ent)
	local money = SearchForDarkRPEntity(ent:GetClass())
	money = money + zrush.f.MachineShop.Sell(ent, ent:GetMachineID()) * 2
	return money
end)

darkdealer.AddCustomEntity("zrush_barrel", function(ent)
	local money = SearchForDarkRPEntity(ent:GetClass())
	local fueltype = ent:GetFuelTypeID()
	if fueltype != 0 then
		local sellProfit = (zrush.PriceMult / 100)
		money = money + math.floor((zrush.Fuel[fueltype].price * ent:GetFuel()) * sellProfit)
	end
	return money
end)

darkdealer.AddCustomEntity("zmlab_meth", function(ent)
	return ent:SellPrice()
end)

darkdealer.AddCustomEntity("zmlab_combiner", function(ent)
	return ent:SellPrice()
end)

timer.Simple(0, function()
	darkdealer.jobs = {
		[TEAM_THIEF] = true,
		[TEAM_MASTERTHIEF] = true,
		[TEAM_GANGSTER] = true,
		[TEAM_GANGSTERBOSS] = true,
		[TEAM_MAFIOSO] = true,
		[TEAM_MAFIABOSS] = true,
		[TEAM_REBEL] = true,
		[TEAM_REBELBOSS] = true
	}
end)