include("shared.lua")

local use_font = system.IsWindows() and "Tahoma" or "Verdana"
surface.CreateFont("UnarrestNPCFont_45", {font = use_font, size = 45, weight = 1000, blursize = 0, scanlines = 0})
surface.CreateFont("UnarrestNPCFont_20", {font = use_font, size = 20, weight = 1000, blursize = 0, scanlines = 0})

local local_ply
local hook_exists

local gradientup = Material("gui/gradient_up")
local gradientdown = Material("gui/gradient_down")
local gradient_color = Color(0, 255, 0)
function ENT:DrawProgressBar(label, color, filled)
	filled = math.Clamp(filled, 0, 1)
	local w, h = 300, 20
	local centerx, centery = ScrW() / 2, ScrH() / 2
	local x, y = centerx - w / 2, centery - h / 2
	surface.SetDrawColor(color_white)
	surface.DrawOutlinedRect(x, y, w, h)
	surface.SetDrawColor(color)
	surface.SetMaterial(gradientdown)
	surface.DrawTexturedRect(x + 2, y + 2, (w - 4) * filled, h - 4)
	surface.SetDrawColor(Color(color.r / 2, color.g / 2, color.b/ 2))
	surface.SetMaterial(gradientup)
	surface.DrawTexturedRect(x + 2, y + 2, (w - 4) * filled, h - 4)
	draw.SimpleTextOutlined(label, "DermaDefaultBold", centerx, centery - 1, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, Color(0, 0, 0))
end

function ENT:Think()
	local_ply = local_ply or LocalPlayer()
	local UsePlayer = self:GetUsePlayer()
	if IsValid(UsePlayer) and UsePlayer == local_ply and !hook_exists then
		hook.Add("HUDPaint", "MG_ReleaseNPC_HUDPaint", function()
			self:DrawProgressBar("Befreien...", gradient_color, (CurTime() - (self:GetEndUse() - self.UnarrestTime)) / self.UnarrestTime)
		end)
		hook_exists = true
	elseif !IsValid(UsePlayer) or UsePlayer != local_ply and hook_exists then
		hook.Remove("HUDPaint", "MG_ReleaseNPC_HUDPaint")
		hook_exists = false
	end
end

local local_ply, dist
local vector_1 = Vector(0, 0, 1)
local color_1 = Color(0, 150, 255, 255)
function ENT:DrawTranslucent()
	local ang = self:GetAngles()
	ang:RotateAroundAxis(ang:Forward(), 90)
	ang:RotateAroundAxis(ang:Right(), -90)
	ang:RotateAroundAxis(ang:Up(), 0)
	MG_DrawEntity3D2D(self, {
		lines = {
			{
				line = self.PrintName,
				font = "UnarrestNPCFont_45",
				offset = -100,
				color = color_1,
			},
			{
				line = "Preis: $"..string.Comma(self.UnarrestPrice),
				font = "UnarrestNPCFont_20",
				offset = -65
			},
		},
		ang = Angle(0, EyeAngles().y - 90, 90),
		distance = 100000,
		size = 0.1,
		hovermult = 1,
	})
end