include("shared.lua")

local emitter = ParticleEmitter(Vector(0, 0, 0))
local function kernel_init(popcorn, vel)
	popcorn:SetVelocity(vel or VectorRand():GetNormalized() * 15)
	popcorn:SetGravity(Vector(0, 0, -200))
	popcorn:SetLifeTime(0)
	popcorn:SetDieTime(math.Rand(4, 10))

	local size = math.Rand(1, 2)

	popcorn:SetStartSize(size)
	popcorn:SetEndSize(size)

	popcorn:SetStartAlpha(255)
	popcorn:SetEndAlpha(0)
	popcorn:SetCollide(true)
	popcorn:SetBounce(math.Rand(0.1, 0.3))
	popcorn:SetRoll(math.pi * math.Rand(0, 1))
	popcorn:SetRollDelta(math.pi * math.Rand(-6, 6))
end

function ENT:Initialize()
	if IsValid(self) then
		local kt = "kernel_timer_"..self:EntIndex()
		timer.Create(kt, 0.05, 0, function()
			if !IsValid(self) then timer.Remove(kt) return end

			if self:GetVelocity():LengthSqr() <= 2500 then return end

			emitter:SetPos(self:GetPos())

			local popcorn = emitter:Add("particle/popcorn-kernel", self:GetPos() + VectorRand():GetNormalized() * 4)
			if popcorn then
				kernel_init(popcorn)
			end
		end)
	end
end

net.Receive("Popcorn_Explosion", function()
	if !emitter then return end
	local pos = net.ReadVector()
	local norm = net.ReadVector()
	local bucketvel = net.ReadVector()
	local entid = net.ReadFloat()
	timer.Remove("kernel_timer_"..entid)
	for i = 1, math.random(300, 400) do
		local explosion = emitter:Add("particle/popcorn-kernel", pos)
		if explosion then
			local dir = VectorRand():GetNormalized()
			kernel_init(explosion, ((-norm) + dir):GetNormalized() * math.Rand(0, 200) + bucketvel * 0.5)
		end
	end
end)