include("shared.lua")
include("sh_config.lua")

local function DrawRepairCost(ply, ent)
	if ent.Base != "protect_base" or ent:GetPos():DistToSqr(ply:EyePos()) > ent.ManualFixDistance then return end
	if !ent.Damageable or !ent.Breakable or ent.FixMode != "manual" or ent:Health() >= ent:GetMaxHealth() then return end
	draw.SimpleTextOutlined("Reparieren für $"..(string.Comma(ent.ManualFixCost) or 0),"mg_instructions",ScrW() / 2, ScrH() / 2, Color(255, 255, 0, 255), TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
end

local function DrawInfos(ply, ent)
	if ent.Base != "protect_base" or ent:GetPos():DistToSqr(ply:EyePos()) > ent.HintDrawDistance then return end
	local str = ent:GetDeviceName()
	local owner = ent:Getowning_ent()
	if IsValid(owner) and owner:IsPlayer() then
		draw.SimpleTextOutlined(str, "mg_instructions",ScrW() / 2, ScrH() / 2 + 25, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER,1, color_black)
		draw.SimpleTextOutlined("Besitzer: "..owner:Name(), "mg_instructions", ScrW() / 2, ScrH() / 2 + 50, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
	end
end

local local_ply, ent
hook.Add("HUDPaint", "protect_base_draw", function()
	local_ply = local_ply or LocalPlayer()
	ent = local_ply:GetEyeTrace().Entity
	if !IsValid(ent) then return end
	DrawRepairCost(local_ply, ent)
	DrawInfos(local_ply, ent)
end)

ENT.DrawBaseModel = false

local w, h = 150, 20
local scale = 0.15
function ENT:DrawModel()
	if self.DrawBaseModel then
		self:DrawModel()
	end
end

function ENT:DrawTranslucent()
	local_ply = local_ply or LocalPlayer()
	local eyepos = local_ply:EyePos()
	local pos = self:LocalToWorld(Vector(0, 0, self:OBBMaxs().z + 10))
	if !self.Damageable or eyepos:DistToSqr(pos) > self.HealthDrawDistance then return end
	local hp = self:Health()
	local ang = (eyepos - pos):Angle()
	ang:RotateAroundAxis(ang:Up(), 90)
	ang:RotateAroundAxis(ang:Forward(), 90)
	local alpha = ((CurTime() - 1) / 0.5) * 255
	local hfrac = math.Clamp(hp / self.StartingHealth, 0, 1)
	cam.Start3D2D(pos, ang, scale)
		surface.SetDrawColor((1 - hfrac) * 255, hfrac * 255, 0, alpha)
		surface.DrawRect(-w / 2, -h / 2, hfrac * w, h)
		surface.SetDrawColor(255, 255, 255, alpha)
		surface.DrawOutlinedRect(-w / 2, -h / 2, w, h)
		if !hfrac or hfrac > 0 then
			draw.SimpleText("Online", "Default", 0, 0, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		end
		if hfrac <= 0 then
			draw.SimpleText("Offline", "Default", 0, 0, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		end
	cam.End3D2D()
end