﻿include("shared.lua")
include("sh_config.lua")

local use_font = system.IsWindows() and "Tahoma" or "Verdana"
surface.CreateFont("Scanner_Close", {
	font = use_font,
	size = 13,
	weight = 1000
})

local function AddListSpacer(list, height, vmargins, color)
	vmargins = vmargins or 0
	local spacer = vgui.Create("DPanel", list)
	spacer:SetTall(height + (vmargins * 2))
	if color then
		spacer.Paint = function(self, w, h)
			surface.SetDrawColor(color)
			surface.DrawRect(0, vmargins, w, height)
		end
	else
		spacer.Paint = nil
	end
	list:Add(spacer)
end

local scanner_frame
net.Receive("protect_scanner_settings", function(len)
	if IsValid(scanner_frame) then return end
	local ent = net.ReadEntity()
	if !IsValid(ent) then return end
	local sel_mode = net.ReadBit()
	local whitelist_ply = net.ReadTable()
	local whitelist_team = net.ReadTable()
	scanner_frame = vgui.Create("DFrame")
	scanner_frame:ShowCloseButton(false)
	scanner_frame:SetTitle("Melder-Einstellungen")
	scanner_frame:SetSize(256, 200)
	scanner_frame:Center()
	scanner_frame:MakePopup()
	scanner_frame:ParentToHUD()
	local ply = LocalPlayer()
	scanner_frame.Think = function(slf)
		if !IsValid(ent) or !ply:Alive() or ply:EyePos():DistToSqr(ent:GetPos()) > 40000 then
			scanner_frame:Close()
		end
	end
	local Close = vgui.Create("DButton", scanner_frame)
	Close:SetSize(50, 20)
	Close:SetPos(scanner_frame:GetWide() - 52, 2)
	Close:SetText("X")
	Close:SetFont("Scanner_Close")
	Close:SetTextColor(color_white)
	Close.Paint = function(self, w, h)
		local col
		if self:IsHovered() then
			col = Color(255, 100, 100)
		else
			col = Color(200, 50, 50)
		end
		draw.RoundedBox(4, 0, 0, w, h, col)
	end
	Close.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		scanner_frame:Remove()
	end
	local list = vgui.Create("DListLayout", scanner_frame)
	list:SetSize(scanner_frame:GetWide() - 10, scanner_frame:GetTall() - 60)
	list:SetPos(5, 30)
	local edit_mode = vgui.Create("DButton", list)
	edit_mode.Mode = sel_mode
	edit_mode:SetText(edit_mode.Mode == 0 and "Whitelist deaktivieren" or "Whitelist aktivieren")
	edit_mode:SetTextColor(edit_mode.Mode == 0 and Color(255, 0, 0) or Color(0, 255, 0))
	edit_mode.DoClick = function(self)
		self.Mode = self.Mode == 0 and 1 or 0
		self:SetTextColor(self.Mode == 0 and Color(255, 0, 0) or Color(0, 255, 0))
		self:SetText(self.Mode == 0 and "Whitelist deaktivieren" or "Whitelist aktivieren")
	end
	edit_mode.Paint = function(self, w, h)
		if self:IsDown() then
			surface.SetDrawColor(55, 55, 55, 255)
		elseif self:IsHovered() then
			surface.SetDrawColor(65, 65, 65, 255)
		else
			surface.SetDrawColor(75, 75, 75, 255)
		end
		self:DrawFilledRect()
	end
	list:Add(edit_mode)
	AddListSpacer(list, 2, 4, Color(255, 255, 255, 100))
	local whitelist_edit = vgui.Create("DLabel", list)
	whitelist_edit:SetText("Whitelist bearbeiten:")
	whitelist_edit:SizeToContents()
	whitelist_edit:SetTall(25)
	list:Add(whitelist_edit)
	local add_ply = vgui.Create("DButton", list)
	add_ply:SetText("Person hinzufügen")
	add_ply:SetTextColor(Color(255, 255, 255))
	add_ply.DoClick = function(self)
		local players = table.Copy(player.GetAll())
		table.sort(players, function(a, b) return a:Name() < b:Name() end)
		local dmenu = DermaMenu(self)
		local found = false
		for _, v in ipairs(players) do
			if !whitelist_ply[v:UserID()] and ply != v then
				found = true
				dmenu:AddOption(v:Name(), function()
					if !IsValid(v) then return end
					whitelist_ply[v:UserID()] = true
				end)
			end
		end
		if !found then
			dmenu:AddOption("Niemand verfügbar")
		end
		dmenu:Open()
	end
	add_ply.Paint = function(self, w, h)
		if self:IsDown() then
			surface.SetDrawColor(55, 55, 55, 255)
		elseif self:IsHovered() then
			surface.SetDrawColor(65, 65, 65, 255)
		else
			surface.SetDrawColor(75, 75, 75, 255)
		end
		self:DrawFilledRect()
	end
	list:Add(add_ply)
	local empty_space = vgui.Create("DPanel", list)
	empty_space:SetSize(scanner_frame:GetWide(), 5)
	empty_space.Paint = function()
	end
	list:Add(empty_space)
	local rem_ply = vgui.Create("DButton", list)
	rem_ply:SetText("Person entfernen")
	rem_ply:SetTextColor(Color(255, 255, 255))
	rem_ply.DoClick = function(self)
		local players = player.GetAll()
		table.sort(players, function(a, b) return a:Name() < b:Name() end)
		local dmenu = DermaMenu(self)
		local found = false
		for _, v in ipairs(players) do
			if whitelist_ply[v:UserID()] and ply != v then
				found = true
				dmenu:AddOption(v:Name(), function()
					if !IsValid(v) then return end
					whitelist_ply[v:UserID()] = nil
				end)
			end
		end
		if !found then
			dmenu:AddOption("Niemand verfügbar")
		end
		dmenu:Open()
	end
	rem_ply.Paint = function(self, w, h)
		if self:IsDown() then
			surface.SetDrawColor(55, 55, 55, 255)
		elseif self:IsHovered() then
			surface.SetDrawColor(65, 65, 65, 255)
		else
			surface.SetDrawColor(75, 75, 75, 255)
		end
		self:DrawFilledRect()
	end
	list:Add(rem_ply)
	AddListSpacer(list, 2, 4, Color(255, 255, 255, 100))
	local add_job = vgui.Create("DButton", list)
	add_job:SetText("Job hinzufügen")
	add_job:SetTextColor(Color(255, 255, 255))
	add_job.DoClick = function(self)
		local dmenu = DermaMenu(self)
		for k, v in SortedPairsByMemberValue(RPExtraTeams, "name") do
			if !whitelist_team[k] then
				dmenu:AddOption(v.name, function()
					whitelist_team[k] = true
				end)
			end
		end
		dmenu:Open()
	end
	add_job.Paint = function(self, w, h)
		if self:IsDown() then
			surface.SetDrawColor(55, 55, 55, 255)
		elseif self:IsHovered() then
			surface.SetDrawColor(65, 65, 65, 255)
		else
			surface.SetDrawColor(75, 75, 75, 255)
		end
		self:DrawFilledRect()
	end
	list:Add(add_job)
	local empty_space = vgui.Create("DPanel", list)
	empty_space:SetSize(scanner_frame:GetWide(), 5)
	empty_space.Paint = function()
	end
	list:Add(empty_space)
	local rem_job = vgui.Create("DButton", list)
	rem_job:SetText("Job entfernen")
	rem_job:SetTextColor(Color(255, 255, 255))
	rem_job.DoClick = function(self)
		local dmenu = DermaMenu(self)
		for k, v in SortedPairsByMemberValue(RPExtraTeams, "name") do
			if whitelist_team[k] then
				dmenu:AddOption(v.name, function()
					whitelist_team[k] = nil
				end)
			end
		end
		dmenu:Open()
	end
	rem_job.Paint = function(self, w, h)
		if self:IsDown() then
			surface.SetDrawColor(55, 55, 55, 255)
		elseif self:IsHovered() then
			surface.SetDrawColor(65, 65, 65, 255)
		else
			surface.SetDrawColor(75, 75, 75, 255)
		end
		self:DrawFilledRect()
	end
	list:Add(rem_job)
	scanner_frame.OnRemove = function()
		if !IsValid(ent) then return end
		net.Start("protect_scanner_settings")
			net.WriteEntity(ent)
			net.WriteBit(edit_mode.Mode == 1)
			net.WriteTable(whitelist_ply)
			net.WriteTable(whitelist_team)
		net.SendToServer()
	end
end)

function ENT:Initialize()
	self:SetRenderBounds(self:OBBMins() - Vector(self.BeamLength, 0, 0), self:OBBMaxs())
end

local mat = CreateMaterial("protect_scanner_beam", "UnlitGeneric", {["$basetexture"] = "vgui/white", ["$additive"] = 1, ["$vertexcolor"] = 1, ["$vertexalpha"] = 1})
local color_red = Color(255, 0, 0, 255)
function ENT:DrawTranslucent()
	if !self.Damageable or self:Health() > 0 then
		local trace = self:TraceBeam()
		render.SuppressEngineLighting(true)
		render.SetMaterial(mat)
		render.DrawBeam(trace.StartPos, trace.HitPos, 0.2, 0, 1, color_red)
		render.SuppressEngineLighting(false)
	end
	self.BaseClass.DrawTranslucent(self)
end