include("shared.lua")

function ENT:Draw()
	self:DrawModel()
end

function ENT:DrawTranslucent()
	local angle = self:GetAngles()
	angle:RotateAroundAxis(angle:Forward(), 90)
	MG_DrawEntity3D2D(self, {
		lines = {
			{
				line = self.PrintName,
				font = "VendingMachine_Big",
				offset = -100,
			},
			{
				line = "Frisches Wasser für $"..string.Comma(self.Price)..".",
				font = "VendingMachine_Small",
				offset = -55
			},
			{
				line = !self:GetAvailable() and "Nicht verfügbar.",
				font = "VendingMachine_Small",
				color = Color(200, 60, 60),
				offset = -20
			},
		},
		pos_add = !self:GetAvailable() and angle:Up() * 18 + angle:Right() * -3 or angle:Up() * 18,
		ang = angle,
		distance = 80000,
		size = 0.1,
		hovermult = 1,
	})
end