include("shared.lua")

local use_font = system.IsWindows() and "Tahoma" or "Verdana"
surface.CreateFont("VendingMedic_Text1", {font = use_font, size = 150, weight = 1000, antialias = true})
surface.CreateFont("VendingMedic_Text2", {font = use_font, size = 110, weight = 600, antialias = true})

function ENT:Draw()
	self:DrawModel()
end

local vector_1 = Vector(5.6, -10.6, 66.5)
local color_1 = Color(30, 39, 46)
local color_2 = Color(47, 79, 79)
local color_3 = Color(23, 31, 36)
local color_4 = Color(179, 57, 57)
local color_5 = Color(38, 52, 61)
local local_ply
function ENT:DrawTranslucent()
	local isAvailable = self:GetAvailable()
	local angle = self:GetAngles()
	angle:RotateAroundAxis(angle:Forward(), 90)
	angle:RotateAroundAxis(angle:Right(), 270)
	MG_DrawEntity3D2D(self, {
		lines = {
			{
				line = self.PrintName,
				font = "VendingMachine_Big",
				offset = -100,
			},
			{
				line = "Heilung schwerer Wunden für $"..string.Comma(self.Price).." pro Leben.",
				font = "VendingMachine_Small",
				offset = -55
			},
			{
				line = !isAvailable and "Nicht verfügbar.",
				font = "VendingMachine_Small",
				color = Color(200, 60, 60),
				offset = -20
			},
		},
		pos_add = !isAvailable and angle:Right() * -3,
		ang = angle,
		distance = 80000,
		size = 0.1,
		hovermult = 1,
	})

	local_ply = local_ply or LocalPlayer()
	if local_ply:EyePos():DistToSqr(self:GetPos()) > 100000 then return end
	local ang = self:GetAngles()
	ang:RotateAroundAxis(ang:Forward(), 90)
	ang:RotateAroundAxis(ang:Right(), -90)
	cam.Start3D2D(self:LocalToWorld(vector_1), ang, 0.01)
		draw.RoundedBox(0, 0, 0, 2120, 1620, color_1)
		draw.RoundedBox(0, 0, 0, 2120, 300, color_2)
		draw.SimpleText("Erste Hilfe-Automat", "VendingMedic_Text1", 1060, 150, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		if !isAvailable then
			draw.SimpleText("Begebe dich zu einem Arzt!", "VendingMedic_Text2", 1060, 810, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
			cam.End3D2D()
			return
		end
		draw.SimpleText("Drücke ["..(string.upper(input.LookupBinding("+use") or "BENUTZEN")).."], um dich zu heilen.", "VendingMedic_Text2", 1060, 486, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		draw.SimpleText("Preis pro HP: $"..string.Comma(self.Price), "VendingMedic_Text2", 1060, 590, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		local progressFactor = 1660 / local_ply:GetMaxHealth()
		local tb = self:GetTable()
		tb.ProgressFactor = tb.ProgressFactor or math.Clamp(progressFactor * local_ply:Health(), 0, 1660)
		tb.ProgressFactor = Lerp(FrameTime() * 5, tb.ProgressFactor, math.Clamp(progressFactor * local_ply:Health(), 0, 1660))
		draw.RoundedBox(2, 230, 690, 1660, 200, color_3)
		draw.RoundedBox(2, 230, 690, progressFactor * tb.MaxHeal, 200, color_5)
		draw.RoundedBox(2, 230, 690, tb.ProgressFactor, 200, color_4)
	cam.End3D2D()
end