include("shared.lua")

local use_font = system.IsWindows() and "Tahoma" or "Verdana"
surface.CreateFont("WeedPlant_Sell", {font = use_font, size = 60, weight = 600, blursize = 0, scanlines = 0, antialias = true})
surface.CreateFont("WeedPlant_InfoText", {font = use_font, size = 16, weight = 1000, blursize = 0, scanlines = 0, antialias = true})

surface.CreateFont("WeedPlant_Close", {
	font = use_font,
	size = 13,
	weight = 1000
})

local local_ply, distance

function ENT:Initialize()
	self:InitTimer()
end

function ENT:InitTimer()
	self:CastEffect()
	timer.Simple(0.5, function()
		if !IsValid(self) then return end
		self:InitTimer()
	end)
end

function ENT:CastEffect()
	if self:GetNoDraw() or self:GetLevel() <= 5 then return end
	distance = (local_ply or LocalPlayer()):EyePos():DistToSqr(self:GetPos())
	if distance < 562500 then
		local pos = (self:GetPos() + self:GetUp() * 30 + self:GetRight() * 1) + Vector(math.Rand(-6, 6), math.Rand(-6, 6), math.Rand(-15, 9))
		local emitter = ParticleEmitter(pos)
		local particle = emitter:Add("particle/fire", pos)
		if particle then
			particle:SetVelocity(Vector(math.Rand(-0.1, 0.1), math.Rand(-0.1, 0.1), math.Rand(-0.1, 0.1)))
			particle:SetLifeTime(0)
			particle:SetDieTime(5)
			particle:SetColor(255, 190, 0)
			particle:SetStartAlpha(255)
			particle:SetEndAlpha(0)
			particle:SetStartSize(3)
			particle:SetEndSize(0)
			particle:SetRoll(0)
			particle:SetRollDelta(0)
			particle:SetAirResistance(0)
			particle:SetGravity(Vector(0, 0, 0))
		end
		emitter:Finish()
	end
end

function ENT:Draw()
	self:DrawModel()
end

function ENT:DrawTranslucent()
	local_ply = local_ply or LocalPlayer()
	distance = local_ply:EyePos():DistToSqr(self:GetPos())
	if distance < 250000 then
		if !self:GetCanGrow() then
			local pos = self:GetPos() + self:GetUp() * 20 + self:GetRight() * 1
			local color = Color(255, 255, 255, 255)
			cam.Start3D2D(pos, Angle(0, EyeAngles().y - 90, 90), 0.15)
				surface.SetDrawColor(Color(25, 25, 25, 225))
				surface.DrawRect(-15, -150, 30, -50)
				surface.SetDrawColor(color)
				surface.DrawOutlinedRect(-15, -150, 30, -50)
				local can_sell = self:GetCanSell()
				draw.SimpleTextOutlined(can_sell and "!" or "$", "WeedPlant_Sell", 0, can_sell and -207 or -210, color, TEXT_ALIGN_CENTER, TEXT_ALIGN_LEFT, 1, Color(25, 25, 25, 100))
			cam.End3D2D()
		end
	end
end

local Plant
local function DrawPlantInfo()
	local_ply = local_ply or LocalPlayer()
	Plant = local_ply:GetEyeTrace().Entity
	if IsValid(Plant) and Plant.IsWeedPlant then
		local xx, yy = ScrW() / 2, ScrH() / 2
		local Owner = "Niemand"
		local owning_ent = Plant.Getowning_ent and Plant:Getowning_ent()
		if IsValid(owning_ent) then
			Owner = owning_ent:Name()
		end
		distance = local_ply:EyePos():Distance(Plant:GetPos())
		if distance < 190 then
			local Alpha = math.Clamp(280 - (0.5 * distance), 0, 255)
			local can_grow = Plant:GetCanGrow()
			local x = !can_grow and 130 or 115
			draw.RoundedBox(4, xx - 110, yy - 55, 220, x, Color(35, 35, 35, Alpha))
			draw.RoundedBox(4, xx - 105, yy - 52.5, 210, 20, Color(72, 221, 0, Alpha))
			draw.SimpleText("Marihuanapflanze", "DermaDefaultBold", xx, yy - 50, Color(255, 255, 255, Alpha), TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP)
			draw.SimpleTextOutlined("Besitzer: "..Owner, "WeedPlant_InfoText", xx, yy - 25, Color(255, 255, 255, Alpha), TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, Color(0, 0, 0))
			draw.SimpleTextOutlined("Level: "..Plant:GetLevel(), "WeedPlant_InfoText", xx, yy - 10, Color(255, 255, 255, Alpha), TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, Color(0, 0, 0))
			draw.SimpleTextOutlined("Erfahrung: "..string.Comma(Plant:GetExperience()).."/"..string.Comma(Plant:GetExpReq()), "WeedPlant_InfoText", xx, yy + 5, Color(255, 255, 255, Alpha), TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, Color(0, 0, 0))
			if Plant:GetDead() then
				draw.SimpleTextOutlined("Wässerung: "..Plant:GetWater().."% (TOT)", "WeedPlant_InfoText", xx, yy + 20, Color(255, 0, 0, Alpha), TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, Color(0, 0, 0))
			else
				draw.SimpleTextOutlined("Wässerung: "..Plant:GetWater().."%", "WeedPlant_InfoText", xx, yy + 20, Color(255, 255, 255, Alpha), TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, Color(0, 0, 0))
			end
			draw.SimpleTextOutlined("Wert: $"..string.Comma(Plant:GetSellAmount()), "WeedPlant_InfoText", xx, yy + 35, Color(255, 255, 255, Alpha), TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, Color(0, 0, 0))
			local can_sell = Plant:GetCanSell()
			if !can_grow and !can_sell then
				draw.SimpleTextOutlined("Wird in "..string.ToMinutesSeconds(math.max(Plant:GetSellTimer() - CurTime() + 1, 0)).." min verkauft.", "WeedPlant_InfoText", xx, yy + 50, Color(255, 255, 255, Alpha), TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, Color(0, 0, 0))
			elseif !can_grow and can_sell then	
				draw.SimpleTextOutlined("Bereit zum Verkaufen!", "WeedPlant_InfoText", xx, yy + 50, Color(255, 255, 255, Alpha), TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, Color(0, 0, 0))
			end
		end
	end
end
hook.Add("HUDPaint", "WeedPlant_DrawPlantInfo", DrawPlantInfo)

local cl_Plant = {}
local PlantMenu
local SellPlantMenu
local CanDestroy
local CanSell
function cl_Plant.OpenMenu()
	local Plant = net.ReadEntity()
	if !IsValid(Plant) then return end 
	if IsValid(PlantMenu) then return end
	PlantMenu = vgui.Create("DFrame")
	PlantMenu:SetTitle("Marihuanapflanze")
	PlantMenu:SetSize(400, 115)
	PlantMenu:ShowCloseButton(false)
	PlantMenu:MakePopup()
	PlantMenu.Paint = function(self, w, h)
		draw.RoundedBox(4, 0, 0, w, h, Color(35, 35, 35, 255))
	end
	PlantMenu:SetPos(ScrW() / 2 - PlantMenu:GetWide() / 2, ScrH())
	PlantMenu:MoveTo(ScrW() / 2 - PlantMenu:GetWide() / 2, ScrH() / 2 - PlantMenu:GetTall() / 2, 0.25, 0, 0.5)
	PlantMenu:ParentToHUD()
	local ply = LocalPlayer()
	PlantMenu.Think = function()
		if IsValid(Plant) then
			PlantMenu:SetTitle("Marihuanapflanze "..(Plant:GetCanSell() and "(Verkaufsbereit)" or !Plant:GetCanGrow() and "(Wird verkauft "..string.ToMinutesSeconds(math.max(Plant:GetSellTimer() - CurTime() + 1, 0))..")" or ""))
			PlantMenu:SizeToContents()
		end
		if !IsValid(Plant) or Plant:GetNoDraw() or !ply:Alive() or ply:EyePos():DistToSqr(Plant:GetPos()) > 10000 then
			PlantMenu:Remove()
		end
	end
	PlantMenu.OnRemove = function()
		if IsValid(SellPlantMenu) then
			SellPlantMenu:Remove()
		end
		if IsValid(CanDestroy) then
			CanDestroy:Remove()
		end
		if IsValid(CanSell) then
			CanSell:Remove()
		end
	end
	local Close = vgui.Create("DButton", PlantMenu)
	Close:SetSize(50, 20)
	Close:SetPos(PlantMenu:GetWide() - 52, 2)
	Close:SetText("X")
	Close:SetFont("WeedPlant_Close")
	Close:SetTextColor(color_white)
	Close.Paint = function(self, w, h)
		local col
		if self:IsHovered() then
			col = Color(255, 100, 100)
		else
			col = Color(200, 50, 50)
		end
		draw.RoundedBox(4, 0, 0, w, h, col)
	end
	Close.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		PlantMenu:Remove()
	end
	local LeftPanel = vgui.Create("DPanel", PlantMenu)
	LeftPanel:SetSize(190, 20)
	LeftPanel:SetPos(5, 25)
	LeftPanel:SetBackgroundColor(Color(72, 221, 0, 255))
	local LeftLabel = vgui.Create("DLabel", LeftPanel)
	LeftLabel:SetFont("WeedPlant_InfoText")
	LeftLabel:SetText("Statistiken")
	LeftLabel:SetTextColor(Color(255, 255, 255))
	LeftLabel:SizeToContents()
	LeftLabel:CenterHorizontal()
	LeftLabel:CenterVertical()
	local LevelLabel = vgui.Create("DLabel", PlantMenu)
	LevelLabel:SetFont("DermaDefaultBold")
	LevelLabel:SetPos(5, 50)
	LevelLabel.Think = function()
		if IsValid(Plant) then
			LevelLabel:SetText("Level: "..Plant:GetLevel())
			LevelLabel:SizeToContents()
		end
	end
	local ExpLabel = vgui.Create("DLabel", PlantMenu)
	ExpLabel:SetFont("DermaDefaultBold")
	ExpLabel:SetPos(5, 65)
	ExpLabel:SetSize(200, 15)
	ExpLabel.Think = function()
		if IsValid(Plant) then
			ExpLabel:SetText("Erfahrung: "..string.Comma(Plant:GetExperience()).."/"..string.Comma(Plant:GetExpReq()))
			ExpLabel:SizeToContents()
		end
	end
	local WateringLabel = vgui.Create("DLabel", PlantMenu)
	WateringLabel:SetFont("DermaDefaultBold")
	WateringLabel:SetPos(5, 80)
	WateringLabel:SetSize(200, 15)
	WateringLabel.Think = function()
		if !IsValid(Plant) then return end
		if Plant:GetDead() then
			WateringLabel:SetText("Wässerung: "..Plant:GetWater().."% (TOT)")
			WateringLabel:SetTextColor(Color(255, 0, 0, 255))
			WateringLabel:SizeToContents()
		else
			WateringLabel:SetText("Wässerung: "..Plant:GetWater().."%")
			WateringLabel:SizeToContents()
		end
	end
	local SellAmountLabel = vgui.Create("DLabel", PlantMenu)
	SellAmountLabel:SetFont("DermaDefaultBold")
	SellAmountLabel:SetPos(5, 95)
	SellAmountLabel:SetSize(200, 15)
	SellAmountLabel.Think = function()
		if IsValid(Plant) and Plant:GetSellAmount() then
			SellAmountLabel:SetText("Wert: $"..string.Comma(Plant:GetSellAmount()))
			SellAmountLabel:SizeToContents()
		end
	end
	local RightPanel = vgui.Create("DPanel", PlantMenu)
	RightPanel:SetSize(190, 20)
	RightPanel:SetPos(205, 25)
	RightPanel:SetBackgroundColor(Color(72, 221, 0, 255))
	local RightLabel = vgui.Create("DLabel", RightPanel)
	RightLabel:SetFont("WeedPlant_InfoText")
	RightLabel:SetText("Aktionen")
	RightLabel:SetTextColor(Color(255, 255, 255))
	RightLabel:SizeToContents()
	RightLabel:CenterHorizontal()
	RightLabel:CenterVertical()
	local SellButton = vgui.Create("DButton", PlantMenu)
	SellButton:SetPos(205, 50)
	SellButton:SetSize(190, 20)
	SellButton:SetText("Verkaufen")
	SellButton.Think = function()
		if !IsValid(Plant) then return end
		if Plant:GetDead() then
			SellButton:SetDisabled(true)
		else
			SellButton:SetDisabled(false)
		end
		if Plant:GetCanSell() then
			SellButton:SetText("Verkaufsoptionen aufrufen")
		elseif !Plant:GetCanGrow() then
			SellButton:SetText("Verkauf zurücksetzen")
		else
			SellButton:SetText("Verkaufen")
		end
	end
	SellButton.DoClick = function()
		if !IsValid(Plant) then return end
		if ply:Team() != TEAM_DEALER then
			surface.PlaySound("buttons/lightswitch2.wav")
			notification.AddLegacy("Du musst Drogenhändler sein, um dies zu tun!", NOTIFY_ERROR, 5)
			return
		end
		if Plant:GetCanGrow() then
			if IsValid(CanSell) then return end
			surface.PlaySound("ui/buttonclick.wav")
			CanSell = vgui.Create("DFrame")
			CanSell:SetTitle("Verkaufsbestätigung")
			CanSell:SetSize(280, 120)
			CanSell:ShowCloseButton(false)
			CanSell:MakePopup()
			CanSell:ParentToHUD()
			CanSell.Paint = function(self, w, h)
				draw.RoundedBox(4, 0, 0, w, h, Color(100, 200, 100, 255))
				draw.RoundedBox(4, 1, 1, w - 2, h - 2, Color(50, 50, 50, 255))
				draw.SimpleText("Möchtest du diese Marihuanapflanze wirklich verkaufen?", "DermaDefault", w / 2, 30, Color(200, 200, 200), TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP)
				if !IsValid(Plant) then return end
				draw.SimpleText("Der Verkaufsprozess dauert "..string.ToMinutesSeconds(Plant:GetSellDelay()).." min.", "DermaDefault", w / 2, 45, Color(200, 200, 200), TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP)
			end
			CanSell:SetPos(ScrW() / 2 - CanSell:GetWide() / 2, ScrH())
			CanSell:MoveTo(ScrW() / 2 - CanSell:GetWide() / 2, ScrH() / 2 - CanSell:GetTall() / 2, 0.25, 0, 0.5)
			local Close = vgui.Create("DButton", CanSell)
			Close:SetSize(50, 20)
			Close:SetPos(CanSell:GetWide() - 52, 2)
			Close:SetText("X")
			Close:SetFont("WeedPlant_Close")
			Close:SetTextColor(color_white)
			Close.Paint = function(self, w, h)
				local col
				if self:IsHovered() then
					col = Color(255, 100, 100)
				else
					col = Color(200, 50, 50)
				end
				draw.RoundedBox(4, 0, 0, w, h, col)
			end
			Close.DoClick = function()
				surface.PlaySound("ui/buttonclick.wav")
				CanSell:Remove()
			end
			local AgreeSell = vgui.Create("DButton", CanSell)
			AgreeSell:SetPos(40, 65)
			AgreeSell:SetText("Ja")
			AgreeSell:SetSize(200, 20)
			AgreeSell.DoClick = function()
				if IsValid(Plant) then
					net.Start("WeedPlant_PlantDoAction")
						net.WriteUInt(1, 8)
						net.WriteEntity(Plant)
					net.SendToServer()
				end
				if IsValid(PlantMenu) then
					PlantMenu:Remove()
				end
				CanSell:Remove()
			end
			local DenySell = vgui.Create("DButton", CanSell)
			DenySell:SetPos(40, 90)
			DenySell:SetText("Nein")
			DenySell:SetSize(200, 20)
			DenySell.DoClick = function()
				surface.PlaySound("ui/buttonclick.wav")
				CanSell:Remove()
			end
		elseif Plant:GetCanSell() then
			if IsValid(SellPlantMenu) then return end
			SellPlantMenu = vgui.Create("DFrame")
			SellPlantMenu:SetTitle("Verkaufsoptionen")
			SellPlantMenu:SetSize(200, 85)
			SellPlantMenu:MakePopup()
			SellPlantMenu.Paint = function(self, w, h)
				draw.RoundedBox(4, 0, 0, w, h, Color(35, 35, 35, 255))
			end
			SellPlantMenu:SetPos(ScrW() / 2 - SellPlantMenu:GetWide() / 2, ScrH())
			SellPlantMenu:MoveTo(ScrW() / 2 - SellPlantMenu:GetWide() / 2, ScrH() / 2 - SellPlantMenu:GetTall() / 2, 0.25, 0, 0.5)
			SellPlantMenu:ParentToHUD()
			local RealSell = vgui.Create("DButton", SellPlantMenu)
			RealSell:SetPos(10, 30)
			RealSell:SetText("Verkauf abschließen")
			RealSell:SetSize(180, 20)
			RealSell.DoClick = function()
				if IsValid(PlantMenu) then
					PlantMenu:Remove()
				end
				SellPlantMenu:Remove()
				if IsValid(Plant) then
					net.Start("WeedPlant_PlantDoAction")
						net.WriteInt(4, 8)
						net.WriteEntity(Plant)
					net.SendToServer()
				end
			end
			local ResetSell = vgui.Create("DButton", SellPlantMenu)
			ResetSell:SetPos(10, 55)
			ResetSell:SetText("Verkauf zurücksetzen")
			ResetSell:SetSize(180, 20)
			ResetSell.DoClick = function()
				if IsValid(PlantMenu) then
					surface.PlaySound("ui/buttonclick.wav")
					PlantMenu:Remove()
				end
				SellPlantMenu:Remove()
				if IsValid(Plant) then
					net.Start("WeedPlant_PlantDoAction")
						net.WriteInt(3, 8)
						net.WriteEntity(Plant)
					net.SendToServer()
				end
			end
		else
			if IsValid(PlantMenu) then
				PlantMenu:Remove()
			end
			net.Start("WeedPlant_PlantDoAction")
				net.WriteUInt(3, 8)
				net.WriteEntity(Plant)
			net.SendToServer()
		end
	end
	local SeizeButton = vgui.Create("DButton", PlantMenu)
	SeizeButton:SetPos(205, 70)
	SeizeButton:SetText("Zerstören")
	SeizeButton:SetSize(190, 20)
	SeizeButton.DoClick = function()
		if !IsValid(Plant) then return end
		if !Plant:GetDead() then
			if IsValid(CanDestroy) then return end
			surface.PlaySound("ui/buttonclick.wav")
			CanDestroy = vgui.Create("DFrame")
			CanDestroy:SetTitle("Zerstörungsbestätigung")
			CanDestroy:SetSize(280, 110)
			CanDestroy:ShowCloseButton(false)
			CanDestroy:MakePopup()
			CanDestroy.Paint = function(self, w, h)
				draw.RoundedBox(4, 0, 0, w, h, Color(200, 100, 100, 255))
				draw.RoundedBox(4, 1, 1, w - 2, h - 2, Color(50, 50, 50, 255))
				draw.SimpleText("Möchtest du diese Marihuanapflanze wirklich zerstören?", "DermaDefault", w / 2, 30, Color(200, 200, 200), TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP)
			end
			CanDestroy:SetPos(ScrW() / 2 - CanDestroy:GetWide() / 2, ScrH())
			CanDestroy:MoveTo(ScrW() / 2 - CanDestroy:GetWide() / 2, ScrH() / 2 - CanDestroy:GetTall() / 2, 0.25, 0, 0.5)
			CanDestroy:ParentToHUD()
			local Close = vgui.Create("DButton", CanDestroy)
			Close:SetSize(50, 20)
			Close:SetPos(CanDestroy:GetWide() - 52, 2)
			Close:SetText("X")
			Close:SetFont("WeedPlant_Close")
			Close:SetTextColor(color_white)
			Close.Paint = function(self, w, h)
				local col
				if self:IsHovered() then
					col = Color(255, 100, 100)
				else
					col = Color(200, 50, 50)
				end
				draw.RoundedBox(4, 0, 0, w, h, col)
			end
			Close.DoClick = function()
				surface.PlaySound("ui/buttonclick.wav")
				CanDestroy:Remove()
			end
			local AgreeDestroy = vgui.Create("DButton", CanDestroy)
			AgreeDestroy:SetPos(40, 55)
			AgreeDestroy:SetText("Ja")
			AgreeDestroy:SetSize(200, 20)
			AgreeDestroy.DoClick = function()
				if IsValid(Plant) then
					net.Start("WeedPlant_PlantDoAction")
						net.WriteUInt(2, 8)
						net.WriteEntity(Plant)
					net.SendToServer()
				end
				if IsValid(PlantMenu) then
					surface.PlaySound("ui/buttonclick.wav")
					PlantMenu:Remove()
				end
				CanDestroy:Remove()
			end
			local DenyDestroy = vgui.Create("DButton", CanDestroy)
			DenyDestroy:SetPos(40, 80)
			DenyDestroy:SetText("Nein")
			DenyDestroy:SetSize(200, 20)
			DenyDestroy.DoClick = function()
				surface.PlaySound("ui/buttonclick.wav")
				CanDestroy:Remove()
			end
		else
			if IsValid(Plant) then
				surface.PlaySound("ui/buttonclick.wav")
				net.Start("WeedPlant_PlantDoAction")
					net.WriteUInt(2, 8)
					net.WriteEntity(Plant)
				net.SendToServer()
			end
		end
	end
end
net.Receive("WeedPlant_OpenPlantMenu", cl_Plant.OpenMenu)