include("shared.lua")

function ENT:Initialize()
	self:InitTimer()
	self.IsOvergrowthPowder = true
end

function ENT:InitTimer()
	self:CastEffect()
	timer.Simple(0.1, function()
		if !IsValid(self) then return end
		self:InitTimer()
	end)
end

local local_ply, distance
function ENT:CastEffect()
	if self:GetNoDraw() then return end
	distance = (local_ply or LocalPlayer()):EyePos():DistToSqr(self:GetPos())
	if distance < 562500 then
		local pos = LocalToWorld(Vector(0, 0, 1), Angle(0,0,90), self:GetPos(), self:GetAngles())
		local ed = EffectData()
		ed:SetOrigin(pos)
		util.Effect("effect_weed_plant_powder", ed, true, true)
	end
end

local Powder
local function DrawPowderInfo()
	local_ply = local_ply or LocalPlayer()
	Powder = local_ply:GetEyeTrace().Entity
	if IsValid(Powder) and Powder.IsOvergrowthPowder then
		local distance = local_ply:GetPos():Distance(Powder:GetPos())
		if distance < 110 then
			local xx, yy = ScrW() / 2, ScrH() / 2
			local Alpha = math.Clamp(280 - (0.50 * distance), 0, 250)
			draw.RoundedBox(4, xx - 85, yy - 55, 180, 110, Color(35, 35, 35, Alpha))
			draw.RoundedBox(4, xx - 80, yy - 50, 170, 20, Color(255, 190, 0, Alpha))
			draw.SimpleText("Zauberpulver", "DermaDefaultBold", xx + 5, yy - 48, Color(255, 255, 255, Alpha), TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP)
			draw.SimpleText("Erlaubt Marihuanapflanzen ab", "DermaDefault", xx + 5, yy - 15, Color(255, 255, 255, Alpha), TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP)
			draw.SimpleText("Level 5 zu überwachsen", "DermaDefault", xx + 5, yy - 3, Color(255, 255, 255, Alpha), TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP)
			draw.SimpleText("Vorrausetzung:", "DermaDefault", xx + 5, yy + 23, Color(255, 0, 0, Alpha), TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP)
			draw.SimpleText("Marihuanapflanze Lv.5", "DermaDefault", xx + 5, yy + 35, Color(255, 0, 0, Alpha), TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP)
		end
	end
end
hook.Add("HUDPaint", "WeedPlant_DrawPowderInfo", DrawPowderInfo)