if SERVER then
	AddCSLuaFile("shared.lua")
end

if CLIENT then
	SWEP.Slot = 3
	SWEP.SlotPos = 10
	SWEP.DrawCrosshair = false
end

SWEP.Base = "weapon_basekit"
SWEP.PrintName = "Bibel"
SWEP.Purpose = "Hilft dir beim Vermitteln des Christentums.\n\nAbgesehen davon, kann sie überhaupt nichts."
SWEP.Instructions = "Linksklick zum Hochhalten."
SWEP.Author = "Modern Gaming"
SWEP.Spawnable = true
SWEP.UseHands = true
SWEP.ViewModel = Model("models/weapons/cstrike/c_eq_fraggrenade.mdl")
SWEP.WorldModel = Model("models/toybox/bible.mdl")
SWEP.ShowWorldModel = false
SWEP.ViewModelFOV = 54
SWEP.HoldType = "slam"

SWEP.Primary.Ammo = "none"
SWEP.Primary.Delay = 0.2
SWEP.Secondary.Ammo = "none"

SWEP.m_WeaponDeploySpeed = 2

SWEP.ViewModelBoneMods = {
	["v_weapon.Flashbang_Parent"] = {scale = Vector(0.009, 0.009, 0.009), pos = Vector(0, 0, 0), angle = Angle(0, 0, 0)},
	["ValveBiped.Bip01_R_Finger02"] = {scale = Vector(1, 1, 1), pos = Vector(0.555, 0, 0), angle = Angle(0, 0, 0)}
}

SWEP.VElements = {
	["v_bible"] = {type = "Model", model = Model("models/toybox/bible.mdl"), bone = "v_weapon.Flashbang_Parent", rel = "", pos = Vector(-0.601, 2.5, -0.5), angle = Angle(0, -85.325, 38.57), size = Vector(0.3, 0.3, 0.3), color = Color(255, 255, 255, 255), surpresslightning = false, material = "", skin = 0, bodygroup = {}}
}

SWEP.WElements = {
	["w_bible"] = {type = "Model", model = Model("models/toybox/bible.mdl"), bone = "ValveBiped.Bip01_R_Hand", rel = "", pos = Vector(4.675, 3.635, -1.558), angle = Angle(80.649, -136.754, -8.183), size = Vector(0.5, 0.5, 0.5), color = Color(255, 255, 255, 255), surpresslightning = false, material = "", skin = 0, bodygroup = {}}
}

DEFINE_BASECLASS("weapon_basekit")

function SWEP:SetupDataTables()
	self:NetworkVar("Bool", 0, "Preaching")
end

function SWEP:Initialize()
	self:SetHoldType(self.HoldType)
	return BaseClass.Initialize(self)
end

function SWEP:Deploy()
	self:SetPreaching(false)
	self:SetHoldType(self.HoldType)
	return BaseClass.Deploy(self)
end

function SWEP:PrimaryAttack()
	self:SetNextPrimaryFire(CurTime() + self.Primary.Delay)
	if IsFirstTimePredicted() then
		self:SetPreaching(!self:GetPreaching())
		self:SetHoldType(self:GetPreaching() and "pistol" or self.HoldType)
	end
end
 
function SWEP:SecondaryAttack()
end

function SWEP:Reload()
end

if CLIENT then
	SWEP.MoveToPos = vector_origin + Vector(-1, 10, 0)
	SWEP.LastMultiX = 0
	SWEP.LastSysTime = 0
	function SWEP:GetViewModelPosition(pos, ang)
		pos = pos - ang:Up() * 2
		local preaching = self:GetPreaching()
		local sys_time = SysTime()
		local multx
		if preaching then
			multx = (self.LastMultiX == 1 and 1) or Lerp((sys_time - self.LastSysTime) * 15, self.LastMultiX, 1)
		else
			multx = (self.LastMultiX == 0 and 0) or Lerp((sys_time - self.LastSysTime) * 15, self.LastMultiX, 0)
		end
		self.LastSysTime = sys_time
		if self.MoveToPos then
			local Offset = self.MoveToPos
			pos = pos + Offset.x * ang:Right() * multx
			pos = pos + Offset.y * ang:Forward() * multx
			pos = pos + Offset.z * ang:Up() * multx
			self.LastMultiX = multx
		end
		return pos, ang
	end
end