if SERVER then
	AddCSLuaFile("shared.lua")
end

if CLIENT then
	language.Add("boots_ammo", "Schuhe")
end

game.AddAmmoType({name = "boots", dmgtype = DMG_GENERIC})

if CLIENT then
	SWEP.Slot = 3
	SWEP.SlotPos = 10
	SWEP.DrawCrosshair = false
end

SWEP.Base = "weapon_basekit"
SWEP.PrintName = "Schuh"
SWEP.Purpose = "Ein neues Zeitalter ist angebrochen.\nWerfe nichtsahnende Menschen mit Schuhen ab!"
SWEP.Instructions = "Linksklick zum Schuhe werfen.\nRechtsklick zum Brüllen.\n\nMacht maximal 15 Schaden."
SWEP.Author = "Modern Gaming"
SWEP.Spawnable = true
SWEP.UseHands = true
SWEP.ViewModel = Model("models/weapons/cstrike/c_eq_fraggrenade.mdl")
SWEP.WorldModel = Model("models/weapons/w_grenade.mdl")
SWEP.ShowWorldModel = false
SWEP.ViewModelFOV = 57
SWEP.HoldType = "grenade"

SWEP.Primary.Ammo = "boots"
SWEP.Primary.ClipSize = 1000
SWEP.Primary.DefaultClip = 25
SWEP.Primary.Automatic = true
SWEP.Primary.Sound = Sound("weapons/slam/throw.wav")
SWEP.Secondary.Ammo = "none"
SWEP.Secondary.Delay = 2

SWEP.ViewModelBoneMods = {
	["v_weapon.Flashbang_Parent"] = {scale = Vector(0.1, 0.1, 0.1), pos = Vector(0, 0, 0), angle = Angle(0, 0, 0)},
	["ValveBiped.Bip01_R_Finger0"] = {scale = Vector(1, 1, 1), pos = Vector(-1.297, 0.185, -0.926), angle = Angle(-10, 0, 0)},
	["ValveBiped.Bip01_R_Finger01"] = {scale = Vector(1, 1, 1), pos = Vector(0.185, 0, 0.4), angle = Angle(0, 0, 0)},
	["ValveBiped.Bip01_R_Finger02"] = {scale = Vector(1, 1, 1), pos = Vector(0.5, 0, 0.4), angle = Angle(0, 0, 0)},
	["ValveBiped.Bip01_R_Finger1"] = {scale = Vector(1, 1, 1), pos = Vector(1.296, 0, 0), angle = Angle(0, 0, 0)},
	["ValveBiped.Bip01_R_Finger11"] = {scale = Vector(1, 1, 1), pos = Vector(0.555, 0, 0), angle = Angle(0, 0, 0)},
	["ValveBiped.Bip01_R_Finger2"] = {scale = Vector(1, 1, 1), pos = Vector(2.036, 0, 0), angle = Angle(0, 0, 0)},
	["ValveBiped.Bip01_R_Finger3"] = {scale = Vector(1, 1, 1), pos = Vector(2.407, 0, 0), angle = Angle(0, 0, 0)},
	["ValveBiped.Bip01_R_Finger4"] = {scale = Vector(1, 1, 1), pos = Vector(0.925, -0.186, 0), angle = Angle(0, 0, 0)},
	["ValveBiped.Bip01_L_Clavicle"] = {scale = Vector(1, 1, 1), pos = Vector(0, 0, -1000), angle = Angle(0, 0, 0)},
}

SWEP.VElements = {
	["v_shoe"] = {type = "Model", model = "models/props_junk/shoe001a.mdl", bone = "v_weapon.pull_ring", rel = "", pos = Vector(-1.2, -5, 1.8), angle = Angle(-175, -60, -15), size = Vector(0.9, 0.9, 0.9), color = Color(255, 255, 255), surpresslightning = false, material = "", skin = 0, bodygroup = {}}
}

SWEP.WElements = {
	["w_shoe"] = {type = "Model", model = "models/props_junk/shoe001a.mdl", bone = "ValveBiped.Bip01_R_Hand", rel = "", pos = Vector(5.717, 2.634, 0.07), angle = Angle(0, 0, -13.44), size = Vector(1, 1, 1), color = Color(255, 255, 255), surpresslightning = false, material = "", skin = 0, bodygroup = {}}
}

if SERVER then
	local shoe_dmg = 4

	hook.Add("EntityTakeDamage", "weapon_boots_dmg", function(ent, dmginfo)
		local att = dmginfo:GetInflictor()
		if IsValid(att) and att.IsShoe then
			dmginfo:SetDamage(shoe_dmg)
		end
	end)

	hook.Add("PreventEntityDamage", "weapon_boots_dmg", function(ent, dmginfo)
		local att = dmginfo:GetInflictor()
		if att.IsShoe then
			return false
		end
	end)

	hook.Add("MG_ShouldEnableProtectionMode", "weapon_boots_protection", function(ent)
		if ent.IsShoe then
			return false
		end
	end)

	hook.Add("MG_CanFreezeEntity", "weapon_boots_protection", function(ent)
		if ent.IsShoe then
			return false
		end
	end)
end

DEFINE_BASECLASS("weapon_basekit")

function SWEP:Initialize()
	self:SetHoldType(self.HoldType)
	self:SetRebooting(false)
	BaseClass.Initialize(self)
end

function SWEP:SetupDataTables()
	self:NetworkVar("Bool", 0, "Rebooting")
	self:NetworkVar("Float", 0, "RebootingTimer")
end

function SWEP:Deploy()
	if !IsValid(self.Owner) then return end
	if (self:Clip1() == 0 and self.Owner:GetAmmoCount(self:GetPrimaryAmmoType()) == 0) then
		self.Owner:DrawViewModel(false)
		return true
	end
	self:AmmoRefill()
	self:SetRebooting(false)
	self:SendWeaponAnim(ACT_VM_DRAW)
	self:SetNextPrimaryFire(CurTime() + 1.15)
	self:SetNextSecondaryFire(CurTime() + 1.15)
	return true
end

function SWEP:Holster()
	self:SetRebooting(false)
	return BaseClass.Holster(self)
end

function SWEP:CanPrimaryAttack()
	if self:Clip1() <= 0 then
		self:SetNextPrimaryFire(CurTime() + 0.1)
		return false
	end
	return true
end

function SWEP:PrimaryAttack()
	if self:CanPrimaryAttack() and !self:GetRebooting() then
		self:EmitSound(self.Primary.Sound)
		self:SendWeaponAnim(ACT_VM_THROW)
		local vm = self.Owner:GetViewModel()
		if IsValid(vm) then
			vm:SetPlaybackRate(1.5)
		end
		self:TakePrimaryAmmo(1)
		self.Owner:SetAnimation(PLAYER_ATTACK1)
		if (self:Clip1() != 0 or self.Owner:GetAmmoCount(self:GetPrimaryAmmoType()) != 0) then
			self:SetRebootingTimer(CurTime() + 0.5)
			self:SetRebooting(true)
		end
		if SERVER then
			local boot = ents.Create("prop_physics") 
			if !IsValid(boot) then return end
			boot:SetModel("models/props_junk/shoe001a.mdl")
			local vec = Vector(0, 0, 12)
			if self.Owner:Crouching() then
				vec = Vector(0, 0, 8)
			end
			boot:SetAngles(self.Owner:EyeAngles())
			boot:SetPos((self.Owner:EyePos() - vec) + (self.Owner:GetForward() * 3) + (self.Owner:GetRight() * 8))
			boot:SetPhysicsAttacker(self.Owner)
			boot:SetOwner(self.Owner)
			boot:Spawn()
			boot:Activate()
			boot.IsShoe = true
			local bootphys = boot:GetPhysicsObject()
			if IsValid(bootphys) then
				bootphys:AddAngleVelocity(Vector(0, 500, 0))
				bootphys:ApplyForceCenter(self.Owner:EyeAngles():Forward():GetNormalized() * 5000)
			end
			timer.Create("boot_destroy_"..boot:EntIndex(), 10, 1, function()
				SafeRemoveEntity(boot)
			end)
			boot:AddCallback("PhysicsCollide", function(self)
				if !IsValid(self) or self.Called then return end
				self.Called = true
				timer.Remove("boot_destroy_"..self:EntIndex())
				SafeRemoveEntityDelayed(self, 5)
			end)
			hook.Run("onBootThrown", self.Owner)
		end
	end
end
 
function SWEP:SecondaryAttack()
	if self:CanPrimaryAttack() then
		self:EmitSound("npc/zombie/zombie_voice_idle"..math.random(1, 14)..".wav")
		self:SetNextSecondaryFire(CurTime() + self.Secondary.Delay)
	end
end

function SWEP:Reload()
end

function SWEP:AmmoRefill()
	local owner = self:GetOwner()

	if !IsValid(owner) then return end

	if owner:GetAmmoCount(self:GetPrimaryAmmoType()) > 0 and self:Clip1() <= 0 then
		if self:Clip1() <= 0 then
			owner:DrawViewModel(true)
			self:SendWeaponAnim(ACT_VM_DRAW)
			self:SetNextPrimaryFire(CurTime() + 1.15)
		end
		self:SetClip1(math.Clamp(self:Clip1() + owner:GetAmmoCount(self:GetPrimaryAmmoType()), 0, self.Primary.ClipSize))
		owner:RemoveAmmo(owner:GetAmmoCount(self:GetPrimaryAmmoType()), self:GetPrimaryAmmoType())
	end
end

function SWEP:Think()
	self:AmmoRefill()

	if self:GetRebooting() and self:GetRebootingTimer() < CurTime() then
		self:SetRebooting(false)
		self:SendWeaponAnim(ACT_VM_DRAW)
		self:SetNextPrimaryFire(CurTime() + 1.15)
	end
end

if CLIENT then
	function SWEP:CustomAmmoDisplay()
		self.AmmoDisplay = self.AmmoDisplay or {}
		self.AmmoDisplay.Draw = true
		self.AmmoDisplay.PrimaryClip = self:Clip1()
		return self.AmmoDisplay
	end

	function SWEP:GetViewModelPosition(pos, ang)
		local vm = IsValid(self.Owner) and self.Owner:GetViewModel()
		if IsValid(vm) then
			pos = pos + vm:GetUp() * -1
		end
		ang:RotateAroundAxis(ang:Up(), 5)
		ang:RotateAroundAxis(ang:Forward(), 1)
		ang:RotateAroundAxis(ang:Right(), -5)
		return pos, ang
	end
end