if SERVER then
	AddCSLuaFile()
end

SWEP.PrintName = "Beißen"
SWEP.ViewModel = ""
SWEP.WorldModel = ""
SWEP.DrawWeaponInfoBox = true
SWEP.Purpose = "Du bist ein Hund. Benehme dich auch so."
SWEP.Instructions = "Linksklick zum Beißen.\nRechtsklick zum Bellen.\nNachladen zum Winseln."
SWEP.Author = "Modern Gaming"
SWEP.Spawnable = false
SWEP.Primary.ClipSize = -1
SWEP.Primary.DefaultClip = -1
SWEP.Primary.Delay = 0.5
SWEP.Primary.Automatic = false
SWEP.Primary.Ammo = "none"
SWEP.Secondary.ClipSize = -1
SWEP.Secondary.DefaultClip = -1
SWEP.Secondary.Ammo = "none"
SWEP.Secondary.Automatic = false
SWEP.Slot = 0
SWEP.SlotPos = 0
SWEP.DrawAmmo = false
SWEP.DrawCrosshair = false
SWEP.NextReload = 0

SWEP.StrayDamage = 25
SWEP.PoliceDogDamage = 35
SWEP.AttackTime = 1.5
SWEP.BarkTime = 0.45
SWEP.ReloadTime = 3

local DamageSound = Sound("npc/barnacle/neck_snap2.wav")

function SWEP:SetupDataTables()
	self:NetworkVar("Float", 0, "NextMeleeAttack")
end

function SWEP:Deploy()
	self:SetNextMeleeAttack(0)
	return true
end

function SWEP:PrimaryAttack()
	if self.NextReload > CurTime() then return end
	self:SetNextMeleeAttack(CurTime() + 0.3)
	self:SetNextPrimaryFire(CurTime() + self.AttackTime)
	self:SetNextSecondaryFire(CurTime() + self.AttackTime)
	self:EmitSound("dog/bite.wav")
	self.NextReload = CurTime() + self.AttackTime
end

function SWEP:SecondaryAttack()
	if self.NextReload > CurTime() then return end
	self:EmitSound("dog/bark"..math.random(1, 6)..".mp3")
	self:SetNextPrimaryFire(CurTime() + self.BarkTime)
	self:SetNextSecondaryFire(CurTime() + self.BarkTime)
	self.NextReload = CurTime() + self.BarkTime
end

function SWEP:Reload()
	if self.NextReload > CurTime() then return end
	self:EmitSound("dog/whine"..math.random(1, 3)..".mp3")
	self:SetNextPrimaryFire(CurTime() + self.ReloadTime)
	self:SetNextSecondaryFire(CurTime() + self.ReloadTime)
	self.NextReload = CurTime() + self.ReloadTime
end

function SWEP:DealDamage()
	local owner = self.Owner
	owner:LagCompensation(true)
	local tr = util.TraceLine({
		start = owner:GetShootPos(),
		endpos = owner:GetShootPos() + owner:EyeAngles():Forward() * 42,
		filter = owner,
		mask = MASK_SHOT_HULL
	})
	if !IsValid(tr.Entity) then 
		tr = util.TraceHull({
			start = owner:GetShootPos(),
			endpos = owner:GetShootPos() + owner:EyeAngles():Forward() * 42,
			filter = owner,
			mins = Vector(-10, -10, -8),
			maxs = Vector(10, 10, 8),
			mask = MASK_SHOT_HULL
		})
	end
	owner:LagCompensation(false)
	if (tr.Hit and !(game.SinglePlayer() and CLIENT)) then
		self:EmitSound(DamageSound)
	end
	if SERVER and IsValid(tr.Entity) then
		local pos = owner:GetShootPos()
		if tr.Entity:IsPlayer() or tr.Entity:IsNPC() then
			local edata = EffectData()
			edata:SetStart(owner:GetShootPos())
			edata:SetOrigin(tr.HitPos)
			edata:SetNormal(tr.Normal)
			edata:SetSurfaceProp(tr.SurfaceProps)
			edata:SetHitBox(tr.HitBox)
			edata:SetEntity(tr.Entity)
			util.Effect("BloodImpact", edata, true, true)
		end
		local dmginfo = DamageInfo()
		local attacker = owner
		if !IsValid(attacker) then attacker = self end
		dmginfo:SetAttacker(attacker)
		dmginfo:SetInflictor(self)
		dmginfo:SetDamage((owner:Team() == TEAM_POLICEDOG and self.PoliceDogDamage or self.StrayDamage) * math.Rand(0.9, 1.1))
		local dest = pos + (owner:EyeAngles():Forward() * 42)
		tr.Entity:DispatchTraceAttack(dmginfo, pos + (owner:EyeAngles():Forward() * 3), dest)
	end
	if SERVER and IsValid(tr.Entity) then
		local phys = tr.Entity:GetPhysicsObject()
		if IsValid(phys) and phys:GetMass() < 250 then
			phys:ApplyForceOffset(owner:EyeAngles():Forward() * 200 * phys:GetMass(), tr.HitPos)
		end
	end
end

function SWEP:Think()
	local meleetime = self:GetNextMeleeAttack()
	if (meleetime > 0 and CurTime() > meleetime) then
		self:DealDamage()
		self:SetNextMeleeAttack(0)
	end
end

function SWEP:OnDrop()
	self:Remove()
end