if SERVER then
	AddCSLuaFile()
end

if CLIENT then
	SWEP.Slot = 3
	SWEP.SlotPos = 2
	SWEP.DrawAmmo = false
	SWEP.DrawCrosshair = true
end

SWEP.PrintName = "EMP"
SWEP.Author = "Modern Gaming"
SWEP.Instructions = "Linksklick um Fahrzeuge zu stoppen."
SWEP.Spawnable = true
SWEP.UseHands = true
SWEP.ViewModel = Model("models/weapons/c_pistol.mdl")
SWEP.WorldModel = Model("models/weapons/w_pistol.mdl")

SWEP.Primary.Delay = 2
SWEP.Primary.ClipSize = -1
SWEP.Primary.DefaultClip = -1
SWEP.Primary.Automatic = false
SWEP.Primary.Ammo = ""
SWEP.Secondary.ClipSize = -1
SWEP.Secondary.DefaultClip = -1
SWEP.Secondary.Automatic = false
SWEP.Secondary.Ammo = ""

SWEP.Range = 80000

local col1 = Color(0, 100, 255, 255)
local col2 = Color(150, 0, 0, 255)
function SWEP:DoDrawCrosshair()
	local w, h = ScrW(), ScrH()
	local w2, h2 = w / 2, h / 2
	local ply = LocalPlayer()
	if !self.Vehicle or self.next_tr < CurTime() then
		self.Vehicle = util.TraceLine(util.GetPlayerTrace(ply))
		self.next_tr = CurTime() + 0.05
	end
	local ent = self.Vehicle.Entity
	local hit = self.Vehicle.HitPos:DistToSqr(ply:GetShootPos()) <= self.Range and IsValid(ent) and ent:IsVehicle() and ent:GetClass() != "prop_vehicle_prisoner_pod"
	surface.SetDrawColor(hit and col1 or col2)
	local gap = (hit and 0 or 10) + 5
	local length = 10
	surface.DrawLine(w2 - length, h2, w2 - gap, h2)
	surface.DrawLine(w2 + length, h2, w2 + gap, h2)
	surface.DrawLine(w2, h2 - length, w2, h2 - gap)
	surface.DrawLine(w2, h2 + length, w2, h2 + gap)
	return true
end

function SWEP:Initialize()
	self:SetHoldType("pistol")
	self:SetDeploySpeed(2)
end

local vehicle_exceptions = {
	["porcycletdm"] = true
}
function SWEP:PrimaryAttack()
	self:SetNextPrimaryFire(CurTime() + 0.2)
	self.Owner:LagCompensation(true)
	local mg = self.Owner:GetEyeTrace()
	self.Owner:LagCompensation(false)
	local ent = mg.Entity
	if !IsValid(ent) then return end
	local class = ent:GetClass()
	if !ent:IsVehicle() or class == "prop_vehicle_prisoner_pod" then return end
	local veh_class = ent:GetVehicleClass()
	if vehicle_exceptions[veh_class] then return end
	local distance = self.Owner:GetShootPos():DistToSqr(mg.HitPos)
	if (distance > self.Range) then return end
	self:EmitSound("Weapon_StunStick.Activate")
	self:ShootEffects()
	self:SetNextPrimaryFire(CurTime() + self.Primary.Delay)
	if SERVER then
 		self:StopVehicle(ent, class)
			local edata = EffectData()
			edata:SetScale(1)
			edata:SetMagnitude(1)
			edata:SetScale(1)
			edata:SetRadius(1)
			edata:SetEntity(ent)
			for i = 1, 50 do
				timer.Simple( 1 / i, function()
					if !IsValid(ent) then return end
					edata:SetStart(ent:GetPos() + Vector(math.Rand(-25, 25), math.Rand(-25, 25), math.Rand(0, 25)))
					edata:SetOrigin(ent:GetPos() + Vector(math.Rand(-25, 25), math.Rand(-25, 25), math.Rand(0, 25)))
					util.Effect("TeslaHitBoxes", edata, true, true)
				end)
			end
		hook.Run("onStoppedVehicle", self.Owner, ent)
	end
end

function SWEP:StopVehicle(mg, class)
	if class == "prop_vehicle_airboat" then
		mg:StartEngine(false)
		timer.Create("EMP_TurnBackOn_"..mg:EntIndex(), 5, 1, function()
			if !IsValid(mg) or mg:IsEngineStarted() then return end
			mg:StartEngine(true)
		end)
	else
		if mg:IsEngineStarted() then
			mg.NextEngineStartAllowed = CurTime() + 1
			mg:Fire("TurnOff")
		end
		timer.Remove("Fuel_Start_"..mg:EntIndex())
	end
end

function SWEP:SecondaryAttack()
end

local shoulddisable = {}
shoulddisable[5003] = true
shoulddisable[6001] = true
function SWEP:FireAnimationEvent(pos, ang, event, options)
	if shoulddisable[event] then return true end
end