if SERVER then
	AddCSLuaFile()
end

if CLIENT then
	SWEP.Slot = 5
	SWEP.SlotPos = 100
	SWEP.DrawAmmo = false
	SWEP.DrawCrosshair = true
end

SWEP.PrintName = "Killzone"
SWEP.Author = "Modern Gaming"
SWEP.Category = "Admin"
SWEP.Instructions = "Linksklick um einen Gegenstand zu einer Killzone zu machen.\nRechtsklick um die Killzone eines Gegenstands zu entfernen.\nR + E zum Regulieren des Schadens."
SWEP.Spawnable = true
SWEP.UseHands = true
SWEP.ViewModel = Model("models/weapons/c_pistol.mdl")
SWEP.WorldModel = Model("models/weapons/w_pistol.mdl")

SWEP.Primary.Delay = 2
SWEP.Primary.ClipSize = -1
SWEP.Primary.DefaultClip = -1
SWEP.Primary.Automatic = false
SWEP.Primary.Ammo = ""
SWEP.Secondary.ClipSize = -1
SWEP.Secondary.DefaultClip = -1
SWEP.Secondary.Automatic = false
SWEP.Secondary.Ammo = ""

SWEP.DamageAmount = 1000

function SWEP:SetupDataTables()
	self:NetworkVar("Int", 0, "Damage")
	self:SetDamage(self.DamageAmount)
end

local ShootSound = Sound("Metal.SawbladeStick")
local function DoEffect(self, tr)
	sound.Play(ShootSound, tr.HitPos)
	local ed = EffectData()
	ed:SetOrigin(tr.HitPos)
	ed:SetNormal(tr.HitNormal)
	ed:SetScale(2)
	ed:SetMagnitude(3)
	util.Effect("ElectricSpark", ed, true, true)
end

function SWEP:PrimaryAttack()
	if !SERVER then return end
	local trace = self.Owner:GetEyeTrace()
	local ent = trace.Entity
	if !IsValid(ent) or ent:IsPlayer() or ent.KillZone then return end
	local damage = self:GetDamage()
	local id = ent:AddCallback("PhysicsCollide", function(ent, data)
		local ent = data.HitEntity
		if IsValid(ent) and ent:IsPlayer() and ent:Alive() then
			if ent:IsPlayer() and ent:HasGodMode() then return end
			local dmg = DamageInfo()
			dmg:SetDamage(damage)
			dmg:SetAttacker(ent)
			dmg:SetInflictor(ent)
			dmg:SetDamageType(DMG_DISSOLVE)
			ent.NoProtection = true
			ent:TakeDamageInfo(dmg)
			ent.NoProtection = nil
			local tr = {
				["HitPos"] = ent:GetPos(),
				["HitNormal"] = Vector(0, 0, 1),
			}
			DoEffect(ent, tr)
		end
	end)
	ent.KillZone = id
	DoEffect(self, trace)
end

function SWEP:SecondaryAttack()
	if !SERVER then return end
	local trace = self.Owner:GetEyeTrace()
	local ent = trace.Entity
	if !IsValid(ent) or ent:IsPlayer() or !ent.KillZone then return end
	ent:RemoveCallback("PhysicsCollide", ent.KillZone)
	ent.KillZone = nil
	DoEffect(self, trace)
end

function SWEP:Reload()
	if (self.NextEdit or 0) > CurTime() then return end
	self.NextEdit = CurTime() + 0.03
	self:SetDamage(math.max(10, self:GetDamage() + (self.Owner:KeyDown(IN_USE) and -10 or 10)))
end

function SWEP:DrawHUD()
	local scrw, scrh = ScrW() / 2, ScrH() - 110
	draw.SimpleTextOutlined("Schaden: "..string.Comma(self:GetDamage()), "mg_instructions", scrw, scrh + 10, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
	draw.SimpleTextOutlined("R + E zum Regulieren.", "mg_instructions2", scrw, scrh + 25, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, color_black)
end