if SERVER then
	AddCSLuaFile()
end

SWEP.Author = "Modern Gaming"
SWEP.PrintName = "Pinkeln"
SWEP.Instructions = "Mit Linksklick kannst du loslegen!"
SWEP.Purpose = "Manchmal muss man es einfach laufen lassen!"
SWEP.Slot = 1
SWEP.SlotPos = 10
SWEP.DrawCrosshair = false
SWEP.Spawnable = true
SWEP.Base = "weapon_base"
SWEP.UseHands = true
SWEP.ViewModelFOV = 50
SWEP.ViewModel = Model("models/weapons/c_arms.mdl")
SWEP.WorldModel = ""
SWEP.HoldType = "normal"

SWEP.Primary.Ammo = "none"
SWEP.Primary.ClipSize = 250
SWEP.Primary.DefaultClip = 250
SWEP.Primary.Delay = 0.01
SWEP.Primary.Automatic = true
SWEP.Secondary.Ammo = "none"
SWEP.Secondary.Delay = 3

local Shout = Sound("vo/npc/barney/ba_hereitcomes.wav")
local Unzip = Sound("piss/zipperdown.wav")

function SWEP:Initialize()
	self:SetHoldType(self.HoldType)

	timer.Simple(0, function()
		if !IsValid(self) or !IsValid(self.Owner) then return end
		hook.Run("InitializePeeSWEP", self, self.Owner)
	end)
end

function SWEP:PreDrawViewModel(vm)
	return true
end

function SWEP:Deploy()
	self:EmitSound(Unzip)
	self:SetNextPrimaryFire(CurTime() + 1)
	self:SetNextSecondaryFire(CurTime() + 1)
	if SERVER then
		self:InitTimer()
	end
	return true
end

function SWEP:Holster()
	self:KillSounds()
	if !SERVER then return true end
	timer.Remove("Prep_Reload_"..self:EntIndex())
	timer.Remove("Reload_"..self:EntIndex())
	return true
end

function SWEP:OnRemove()
	self:Holster()
end

function SWEP:PrimaryAttack()
end

function SWEP:SecondaryAttack()
end

function SWEP:InitTimer()
	timer.Remove("Prep_Reload_"..self:EntIndex())
	timer.Remove("Reload_"..self:EntIndex())
	if self:Clip1() >= self.Primary.ClipSize then return end
	timer.Create("Prep_Reload_"..self:EntIndex(), 1.5, 0, function()
		if IsValid(self) then
			timer.Create("Reload_"..self:EntIndex(), 0.075, 0, function()
				if IsValid(self) then
					if self:Clip1() < self.Primary.ClipSize then
						self:SetClip1(self:Clip1() + 1)
					else
						timer.Remove("Reload_"..self:EntIndex())
					end
				end
			end)
		end
	end)
end

function SWEP:CanPrimaryAttack()
	if self:Clip1() <= 0 then
		self:SetNextPrimaryFire(CurTime() + 0.1)
		if SERVER then
			self:InitTimer()
		end
		return false
	end
	return true
end

local custom_rules = {
	["default"] = function(ply)
		local pos = ply:GetPos() + Vector(0, 0, 32)
		if ply:Crouching() then
			pos = ply:GetPos() + Vector(0, 0, 16)
		end
		return {pos, ply:GetAngles(), 215, true}
	end,
	["models/falloutdog/falloutdog.mdl"] = function(ply)
		local plyang = ply:GetAngles()
		local ang = Angle(0, plyang.y, 0)
		local pos = ply:GetPos() - ang:Forward() * 18 + Vector(0, 0, 22)
		if ply:Crouching() then
			pos = ply:GetPos() - ang:Forward() * 20 + Vector(0, 0, 8)
		end
		return {pos, ang, 100, false}
	end,
}

local pee_loop = Sound("ambient/water/water_flow_loop1.wav")
function SWEP:PrimaryAttack()
	if !self:CanPrimaryAttack() then return end
	if self.Owner:GetAngles().p < -32 or self.Owner:GetAngles().p > 60 then return end
	if self.LoopSound then
		self.LoopSound:ChangeVolume(0.25, 0.25)
	else
		self.LoopSound = self.LoopSound or CreateSound(self.Owner, pee_loop)
		if self.LoopSound then
			self.LoopSound:Play()
		end
	end
	if IsFirstTimePredicted() then
		local rules = custom_rules[self.Owner:GetModel()] and custom_rules[self.Owner:GetModel()](self.Owner) or custom_rules["default"](self.Owner)
		local ed = EffectData()
		ed:SetEntity(self.Owner)
		ed:SetOrigin(rules[1])
		ed:SetAngles(rules[2])
		ed:SetRadius(rules[3])
		util.Effect("effect_piss", ed, true, false)
	end
	if SERVER then
		self:InitTimer()
	end
	self:TakePrimaryAmmo(1)
	self:SetNextPrimaryFire(CurTime() + self.Primary.Delay)
	self.Owner:ViewPunch(Angle(-0.01, 0, 0))
	if SERVER then
		if !self.Pissing then
			hook.Run("onPiss", self.Owner)
		end
		self.Pissing = true
		timer.Create("piss_stop_"..self.Owner:EntIndex(), 1, 1, function()
			if IsValid(self) and IsValid(self.Owner) and self.Pissing then
				self.Pissing = false
				hook.Run("onPissStop", self.Owner)
			end
		end)
	end
end

function SWEP:SecondaryAttack()
	local rules = custom_rules[self.Owner:GetModel()] and custom_rules[self.Owner:GetModel()](self.Owner) or custom_rules["default"](self.Owner)
	if !rules[4] then return end
	self:EmitSound(Shout)
	self:SetNextSecondaryFire(CurTime() + self.Secondary.Delay)
end

function SWEP:Think()
	local owner = self:GetOwner()
	if owner:KeyReleased(IN_ATTACK) or !owner:KeyDown(IN_ATTACK) or !self:CanPrimaryAttack() or owner:GetAngles().p > -32 or owner:GetAngles().p < 60 then
		if self.LoopSound then
			self.LoopSound:ChangeVolume(0, 0.5)
		end
	end
end

function SWEP:KillSounds()
	if self.LoopSound then
		self.LoopSound:Stop()
		self.LoopSound = nil
	end
end

function SWEP:Holster()
	self:KillSounds()
	return true
end

function SWEP:OnRemove()
	self:KillSounds()
end

function SWEP:OnDrop()
	self:KillSounds()
end

function SWEP:Reload()
end

function SWEP:CustomAmmoDisplay()
	self.AmmoDisplay = self.AmmoDisplay or {}
	self.AmmoDisplay.Draw = true
	self.AmmoDisplay.PrimaryClip = self:Clip1()
	return self.AmmoDisplay
end