TASER = {}

SWEP.Base = "weapon_basekit"
SWEP.PrintName = "Taser"
SWEP.Instructions = "Linksklick, um eine Person zu tasern."
SWEP.HoldType = "pistol"
SWEP.ViewModelFOV = 50
SWEP.ViewModelFlip = false
SWEP.ViewModel = Model("models/weapons/c_pistol.mdl")
SWEP.WorldModel = Model("models/weapons/w_pistol.mdl")
SWEP.UseHands = true
SWEP.Spawnable = true
SWEP.Primary.ClipSize = -1
SWEP.Primary.DefaultClip = 0
SWEP.Primary.Ammo = "none"
SWEP.Primary.Automatic = false
SWEP.Secondary.ClipSize = -1
SWEP.Secondary.DefaultClip = -1
SWEP.Secondary.Automatic = false
SWEP.Secondary.Ammo = "none"

SWEP.Range = 400
SWEP.ReloadCharge = false
SWEP.RechargeTime = 2.6
SWEP.DepletionTime = 0.4

DEFINE_BASECLASS("weapon_basekit")

function SWEP:SetupDataTables()
	self:NetworkVar("Bool", 0, "Deplete")
	self:NetworkVar("Float", 0, "LastUse")
	self:NetworkVar("Float", 1, "Charge")
end

function SWEP:Initialize()
	BaseClass.Initialize(self)
	self:SetHoldType(self.HoldType)
	self:SetCharge(100)
	if CLIENT then
		self.VElements["counter"].draw_func = function()
			self:DrawScreen(-27, -65, 65, 123)
		end
	end
end

function SWEP:Deploy()
	self:SendWeaponAnim(ACT_VM_DRAW)
	self:SetNextPrimaryFire(CurTime() + self:SequenceDuration())
	self:SetNextSecondaryFire(CurTime() + self:SequenceDuration())
	return true
end

function SWEP:PrimaryAttack()
	if !IsValid(self.Owner) then return end
	if self:GetCharge() < 100 then return end
	self:SetLastUse(CurTime())
	self:SetDeplete(true)
	self:SendWeaponAnim(ACT_VM_PRIMARYATTACK)
	self.Owner:SetAnimation(PLAYER_ATTACK1)
	if SERVER then
		self.Owner:EmitSound("npc/turret_floor/shoot1.wav", 100)
		self.Owner:LagCompensation(true)
		local tr = self.Owner:GetEyeTrace()
		self.Owner:LagCompensation(false)
		local ent = tr.Entity
		local disttosqr = self.Owner:GetShootPos():DistToSqr(tr.HitPos)
		if IsValid(ent) and ent:IsPlayer() and !ent:HasGodMode() and !IsValid(ent.PlayerRagdoll) and ent != self.Owner and disttosqr < self.Range and hook.Run("canTasePlayer", self.Owner, self, ent) != false then
			local edata = EffectData()
			edata:SetOrigin(tr.HitPos)
			edata:SetStart(self.Owner:GetShootPos())
			edata:SetAttachment(1)
			edata:SetEntity(self)
			util.Effect("ToolTracer", edata, true, true)
			TASER.Electrolute(ent)
			DarkRP.log(self.Owner:Name().." ("..self.Owner:SteamID()..") tasered "..ent:Name(), Color(0, 255, 255))
			hook.Run("onPlayerTasered", self.Owner, ent)
		end
	else
		hook.Run("onTaserUsed", self.Owner)
	end
end

function SWEP:Think()
	if self:GetCharge() < 100 or self:GetDeplete() then
		local charge
		if self:GetDeplete() then
			speed = self.DepletionTime
			speed = hook.Run("taserDeplete", self, speed) or speed
			charge = 100 - ((CurTime() - self:GetLastUse()) / speed) * 100
		else
			speed = self.RechargeTime
			speed = hook.Run("taserRecharge", self, speed) or speed
			charge = ((CurTime() - self:GetLastUse()) / speed) * 100
		end
		self:SetCharge(math.Clamp(charge, 0, 100))
		if self:GetCharge() <= 0 and self:GetDeplete() then
			self:SetLastUse(CurTime())
			self:SetDeplete(false)
			self:SetCharge(0)
		end
	end
end

function SWEP:SecondaryAttack()
end

function SWEP:Reload()
end

local shoulddisable = {}
shoulddisable[5003] = true
shoulddisable[6001] = true
function SWEP:FireAnimationEvent(pos, ang, event, options)
	if shoulddisable[event] then return true end
end

SWEP.Range = SWEP.Range * SWEP.Range