if SERVER then
	AddCSLuaFile()
end

SWEP.PrintName = "Gießkanne"
SWEP.ViewModelFOV = 90
SWEP.ViewModel = Model("models/weapons/eryk/watercan_weapon/v_watercan.mdl")
SWEP.WorldModel = Model("models/weapons/eryk/watercan_weapon/w_watercan.mdl")
SWEP.DrawWeaponInfoBox = true
SWEP.Purpose = "Wird benutzt, um Pflanzen zu wässern."
SWEP.Instructions = "Linksklick zum Wässern von Pflanzen."
SWEP.Author = "Modern Gaming"
SWEP.Spawnable = true
SWEP.Primary.ClipSize = -1
SWEP.Primary.DefaultClip = -1
SWEP.Primary.Delay = 0.5
SWEP.Primary.Automatic = true
SWEP.Primary.Ammo = "none"
SWEP.Secondary.ClipSize = -1
SWEP.Secondary.DefaultClip = -1
SWEP.Secondary.Ammo = "none"
SWEP.Secondary.Automatic = false
SWEP.Slot = 0
SWEP.SlotPos = 10
SWEP.DrawAmmo = false
SWEP.DrawCrosshair = true
SWEP.Range = 100 * 100
SWEP.m_WeaponDeploySpeed = 1

function SWEP:Initialize()
	self:SetHoldType("slam")
end

function SWEP:CalcViewModelView(vm, oldPos, oldAng, pos, ang)
	local oldPos = vm:GetPos()
	local oldAng = vm:GetAngles()
	local newPos = pos + ang:Up() * -4 + ang:Forward() * -20
  	local newAng = ang + Angle(-18, 0, 0)
	return newPos, newAng
end

function SWEP:PrimaryAttack()
	self:SetNextPrimaryFire(CurTime() + self.Primary.Delay)
	self:SetNextSecondaryFire(CurTime() + self.Primary.Delay)
	self.Owner:LagCompensation(true)
	local mg = self.Owner:GetEyeTrace()
	self.Owner:LagCompensation(false)
	local ent = mg.Entity
	if !IsValid(ent) or (!ent.IsPlant and !ent.IsWeedPlant) then return end
	if ent.IsPlant and ent:GetID() == 0 then return end
	local distance = self.Owner:GetShootPos():DistToSqr(mg.HitPos)
	if distance > self.Range then return end
	self.Owner:SetAnimation(PLAYER_ATTACK1)
	self:SendWeaponAnim(ACT_VM_HITCENTER)
	if !SERVER then return end
	ent:Water()
end

function SWEP:SecondaryAttack()
end

function SWEP:OnDrop()
	self:Remove()
end