ENT.Type = "anim"

DEFINE_BASECLASS("wdj_audiosource")

ENT.Base = "wdj_audiosource"

ENT.PrintName = "Radiokonsole"
ENT.Category = "DJ"

ENT.Spawnable = true

ENT.RenderGroup = RENDERGROUP_BOTH
ENT.Model = "models/props/de_nuke/nuclearcontrolbox.mdl"

function ENT:SetupDataTables()
	BaseClass.SetupDataTables(self)
	self:NetworkVar("Float", 0, "CurMediaStarted")
	self:NetworkVar("String", 0, "CurMedia")
	self:NetworkVar("String", 1, "NextMedia")
	self:NetworkVar("String", 2, "ChannelNameInternal")
	self:NetworkVar("String", 3, "FallbackMedia")
	self:NetworkVar("Bool", 0, "BroadcastVoice")
	self:NetworkVar("Bool", 1, "PlaySound")
end

wdj.DJ_Controllers = {}
function ENT:Initialize()
	if SERVER then
		self:SetModel(self.Model)
		self:PhysicsInit(SOLID_VPHYSICS)
		self:SetMoveType(MOVETYPE_VPHYSICS)
		self:SetSolid(SOLID_VPHYSICS)
		for ch=0,wdj.MAX_CHANNELS do
			local m = wdj.GetMaster(ch, self)
			if !IsValid(m) then
				self:SetChannel(ch)
				break
			end
		end
		self:CPPISetOwner(self:Getowning_ent())
	end
end

hook.Add(SERVER and "OnEntityCreated" or "NetworkEntityCreated", "wdj.DJControllersTable", function(ent)
	if ent:GetClass() == "wdj_mastercontroller" then
		wdj.DJ_Controllers[ent:EntIndex()] = ent
	end
end)

hook.Add("EntityRemoved", "wdj.DJControllersTable", function(ent)
	wdj.DJ_Controllers[ent:EntIndex()] = nil
end)

function ENT:WDJ_IsAllowed(ply)
	if ply:EyePos():DistToSqr(self:GetPos()) > 100000 then return false end
	if DarkRP and ply:Team() == TEAM_DJ then return true end
	if ply == self:CPPIGetOwner() then return true end
	return false
end

function ENT:IsAudioSourceEnabled()
	return self:GetPlaySound()
end

function ENT:GetRadioMaster()
	return self
end

function ENT:GetChannelName()
	local nm = self:GetChannelNameInternal()
	if nm != "" then return nm end
end

function ENT:GetChannelNameFormatted()
	local name = self:GetChannelName()
	if name then
		name = string.format("%s (#%d)", name, self:GetChannel())
	else
		name = string.format("Channel #%d", self:GetChannel())
	end
	return name
end

function ENT:SetChannelName(nm)
	if nm == nil then nm = "" end
	self:SetChannelNameInternal(nm)
end