local SKIN = {}

SKIN.DermaVersion = 1
SKIN.GwenTexture = Material("gwenskin/GModDefault.png")

function SKIN:PaintFrame(panel, w, h)
	surface.SetDrawColor(255, 255, 255)
	surface.DrawRect(0, 0, w, h)
	surface.SetDrawColor(127, 127, 127)
	surface.DrawOutlinedRect(0, 0, w, h)
	surface.SetDrawColor(50, 50, 50)
	surface.DrawRect(0, 0, w, 25)
end

function SKIN:PaintButton( panel, w, h )
	if panel:GetText() == "" then return end
	if panel.Depressed or panel:IsSelected() or panel:GetToggle() then
	elseif panel:GetDisabled() then
		surface.SetDrawColor(170, 170, 170)
	elseif panel.Hovered then
		surface.SetDrawColor(100, 100, 100)
	else
		surface.SetDrawColor(50, 50, 50)
	end
	surface.DrawRect(0, 0, w, h)
	surface.SetDrawColor(0, 0, 0)
	surface.DrawOutlinedRect(0, 0, w, h)
end
derma.DefineSkin("WyoziCK", "l337", SKIN)

local PANEL = {}

function PANEL:InitCustomControls(ctrl)
	local qbtn = ctrl:Add("DButton")
	qbtn:Dock(RIGHT)
	qbtn:SetWide(100)
	qbtn:SetText("Titel hinzufügen")
	qbtn.DoClick = function()
		self:OnURLSelected(ctrl.AddressBar:GetText())
	end
	self.addToQueueButton = qbtn
end

function PANEL:Init()
	self.browser = self:Add("DHTML")
	self.browser:Dock(FILL)
	self.browser:OpenURL("https://youtube.com/")
	self.browser.Paint = function() end
	local oldcm = self.browser.ConsoleMessage
	self.browser.ConsoleMessage = function(pself, msg, ...)
		if msg then
			if string.find(msg, "XMLHttpRequest") then return end
			if string.find(msg, "Unsafe JavaScript attempt to access") then return end
		end
		return oldcm(pself, msg, ...)
	end
	self.browser.UrlChanged = function() end
	self.browser:AddFunction("medialib", "CurrentURL", function(curl)
		if curl != self.browser._lastcurl then
			self.browser:UrlChanged(curl)
			self.browser._lastcurl = curl
		end
	end)
	self.browser:AddFunction("medialib", "QueueURL", function(url)
		self:OnURLSelected(url)
	end)
	function self.browser:RequestCurrentURL()
		self:RunJavascript("medialib.CurrentURL(window.location.href);")
	end
	self.controls = self:Add("DHTMLControls")
	self.controls:Dock(TOP)
	self.controls:SetHTML(self.browser)
	self:InitCustomControls(self.controls)
	local function UrlChanged(u)
		local addressBar = self.controls.AddressBar
		if vgui.GetKeyboardFocus() != addressBar then
			addressBar:SetText(u)
		end
		local vid = wdj.medialib.load("media").GuessService(u)
		local enabled = vid != nil or wdj.ytapi.isPlaylistUrl(u)
		self:OnURLValidityChanged(enabled)
	end
	self.browser.OnDocumentReady = function(s, u)
		UrlChanged(u:find("^data:text") and "home" or u)
	end
	self.browser.UrlChanged = function(s, u)
		UrlChanged(u)
	end
	self.browser.OnChangeTitle = function(s, u) self.browser:RequestCurrentURL() end
end

function PANEL:OnURLValidityChanged(b)
	self.addToQueueButton:SetEnabled(b)
end

function PANEL:OnURLSelected(url)
end
vgui.Register("WDJMedialibVideoSelector", PANEL, "Panel")

local RequestFrame
local function VideoSelector(onAccept, opts)
	local frame = vgui.Create("DFrame")
	frame:SetTitle("Titelauswahl")
	frame:SetSkin("WyoziCK")
	frame:SetSize(ScrW() * 0.8, ScrH() * 0.8)
	frame:Center()
	RequestFrame = frame
	local vidsel = frame:Add("WDJMedialibVideoSelector")
	vidsel.OnURLSelected = function(_, url)
		frame:Close()
		onAccept(url)
	end
	vidsel:Dock(FILL)
	frame:MakePopup()
end

function wdj.OpenVideoRequester(placeholderUrl, onAccept, opts)
	VideoSelector(onAccept, opts)
end