include("shared.lua")

surface.CreateFont("Dumpster_Header", {font = "BebasNeue", size = 80, weight = 500, blursize = 0, scanlines = 0, antialias = true})
surface.CreateFont("Dumpster_Small", {font = "BebasNeue", size = 25, weight = 300, blursize = 0, scanlines = 0, antialias = true})

function ENT:Initialize()
	self.EmitTime = CurTime()
	self.Effect = ParticleEmitter(self:GetPos())
end

local local_ply, pos, distance
function ENT:Draw()
	self:DrawModel()
end

function ENT:DrawTranslucent()
	local_ply = local_ply or LocalPlayer()
	pos = self:GetPos()
	distance = local_ply:EyePos():DistToSqr(pos)
	if distance < 1000000 and self:GetUsed() then
		if self.EmitTime < CurTime() then
			local forward = self:GetForward() * 40 + self:GetUp() * 75
			local smoke = self.Effect:Add("particle/smokesprites_000"..math.random(1, 9), pos + Vector(math.Rand(5, 15), math.Rand(-25, 25), math.Rand(15, 25)))
			if smoke then
				smoke:SetVelocity(forward)
				smoke:SetDieTime(math.Rand(1, 2))
				smoke:SetStartAlpha(math.Rand(25, 75))
				smoke:SetEndAlpha(0)
				smoke:SetStartSize(math.Rand(5, 10))
				smoke:SetEndSize(math.Rand(50, 100))
				smoke:SetRoll(0)
				smoke:SetRollDelta(0)
				smoke:SetColor(102, 51, 0)
				smoke:SetGravity(Vector(0, 0, math.Rand(-150, -200)))
				smoke:SetCollide(true)
			end
			local comp = self.Effect:Add("particle/particle_composite", pos + Vector(math.Rand(5, 15), math.Rand(-25, 25), math.Rand(15, 25)))
			if comp then
				comp:SetVelocity(forward)
				comp:SetDieTime(math.Rand(1, 2))
				comp:SetStartAlpha(math.Rand(25, 75))
				comp:SetEndAlpha(0)
				comp:SetStartSize(math.Rand(5, 10))
				comp:SetEndSize(math.Rand(50, 100))
				comp:SetRoll(0)
				comp:SetRollDelta(0)
				comp:SetColor(102, 51, 0)
				comp:SetGravity(Vector(0, 0, math.Rand(-150, -200)))
				comp:SetCollide(true)
			end
			self.EmitTime = CurTime() + 0.1
		end
	end
	if distance < 90000 then
		local ang = self:GetAngles()
		ang:RotateAroundAxis(ang:Up(), 90)
		ang:RotateAroundAxis(ang:Forward(), 90)
		cam.Start3D2D(self:GetPos() + ang:Up() + Vector(0, 0 , 30), Angle(0, EyeAngles().y - 90, 90), 0.1)
			draw.SimpleTextOutlined("Mülltonne", "Dumpster_Header", 0, -150, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_LEFT, 1, color_black)
			if self:GetUsed() then
				draw.SimpleTextOutlined("Wird durchwühlt!", "Dumpster_Small", 0, -80, Color(255, 255, 0, 255), TEXT_ALIGN_CENTER, TEXT_ALIGN_LEFT, 1, color_black)
			elseif self:GetAvailable() then
				draw.SimpleTextOutlined("Kann durchwühlt werden!", "Dumpster_Small", 0, -80, Color(102, 204, 51, 255), TEXT_ALIGN_CENTER, TEXT_ALIGN_LEFT, 1, color_black)
			else
				draw.SimpleTextOutlined("Mülltonne leer!", "Dumpster_Small", 0, -80, Color(200, 0, 0, 255), TEXT_ALIGN_CENTER, TEXT_ALIGN_LEFT, 1, color_black)
				draw.SimpleTextOutlined("Mülltonne ist in "..string.ToMinutesSeconds(math.max(self:GetNextAvailable() - CurTime() + 1, 0)).." min wieder verfügbar!", "Dumpster_Small", 0, -60, Color(255, 200, 0, 255), TEXT_ALIGN_CENTER, TEXT_ALIGN_LEFT, 1, color_black)
			end
		cam.End3D2D()
	end
end