local use_font = system.IsWindows() and "Tahoma" or "Verdana"
surface.CreateFont("EconomyFont_EHUDTitle", {font = use_font, size = 18, antialias = true})
surface.CreateFont("EconomyFont_EHUDSubtitle", {font = use_font, size = 14, antialias = true})
surface.CreateFont("EconomyFont_Message", {font = use_font, size = 13, antialias = true})
surface.CreateFont("EconomyFont_MessageBold", {font = use_font, size = 13, antialias = true, weight = 600})
surface.CreateFont("EconomyFont_PanelTitle", {font = use_font, size = 14, antialias = true, weight = 600})
surface.CreateFont("EconomyFont_Small", {font = use_font, size = 10, antialias = true})

local Func = EconomyFunctions
local Config = EconomyConfig
local surface = surface
local draw = draw

net.Receive("Economy_HostageMoney", function()
	Derma_StringRequest("Geiselkasse | Geld abheben", "Wie viel Geld möchtest du der Geiselkasse entnehmen?", "", function(amount)
		amount = tonumber(amount)
		if !amount then
			notification.AddLegacy("Du musst eine Zahl als Betrag angeben!", 1, 4)
			surface.PlaySound("buttons/lightswitch2.wav")
			return
		end
		if amount < 1 then
			notification.AddLegacy("Der Betrag muss mindestens $1 sein!", 1, 4)
			surface.PlaySound("buttons/lightswitch2.wav")
			return
		end
		if amount > Config.HostageMoney then
			notification.AddLegacy("Die Geiselkasse hat nicht so viel Geld!", 1, 4)
			surface.PlaySound("buttons/lightswitch2.wav")
			return
		end
		net.Start("Economy_HostageMoney")
			net.WriteUInt(amount, 32)
		net.SendToServer()
	end, nil, "Abheben", "Abbrechen")
end)

net.Receive("Economy_SyncAll", function()
	Config.EconomyBank = net.ReadFloat()
	Config.Reputation = net.ReadFloat()
	Config.Loans = net.ReadTable()
	Config.Taxes = net.ReadTable()
	Config.CurrentPerks = net.ReadTable()
	Config.HostageMoney = net.ReadFloat()
end)

net.Receive("Economy_SyncBank", function()
	Config.EconomyBank = net.ReadFloat()
	Config.HostageMoney = net.ReadFloat()
end)

net.Receive("Economy_SyncReputation", function()
	Config.Reputation = net.ReadFloat()
end)

net.Receive("Economy_SyncLoans", function()
	Config.Loans = net.ReadTable()
end)

net.Receive("Economy_SyncTaxes", function()
	Config.Taxes = net.ReadTable()
end)

net.Receive("Economy_SyncPerks", function()
	Config.CurrentPerks = net.ReadTable()
end)

net.Receive("Economy_OpenEconomyManager", function()
	local closing = false
	local opened = false
	local EconomyManager = vgui.Create("DPanel")
	EconomyManager:SetSize(600, 500)
	EconomyManager:Center()
	EconomyManager:SetAlpha(0)
	EconomyManager:MakePopup()
	EconomyManager:ParentToHUD()
	EconomyManager.Paint = function(self, w, h)
		surface.SetFont("EconomyFont_PanelTitle")
		local x, y = surface.GetTextSize("")
		draw.RoundedBox(4, 0, 0, w, h, Color(50, 50, 50, 255))
		draw.RoundedBoxEx(4, 0, 0, w, y + 6, Color(45, 45, 45, 255), true, true, false, false)
		draw.RoundedBox(0, 0, y + 6, w, 1, Color(35, 35, 35, 255))
		draw.DrawText("Wirtschafts-Konfig.", "EconomyFont_PanelTitle", 3, 3, color_white)
	end
	local systime
	local systime2
	EconomyManager.Think = function(self)
		if self:GetAlpha() < 255 and !closing then
			if !sysime then sysime = SysTime() end
			self:SetAlpha(Lerp((SysTime() - sysime) * 10, 0, 255))
		elseif self:GetAlpha() > 0 and closing then
			if !systime2 then systime2 = SysTime() end
			self:SetAlpha(Lerp((SysTime() - systime2) * 10, 255, 0))
			if self:GetAlpha() <= 0 then
				self:Hide()
			end
		end
		if !input.IsKeyDown(KEY_F2) then
			opened = true
		end
		if Config.EconomyManagerQuickKey and input.IsKeyDown(KEY_F2) and opened then
			closing = true
		end
	end
	local CloseButton = vgui.Create("DButton", EconomyManager)
	CloseButton:SetText("Schließen")
	CloseButton:SetSize(EconomyManager:GetWide() / 3 - 20, 30)
	CloseButton:SetPos(EconomyManager:GetWide() - CloseButton:GetWide() - 15, EconomyManager:GetTall() - CloseButton:GetTall() - 15)
	CloseButton:SetFont("EconomyFont_MessageBold")
	CloseButton.Paint = function(self, w, h)
		draw.RoundedBox(4, 0, 0, w, h, Color(35, 35, 35, 250))
		if self:IsHovered() then
			if self:IsDown() then
				self:SetTextColor(Color(150, 150, 150, 200))
			else
				self:SetTextColor(Color(200, 200, 200, 200))
			end
		else
			self:SetTextColor(Color(255, 255, 255, 200))
		end
	end
	CloseButton.DoClick = function(self)
		if closing then self:Hide() return end
		closing = true
	end
	local Tabs = vgui.Create("DPropertySheet", EconomyManager)
	Tabs:SetSize(EconomyManager:GetWide() - 30, EconomyManager:GetTall() - 100)
	Tabs:SetPos(15, 40)
	Tabs.Paint = function(self)
		draw.RoundedBoxEx(4, 0, 20, self:GetWide(), self:GetTall() - 20, Color(35, 35, 35, 250), true, true, true, true)
	end
	local TabsList = {}
	local TaxesPanel = vgui.Create("DScrollPanel", Tabs)
	TaxesPanel:SetSize(Tabs:GetWide(), Tabs:GetTall())
	TaxesPanel.Paint = function(self)
	end
	TaxesPanel.Paint = function(self, w, h)
		draw.RoundedBox(4, 0, 0, w, h, Color(35, 35, 35, 250))
	end
	TaxesPanel:GetVBar().Paint = function(self, w, h)
		draw.RoundedBox(4, 0, 0, w, h, Color(75, 75, 75, 255))
	end
	TaxesPanel:GetVBar().btnGrip.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 1, w, h - 2, Color(25, 25, 25, 250))
	end
	TaxesPanel:GetVBar().btnUp.Paint = function(self, w, h)
		draw.RoundedBoxEx(4, 0, 0, w, h, Color(25, 25, 25, 250), false, true, false, false)
		draw.DrawText("▲", "EconomyFont_Small", 3, 2, color_white)
	end
	TaxesPanel:GetVBar().btnDown.Paint = function(self, w, h)
		draw.RoundedBoxEx(4, 0, 0, w, h, Color(25, 25, 25, 250), false, false, false, true)
		draw.DrawText("▼", "EconomyFont_Small", 3, 2, color_white)
	end
	local TaxLabel = vgui.Create("DLabel", TaxesPanel)
	TaxLabel:SetSize(500, 25)
	TaxLabel:SetPos(25, 5)
	TaxLabel:SetText("Hier kann der Prozentsatz der Lohnsteuer für verschiedene Jobs eingestellt werden.")
	local taxes = Config.Taxes or {}
	local taxsliders = {}
	local count = 0
	count = count + 1
	local TaxSlider = vgui.Create("DNumSlider", TaxesPanel)
	TaxSlider:SetSize(500, 25)
	TaxSlider:SetPos(25, (count - 1) * TaxSlider:GetTall() + 35)
	TaxSlider:SetText("Alle Steuerbeträge setzen auf:")
	TaxSlider:SetDecimals(0)
	TaxSlider:SetMin(0)
	TaxSlider:SetMax(Config.MaxTaxes)
	TaxSlider:SetValue(Config.DefaultTaxes)
	TaxSlider.OnValueChanged = function(self, value)
		if value > Config.MaxTaxes then
			self:SetValue(Config.MaxTaxes)
		end
		for job in pairs(Config.TaxPayers) do
			if taxsliders[job] then
				taxsliders[job]:SetValue(value)
			end
		end
	end
	count = count + 1
	for job in SortedPairs(Config.TaxPayers) do
		if !RPExtraTeams[job] then continue end
		count = count + 1
		local TaxSlider = vgui.Create("DNumSlider", TaxesPanel)
		TaxSlider:SetSize(500, 25)
		TaxSlider:SetPos(25, (count - 1) * TaxSlider:GetTall() + 35)
		TaxSlider:SetText(team.GetName(job))
		TaxSlider:SetDecimals(0)
		TaxSlider:SetMin(0)
		TaxSlider:SetMax(Config.MaxTaxes)
		TaxSlider:SetValue(taxes[job] or Config.DefaultTaxes)
		TaxSlider.Think = function(self)
			if self:GetValue() > Config.MaxTaxes then
				self:SetValue(Config.MaxTaxes)
			end
			taxes[job] = self:GetValue()
		end
		taxsliders[job] = TaxSlider
	end
	local TaxesPanel = Tabs:AddSheet("Steuern", TaxesPanel, "icon16/newspaper.png", false, false)
	table.insert(TabsList, TaxesPanel)
	local LoanPanel = vgui.Create("DScrollPanel", Tabs)
	LoanPanel:SetSize(Tabs:GetWide(), Tabs:GetTall())
	LoanPanel.Paint = function(self)
	end
	LoanPanel.Paint = function(self, w, h)
		draw.RoundedBox(4, 0, 0, w, h, Color(35, 35, 35, 250))
	end
	LoanPanel:GetVBar().Paint = function(self, w, h)
		draw.RoundedBox(4, 0, 0, w, h, Color(75, 75, 75, 255))
	end
	LoanPanel:GetVBar().btnGrip.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 1, w, h - 2, Color(25, 25, 25, 250))
	end
	LoanPanel:GetVBar().btnUp.Paint = function(self, w, h)
		draw.RoundedBoxEx(4, 0, 0, w, h, Color(25, 25, 25, 250), false, true, false, false)
		draw.DrawText("▲", "EconomyFont_Small", 3, 2, color_white)
	end
	LoanPanel:GetVBar().btnDown.Paint = function(self, w, h)
		draw.RoundedBoxEx(4, 0, 0, w, h, Color(25, 25, 25, 250), false, false, false, true)
		draw.DrawText("▼", "EconomyFont_Small", 3, 2, color_white)
	end
	local LoanLabel = vgui.Create("DLabel", LoanPanel)
	LoanLabel:SetSize(500, 25)
	LoanLabel:SetPos(25, 5)
	LoanLabel:SetText("Hier können die Löhne der für den Staat arbeitenden Dienstkräfte eingestellt werden.")
	local count = 0
	local loans = Config.Loans or {}
	local loansliders = {}
	for job in SortedPairs(Config.LoanPlayers) do
		local jobt
		local found = false
		for t,v in pairs(RPExtraTeams) do
			if t == job then
				found = true
				jobt = v
				break
			end
		end
		if !found then continue end
		count = count + 1
		local LoanSlider = vgui.Create("DNumSlider", LoanPanel)
		LoanSlider:SetSize(500, 25)
		LoanSlider:SetPos(25, (count - 1) * LoanSlider:GetTall() + 35)
		LoanSlider:SetText(team.GetName(job))
		LoanSlider:SetDecimals(0)
		LoanSlider:SetMin(math.Round(jobt.salary * Config.MinLoan / 100))
		LoanSlider:SetMax(math.Round(jobt.salary * Config.MaxLoan / 100))
		local value = 0
		if loans[job] then
			value = math.Round(loans[job])
		else
			value = math.Round(Config.DefaultLoan * jobt.salary / 100)
		end
		LoanSlider:SetValue(value)
		LoanSlider.Think = function(self)
			if self:GetValue() > math.Round(jobt.salary * Config.MaxLoan / 100) then
				self:SetValue(math.Round(jobt.salary * Config.MaxLoan / 100))
			end
			loans[job] = self:GetValue()
		end
		loansliders[job] = LoanSlider
	end
	local LoanPanel = Tabs:AddSheet("Löhne", LoanPanel, "icon16/money.png", false, false)
	table.insert(TabsList, LoanPanel)
	local PerksPanel = vgui.Create("DScrollPanel", Tabs)
	PerksPanel:SetSize(Tabs:GetWide(), Tabs:GetTall())
	PerksPanel.Paint = function(self, w, h)
		draw.RoundedBox(4, 0, 0, w, h, Color(35, 35, 35, 250))
	end
	PerksPanel:GetVBar().Paint = function(self, w, h)
		draw.RoundedBox(4, 0, 0, w, h, Color(75, 75, 75, 255))
	end
	PerksPanel:GetVBar().btnGrip.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 1, w, h - 2, Color(25, 25, 25, 250))
	end
	PerksPanel:GetVBar().btnUp.Paint = function(self, w, h)
		draw.RoundedBoxEx(4, 0, 0, w, h, Color(25, 25, 25, 250), false, true, false, false)
		draw.DrawText("▲", "EconomyFont_Small", 3, 2, color_white)
	end
	PerksPanel:GetVBar().btnDown.Paint = function(self, w, h)
		draw.RoundedBoxEx(4, 0, 0, w, h, Color(25, 25, 25, 250), false, false, false, true)
		draw.DrawText("▼", "EconomyFont_Small", 3, 2, color_white)
	end
	local PerkLabel = vgui.Create("DLabel", PerksPanel)
	PerkLabel:SetSize(500, 25)
	PerkLabel:SetPos(25, 5)
	PerkLabel:SetText("Hier können Perks, welche für den gesamten Staat wirken, erworben werden.")
	local height = 0
	for _,perk in pairs(Config.Perks) do
		local Perk = vgui.Create("DPanel", PerksPanel)
		Perk:SetSize(500, 50)
		Perk:SetPos(25, height + 35)
		surface.SetFont("EconomyFont_Message")
		local desc = DarkRP.textWrap(perk.description, "EconomyFont_Message", 200)
		local x, y = surface.GetTextSize(desc)
		Perk:SetTall(20 + y)
		height = height + Perk:GetTall() + 10
		Perk.Paint = function(self)
			draw.DrawText(perk.title.." ($"..string.Comma(perk.cost)..")", "EconomyFont_MessageBold", 0, 0, color_white)
			draw.DrawText(desc, "EconomyFont_Message", 5, 15, color_white)
			draw.DrawText(math.ceil(perk.duration).." Minuten", "EconomyFont_Message", 265, 0, color_white, TEXT_ALIGN_CENTER)
		end
		local BuyPerk = vgui.Create("DButton", Perk)
		BuyPerk:SetText("Kaufen")
		BuyPerk:SetSize(90, 25)
		BuyPerk:SetPos(220, 15)
		BuyPerk:SetFont("EconomyFont_MessageBold")
		BuyPerk.Paint = function(self, w, h)
			draw.RoundedBox(4, 0, 0, w, h, Color(50, 50, 50, 255))
			if self:GetDisabled() then
				self:SetTextColor(Color(100, 100, 100, 200))
			else
				if self:IsHovered() then
					if self:IsDown() then
						self:SetTextColor(Color(150, 150, 150, 200))
					else
						self:SetTextColor(Color(200, 200, 200, 200))
					end
				else
					self:SetTextColor(Color(255, 255, 255, 200))
				end
			end
		end
		BuyPerk.DoClick = function(self)
			surface.PlaySound("ui/buttonclick.wav")
			net.Start("Economy_BuyPerk")
				net.WriteInt(perk.id, 16)
			net.SendToServer()
		end
		BuyPerk.Think = function(self)
			if Config.CurrentPerks[perk.id] then
				self:SetText("Aktiv ("..string.ToMinutesSeconds(math.max(0, math.abs(Config.CurrentPerks[perk.id] - CurTime())))..")")
				self:SetDisabled(true)
			else
				if Config.EconomyBank - Config.UnacceptableEconomy >= perk.cost then
					self:SetText("Kaufen")
					self:SetDisabled(false)
				else
					self:SetText("Zu teuer!")
					self:SetDisabled(true)
				end
			end
		end
	end
	table.insert(TabsList, Tabs:AddSheet("Perks", PerksPanel, "icon16/basket.png", false, false))
	for _,tab in pairs(TabsList) do
		tab.Tab.Paint = function(self, w)
			local tall = self:GetTall()
			if Tabs:GetActiveTab() == tab.Tab then
				tall = self:GetTall() - 8
			end
			draw.RoundedBoxEx(4, 4, 0, w - 8, tall, Color(35, 35, 35, 250), true, true, false, false)
		end
	end
	local ApplyButton = vgui.Create("DButton", EconomyManager)
	ApplyButton:SetText("Änderungen übernehmen")
	ApplyButton:SetSize(EconomyManager:GetWide() / 3 - 20, 30)
	ApplyButton:SetPos(15, EconomyManager:GetTall() - ApplyButton:GetTall() - 15)
	ApplyButton:SetFont("EconomyFont_MessageBold")
	ApplyButton.Paint = function(self, w, h)
		draw.RoundedBox(4, 0, 0, w, h, Color(35, 35, 35, 250))
		if self:GetDisabled() then
			self:SetTextColor(Color(100, 100, 100, 200))
		else
			if self:IsHovered() then
				if self:IsDown() then
					self:SetTextColor(Color(150, 150, 150, 200))
				else
					self:SetTextColor(Color(200, 200, 200, 200))
				end
			else
				self:SetTextColor(Color(255, 255, 255, 200))
			end
		end
	end
	ApplyButton.DoClick = function(self)
		if TaxesPanel.Tab == Tabs:GetActiveTab() then
			net.Start("Economy_SetTaxes")
				net.WriteTable(taxes)
			net.SendToServer()
		else
			net.Start("Economy_SetLoans")
				net.WriteTable(loans)
			net.SendToServer()
		end
	end
	ApplyButton.Think = function(self)
		local active_tab = Tabs:GetActiveTab()
		if TaxesPanel.Tab == active_tab or LoanPanel.Tab == active_tab then
			self:SetDisabled(false)
		else
			self:SetDisabled(true)
		end
	end
	local ResetButton = vgui.Create("DButton", EconomyManager)
	ResetButton:SetText("Auf Standard zurücksetzen")
	ResetButton:SetSize(EconomyManager:GetWide() / 3 - 20, 30)
	ResetButton:SetPos(EconomyManager:GetWide() - ResetButton:GetWide() - CloseButton:GetWide() - 30, EconomyManager:GetTall() - ResetButton:GetTall() - 15)
	ResetButton:SetFont("EconomyFont_MessageBold")
	ResetButton.Paint = function(self, w, h)
		draw.RoundedBox(4, 0, 0, w, h, Color(35, 35, 35, 250))
		if self:GetDisabled() then
			self:SetTextColor(Color(100, 100, 100, 200))
		else
			if self:IsHovered() then
				if self:IsDown() then
					self:SetTextColor(Color(150, 150, 150, 200))
				else
					self:SetTextColor(Color(200, 200, 200, 200))
				end
			else
				self:SetTextColor(Color(255, 255, 255, 200))
			end
		end
	end
	ResetButton.DoClick = function(self)
		if TaxesPanel.Tab == Tabs:GetActiveTab() then
			for k, v in pairs(taxes) do
				taxes[k] = Config.DefaultTaxes
				if taxsliders[k] then
					taxsliders[k]:SetValue(Config.DefaultTaxes)
				end
			end
		else
			for job in pairs(Config.LoanPlayers) do
				local jobt
				local found = false
				for t,v in pairs(RPExtraTeams) do
					if t == job then
						found = true
						jobt = v
						break
					end
				end
				if !found then continue end
				local def_loan = math.Round(Config.DefaultLoan * jobt.salary / 100)
				loans[job] = def_loan
				if loansliders[job] then
					loansliders[job]:SetValue(def_loan)
				end
			end
		end
	end
	ResetButton.Think = function(self)
		local active_tab = Tabs:GetActiveTab()
		if TaxesPanel.Tab == active_tab or LoanPanel.Tab == active_tab then
			self:SetDisabled(false)
		else
			self:SetDisabled(true)
		end
	end
end)

local LoadoutPanel
net.Receive("Economy_OpenLoadout", function()
	if IsValid(LoadoutPanel) then LoadoutPanel:Hide() end
	local closing = false
	LoadoutPanel = vgui.Create("DPanel")
	LoadoutPanel:SetSize(500, 300)
	LoadoutPanel:Center()
	LoadoutPanel:SetAlpha(0)
	LoadoutPanel:MakePopup()
	LoadoutPanel:ParentToHUD()
	LoadoutPanel.Paint = function(self, w, h)
		surface.SetFont("EconomyFont_PanelTitle")
		local x, y = surface.GetTextSize("")
		draw.RoundedBox(4, 0, 0, w, h, Color(50, 50, 50, 255))
		draw.RoundedBoxEx(4, 0, 0, w, y + 6, Color(45, 45, 45, 255), true, true, false, false)
		draw.RoundedBox(0, 0, y + 6, w, 1, Color(35, 35, 35, 255))
		draw.DrawText("Spezialausrüstung", "EconomyFont_PanelTitle", 3, 3, color_white)
	end
	local systime
	local systime2
	LoadoutPanel.Think = function(self)
		if self:GetAlpha() < 255 and !closing then
			if !systime then systime = SysTime() end
			self:SetAlpha(Lerp((SysTime() - systime) * 10, 0, 255))
		elseif self:GetAlpha() > 0 and closing then
			if !systime2 then systime2 = SysTime() end
			self:SetAlpha(Lerp((SysTime() - systime2) * 10, 255, 0))
			if self:GetAlpha() <= 0 then
				self:Hide()
			end
		end
	end
	local CloseButton = vgui.Create("DButton", LoadoutPanel)
	CloseButton:SetText("Schließen")
	CloseButton:SetSize(LoadoutPanel:GetWide() - 30, 30)
	CloseButton:SetPos(15, LoadoutPanel:GetTall() - CloseButton:GetTall() - 15)
	CloseButton:SetFont("EconomyFont_MessageBold")
	CloseButton.Paint = function(self, w, h)
		draw.RoundedBox(4, 0, 0, w, h, Color(35, 35, 35, 250))
		if self:IsHovered() then
			if self:IsDown() then
				self:SetTextColor(Color(150, 150, 150, 200))
			else
				self:SetTextColor(Color(200, 200, 200, 200))
			end
		else
			self:SetTextColor(Color(255, 255, 255, 200))
		end
	end
	CloseButton.DoClick = function(self)
		if closing then self:Hide() return end
		closing = true
		net.Start("Economy_SetupLoadout")
			net.WriteTable(Config.UpgradesLoadout)
		net.SendToServer()
	end
	local UpgradesLoadout = vgui.Create("DPanel", LoadoutPanel)
	UpgradesLoadout:SetSize(LoadoutPanel:GetWide() / 2 - 20, LoadoutPanel:GetTall() - 90)
	UpgradesLoadout:SetWide(LoadoutPanel:GetWide() - 30)
	UpgradesLoadout:SetPos(15, 35)
	surface.SetFont("EconomyFont_Message")
	local x, y = surface.GetTextSize("")
	UpgradesLoadout.Paint = function(self, w, h)
		draw.RoundedBox(4, 0, 0, w, h, Color(35, 35, 35, 250))
		local err_message = ""
		if !Config.CurrentPerks[1] then
			err_message = "Perk nicht aktiv!"
		end
		if Config.Reputation < Config.UpgradesReputation then
			err_message = "Ruf zu niedrig!"
		end
		if err_message != "" then
			draw.DrawText(err_message, "EconomyFont_Message", w / 2, (h - y) / 2, Color(255, 100, 100, 255), TEXT_ALIGN_CENTER)
		else
			draw.DrawText(Config.AvailableUpgradePoints.." Verbesserungspunkte übrig", "EconomyFont_MessageBold", w / 2, h - 60, color_white, TEXT_ALIGN_CENTER)
		end
	end
	if Config.CurrentPerks[1] then
		if Config.Reputation >= Config.UpgradesReputation then
			for k,upgrade in pairs(Config.UpgradesLoadout) do
				if !upgrade.value then
					upgrade.value = 0
				end
				local Upgrade = vgui.Create("DPanel", UpgradesLoadout)
				Upgrade:SetSize(UpgradesLoadout:GetWide(), (UpgradesLoadout:GetTall() - 100) / #Config.UpgradesLoadout)
				Upgrade:SetPos(0, (k - 1) * Upgrade:GetTall())
				Upgrade.Paint = function(self, w, h)
					if (!Config.CurrentPerks[1] or Config.Reputation < Config.UpgradesReputation) then Upgrade:Remove() end
					draw.DrawText(upgrade.title.." ("..upgrade.value..")", "EconomyFont_MessageBold", w / 2, 0, color_white, TEXT_ALIGN_CENTER)
					for i = 0, 9 do
						draw.RoundedBox(2, w / 2 - 39 + i * 8, 20, 5, 10, Color(0, 255, 0, 10))
					end
					for i = 0, upgrade.value - 1 do
						draw.RoundedBox(2, w / 2 - 39 + i * 8, 20, 5, 10, Color(0, 255, 0, 200))
					end
				end
				local Add = vgui.Create("DButton", Upgrade)
				Add:SetSize(16, 16)
				Add:SetPos(Upgrade:GetWide() / 2 + 45, 17)
				Add:SetText("+")
				Add:SetFont("EconomyFont_Message")
				Add:SetTextColor(color_white)
				Add.Paint = function(self) end
				Add.DoClick = function(self)
					if Config.AvailableUpgradePoints > 0 and upgrade.value < 10 then
						upgrade.value = upgrade.value + 1
						Config.AvailableUpgradePoints = Config.AvailableUpgradePoints - 1
					end
				end
				local Subtract = vgui.Create("DButton", Upgrade)
				Subtract:SetSize(16, 16)
				Subtract:SetPos(Upgrade:GetWide() / 2 - 45 - Subtract:GetWide(), 17)
				Subtract:SetText("-")
				Subtract:SetFont("EconomyFont_Message")
				Subtract:SetTextColor(color_white)
				Subtract.Paint = function(self)
				end
				Subtract.DoClick = function(self)
					if upgrade.value > 0 then
						upgrade.value = upgrade.value - 1
						Config.AvailableUpgradePoints = Config.AvailableUpgradePoints + 1
					end
				end
			end
		end
	end
end)

local OpportunityPanel
local function ViewOpportunity(opportunity, time)
	if IsValid(OpportunityPanel) then OpportunityPanel:Hide() end
	local close = CurTime() + time
	OpportunityPanel = vgui.Create("DPanel")
	OpportunityPanel:SetSize(350, 450)
	OpportunityPanel:SetAlpha(0)
	OpportunityPanel:MakePopup()
	OpportunityPanel.Paint = function(self, w, h)
		surface.SetFont("EconomyFont_PanelTitle")
		local x, y = surface.GetTextSize(opportunity.title)
		draw.RoundedBox(4, 0, 0, w, h, Color(50, 50, 50, 255))
		draw.RoundedBoxEx(4, 0, 0, w, y + 6, Color(45, 45, 45, 255), true, true, false, false)
		draw.RoundedBox(0, 0, y + 6, w, 1, Color(35, 35, 35, 255))
		draw.DrawText(opportunity.title, "EconomyFont_PanelTitle", 3, 3, color_white)
		draw.DrawText(math.abs(math.max(0, math.ceil(close - CurTime()))).." Sekunden...", "EconomyFont_PanelTitle", w - 3,  3, color_white, TEXT_ALIGN_RIGHT)
	end
	local curtime
	local curtime2
	OpportunityPanel.Think = function(self)
		NotificationQueue = {}
		if self:GetAlpha() < 255 and CurTime() < close then
			if !curtime then curtime = CurTime() end
			self:SetAlpha(Lerp((CurTime() - curtime) * 8, 0, 255))
		elseif self:GetAlpha() > 0 and CurTime() >= close then
			if !curtime2 then curtime2 = CurTime() end
			self:SetAlpha(Lerp((CurTime() - curtime2) * 8, 255, 0))
			if self:GetAlpha() <= 0 then
				self:Hide()
				gui.EnableScreenClicker(false)
			end
		end
	end
	local width = OpportunityPanel:GetWide() - 30
	surface.SetFont("EconomyFont_Message")
	local text = DarkRP.textWrap(opportunity.description, "EconomyFont_Message", width - 20)
	local x, y = surface.GetTextSize(text)
	local Description = vgui.Create("DPanel", OpportunityPanel)
	Description:SetSize(width, y + 20)
	Description:SetPos(15, 35)
	Description.Paint = function(self, w, h)
		draw.RoundedBox(4, 0, 0, w, h, Color(35, 35, 35, 255))
		draw.DrawText(text, "EconomyFont_Message", 10, 10, color_white)
	end
	local height
	for k, choice in pairs(opportunity.choices) do
		local choiceCost = ""
		if choice.choiceCost > 0 then
			choiceCost = " ($"..string.Comma(choice.choiceCost)..")"
		end
		local Choice = vgui.Create("DButton", OpportunityPanel)
		Choice:SetText(choice.choice..choiceCost)
		Choice:SetSize(OpportunityPanel:GetWide() - 30, 30)
		Choice:SetPos(15, Description:GetTall() + 45 + (k - 1) * (Choice:GetTall() + 6))
		Choice:SetFont("EconomyFont_MessageBold")
		Choice.Paint = function(self, w, h)
			draw.RoundedBox(4, 0, 0, w, h, Color(35, 35, 35, 250))
			if self:GetDisabled() then
				self:SetTextColor(Color(100, 100, 100, 200))
			else
				if self:IsHovered() then
					if self:IsDown() then
						self:SetTextColor(Color(150, 150, 150, 200))
					else
						self:SetTextColor(Color(200, 200, 200, 200))
					end
				else
					self:SetTextColor(Color(255, 255, 255, 200))
				end
			end
		end
		Choice.DoClick = function(self)
			close = CurTime()
			net.Start("Economy_MakeChoice")
				net.WriteString(tostring(k))
			net.SendToServer()
		end
		Choice.Think = function(self)
			if Config.EconomyBank < choice.choiceCost then
				self:SetDisabled(true)
			else
				self:SetDisabled(false)
			end
		end
		local x, y = Choice:GetPos()
		height = y + Choice:GetTall() + 15
	end
	OpportunityPanel:SetTall(height)
	OpportunityPanel:Center()
end

local NotificationQueue = {}
local NotificationPanel
local function OpenNotificationPanel(message, c_time, time, opportunity)
	if IsValid(NotificationPanel) then NotificationPanel:Hide() end
	local fade = false
	NotificationPanel = vgui.Create("DPanel")
	NotificationPanel:SetAlpha(0)
	NotificationPanel:SetWidth(245)
	surface.SetFont("EconomyFont_Message")
	message = DarkRP.textWrap(message, "EconomyFont_Message", NotificationPanel:GetWide() - 10)
	local x, y = surface.GetTextSize(message)
	NotificationPanel.Paint = function(self, w, h)
		draw.RoundedBox(4, 0, 0, w, h, Color(45, 45, 45, 250))
		if opportunity then
			draw.DrawText(opportunity.title, "EconomyFont_MessageBold", 5, 5, color_white)
			draw.DrawText(message, "EconomyFont_Message", 5, 5 + y, color_white)
			local timeRemaining = math.max(0, math.ceil(time - (CurTime() - c_time))).." Sekunden..."
			surface.SetFont("EconomyFont_Message")
			local x, y = surface.GetTextSize(timeRemaining)
			draw.DrawText(timeRemaining, "EconomyFont_Message", w - x - 5, h - y - 5, color_white)
		else
			draw.DrawText(message, "EconomyFont_Message", 5, 5, color_white)
		end
	end
	if opportunity then
		local ViewButton = vgui.Create("DButton", NotificationPanel)
		ViewButton:SetSize(50, 20)
		ViewButton:SetText("Ansehen")
		ViewButton.Paint = function(self, w, h)
			draw.RoundedBox(4, 0, 0, w, h, Color(35, 35, 35, 250))
			if self:IsHovered() then
				if self:IsDown() then
					self:SetTextColor(Color(150, 150, 150, 200))
				else
					self:SetTextColor(Color(200, 200, 200, 200))
				end
			else
				self:SetTextColor(Color(255, 255, 255, 200))
			end
		end
		ViewButton.DoClick = function(self)
			fade = true
		end
		surface.SetFont("EconomyFont_Message")
		local x1, y1 = surface.GetTextSize(opportunity.title)
		NotificationPanel:SetHeight(y + y1 + ViewButton:GetTall() + 15)
		ViewButton:SetPos(5, NotificationPanel:GetTall() - ViewButton:GetTall() - 5)
	else
		NotificationPanel:ParentToHUD()
		NotificationPanel:SetHeight(y + 10)
	end
	local curtime
	local curtime2
	NotificationPanel.Think = function(self)
		if self:GetAlpha() < 255 and CurTime() < c_time + time and !fade then
			if !curtime then curtime = CurTime() end
			self:SetAlpha(Lerp((CurTime() - curtime) * 5, 0, 255))
		elseif (self:GetAlpha() > 0 and CurTime() >= c_time + time) or fade then
			if !curtime2 then curtime2 = CurTime() end
			self:SetAlpha(Lerp((CurTime() - curtime2) * 5, 255, 0))
			if self:GetAlpha() <= 0 then
				NotificationPanel:Hide()
				table.remove(NotificationQueue, 1)
				if #NotificationQueue > 0 then
					OpenNotificationPanel(NotificationQueue[1].message, NotificationQueue[1].opportunity and NotificationQueue[1].c_time or CurTime(), NotificationQueue[1].time, NotificationQueue[1].opportunity)
				end
				if fade then
					ViewOpportunity(opportunity, math.max(0, time - (CurTime() - c_time)))
				end
			end
		end
	end
	NotificationPanel:SetPos(ScrW() / 2 - NotificationPanel:GetWide() / 2, 74)
	print(message)
end

local economynotifications = CreateClientConVar("cl_economynotifications", 1, FCVAR_ARCHIVE)
net.Receive("Economy_AddNotification", function()
	local opportunity
	local c_time
	local message = net.ReadString()
	local time = net.ReadFloat()
	if net.ReadBool() then
		opportunity = net.ReadTable()
		c_time = net.ReadFloat()
	end
	if !c_time then c_time = CurTime() end
	if !opportunity and !economynotifications:GetBool() then return end
	if #NotificationQueue < 10 or opportunity then
		table.insert(NotificationQueue, { c_time = c_time, message = message, time = time, opportunity = opportunity })
	end
	if #NotificationQueue <= 1 then
		OpenNotificationPanel(message, c_time, time, opportunity)
	end
end)

local gradient = surface.GetTextureID("gui/gradient")
local center_gradient = surface.GetTextureID("gui/center_gradient")
local function DrawGradient(x, y, width, height, alpha)
	surface.SetTexture(center_gradient)
	surface.SetDrawColor(255, 165, 0, alpha)
	surface.DrawTexturedRect(x + 3, y + 0, width - 6, height - 3)
	surface.SetTexture(gradient)
	surface.SetDrawColor(255, 0, 0, alpha)
	surface.DrawTexturedRect(x + 3, y + 0, width - 6, height - 3)
	surface.SetTexture(gradient)
	surface.SetDrawColor(0, 255, 0, alpha)
	surface.DrawTexturedRectRotated(x + width / 2, y + height / 2 - 1  + 0, width - 6, height - 3, 180)
end

local economy_hud_simple = CreateClientConVar("cl_economy_hud_simple", 1, FCVAR_ARCHIVE)
local reputation = 0
local box_color = Color(35, 35, 35, 250)
local rep, text, adj, pos
local function DrawEconomyMeter(scrw, x, y, width, height)
	rep = Config.Reputation
	draw.RoundedBoxEx(4, x, y, width, height, box_color, false, false, true, true)
	DrawGradient(x, y, width, height, 150)
	reputation = math.Clamp((reputation == rep and reputation) or Lerp(0.03, reputation, rep), 0, 100)
	pos = reputation * (width - 9) / 100
	surface.SetDrawColor(200, 200, 200, 250)
	surface.DrawRect(scrw / 2 - width / 2 + 4 + pos, 0, 2, height - 3)
	surface.SetDrawColor(35, 35, 35, 250)
	surface.DrawRect(scrw / 2 - width / 2 + 3 + pos, 0, 2, height - 3)
	surface.SetFont("EconomyFont_EHUDTitle")
	adj = "Ausgezeichnet"
	if rep <= Config.UnacceptableReputation then
		adj = "Sehr niedrig"
	elseif rep <= 40 then
		adj = "Niedrig"
	elseif rep <= 60 then
		adj = "Neutral"
	elseif rep <= 75 then
		adj = "Hoch"
	elseif rep <= 90 then
		adj = "Sehr hoch"
	end
	local int = economy_hud_simple:GetInt()
	if int >= 2 then
		text = adj.." ("..rep.."%)"
	else
		text = "Ruf des Staats: "..adj.." ("..rep.."%)"
	end
	x, y = surface.GetTextSize(text)
	surface.SetDrawColor(0, 0, 0, 175)
	surface.DrawRect(scrw / 2 - x / 2 - 5, height, x + 10, 35)
	draw.DrawText(text, "EconomyFont_EHUDTitle", scrw / 2 - x / 2, height, color_white)
	surface.SetFont("EconomyFont_EHUDSubtitle")
	height = height + y - 1
	if int >= 2 then
		text = "$"..string.Comma(Config.EconomyBank)
	else
		text = "Staatskasse: $"..string.Comma(Config.EconomyBank)
	end
	x, y = surface.GetTextSize(text)
	draw.DrawText(text, "EconomyFont_EHUDSubtitle", scrw / 2 - x / 2, height, color_white)
end

local showeconomy = CreateClientConVar("cl_showeconomy", 1, FCVAR_ARCHIVE)
local scrw, int, w, h
local function PaintBar()
	if !showeconomy:GetBool() then return end
	scrw = ScrW()
	int = economy_hud_simple:GetInt()
	w = int >= 1 and 200 or 245
	h = int >= 1 and 14 or 24
	DrawEconomyMeter(scrw, scrw / 2 - w / 2, 0, w, h)
end
hook.Add("HUDPaint", "Economy_PaintBar", PaintBar)