EconomyConfig = EconomyConfig or {}
EconomyFunctions = EconomyFunctions or {}

local Config = EconomyConfig

Config.EconomyBankReset = 40000
Config.ReputationReset = 50
Config.Reputation = 75
Config.EconomyBank = 50000
Config.HostageMoney = 5000
Config.HostageMoney = 5000
Config.HostageMoneyReset = 4000
Config.MaxHostageMoney = 25000
Config.HostageMoneyPerPerson = 100
Config.HostageMoneyCalculationTime = 600
Config.UnacceptableEconomy = 2500
Config.EconomyManagerCommand = "economy"
Config.EconomyManagerQuickKey = true

timer.Simple(0, function()
	Config.RobbingJobs = {
		[TEAM_THIEF] = true,
		[TEAM_MASTERTHIEF] = true,
		[TEAM_GANGSTER] = true,
		[TEAM_GANGSTERBOSS] = true,
		[TEAM_MAFIOSO] = true,
		[TEAM_MAFIABOSS] = true,
		[TEAM_REBEL] = true,
		[TEAM_REBELBOSS] = true
	}

	Config.HostageJobs = {
		[TEAM_GANGSTER] = true,
		[TEAM_GANGSTERBOSS] = true,
		[TEAM_MAFIOSO] = true,
		[TEAM_MAFIABOSS] = true,
		[TEAM_REBEL] = true,
		[TEAM_REBELBOSS] = true,
		[TEAM_TERROR] = true
	}
end)

Config.MayorTeam = TEAM_MAYOR
Config.UnacceptableReputation = 25
Config.AllowRecall = true
Config.AutoWant = true
Config.WantMessage = "Banküberfall"
Config.MoneyPickupSpeed = 1
Config.MoneyPickupSound = "physics/body/body_medium_impact_soft6.wav"
Config.MoneyWorth = 250
Config.MoneyComesFromGovernment = true
Config.RaidProtection = 1800
Config.RaidMinPlayers = 24
Config.AlarmSound = "ambient/alarms/alarm1.wav"
Config.AlarmHealth = 100
Config.AlarmSparkOnDamage = true
Config.AlarmStartAgain = 600
Config.AlarmCooldown = 20

Config.HintInterval = 1800
Config.HintLength = 10
Config.SayHintBeforeHint = true

Config.Hints = {
	"Wenn ihr Bürgermeister seid, könnt ihr mit \"/economy\" oder F2 den Wirtschafts-Konfig. öffnen.",
	"Ab 24 Spielern erreichen den Bürgermeister alle 10 Minuten wichtige Anfragen, die er beantworten sollte.\nTut er dies nicht, verliert der Staat an Ruf.",
	"Der Bürgermeister trifft wichtige Entscheidungen.\nDiese beeinflussen den Ruf und die\nWirtschaft vom Staat.",
	"Der Bürgermeister kann die Steuern für die Löhne aller Spieler, welche nicht beim Staat angestellt sind, festlegen. Ein zu hoher Eintrag ohne ersichtlichen Grund (~25%) rechtfertigt eine Degradierung.",
	"Der Bürgermeister kann die Löhne aller Staatsbeamten festlegen.\nEin zu niedriger Eintrag ohne ersichtlichen Grund rechtfertigt eine Degradierung.",
	"Der Bürgermeister hat die Möglichkeit, Perks für die Verbesserung der Wirtschaft und des Wohlergehens der Bürger zu erwerben.",
	"Jedes Mal wenn ein Spieler, welcher beim Staat angestellt ist, seinen Lohn erhält, wird dieser aus der Staatskasse bezahlt.",
	"Wenn der Ruf des Staats inakzeptabel wird und/oder die Wirtschaft instabil, wird der Bürgermeister seines Amtes enthoben und ein Teil der Beamten wird gefeuert.",
	"Nehme einen Job als Staatsbeamter in Betracht und du wirst Möglichkeiten haben dich aufzuwerten, sofern dies freigeschaltet wurde.",
	"Ab 24 Spielern und einem Bürgermeister, kann die Staatskasse geplündert werden.\nDies funktioniert über einen Raid oder Einbruch auf die Polizeiwache.",
	"Bei einer Plünderung der Staatskasse, sollte man stets immer die Alarmsirenen ausschalten, um nicht direkt erkannt zu werden.",
	"Der Bürgermeister darf, gemäß den Regeln, Gesetze anfertigen an die sich zu halten sind.\nAchtet die Gesetze des Bürgermeisters immer.\nAnsonsten besucht ihr schnell, nach Vorwarnung, ein Gefängnis.",
}

Config.EnableTaxes = true
Config.EnableLoans = true

timer.Simple(0, function()
	Config.LoanPlayers = {
		[TEAM_ZOLL] = true,
		[TEAM_JAILGUARD] = true,
		[TEAM_POLICE] = true,
		[TEAM_CHIEF] = true,
		[TEAM_SEK] = true,
		[TEAM_SEKSNIPER] = true,
		[TEAM_SEKLEADER] = true,
		[TEAM_POLICEDOG] = true,
		[TEAM_SECRETSERVICE] = true
	}

	Config.TaxPayers = {
		[TEAM_CITIZEN] = true,
		[TEAM_PRIEST] = true,
		[TEAM_SECURITY] = true,
		[TEAM_GUN] = true,
		[TEAM_MARKET] = true,
		[TEAM_THIEF] = true,
		[TEAM_MASTERTHIEF] = true,
		[TEAM_GANGSTER] = true,
		[TEAM_GANGSTERBOSS] = true,
		[TEAM_MAFIOSO] = true,
		[TEAM_MAFIABOSS] = true,
		[TEAM_REBEL] = true,
		[TEAM_REBELBOSS] = true,
		[TEAM_REPAIR] = true,
		[TEAM_REFFINERY] = true,
		[TEAM_GARDENER] = true,
		[TEAM_DEALER] = true,
		[TEAM_METHCOOK] = true,
		[TEAM_COOK] = true,
		[TEAM_HITMAN] = true,
		[TEAM_BANKER] = true,
		[TEAM_DOCTOR] = true,
		[TEAM_DRIVER] = true,
		[TEAM_LAWYER] = true,
		[TEAM_DJ] = true
	}

	if TEAM_THEATER then
		Config.TaxPayers[TEAM_THEATER] = true
	end

	Config.GovernmentJobs = {
		[TEAM_JAILGUARD] = true,
		[TEAM_POLICE] = true,
		[TEAM_CHIEF] = true,
		[TEAM_SEK] = true,
		[TEAM_SEKSNIPER] = true,
		[TEAM_SEKLEADER] = true,
		[TEAM_SECRETSERVICE] = true
	}
end)

Config.MaxTaxes = 30
Config.DefaultTaxes = 15
Config.TaxNotificationLength = 6
Config.MinLoan = 50
Config.MaxLoan = 150
Config.DefaultLoan = 100
Config.LoanNotificationLength = 6

Config.RandomReputation = true
Config.RandomReputationTime = {800, 1200}
Config.RandomReputationAdd = 2
Config.RandomReputationRemove = 4

Config.EnableLoadouts = true
Config.LoadoutCommand = "loadout"
Config.PerkNotificationLength = 6

Config.Perks = {
	{id = 1, title = "Polizeistaat", cost = 15000, duration = 45, description = [[Erlaubt bewaffnungsfähigen Staatsbeamten Zugriff auf ein Verbesserungsmenü, indem sie 10 Punkte auf 3 verschiedene Verbesserungen anwenden können.]]},
	{id = 2, title = "Erhöhter Mindestlohn", cost = 20000, duration = 30, description = [[Steuerzahler erhalten am Zahltag 75% mehr Lohn, als sonst.]]},
	{id = 3, title = "Ordentliche Buchführung", cost = 20000, duration = 60, description = [[Der Staat erhält 25% mehr Einnahmen durch Steuern.]]},
	{id = 4, title = "Manipulierte Umfragewerte", cost = 15000, duration = 60, description = [[Die Entscheidungen des Bürgermeisters bei wichtigen Anfragen haben 50% höheren positiven Einfluss auf den Ruf als zuvor.]]},
	{id = 5, title = "Zweite Chance", cost = 30000, duration = 45, description = [[Sollte es mal nicht so gut laufen, wird der derzeitige Bürgermeister nicht automatisch entlassen und die Wirtschaft, Ruf und alle Perks werden zurückgesetzt.]]},
	{id = 6, title = "Diktatur", cost = 25000, duration = 40, description = [[Der Bürgermeister kann über einen gewissen Zeitraum nicht degradiert werden, dabei ist egal welche korrupten Machenschaften er pflegt.]]},
	{id = 7, title = "Steueroasen", cost = 10000, duration = 30, description = [[Der Bürgermeister erhält $4,000 als sein neues Gehalt.]]}
}

Config.UpgradesReputation = 50
Config.AvailableUpgradePoints = 10
Config.WalkSpeedUpgrade = 60
Config.DamageScaleUpgrade = 0.25
Config.ArmorScaleUpdate = 5

Config.UpgradesLoadout = {
	{id = "armor", title = "Rüstung"},
	{id = "speed", title = "Geschwindigkeit"},
	{id = "resistance", title = "Schadensresistenz"}
}

Config.NewMayorPayment = 4000

Config.OpportunityInterval = 600
Config.OpportunityNotificationExpiration = 180
Config.OpportunityPostNotificationExpiration = 12
Config.OpportunityIgnoreCount = 3
Config.OpportunityNotification = "Eine wichtige Anfrage ist eingetroffen, die Sie sich schnellst möglich ansehen sollten.\n\nSollten Sie dies nicht tun, werden wir möglicherweise an Ruf verlieren."

Config.OpportunitySkipped = 12.5
Config.OpportunityMinPlayers = 24
Config.OpportunityMinPlayersWithMayor = 10

Config.Opportunities = {
	{title = "Forschung",
	description = [[Ein lokales Forschungszentrum hat angefordert, dass Sie in eine ihrer Abteilungen Geld investieren.
Sie können die Forderung ignorieren, jedoch haben diese Forschungen großen Einfluss auf die Zukunft.
Ihre Forscher zählen zu den Besten der Welt, und sie sind sicher, ihre Ziele mit ein wenig Finanzierung zu erreichen.
Es existiert eine große Nachfrage nach medizinischen Verbesserungen, aber eine Verbesserung der derzeitigen Technologie könnte viel profitabler, doch auch riskanter sein.]],
	choices = {
		{choice = "Investiere in medizinische Forschung", choiceCost = 5000,
			results = {
				{chance = 30, money = 5000, reputation = 8, message = [[Ein paar medizinische Erfolge wurden errungen.]]},
				{chance = 15, money = 8000, reputation = 10, message = [[Herzlichen Glückwunsch. Es wurden viele Fortschritte in der Medizin gemacht.]]},
				{chance = 20, money = 3000, reputation = 5, message = [[Es wurden zu wenige medizinische Fortschritte gemacht, um davon zu profitieren.]]},
				{chance = 1, money = 25000, reputation = 20, message = [[Ein Heilmittel, das praktisch alle Krankheiten heilt, wurde entdeckt.]]},
				{chance = 10, money = 0, reputation = -2, message = [[Die Forscher sind vermutlich inkompetent, sie haben nichts erreicht und das gesamte Geld verloren.]]},
				{chance = 10, money = 2500, reputation = -5, message = [[Es gab einen Unfall!
Die Forschung wurde zurückgesetzt und das Geld bis auf ein paar Tausend ging verloren.]]},
				{chance = 2, money = 17500, reputation = 15, message = [[Mehrere Heilmittel für tödliche Krankheiten wurden gefunden.]]},
				{chance = 5, money = 12500, reputation = 8, message = [[Mehrere Heilmittel für nicht-tödliche Viren wurden entdeckt.]]},
				{chance = 5, money = -1000, reputation = -8, message = [[In der Einrichtung kam es zu einer großen Explosion.
Dies hätte wahrscheinlich verhindert werden können, wenn sie nicht in dieses Projekt investiert hätten.]]},
				{chance = 5, money = -3000, reputation = -10, message = [[Jemand ist verrückt geworden und hat ihre Investition dazu benutzt, Menschen zu töten.]]},
				{chance = 8, money = 0, reputation = -4, message = [[Ein Fehler beim Führen eines Protokolls führte zu einer Katastrophe.]]},
			}
		},
		{choice = "Investiere in neue Technologie", choiceCost = 8000,
			results = {
				{chance = 25, money = 8000, reputation = 4, message = [[Ein wenig neue Technologie wurde erforscht.]]},
				{chance = 15, money = 12500, reputation = 6, message = [[Herzlichen Glückwunsch.
Es wurden viele technische Geräte entwickelt.]]},
				{chance = 15, money = 5000, reputation = 2, message = [[Zu wenig neue Technologie wurde entwickelt, um davon zu profitieren.]]},
				{chance = 5, money = 20000, reputation = 10, message = [[Lebensrettende Technologie wurde erforscht.]]},
				{chance = 10, money = 0, reputation = -2, message = [[Die Forscher sind vermutlich inkompetent, sie haben nichts erreicht und das gesamte Geld verloren.]]},
				{chance = 10, money = 4000, reputation = -4, message = [[Es gab einen Unfall!
Die Forschung wurde zurückgesetzt und das Geld bis auf ein paar Tausend ging verloren.]]},
				{chance = 1, money = 30000, reputation = 0, message = [[Eine neue Energiequelle wurde entdeckt.
Sie kostet momentan eine Menge, aber das wird sich mit der Zeit legen.]]},
				{chance = 2, money = 0, reputation = 15, message = [[Eine neue Energiequelle wurde entdeckt.
Sie wurde gänzlich umsonst zur Verfügung gestellt.]]},
				{chance = 5, money = -2500, reputation = -8, message = [[In der Einrichtung kam es zu einer großen Explosion.
Dies hätte wahrscheinlich verhindert werden können, wenn Sie nicht in dieses Projekt investiert hätten.]]},
				{chance = 5, money = -5000, reputation = -12, message = [[Jemand ist verrückt geworden und hat ihre Investition dazu benutzt, Menschen zu töten.]]},
				{chance = 8, money = 0, reputation = -3, message = [[Ein Fehler beim Führen eines Protokolls führte zu einer Katastrophe.]]},
			}
		},
		{choice = "Anfrage ignorieren", choiceCost = 0,
			results = {
				{chance = 40, money = 0, reputation = 0, message = [[Du hast die Forschungsanfrage ohne weitere Konflikationen ignoriert.]]},
				{chance = 20, money = 0, reputation = -4, message = [[Durch das Ignorieren der Forschungsanfrage haben einige Bürger ihr Vertrauen verloren.]]},
				{chance = 3, money = 0, reputation = -8, message = [[Durch das Verweigern der Investition kam es zu unbegründeten Todesfällen, diese hätten verhindert werden können.]]},
				{chance = 5, money = 0, reputation = 2, message = [[Die Bevölkerung glaubt, dass es eine gute Wahl war, nicht zu investieren.]]},
				{chance = 8, money = 0, reputation = 5, message = [[Es hat sich rausgestellt, dass das Ignorieren der Forschungsanfrage eine sehr gute Wahl war, da die Forschungsinstitution lediglich eine Bande aus Betrügern war.]]},
			}
		}
	}},
	{title = "Terrorismus",
	description = [[Es gibt eine Bedrohung für die Sicherheit von uns allen.
Laut unseren Geheimagenturen hat ein Islamist vor, ein Mehrfamilienwohnhaus in einem einkommensschwachen Viertel sprengen.
Was sollen wir aufgrund dieser Bedrohung tun?]],
	choices = {
		{choice = "Spezialeinheiten schicken", choiceCost = 5000,
			results = {
				{chance = 30, money = 0, reputation = 10, message = [[Die Spezialeinheiten haben einen Mann mit Sprengstoff und Bombenbauplänen gefangen genommen.]]},
				{chance = 15, money = 15000, reputation = 2, message = [[Die Spezialeinheiten haben keine Explosivstoffe gefunden, aber sie fanden viel illegale Schmuggelware.]]},
				{chance = 10, money = 10000, reputation = 1, message = [[Die Spezialeinheiten fanden heraus, dass die Bedrohung gefälscht war und haben den Verantwortlichen verhaftet und ein Bußgeld von $10.000 ausgestellt.]]},
				{chance = 10, money = 0, reputation = 0, message = [[Die Spezialeinheiten haben nichts gefunden und keine Explosion ertönte.]]},
				{chance = 5, money = 0, reputation = -8, message = [[Das Gebäude ist vorzeitig explodiert, und viele Menschen sind gestorben.]]},
			}
		},
		{choice = "Das Gebäude evakuieren", choiceCost = 0,
			results = {
				{chance = 30, money = 0, reputation = 6, message = [[Das Gebäude wurde evakuiert und es wurden explosive Sprengsätze gefunden.]]},
				{chance = 15, money = 0, reputation = -6, message = [[Das Gebäude wurde evakuiert und es wurden keine explosiven Sprengsätze gefunden.]]},
				{chance = 10, money = 0, reputation = 4, message = [[Das Gebäude wurde evakuiert. Gefolgt von einer Explosion, dafür aber wurde niemand getötet.]]},
				{chance = 15, money = 0, reputation = -12, message = [[Die Evakuierung ist fehlgeschlagen.
Der Terrorist hat die Bomben gezündet, bevor alle flüchten konnten.]]},
			}
		},
		{choice = "Bedrohung ignorieren", choiceCost = 0,
			results = {
				{chance = 35, money = 0, reputation = -20, message = [[Das Gebäude ist explodiert, und viele Menschen sind gestorben.]]},
				{chance = 15, money = 0, reputation = -10, message = [[Es ist nichts passiert, aber es wurde öffentlich, dass Sie nichts gegen diese Bedrohung unternommen hat.]]},
				{chance = 15, money = 0, reputation = 0, message = [[Nichts ist passiert, und die Sache blieb für die Öffentlichkeit geheim.]]},
				{chance = 10, money = 0, reputation = -5, message = [[Der Terrorist wurde rechtzeitig von einem Streifenpolizisten gefasst.
				Die Bevölkerung ist empört, dass man diese Bedrohung vor ihr geheim gehalten hat.]]},
			}
		}
	}},
	{title = "Flüchtlinge aufnehmen",
	description = [[Wir sollen eine hohe Zahl an Flüchtlingen von der Nachbarschaft aufnehmen.
Wir können ein Asyl für $8,000 bauen lassen oder die Anfrage ablehnen.
So oder so könnte sich die öffentliche Meinung in beiden Fällen gegen uns stellen.
Was sollen wir tun?]],
	choices = {
		{choice = "Flüchtlinge aufnehmen", choiceCost = 8000,
			results = {
				{chance = 25, money = 6000, reputation = 12, message = [[Wir haben ein Asyl in einer Wohnsiedlung bauen lassen.
Die Flüchtlinge verhalten sich friedlich und integrieren sich ein.
Einige haben schon Anbindung an die Arbeitswelt gefunden.]]},
				{chance = 15, money = 6000, reputation = 8, message = [[Wir haben ein Asyl in einer Wohnsiedlung bauen lassen.
Die Flüchtlinge verhalten sich friedlich, benötigen aber mehr Zeit für ihre Inegration in unsere Sitten.
Zudem unterstützen uns Hilfsorganisationen mit Zahlungsmitteln.]]},
				{chance = 10, money = 10000, reputation = 6, message = [[Alles verläuft nach Plan.
Wir erhalten sogar zusätzliche Hilfezuschüsse.]]},
				{chance = 15, money = -2000, reputation = -8, message = [[Wir haben ein Asyl in einer Wohnsiedlung bauen lassen.
Die Flüchtlinge demolieren alles und stehen vor dem Beginn einer Rebellion.
Aufruhr herrscht im gesamten Umfeld vor.
Wir verlieren Geld und müssen unsere Sicherheitsmaßnahmen verschärfen.]]},
				{chance = 5, money = 0, reputation = -10, message = [[Die Pfleger des Asyls misshandeln Flüchtlinge.
Als dies öffentlich wurde, mussten wir das Asyl schließen und die Flüchtlinge auf der Straße aussetzen.]]},
				{chance = 5, money = -1000, reputation = -5, message = [[Wir haben ein neues Asyl nahe der Innenstadt bauen lassen.
Die örtlichen Rechtsradikalen haben das Asylheim niedergebrannt und mussten die Flüchtlinge abweisen.]]},
			}
		},
		{choice = "Flüchtlinge ablehnen", choiceCost = 0,
			results = {
				{chance = 25, money = 0, reputation = -12, message = [[Wir haben die Flüchtlinge fortgeschickt und keine Kosten gescheut.
Die Bevölkerung ist zornig über diese Entscheidung.]]},
				{chance = 25, money = -4000, reputation = -5, message = [[Wir haben die Flüchtlinge fortgeschickt und keine Kosten gescheut.
Dafür wurde uns einiges an Mitteln gekürzt und die Bevölkerung ist nicht gerade erfreut.]]},
				{chance = 25, money = 0, reputation = 0, message = [[Wir haben die Flüchtlinge fortgeschickt und keine Kosten gescheut.
Wir konnten diese Entscheidung vor der Bevölkerung geheim halten.]]},
				{chance = 25, money = 0, reputation = 4, message = [[Wir haben die Flüchtlinge fortgeschickt und keine Kosten gescheut.
Die Mehrheit der Bevölkerung unterstützt unsere Entscheidung.]]},
			}
		}
	}},
	{title = "Spenden für eine gute Sache",
	description = [[Eine Spendengemeinschaft hat über $20.000 gesammelt, um dazu beizutragen, die Arbeitslosenrate in den unteren Einkommensschichten zu verringern.
Die Arbeitslosigkeit liegt derzeitig bei 8% und wir könnten ihr Geld gut einsetzen, es aber auch für uns benutzen.]],
	choices = {
		{choice = "Geld investieren", choiceCost = 0,
			results = {
				{chance = 30, money = 4000, reputation = 6, message = [[Die Arbeitslosigkeit wurde um 5% verringert.]]},
				{chance = 20, money = 6000, reputation = 2, message = [[Die Arbeitslosigkeit wurde um 7% verringert.]]},
				{chance = 20, money = 2000, reputation = 10, message = [[Die Arbeitslosigkeit wurde um 3% verringert.]]},
				{chance = 35, money = 0, reputation = -2, message = [[Das Geld wurde fehlinvestiert.
Die Arbeitslosigkeit wurde nicht beeinflusst.]]},
				{chance = 3, money = 0, reputation = -10, message = [[Das Geld wurde von unserem Buchhalter falsch investiert und ein Wasserpark für Schweine wurde errichtet.]]},
			}
		},
		{choice = "Geld entfremden", choiceCost = 0,
			results = {
				{chance = 75, money = 20000, reputation = -40, message = [[Wir haben das ganze Geld behalten.
Die Bevölkerung ist noch nie so enttäuscht über uns gewesen.]]},
				{chance = 25, money = 20000, reputation = 0, message = [[Niemanden scheint es zu kümmern, dass wir all das Geld gestohlen haben.]]},
			}
		},
		{choice = "Gemeinschaft abweisen", choiceCost = 0,
			results = {
				{chance = 40, money = 0, reputation = -6, message = [[Die Spendengemeinschaft und die Bevölkerung ist von ihrer Entscheidung sehr enttäuscht.]]},
				{chance = 25, money = 0, reputation = -2, message = [[Die Spendengemeinschaft ist von ihrer Entscheidung sehr enttäuscht, aber zum Glück verfügte diese über einen einen schlechten Reputation und unser Ruf wurde nur minimal geschädigt.]]},
				{chance = 15, money = 0, reputation = 6, message = [[Die Spendengemeinschaft bestand aus einem Haufen Betrüger, die Falschgeld strecken wollten um uns am Ende blöd aussehen zu lassen.
Es war gut, dass wir diese Halunken abgewiesen wurden.]]},
			}
		}
	}},
	{title = "Güterbahnhof",
	description = [[Einige größere Firmen in unserem Staat wünschen sich eine Anbindung an unser Schienensystem.
Wir sollten einen Güterbahnhof im Industriebezirk errichten.
Sollten wir dieses Unterfangen anstreben?]],
	choices = {
		{choice = "Baue einen Bahnhof", choiceCost = 7000,
			results = {
				{chance = 30, money = 6000, reputation = 10, message = [[Der Bau geht gut voran.
Die Unternehmer danken für euren Einsatz und greifen dem Projekt mit Geldspenden unter die Arme.]]},
				{chance = 30, money = 15000, reputation = 12, message = [[Der Bau des Güterbahnhofs hat einige große Firmen in den Staat gelockt.
Die zusätzlichen Steuereinnahmen füllen unsere Kassen.]]},
				{chance = 10, money = 3500, reputation = -4, message = [[Das Gebiet auf dem gebaut werden sollte, ist nicht geeignet für ein solchen Unterfangen, der Boden ist zu sandig.
Wir konnten jedoch die Hälfte der Ausgaben wieder zurückholen.]]},
				{chance = 10, money = 0, reputation = -6, message = [[Das Unterfangen ist eine riesige Katastrophe, der Bau dauert viel zu lange und uns gehen die Geldmittel aus.]]},
				{chance = 10, money = 0, reputation = -10, message = [[Eine Gasleitung wurde beschädigt!
Die gesamte Baustelle ist in die Luft geflogen und viele Menschen sind ums Leben gekommen!]]},
			}
		},
		{choice = "Bahnhofbau ablehnen", choiceCost = 0,
			results = {
				{chance = 30, money = 0, reputation = 0, message = [[Wir konnten die Firmen davon überzeugen, dass ein Bau nicht notwendig ist.
Sie haben uns diese Masche abgekauft.]]},
				{chance = 35, money = 0, reputation = -8, message = [[Die Firmen haben bemerkt, dass wir uns nicht einmal die Pläne angesehen haben.
Sie sind nicht gerade erfreut.]]},
			}
		},
	}},
	{title = "Wasserwerke",
	description = [[Die Wasserwerke unseres Staats brauchen dringend Geld, um marode Wasserleitungen reparieren zu können.
Was tun wir deshalb?]],
	choices = {
		{choice = "Investiere in neue Leitungen", choiceCost = 6000,
			results = {
				{chance = 35, money = 0, reputation = 10, message = [[Die Reparaturen waren erfolgreich, die Bevölkerung ist erfreut nun wieder gereinigtes Trinkwasser zu haben.]]},
				{chance = 15, money = 0, reputation = -4, message = [[Die Bauarbeiten sind das einzige, was der Bevölkerung an den neuen Leitungen auffällt.]]},
				{chance = 10, money = 0, reputation = -5, message = [[Der Bau der neuen Leitungen, beansprucht mehr Zeit als geplant.
Die Anwohner beschweren sich über die Ausfälle der Wasserzufuhr.]]},
				{chance = 5, money = 0, reputation = -8, message = [[Am Bau der Leitungen wurde gepfuscht und Rohre sind geplatzt.
Viele Bürger sind lange Zeit ohne Wasserzufuhr.]]},
				{chance = 20, money = 10000, reputation = 15, message = [[Die Modernisierung der Leitungen hat einige kleinere Firmen in unseren Staat gelockt.
Sie finden schnell einen Sitz und bieten neue Arbeitsplätze an.]]},
			}
		},
		{choice = "Nichts unternehmen", choiceCost = 0,
			results = {
				{chance = 35, money = 0, reputation = 0, message = [[Die Leitungen scheinen noch einigermaßen zu halten.]]},
				{chance = 30, money = 0, reputation = -8, message = [[Die Bürger haben mit Ausfällen in der Wasserzufuhr zu kämpfen.]]},
				{chance = 20, money = 0, reputation = -14, message = [[Eine Hauptleitung ist geplatzt.
Einige Stadtteile stehen ohne Wasserzufuhr da.]]},
			}
		}
	}},
	{title = "Demonstration",
	description = [[Die Obdachlosen überfluten die Straßen.
Unsere Bürger demonstrieren!
Wir müssen dagegen etwas unternehmen.]],
	choices = {
		{choice = "Ein Obdachlosenheim errichten", choiceCost = 7500,
			results = {
				{chance = 40, money = 6000, reputation = 10, message = [[Der Bau des Obdachlosenheims lief tadellos.
Die Obdachlosen dürften nun niemanden mehr stören.
Einige fanden sogar nach kurzer Zeit Arbeitsanbindung.]]},
				{chance = 10, money = 0, reputation = -2, message = [[Die Obdachlosen verschwanden auf magische Weise und das Obdachlosenheim steht nun leer.
Was für eine Fehlinvestition.]]},
				{chance = 25, money = -2000, reputation = 2, message = [[Einige Obdachlose waren gegen den Bau und demolierten das Baugelände.
Der Bau verzögert sich um einige Monate und kostet extra.]]},
			}
		},
		{choice = "Die Obdachlosen in ein Tötungslager stecken", choiceCost = 1000,
			results = {
				{chance = 20, money = 0, reputation = 6, message = [[Die Lage beruhigt sich und niemand fragt sich wo die ganzen Obdachlosen geblieben sind.]]},
				{chance = 25, money = 0, reputation = -2, message = [[Die Lage beruhigt sich, jedoch kommen Fragen auf, was mit den ganzen Obdachlosen passiert ist.]]},
				{chance = 20, money = 0, reputation = -15, message = [[Einige Obdachlose konnten entkommen.
Sie erzählten allen von unseren Untaten!]]},
				{chance = 15, money = 0, reputation = -4, message = [[Unsere Einsatzkräfte haben einige Zivilisten mit Obdachlosen verwechselt.
Zum Glück ist es nur wenigen aufgefallen.]]},
			}
		},
		{choice = "Die Demonstrationen unterbinden", choiceCost = 2000,
			results = {
				{chance = 30, money = 0, reputation = 5, message = [[Wir konnten die Demonstration unterbinden, alles ist ruhig verlaufen.]]},
				{chance = 20, money = 0, reputation = -2, message = [[Die Lage ist etwas aus dem Ruder gelaufen, jedoch wurde die Demonstration aufgelöst.]]},
				{chance = 10, money = 0, reputation = -8, message = [[Das Chaos ist ausgebrochen!
Wir mussten mit Wasserwerfern und Tränengas anrücken.
Viele Menschen wurden verletzt!]]},
			}
		},
		{choice = "Nichts unternehmen", choiceCost = 0,
			results = {
				{chance = 35, money = 0, reputation = -6, message = [[Die Demonstration ist ausgeartet.
Viele Menschen wurden verletzt!
Die Bevölkerung fühlt sich nicht wertgeschätzt, weil Sie nichts getan haben.]]},
				{chance = 40, money = 0, reputation = 2, message = [[Die Demonstration ist ruhig verlaufen.
Sie hat sich schlussendlich aufgelöst.]]},
				{chance = 15, money = 0, reputation = -15, message = [[Das Chaos ist ausgebrochen!
Wir mussten mit schlussendlich mit Wasserwerfern und Tränengas anrücken.
Viele Menschen wurden verletzt und alle schauen wütend zu ihnen auf!]]},
				{chance = 3, money = 0, reputation = 0, message = [[Die Demonstration lief noch einige Tage, aber zum Glück tauchte ein lila Drache auf, welcher alle Demonstranten in die Kanalisation flog.
Die meisten Demonstranten standen wohl unter Rauschgiften.]]},
			}
		}
	}},
	{title = "Tierschützer",
	description = [[Wir haben Probleme mit den lokalen Tierschützerverbänden bekommen.
Unsere Jäger töten im Übermaß bedrohte Tierarten.
Wir sollten dem einen Riegel vorschieben.]],
	choices = {
		{choice = "Tierschutzgesetze verschärfen", choiceCost = 1000,
			results = {
				{chance = 50, money = 0, reputation = 8, message = [[Die neuen Tierschutzgesetze haben einige bedrohte Tierarten gerettet.]]},
				{chance = 15, money = 5000, reputation = 10, message = [[Die neuen Tierschutzgesetze haben einige bedrohte Tierarten gerettet.
Wir wurden von einigen Tierschutzorganisationen mit Geldgeschenken überrascht.]]},
				{chance = 30, money = -1000, reputation = -6, message = [[Da wir das Jagen eingeschränkt haben ist die Nahrungsmittelzufuhr eingestockt.
Der Marktpreis für Fleischprodukte ist rapide angestiegen.
Das gefällt der Bevölkerung überhaupt nicht.]]},
				{chance = 5, money = 0, reputation = -14, message = [[Die angeblich bedrohten Tierarten waren nicht so harmlos, wie wir es uns erhofft hatten.
Wir leiden nun unter einer Epidemie.]]},
			}
		},
		{choice = "Nichts unternehmen", choiceCost = 0,
			results = {
				{chance = 30, money = 0, reputation = -14, message = [[Die bedrohten Tierarten sind ausgestorben und die Bevölkerung ist empört darüber, dass nichts getan wurde.]]},
				{chance = 20, money = 0, reputation = 2, message = [[Wir mussten keine neuen Gesetze aufstellen.
Die örtlichen Förster haben sich selbst um die Erhaltung bestimmter Tierarten gesorgt.]]},
				{chance = 10, money = 0, reputation = 5, message = [[Es hat sich herausgestellt, dass das Ganze nur eine Verdrehung von Tatsachen war und im Nachhinein gut war, dass nichts unternommen wurde.]]},
			}
		}
	}},
	{title = "Straßenbanden",
	description = [[Wir sollten etwas gegen die Straßenbanden in einigen unserer Stadtteilen unternehmen!
Die Bevölkerung fürchtet sich nachts auf die Straße zu gehen.]],
	choices = {
		{choice = "Straßen patrouillieren", choiceCost = 2000,
			results = {
				{chance = 30, money = 0, reputation = 8, message = [[Bei den Patrouillien wurden einige Bandenmitglieder gefasst.
Das hatte zur Folge, dass die meisten Straßenbanden unsere Gegenden verließen und nun woanders ihr Unheil treiben.]]},
				{chance = 15, money = 0, reputation = 0, message = [[Bei den Patroullien konnte keine Gefahr erkannt werden, anscheinend lag uns eine Fehlinformation vor.]]},
				{chance = 15, money = 0, reputation = 15, message = [[Bei den Patroullien wurden Bandenmitglieder tödlich verletzt.
Das hatte zur Folge, dass sich fast alle Straßenbanden aufgelöst haben.]]},
				{chance = 10, money = 0, reputation = -5, message = [[Bei den Patroullien wurden Beamte tödlich verletzt.]]},
				{chance = 5, money = -2500, reputation = -10, message = [[Bei den Patroullien wurden Beamte tödlich verletzt.
Durch den Mangel an Arbeitskräften, waren wir gezwungen neue Beamte auszubilden.
Das kostete uns nun ein wenig.]]},
			}
		},
		{choice = "Nichts unternehmen", choiceCost = 0,
			results = {
				{chance = 40, money = 0, reputation = -16, message = [[Die Straßenbanden machen mit ihren Machenschaften weiter und die Lage hat sich kein Stück verbessert.
Die Bevölkerung verdächtigt sie, mit den Banden unter einer Decke zu stecken.]]},
				{chance = 20, money = 0, reputation = 2, message = [[Das Geschäft hat sich für die Straßenbanden als nicht wirklich lukrativ herausgestellt und viele Straßenbanden haben unsere Gegenden verlassen.]]},
			}
		}
	}},
	{title = "Korrupte Politiker",
	description = [[Wir haben einige korrupte Politiker in unseren Reihen.
Sie hinterziehen Steuern und betreiben illegalen Handel mit ausländischen Konzernen.
Was sollen wir tun?]],
	choices = {
		{choice = "Neue Politiker einstellen", choiceCost = 2000,
			results = {
				{chance = 20, money = 0, reputation = 5, message = [[Wir haben neue Politiker eingestellt.
Sie sind einigermaßen begabt, aber noch lange nicht professionell.]]},
				{chance = 20, money = 5000, reputation = 8, message = [[Wir haben sehr kompetente Politiker eingestellt.
Sie machen ihre Arbeit richtig und arbeiten die Probleme der Vorherigen auf.]]},
				{chance = 15, money = 0, reputation = -4, message = [[Wir haben nur inkompetente Politiker gefunden und die korrupten mit Diesen ersetzt.
Es scheint genauso schlimm wie vorher.]]},
				{chance = 10, money = 0, reputation = -6, message = [[Die Politikersuche stellte sich als Fehlinvestition heraus.
Wir konnten kein neues Personal finden und das Ganze ging an die Öffentlichkeit.]]},
			}
		},
		{choice = "In das Geschäft einsteigen", choiceCost = 0,
			results = {
				{chance = 25, money = 15000, reputation = 0, message = [[Wir sind in das Geschäft eingestiegen.
Die zusätzlichen Einnahmen füllen unsere Kassen.
Die ganze Sache wurde vor der Bevölkerung geheim gehalten.]]},
				{chance = 25, money = 15000, reputation = -20, message = [[Wir sind in das Geschäft eingestiegen.
Die zusätzlichen Einnahmen füllen unsere Kassen.
Die Bevölkerung kam leider dahinter und unser Ruf musste darunter leiden.]]},
				{chance = 20, money = -5000, reputation = 0, message = [[Der Einstieg in das Geschäft war ein großer Fehler.
Wir haben am Ende mehr bezahlt als wir daraus bekommen haben.
Wenigstens ist es niemandem aufgefallen.]]},
				{chance = 20, money = -5000, reputation = -20, message = [[Der Einstieg in das Geschäft war ein großer Fehler.
Wir haben am Ende mehr bezahlt als wir daraus bekommen haben.
Das gefällt der Bevölkerung gar nicht.]]},
			}
		},
		{choice = "Nichts unternehmen", choiceCost = 0,
			results = {
				{chance = 30, money = -4000, reputation = -6, message = [[Die Politiker ziehen uns weiterhin das Geld aus der Tasche und die Bevölkerung fragt sich langsam, wo das ganze Geld hin geht.]]},
				{chance = 35, money = 0, reputation = 0, message = [[Die Politiker haben aufgehört uns das Geld zu entfremden, als sie spitz bekommen haben, dass wir von ihrem Geschäft wissen.]]},
				{chance = 20, money = -8000, reputation = -10, message = [[Die Politiker haben ihren Posten verlassen, nachdem sie einen riesigen Deal über die Bühne gezogen haben.]]},
			}
		}
	}},
	{title = "Elektrizitätswerke",
	description = [[Unsere Elektrizitätskraftwerke produzieren zu wenig Strom um alle Stadteile damit versorgen zu können.
Wir brauchen eine permanente Lösung für dieses Problem.]],
	choices = {
		{choice = "Ein Atomkraftwerk bauen", choiceCost = 7000,
			results = {
				{chance = 25, money = 15000, reputation = 8, message = [[Wir produzieren Strom im Übermaß.
Wir verkaufen den Überschuss an Interessenten und verdienen gut damit.]]},
				{chance = 5, money = -5000, reputation = -25, message = [[Durch einen Reaktorausfall sind große Teile des Staats verstrahlt und können für lange Zeit nicht bewohnt werden.]]},
				{chance = 10, money = 0, reputation = -5, message = [[Wir produzieren genug Strom, um uns vollständig zu versorgen.
Einige Bürger haben jedoch Bedenken, was den Klimaschutz angeht.]]},
				{chance = 10, money = 0, reputation = 4, message = [[Wir produzieren genug Strom, um uns vollständig zu versorgen.
Niemanden scheinen die potenziellen Umweltschäden zu kümmern.]]},
			}
		},
		{choice = "Solaranlagen bauen", choiceCost = 5000,
			results = {
				{chance = 30, money = 0, reputation = 10, message = [[Wir produzieren genug Strom, um den gesamten Staat zu versorgen und schützen die Umwelt.
Eine vorbildliche Leistung!]]},
				{chance = 20, money = -3000, reputation = -3, message = [[Wir produzieren zu wenig Strom um den gesamten Staat versorgen zu können und das Projekt wird uns langsam zu kostspielig.]]},
				{chance = 10, money = 10000, reputation = 8, message = [[Die neuen Solaranlagen haben einige große Firmen in den Staat gelockt.
Die zusätzlichen Steuereinnahmen füllen unsere Kassen.]]},
				{chance = 2, money = -5000, reputation = -10, message = [[Eine Horde wütender Nationalsozialisten hat unsere Solaranlagen demoliert, weil sie den Klimawandel für eine Lüge der Regierung halten.
Das kostet uns eine Stange extra.]]},
			}
		},
		{choice = "Nichts unternehmen", choiceCost = 0,
			results = {
				{chance = 25, money = 0, reputation = -10, message = [[Die Bürger beklagen sich über Ausfälle der Stromzufuhr.]]},
				{chance = 20, money = -1000, reputation = 0, message = [[Der Strom fließt ordnungsgemäß, dafür müssen unsere Kraftwerke aber auf Hochtouren laufen.]]},
			}
		}
	}},
	{title = "Geheimnisvolle Morde",
	description = [[Ein Serienmörder treibt sein Unwesen bei uns.
Es verschwinden nächtlich immer wieder Menschen und tauchen Tage später als Leiche wieder auf.
Unsere Ermittler sind am Ende.
Wie sollen wir mit dieser Sache umgehen?]],
	choices = {
		{choice = "Spezialermittler anheuern", choiceCost = 3000,
			results = {
				{chance = 40, money = 0, reputation = 15, message = [[Wir haben den Mörder dank ihrer Hilfe fassen können.
Es sind keine weiteren Menschen ums Leben gekommen.]]},
				{chance = 15, money = 0, reputation = -2, message = [[Die Spezialermittler konnten den Mörder nicht fassen.
Er ist noch auf freiem Fuß, aber ist glücklicherweise untergetaucht.]]},
				{chance = 10, money = 0, reputation = -10, message = [[Die Spezialermittler konnten den Mörder nicht fassen.
Er ist noch auf freiem Fuß und tötet weiterhin Unschuldige.]]},
				{chance = 5, money = 0, reputation = -10, message = [[Die Spezialermittler wurden ermordet.
Wer hätte das gedacht?]]},
			}
		},
		{choice = "Verdächtige überprüfen", choiceCost = 0,
			results = {
				{chance = 35, money = 0, reputation = 10, message = [[Wir haben den Mörder dank ihrer Hilfe unter den Verdächtigen identifizieren können.
Es sind keine weiteren Menschen ums Leben gekommen.]]},
				{chance = 15, money = 0, reputation = -2, message = [[Wir haben den Mörder unter den Verdächtigen nicht identifizieren können.
Er ist noch auf freiem Fuß, aber ist glücklicherweise untergetaucht.]]},
				{chance = 10, money = 0, reputation = -10, message = [[Wir haben den Mörder unter den Verdächtigen nicht identifizieren können.
Er ist noch auf freiem Fuß und tötet weiterhin Unschuldige.]]},
			}
		},
		{choice = "Nichts unternehmen", choiceCost = 0,
			results = {
				{chance = 30, money = 0, reputation = -15, message = [[Der Mörder ist weiterhin auf freiem Fuß und mordet heiter weiter.
Die Bevölkerung verliert ihr Vertrauen in Ihre Fähigkeiten.]]},
				{chance = 10, money = 0, reputation = 4, message = [[Der Mörder wurde von einem Streifenpolizisten vorzeitig gefasst.
Niemand musste mehr sterben.]]},
				{chance = 5, money = 0, reputation = 1, message = [[Der Mörder hat seltsamerweise aufgehört zu morden.]]},
			}
		}
	}},
	{title = "Steuerbeschwerde",
	description = [[Viele große Unternehmen in unserem Staat bemängeln die hohen Steuerabgaben.
Sollten wir diesbezüglich nichts unternehmen, siedeln diese Unternehmen um und wir verlieren einen Großteil unserer Steuereinnahmen.
Was ist zu tun?]],
	choices = {
		{choice = "Gewerbesteuer senken", choiceCost = 1000,
			results = {
				{chance = 15, money = -5000, reputation = 5, message = [[Wir haben die Gewerbesteuern gesenkt.
Das wirkt sich über längere Zeit negativ auf unsere Steuereinnahmen aus.]]},
				{chance = 25, money = 6000, reputation = 10, message = [[Wir haben die Gewerbesteuern gesenkt.
In kürzester Zeit fanden neue Unternehmen ihren Weg zu uns und wir nehmen mehr Steuern ein als je zuvor.]]},
				{chance = 5, money = -7500, reputation = -5, message = [[Wir haben die Gewerbsteuern gesenkt, leider aber zu spät.
Die meisten großen Unternehmen sind bereits umgesiedelt.
Wir schreiben die nächste Zeit erstmal nur noch rote Zahlen.]]},
				{chance = 5, money = -10000, reputation = -10, message = [[Es war ein großer Fehler die Gewerbesteuer zu senken.
Viele große Unternehmen nutzen das als Steueroase aus.]]},
			}
		},
		{choice = "Ausnahmen machen", choiceCost = 0,
			results = {
				{chance = 25, money = 4000, reputation = 4, message = [[Wir haben die Steuersätze für einige große Unternehmer verringert.
Alle sind mit den neuen Steuersätzen einverstanden und wir verdienen weiterhin gut an Steuern.]]},
				{chance = 10, money = 4000, reputation = -5, message = [[Wir haben die Steuersätze für einige große Unternehmer verringert.
Die kleineren Unternehmen fühlen sich betrogen, aber wir verdienen weiterhin gut an Steuern.]]},
				{chance = 10, money = -6000, reputation = -5, message = [[Wir haben die Steuersätze für einige große Unternehmer verringert.
Sie waren mit den neuen Steuersätzen immer noch nicht einverstanden und sind umgesiedelt.
Manchen kann man es auch nicht recht machen.]]},
			}
		},
		{choice = "Nichts unternehmen", choiceCost = 0,
			results = {
				{chance = 20, money = -7500, reputation = -6, message = [[Die meisten großen Unternehmen sind umgesiedelt.
Wir schreiben die nächste Zeit erstmal nur noch rote Zahlen.]]},
				{chance = 30, money = 0, reputation = 0, message = [[Es hat sich nichts geändert.
Die Unternehmer scheinen nur unnötig rumgemeckert zu haben.]]},
				{chance = 10, money = -1000, reputation = -2, message = [[Nur wenige größere Unternehmen sind umgesiedelt.
Der Großteil ist aber geblieben.]]},
			}
		}
	}},
	{title = "Virusausbruch",
	description = [[In unserem geheimen, unterirdischen Forschungslabor hat sich ein tödlicher Virus ausgebreitet, der seinen Weg in eine reiche Siedlung machte..
Die gesamte Gegend ist kontaminiert und wir sollten das Gebiet abriegeln.]],
	choices = {
		{choice = "Gebiet unter Quarantäne setzen", choiceCost = 2000,
			results = {
				{chance = 35, money = 0, reputation = 0, message = [[Das Gebiet wurde erfolgreich unter Quarantäne gesetzt und der Virus konnte nicht ausbrechen.
Doch alle Menschen innerhalb, starben innerhalb von 2 Wochen.
Niemand ahnt, dass wir etwas mit den Toden dieser Menschen zu tun haben.]]},
				{chance = 15, money = 0, reputation = -5, message = [[Das Gebiet wurde erfolgreich unter Quarantäne gesetzt und der Virus konnte nicht ausbrechen.
Doch alle Menschen innerhalb, starben innerhalb von 2 Wochen.
Wir werden verdächtigt, etwas mit dem Tod dieser Menschen zu tun zu haben.
				Beweise für die Anschuldigungen, gibt es aber nicht.]]},
				{chance = 10, money = 0, reputation = -8, message = [[Das Gebiet wurde erfolgreich unter Quarantäne gesetzt.
Nach 2 Wochen stellte sich heraus, dass sich unsere Forscher vertan haben und der Virus nicht tödlich oder gefährlich ist.
Die Opfer der Quarantäne halten Interviews ab und lassen uns schlecht darstehen.]]},
				{chance = 10, money = 0, reputation = -15, message = [[Das Gebiet konnte nicht rechtzeitig unter Quarantäne gesetzt werden und der Virus ist ausgebrochen.
Ganze Viertel mussten abgeriegelt werden.]]},
			}
		},
		{choice = "Menschen zu Forschungszwecken nutzen", choiceCost = 1000,
			results = {
				{chance = 25, money = 5000, reputation = 6, message = [[Wir haben die infizierten Menschen in unser unterirdisches Forschungslabor verlagert.
Sie wurden für Tests benutzt und wir konnten große medizinische Fortschritte verzeichen und verkaufen das Heilmittel für gutes Geld.
Wir konnten sie nach kurzer Zeit schon lebendig entlassen.]]},
				{chance = 15, money = 0, reputation = -24, message = [[Einige der Menschen haben sich gewehrt und es kam zu Übergriffen und zum Übertragen der Viren an Unbeteiligte.
Die Bevölkerung war noch nie so enttäuscht durch uns.]]},
				{chance = 10, money = 0, reputation = 0, message = [[Wir haben die infizierten Menschen in unser unterirdisches Forschungslabor verlagert.
Wir konnten keine signifikanten Fortschritte vor dem unvermeindlichen Tod der Probanten erzwecken.
Dies wurde vor der Öffentlichkeit geheim gehalten.]]},
				{chance = 10, money = 0, reputation = -18, message = [[Wir haben die infizierten Menschen in unser unterirdisches Forschungslabor verlagert.
Wir konnten keine signifikanten Fortschritte vor dem unvermeindlichen Tod der Probanten erzwecken.
Wir konnten das nicht von der Öffentlichkeit geheim halten und wurden angeprangert.]]},
			}
		},
		{choice = "Nichts unternehmen", choiceCost = 0,
			results = {
				{chance = 20, money = -10000, reputation = -20, message = [[Der Virus hat mehr als ein Viertel aller Einwohner getötet.
Nur weil wir nichts gemacht haben, verloren wir fast alles.]]},
				{chance = 10, money = 0, reputation = 0, message = [[Die Forscher haben sich geirrt und der Virus war nur eine Falschmeldung.]]},
				{chance = 10, money = 0, reputation = -5, message = [[Der Virus hat sich nicht groß ausgebreitet, doch einige Menschen starben.
Die Bevölkerung ist enttäuscht, dass wir nichts gemacht haben.]]},
			}
		}
	}}
}

Config.CurrentPerks = {}

Config.GiveMoney = function(ply, amount)
	ply:addMoney(amount)
	DarkRP.notify(ply, 0, 3, "Du hast $"..string.Comma(amount).." für das Ausrauben der Staatskasse erhalten.")
end

Config.AddChatCommand = function(command, callback, description, delay)
	if SERVER then
		DarkRP.defineChatCommand(command, callback)
	end
	DarkRP.declareChatCommand{command = command, description = description, delay = delay}
end

Config.ChangeTeam = function(ply, t, force)
	if t == "Default" then
		t = GAMEMODE.DefaultTeam
	end
	ply:changeTeam(t, force)
end