include("shared.lua")

surface.CreateFont("EconomyAlarm_Font", {font = "Roboto", size = 25, antialias = true, weight = 600})
surface.CreateFont("EconomyAlarm_Font2", {font = "Roboto", size = 22, antialias = true, weight = 500})

local local_ply, eye_trace, ent
local vector_pos = Vector(0, 0, 25)
local function DrawAlarm()
	local_ply = local_ply or LocalPlayer()
	eye_trace = local_ply:GetEyeTrace()
	ent = eye_trace.Entity
	if IsValid(ent) and ent:GetClass() == "economy_alarm" and ent:GetPos():DistToSqr(eye_trace.StartPos) < 90000 then
		surface.SetTextColor(color_white)
		local ts = (ent:GetPos() + vector_pos):ToScreen()
		local use_color = ent:GetActivated() and Color(100, 255, 100) or Color(255, 100, 100)
		draw.SimpleTextOutlined(ent.PrintName, "EconomyAlarm_Font", ts.x, ts.y, use_color, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, color_black)
		draw.SimpleTextOutlined("Status: "..(ent:GetActivated() and "Funktioniert" or "Beschädigt"), "EconomyAlarm_Font2", ts.x, ts.y + 25, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, color_black)
		draw.SimpleTextOutlined("Staatskassenraub möglich: "..(ent:GetAvailable() and "Ja" or "Nein"), "EconomyAlarm_Font2", ts.x, ts.y + 42, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, color_black)
		if !ent:GetActivated() and ent:GetRepairTime() > CurTime() then 
			draw.SimpleTextOutlined(string.ToMinutesSeconds(math.Round(ent:GetRepairTime() - CurTime())).." min. bis Funktion zurückkehrt.", "EconomyAlarm_Font2", ts.x, ts.y + 65, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, color_black)
		end
	end
end
hook.Add("HUDPaint", "Economy_DrawAlarm", DrawAlarm)