local function AddAmmoButton(ent, id, panel, tm)
	if ent.allowed and !table.HasValue(ent.allowed, tm) then return end
	local AmmoPanel = vgui.Create("DFrame")
	AmmoPanel:SetSize(F4Menu_AmmoMain:GetWide(), 54)
	AmmoPanel:SetTitle("")
	AmmoPanel:ShowCloseButton(false)
	AmmoPanel:SetDraggable(false)
	AmmoPanel.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 0, w, h + 20, F4Menu_Reskin.Colors[1])
		draw.RoundedBox(0, 1, 1, w - 2, h - 2, F4Menu_Reskin.Colors[2])
		local x2, y2 = F4Menu_AmmoMain:LocalToScreen(0, 0)
		local w2, h2 = F4Menu_AmmoMain:GetSize()
		render.SetScissorRect(x2, y2, x2 + w2, y2 + h2, true)
		render.SetScissorRect(0, 0, 0, 0, false)
	end
	local Name = vgui.Create("DLabel", AmmoPanel)
	Name:SetPos(10, 6)
	Name:SetText(ent.name)
	Name:SetFont("F4Menu_JobFont")
	Name:SetTextColor(color_black)
	Name:SizeToContents()
	local Desc = vgui.Create("DLabel", AmmoPanel)
	Desc:SetPos(15, 30)
	Desc:SetSize(AmmoPanel:GetWide() - 200, AmmoPanel:GetTall())
	Desc:SetTextColor(Color(0, 0, 0, 200))
	Desc:SetWrap(true)
	Desc:SetFont("F4Menu_EntityFont")
	local price = ent.price
	Desc:SetText("Preis: $"..string.Comma(price)..", Magazingröße: "..string.Comma(ent.amountGiven))
	Desc:SetAutoStretchVertical(true)
	local Icon = vgui.Create("SpawnIcon", AmmoPanel)
	Icon:SetPos(AmmoPanel:GetWide() - 208, 0)
	local model = ent.model
	if istable(model) then
		model = model[math.random(#model)]
	end
	Icon:SetModel(model)
	Icon:SetSize(50, 50)
	Icon:SetMouseInputEnabled(false)
	local Buy = vgui.Create("DButton", AmmoPanel)
	Buy:SetSize(110, 20)
	Buy:SetPos(AmmoPanel:GetWide() - 142, 17)
	Buy:SetText("Artikel kaufen")
	Buy:SetFont("F4Menu_BuyItemFont")
	Buy:SetTextColor(color_white)
	local ply = LocalPlayer()
	local unavailable
	Buy.Paint = function(self, w, h)
		local col
		local col2 = F4Menu_Reskin.Colors[3]
		local col3 = F4Menu_Reskin.Colors[4]
		if self:IsHovered() then
			col = F4Menu_Reskin.Colors[5]
		else
			col = F4Menu_Reskin.Colors[6]
		end
		if unavailable or !ply:canAfford(price) then
			if self:IsHovered() then
				col = F4Menu_Reskin.Colors[7]
			else
				col = F4Menu_Reskin.Colors[8]
			end
			col2 = F4Menu_Reskin.Colors[9]
			col3 = F4Menu_Reskin.Colors[10]
		end
		draw.RoundedBox(0, 0, 0, w, h, col2)
		draw.RoundedBox(0, 1, 1, w - 2, h - 2, col)
		surface.SetDrawColor(col3)
		surface.DrawLine(1, 1, w - 2, 1)
		surface.DrawLine(1, 1, 1, 20)
		surface.DrawLine(1, 18, w - 2, 18)
		surface.DrawLine(w - 2, 1, w - 2, 20)
	end
	local customCheck = ent.customCheck
	local nextcheck2 = CurTime()
	Buy.Think = function(self, w, h)
		if nextcheck2 >= CurTime() then return end
		nextcheck2 = CurTime() + 0.25
		if customCheck then
			local check = customCheck(ply)
			if check == false then
				if ent.CustomCheckFailMsg then
					self:SetTooltip(ent.CustomCheckFailMsg(ply))
				end
				unavailable = true
			else
				unavailable = false
			end
		else
			self:SetTooltip(nil)
		end
	end
	Buy.DoClick = function()
		RunConsoleCommand("darkrp", "buyammo", ent.id)
	end
	panel[id]:AddItem(AmmoPanel)
end

function F4Menu_AddRefreshedAmmoItems()
	local scrollbar = false
	local closedcats = {}
	if IsValid(F4Menu_AmmoMain) then
		scrollbar = F4Menu_AmmoMain.VBar:GetScroll()
		for k,v in ipairs(F4Menu_AmmoMain:GetItems()) do
			if !v:GetExpanded() then
				closedcats[k] = true
			end
		end
		F4Menu_AmmoMain:Remove()
	end
	F4Menu_AmmoMain = vgui.Create("DPanelList", F4Menu_AmmoPanel)
	F4Menu_AmmoMain:SetSize(F4Menu_AmmoPanel:GetWide(), F4Menu_AmmoPanel:GetTall())
	F4Menu_AmmoMain:SetPos(0, 0)
	F4Menu_AmmoMain:EnableVerticalScrollbar(true)
	F4Menu_AmmoMain.Paint = function(s, w, h)
		draw.RoundedBox(4, 3, 13, 8, h - 24, F4Menu_Reskin.Colors[11])
		draw.RoundedBox(4, 0, 0, w, h, F4Menu_Reskin.Colors[12])
	end
	F4Menu_AmmoMain.VBar.Paint = function(s, w, h)
		draw.RoundedBox(4, 3, 13, 8, h - 24, F4Menu_Reskin.Colors[11])
	end
	F4Menu_AmmoMain.VBar.btnUp.Paint = function(s, w, h)
	end
	F4Menu_AmmoMain.VBar.btnDown.Paint = function(s, w, h)
	end
	F4Menu_AmmoMain.VBar.btnGrip.Paint = function(s, w, h)
		draw.RoundedBox(4, 5, 0, 4, h + 22, F4Menu_Reskin.Colors[11])
	end
	local F4Menu_AmmoCategories = {}
	local F4Menu_AmmoLists = {}
	local cats = DarkRP.getCategories()["ammo"]
	local num = 1
	local ply = LocalPlayer()
	local tm = ply:Team()
	for _, data in ipairs(cats) do
		if data["canSee"] and data["canSee"](ply) then
			local members = data["members"]
			if #members > 0 then
				if !F4Menu_AmmoCategories[num] then
					for _,v in ipairs(members) do
						local check = v.allowed
						if !check then check = {tm} end
						if table.HasValue(check, tm) then
							break
						end
					end
					F4Menu_AmmoCategories[num] = vgui.Create("DCollapsibleCategory", F4Menu_AmmoMain)
					local ammocat = F4Menu_AmmoCategories[num]
					ammocat:SetSize(F4Menu_AmmoMain:GetWide(), 100)
					if (closedcats[key] == true) then
						ammocat:SetExpanded(false)
					else
						ammocat:SetExpanded(true)
					end
					ammocat:SetLabel("")
					ammocat.PaintOver = function(self, w, h)
						surface.SetDrawColor(F4Menu_Reskin.Colors[1])
						surface.DrawLine(0, 20, w, 20)
						draw.RoundedBox(0, 0, 0, w, 20, F4Menu_Reskin.Colors[13])
						draw.RoundedBox(0, 1, 1, w - 2, 20 - 2, F4Menu_Reskin.Colors[14])
						surface.SetDrawColor(F4Menu_Reskin.Colors[16])
						surface.DrawLine(1, 1, w - 2, 1)
						surface.DrawLine(1, 1, 1, 18)
						surface.DrawLine(1, 18, w - 2, 18)
						surface.DrawLine(w - 2, 1, w - 2, 18)
						draw.SimpleText(data["name"], "F4Menu_CategoryTitle", 10, 3, color_white, TEXT_ALIGN_LEFT)
					end
					F4Menu_AmmoLists[num] = vgui.Create("DPanelList", ammocat)
					local ammolist = F4Menu_AmmoLists[num]
					ammolist:SetWide(F4Menu_AmmoMain:GetWide())
					ammolist:SetAutoSize(true)
					ammolist:SetPadding(2)
					ammolist:SetSpacing(0)
					ammolist:SetPos(0, 20)
					ammolist:EnableVerticalScrollbar(false)
					ammolist.Paint = function(s, w, h)
						draw.RoundedBox(4, 3, 13, 8, h - 24, F4Menu_Reskin.Colors[11])
						draw.RoundedBox(0, 0, 0, w, h, F4Menu_Reskin.Colors[12])
					end
					F4Menu_AmmoMain:AddItem(ammocat)
				end
				for k,v in ipairs(members) do
					if !F4Menu_Reskin.ShowNonAvailableEntitiesToAll then
						local hasCheck
						if v.customCheck then
							hasCheck = true
						end
						if hasCheck and v.customCheck(ply) then
							AddAmmoButton(v, num, F4Menu_AmmoLists, tm)
						elseif !hasCheck then
							AddAmmoButton(v, num, F4Menu_AmmoLists, tm)
						end
					else
						AddAmmoButton(v, num, F4Menu_AmmoLists, tm)
					end
				end
				num = num + 1
			end
		end
	end
	for id in pairs(F4Menu_AmmoLists) do
		if #F4Menu_AmmoLists[id]:GetItems() == 0 then
			F4Menu_AmmoCategories[id]:Remove()
			F4Menu_AmmoCategories[id] = nil
		end
	end
	if scrollbar then
		F4Menu_AmmoMain.VBar:AnimateTo(scrollbar, 0, 0, 1)
	end
end

function F4Menu_OpenAmmo()
	F4Menu_AmmoPanel = vgui.Create("DFrame", F4Menu_Main)
	F4Menu_AmmoPanel:SetSize(F4Menu:GetWide() - 260, F4Menu:GetTall() - 50)
	F4Menu_AmmoPanel:SetPos(30, 30)
	F4Menu_AmmoPanel:ShowCloseButton(false)
	F4Menu_AmmoPanel:SetTitle("")
	F4Menu_AmmoPanel.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 0, w, h, F4Menu_Reskin.Colors[12])
	end
	F4Menu_AddRefreshedAmmoItems()
	F4Menu_AmmoPanel:SetVisible(false)
end