local cmenu_commands = CreateClientConVar("cl_cmenu_commands", 1, FCVAR_ARCHIVE)
hook.Add("ContextMenuOpened", "CMenu_ContextMenuCommands", function()
	if !cmenu_commands:GetBool() then
		if IsValid(CMenu_Commands) then
			CMenu_Commands:Remove()
		end
		return
	end
	if !F4Menu_Reskin.ContextMenuExtension or IsValid(CMenu_Commands) then return end
	CMenu_Commands = vgui.Create("DFrame", g_ContextMenu)
	CMenu_Commands:SetSize(350, 400)
	CMenu_Commands:SetPos(5, 220)
	CMenu_Commands:ShowCloseButton(false)
	CMenu_Commands:SetTitle("")
	CMenu_Commands.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 0, w, h, F4Menu_Reskin.Colors[12])
	end
	CMenu_CommandsMain = vgui.Create("DPanelList", CMenu_Commands)
	CMenu_CommandsMain:SetSize(CMenu_Commands:GetWide(), CMenu_Commands:GetTall())
	CMenu_CommandsMain:SetPos(0, 0)
	CMenu_CommandsMain:EnableVerticalScrollbar(true)
	CMenu_CommandsMain.Paint = function(s, w, h)
		draw.RoundedBox(4, 3, 13, 8, h - 24, F4Menu_Reskin.Colors[11])
		draw.RoundedBox(4, 0, 0, w, h, F4Menu_Reskin.Colors[12])
	end
	CMenu_CommandsMain.VBar.Paint = function(s, w, h)
		draw.RoundedBox(4, 3, 13, 8, h - 24, F4Menu_Reskin.Colors[11])
	end
	CMenu_CommandsMain.VBar.btnUp.Paint = function(s, w, h)
	end
	CMenu_CommandsMain.VBar.btnDown.Paint = function(s, w, h)
	end
	CMenu_CommandsMain.VBar.btnGrip.Paint = function(s, w, h)
		draw.RoundedBox(4, 5, 0, 4, h + 22, F4Menu_Reskin.Colors[11])
	end
	CMenu_MoneyCommands = vgui.Create("DCollapsibleCategory", CMenu_CommandsMain)
	CMenu_MoneyCommands:SetSize(CMenu_CommandsMain:GetWide(), 100)
	CMenu_MoneyCommands:SetExpanded(true)
	CMenu_MoneyCommands:SetLabel("")
	CMenu_MoneyCommands.PaintOver = function(self, w, h)
		surface.SetDrawColor(F4Menu_Reskin.Colors[1])
		surface.DrawLine(0, 20, w, 20)
		draw.RoundedBox(0, 0, 0, w, 20, F4Menu_Reskin.Colors[13])
		draw.RoundedBox(0, 1, 1, w - 2, 18, F4Menu_Reskin.Colors[14])
		surface.SetDrawColor(F4Menu_Reskin.Colors[16])
		surface.DrawLine(1, 1, w - 2, 1)
		surface.DrawLine(1, 1, 1, 18)
		surface.DrawLine(1, 18, w - 2, 18)
		surface.DrawLine(w - 2, 1, w - 2, 18)
		draw.SimpleText(F4Menu_Reskin.FirstCommandsTitle, "F4Menu_CategoryTitle", 10, 3, color_white, TEXT_ALIGN_LEFT)
	end
	CMenu_MoneyCommandsList = vgui.Create("DPanelList", CMenu_MoneyCommands)
	CMenu_MoneyCommandsList:SetWide(CMenu_CommandsMain:GetWide())
	CMenu_MoneyCommandsList:SetAutoSize(true)
	CMenu_MoneyCommandsList:SetPadding(2)
	CMenu_MoneyCommandsList:SetSpacing(2)
	CMenu_MoneyCommandsList:SetPos(0, 20)
	CMenu_MoneyCommandsList:EnableVerticalScrollbar(false)
	CMenu_MoneyCommandsList.Paint = function(s, w, h)
		draw.RoundedBox(4, 3, 13, 8, h - 24, F4Menu_Reskin.Colors[11])
		draw.RoundedBox(0, 0, 0, w, h, F4Menu_Reskin.Colors[12])
	end
	CMenu_RoleplayCommands = vgui.Create("DCollapsibleCategory", CMenu_CommandsMain)
	CMenu_RoleplayCommands:SetSize(CMenu_CommandsMain:GetWide(), 100)
	CMenu_RoleplayCommands:SetExpanded(true)
	CMenu_RoleplayCommands:SetLabel("")
	CMenu_RoleplayCommands.PaintOver = function(self, w, h)
		surface.SetDrawColor(F4Menu_Reskin.Colors[1])
		surface.DrawLine(0, 20, w, 20)
		draw.RoundedBox(0, 0, 0, w, 20, F4Menu_Reskin.Colors[13])
		draw.RoundedBox(0, 1, 1, w - 2, 18, F4Menu_Reskin.Colors[14])
		surface.SetDrawColor(F4Menu_Reskin.Colors[16])
		surface.DrawLine(1, 1, w - 2, 1)
		surface.DrawLine(1, 1, 1, 18)
		surface.DrawLine(1, 18, w - 2, 18)
		surface.DrawLine(w - 2, 1, w - 2, 18)
		draw.SimpleText(F4Menu_Reskin.SecondCommandsTitle, "F4Menu_CategoryTitle", 10, 3, color_white, TEXT_ALIGN_LEFT)
	end
	CMenu_RoleplayCommandsList = vgui.Create("DPanelList", CMenu_RoleplayCommands)
	CMenu_RoleplayCommandsList:SetWide(CMenu_CommandsMain:GetWide())
	CMenu_RoleplayCommandsList:SetAutoSize(true)
	CMenu_RoleplayCommandsList:SetPadding(2)
	CMenu_RoleplayCommandsList:SetSpacing(2)
	CMenu_RoleplayCommandsList:SetPos(0, 20)
	CMenu_RoleplayCommandsList:EnableVerticalScrollbar(false)
	CMenu_RoleplayCommandsList.Paint = function(s, w, h)
		draw.RoundedBox(4, 3, 13, 8, h - 24, F4Menu_Reskin.Colors[11])
		draw.RoundedBox(0, 0, 0, w, h, F4Menu_Reskin.Colors[12])
	end
	CMenu_OtherCommands = vgui.Create("DCollapsibleCategory", CMenu_CommandsMain)
	CMenu_OtherCommands:SetSize(CMenu_CommandsMain:GetWide(), 100)
	CMenu_OtherCommands:SetExpanded(true)
	CMenu_OtherCommands:SetLabel("")
	CMenu_OtherCommands.PaintOver = function(self, w, h)
		surface.SetDrawColor(F4Menu_Reskin.Colors[1])
		surface.DrawLine(0, 20, w, 20)
		draw.RoundedBox(0, 0, 0, w, 20, F4Menu_Reskin.Colors[13])
		draw.RoundedBox(0, 1, 1, w - 2, 18, F4Menu_Reskin.Colors[14])
		surface.SetDrawColor(F4Menu_Reskin.Colors[16])
		surface.DrawLine(1, 1, w - 2, 1)
		surface.DrawLine(1, 1, 1, 18)
		surface.DrawLine(1, 18, w - 2, 18)
		surface.DrawLine(w - 2, 1, w - 2, 18)
		draw.SimpleText(F4Menu_Reskin.ThirdCommandsTitle, "F4Menu_CategoryTitle", 10, 3, color_white, TEXT_ALIGN_LEFT)
	end
	CMenu_OtherCommandsList = vgui.Create("DPanelList", CMenu_OtherCommands)
	CMenu_OtherCommandsList:SetWide(CMenu_CommandsMain:GetWide())
	CMenu_OtherCommandsList:SetAutoSize(true)
	CMenu_OtherCommandsList:SetPadding(2)
	CMenu_OtherCommandsList:SetSpacing(2)
	CMenu_OtherCommandsList:SetPos(0, 20)
	CMenu_OtherCommandsList:EnableVerticalScrollbar(false)
	CMenu_OtherCommandsList.Paint = function(s, w, h)
		draw.RoundedBox(4, 3, 13, 8, h - 24, F4Menu_Reskin.Colors[11])
		draw.RoundedBox(0, 0, 0, w, h, F4Menu_Reskin.Colors[12])
	end
	CMenu_CommandsMain:AddItem(CMenu_MoneyCommands)
	CMenu_CommandsMain:AddItem(CMenu_RoleplayCommands)
	CMenu_CommandsMain:AddItem(CMenu_OtherCommands)
	for _,v in ipairs(F4Menu_Reskin.MONEY_BUTTONS) do
		local EconomyButtons = vgui.Create("DButton", CMenu_CommandsMain)
		EconomyButtons:SetSize(CMenu_Commands:GetWide() - 40, 30)
		EconomyButtons:SetText("")
		local name = v.Name
		EconomyButtons.Paint = function(self, w, h)
			local col
			if self:IsHovered() then
				col = F4Menu_Reskin.Colors[5]
			else
				col = F4Menu_Reskin.Colors[6]
			end
			draw.RoundedBox(0, 0, 0, w, h, F4Menu_Reskin.Colors[3])
			draw.RoundedBox(0, 1, 1, w - 2, h - 2, col)
			surface.SetDrawColor(F4Menu_Reskin.Colors[17])
			surface.DrawLine(1, 1, w - 2, 1)
			surface.DrawLine(1, 1, 1, 28)
			surface.DrawLine(1, 28, w - 2, 28)
			surface.DrawLine(w - 2, 1, w - 2, 28)
			draw.SimpleText(name, "F4Menu_ButtonFont", w / 2, 7, color_white, TEXT_ALIGN_CENTER)
		end
		local comm = v.Command
		if comm then
			EconomyButtons:SetTooltip(comm)
		end
		EconomyButtons.DoClick = function()
			v.Function(3)
		end
		CMenu_MoneyCommandsList:AddItem(EconomyButtons)
	end
	for _,v in ipairs(F4Menu_Reskin.RP_BUTTONS) do
		local RoleplayButtons = vgui.Create("DButton", CMenu_CommandsMain)
		RoleplayButtons:SetSize(CMenu_Commands:GetWide() - 40, 30)
		RoleplayButtons:SetText("")
		local name = v.Name
		RoleplayButtons.Paint = function(self, w, h)
			local col
			if self:IsHovered() then
				col = F4Menu_Reskin.Colors[5]
			else
				col = F4Menu_Reskin.Colors[6]
			end
			draw.RoundedBox(0, 0, 0, w, h, F4Menu_Reskin.Colors[3])
			draw.RoundedBox(0, 1, 1, w - 2, h - 2, col)
			surface.SetDrawColor(F4Menu_Reskin.Colors[17])
			surface.DrawLine(1, 1, w - 2, 1)
			surface.DrawLine(1, 1, 1, 28)
			surface.DrawLine(1, 28, w - 2, 28)
			surface.DrawLine(w - 2, 1, w - 2, 28)
			draw.SimpleText(name, "F4Menu_ButtonFont", w / 2, 7, color_white, TEXT_ALIGN_CENTER)
		end
		local comm = v.Command
		if comm then
			RoleplayButtons:SetTooltip(comm)
		end
		RoleplayButtons.DoClick = function()
			v.Function(3)
		end
		CMenu_RoleplayCommandsList:AddItem(RoleplayButtons)
	end
	for _,v in ipairs(F4Menu_Reskin.OTHER_BUTTONS) do
		local OtherButtons = vgui.Create("DButton", CMenu_CommandsMain)
		OtherButtons:SetSize(CMenu_Commands:GetWide() - 40, 30)
		OtherButtons:SetText("")
		local name = v.Name
		OtherButtons.Paint = function(self, w, h)
			local col
			if self:IsHovered() then
				col = F4Menu_Reskin.Colors[5]
			else
				col = F4Menu_Reskin.Colors[6]
			end
			draw.RoundedBox(0, 0, 0, w, h, F4Menu_Reskin.Colors[3])
			draw.RoundedBox(0, 1, 1, w - 2, h - 2, col)
			surface.SetDrawColor(F4Menu_Reskin.Colors[17])
			surface.DrawLine(1, 1, w - 2, 1)
			surface.DrawLine(1, 1, 1, 28)
			surface.DrawLine(1, 28, w - 2, 28)
			surface.DrawLine(w - 2, 1, w - 2, 28)
			draw.SimpleText(name, "F4Menu_ButtonFont", w / 2, 7, color_white, TEXT_ALIGN_CENTER)
		end
		local comm = v.Command
		if comm then
			OtherButtons:SetTooltip(comm)
		end
		OtherButtons.DoClick = function()
			v.Function(3)
		end
		CMenu_OtherCommandsList:AddItem(OtherButtons)
	end
end)