local function AddEntityButton(ent, id, panel, tm)
	if ent.allowed and !table.HasValue(ent.allowed, tm) then return end
	local EntityPanel = vgui.Create("DFrame")
	EntityPanel:SetSize(F4Menu_EntitiesMain:GetWide(), 54)
	EntityPanel:SetTitle("")
	EntityPanel:ShowCloseButton(false)
	EntityPanel:SetDraggable(false)
	EntityPanel.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 0, w, h + 20, F4Menu_Reskin.Colors[1])
		draw.RoundedBox(0, 1, 1, w - 2, h - 2, F4Menu_Reskin.Colors[2])
		local x2, y2 = F4Menu_EntitiesMain:LocalToScreen(0, 0)
		local w2, h2 = F4Menu_EntitiesMain:GetSize()
		render.SetScissorRect(x2, y2, x2 + w2, y2 + h2, true)
		render.SetScissorRect(0, 0, 0, 0, false)
	end
	local Name = vgui.Create("DLabel", EntityPanel)
	Name:SetPos(10, 6)
	Name:SetText(ent.name)
	Name:SetFont("F4Menu_JobFont")
	Name:SetTextColor(color_black)
	Name:SizeToContents()
	local Desc = vgui.Create("DLabel", EntityPanel)
	Desc:SetPos(15, 30)
	Desc:SetSize(EntityPanel:GetWide() - 200, EntityPanel:GetTall())
	Desc:SetTextColor(Color(0, 0, 0, 200))
	Desc:SetWrap(true)
	Desc:SetFont("F4Menu_EntityFont")
	local price = ent.price
	Desc:SetText("Preis: $"..string.Comma(price))
	Desc:SetAutoStretchVertical(true)
	local Max = vgui.Create("DLabel", EntityPanel)
	Max:SetPos(EntityPanel:GetWide() - 240, 36)
	Max:SetSize(EntityPanel:GetWide() - 200, EntityPanel:GetTall())
	Max:SetTextColor(Color(0, 0, 0, 200))
	Max:SetWrap(true)
	Max:SetFont("F4Menu_LimitFont")
	Max:SetText("Max: "..ent.max)
	Max:SetAutoStretchVertical(true)
	local Icon = vgui.Create("SpawnIcon", EntityPanel)
	Icon:SetPos(EntityPanel:GetWide() - 208, 0)
	local model = ent.model
	if istable(model) then
		model = model[math.random(#model)]
	end
	Icon:SetModel(model)
	Icon:SetSize(50, 50)
	Icon:SetMouseInputEnabled(false)
	local ply = LocalPlayer()
	local Blocked = vgui.Create("DPanel", EntityPanel)
	Blocked:SetSize(70, 10)
	Blocked:SetPos(EntityPanel:GetWide() - 217, EntityPanel:GetTall() - 15)

	local blockcheck = CurTime()
	local vip, level
	Blocked.Think = function(self)
		if blockcheck >= CurTime() then return end
		blockcheck = CurTime() + 1

		vip = ent.vip and !MG_VIPGroups[ply:GetUserGroup()]
		level = ent.level and ply:getLevel() < ent.level
	end

	Blocked.Paint = function(self, w, h)
		if vip or level then
			if vip then
				draw.RoundedBox(0, 0, 0, w, h, F4Menu_Reskin.Colors[15])
				draw.SimpleText("VIP", "F4Menu_BuyItemFont", w / 2, h / 2 - 1, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
			else
				draw.RoundedBox(0, 0, 0, w, h, F4Menu_Reskin.Colors[15])
				draw.SimpleText("Level "..ent.level, "F4Menu_BuyItemFont", w / 2, h / 2 - 1, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
			end
		end
	end
	Blocked:SetMouseInputEnabled(false)

	local Buy = vgui.Create("DButton", EntityPanel)
	Buy:SetPos(EntityPanel:GetWide() - 142, 17)
	Buy:SetSize(110, 20)
	Buy:SetText("Artikel kaufen")
	Buy:SetFont("F4Menu_BuyItemFont")
	Buy:SetTextColor(color_white)
	local unavailable
	Buy.Paint = function(self, w, h)
		local col
		local col2 = F4Menu_Reskin.Colors[3]
		local col3 = F4Menu_Reskin.Colors[4]
		if self:IsHovered() then
			col = F4Menu_Reskin.Colors[5]
		else
			col = F4Menu_Reskin.Colors[6]
		end
		if unavailable or !ply:canAfford(price) then
			if self:IsHovered() then
				col = F4Menu_Reskin.Colors[7]
			else
				col = F4Menu_Reskin.Colors[8]
			end
			col2 = F4Menu_Reskin.Colors[9]
			col3 = F4Menu_Reskin.Colors[10]
		end
		draw.RoundedBox(0, 0, 0, w, h, col2)
		draw.RoundedBox(0, 1, 1, w - 2, h - 2, col)
		surface.SetDrawColor(col3)
		surface.DrawLine(1, 1, w - 2, 1)
		surface.DrawLine(1, 1, 1, 18)
		surface.DrawLine(1, 18, w - 2, 18)
		surface.DrawLine(w - 2, 1, w - 2, 18)
	end
	local customCheck = ent.customCheck
	local nextcheck2 = CurTime()
	Buy.Think = function(self, w, h)
		if nextcheck2 >= CurTime() then return end
		nextcheck2 = CurTime() + 0.25
		if customCheck then
			local check = customCheck(ply)
			if check == false then
				if ent.CustomCheckFailMsg then
					self:SetTooltip(ent.CustomCheckFailMsg(ply))
				end
				unavailable = true
			else
				unavailable = false
			end
		else
			self:SetTooltip(nil)
		end
	end
	Buy.DoClick = function()
		RunConsoleCommand("darkrp", ent.cmd)
	end
	panel[id]:AddItem(EntityPanel)
end

function F4Menu_AddRefreshedEntities()
	local scrollbar = false
	local closedcats = {}
	if IsValid(F4Menu_EntitiesMain) then
		scrollbar = F4Menu_EntitiesMain.VBar:GetScroll()
		for k,v in ipairs(F4Menu_EntitiesMain:GetItems()) do
			if !v:GetExpanded() then
				closedcats[k] = true
			end
		end
		F4Menu_EntitiesMain:Remove()
	end
	F4Menu_EntitiesMain = vgui.Create("DPanelList", F4Menu_EntitiesPanel)
	F4Menu_EntitiesMain:SetSize(F4Menu_EntitiesPanel:GetWide(), F4Menu_EntitiesPanel:GetTall())
	F4Menu_EntitiesMain:SetPos(0, 0)
	F4Menu_EntitiesMain:EnableVerticalScrollbar(true)
	F4Menu_EntitiesMain.Paint = function(s, w, h)
		draw.RoundedBox(4, 3, 13, 8, h - 24, F4Menu_Reskin.Colors[11])
		draw.RoundedBox(4, 0, 0, w, h, F4Menu_Reskin.Colors[12])
	end
	F4Menu_EntitiesMain.VBar.Paint = function(s, w, h)
		draw.RoundedBox(4, 3, 13, 8, h - 24, F4Menu_Reskin.Colors[11])
	end
	F4Menu_EntitiesMain.VBar.btnUp.Paint = function(s, w, h)
	end
	F4Menu_EntitiesMain.VBar.btnDown.Paint = function(s, w, h)
	end
	F4Menu_EntitiesMain.VBar.btnGrip.Paint = function(s, w, h)
		draw.RoundedBox(4, 5, 0, 4, h + 22, F4Menu_Reskin.Colors[11])
	end
	local F4Menu_EntityCategories = {}
	local F4Menu_EntityLists = {}
	local cats = DarkRP.getCategories()["entities"]
	local num = 1
	local ply = LocalPlayer()
	local tm = ply:Team()
	for _, data in ipairs(cats) do
		if data["canSee"] and data["canSee"](ply) then
			local members = data["members"]
			if #members > 0 then
				if !F4Menu_EntityCategories[num] then
					for _,v in ipairs(members) do
						local check = v.allowed
						if !check then check = {tm} end
						if table.HasValue(check, tm) then
							break
						end
					end
					F4Menu_EntityCategories[num] = vgui.Create("DCollapsibleCategory", F4Menu_EntitiesMain)
					local entcat = F4Menu_EntityCategories[num]
					entcat:SetSize(F4Menu_EntitiesMain:GetWide(), 100)
					if (closedcats[key] == true) then
						entcat:SetExpanded(false)
					else
						entcat:SetExpanded(true)
					end
					entcat:SetLabel("")
					entcat.PaintOver = function(self, w, h)
						surface.SetDrawColor(F4Menu_Reskin.Colors[1])
						surface.DrawLine(0, 20, w, 20)
						draw.RoundedBox(0, 0, 0, w, 20, F4Menu_Reskin.Colors[13])
						draw.RoundedBox(0, 1, 1, w - 2, 20 - 2, F4Menu_Reskin.Colors[14])
						surface.SetDrawColor(F4Menu_Reskin.Colors[16])
						surface.DrawLine(1, 1, w - 2, 1)
						surface.DrawLine(1, 1, 1, 18)
						surface.DrawLine(1, 18, w - 2, 18)
						surface.DrawLine(w - 2, 1, w - 2, 18)
						draw.SimpleText(data["name"], "F4Menu_CategoryTitle", 10, 3, color_white, TEXT_ALIGN_LEFT)
					end
					F4Menu_EntityLists[num] = vgui.Create("DPanelList", entcat)
					local entlist = F4Menu_EntityLists[num]
					entlist:SetWide(F4Menu_EntitiesMain:GetWide())
					entlist:SetAutoSize(true)
					entlist:SetPadding(2)
					entlist:SetSpacing(0)
					entlist:SetPos(0, 20)
					entlist:EnableVerticalScrollbar(false)
					entlist.Paint = function(s, w, h)
						draw.RoundedBox(4, 3, 13, 8, h - 24, F4Menu_Reskin.Colors[11])
						draw.RoundedBox(0, 0, 0, w, h, F4Menu_Reskin.Colors[12])
					end
					F4Menu_EntitiesMain:AddItem(entcat)
				end
				for k,v in ipairs(members) do
					if !F4Menu_Reskin.ShowNonAvailableEntitiesToAll then
						local hasCheck
						if v.customCheck then
							hasCheck = true
						end
						if hasCheck and v.customCheck(ply) then
							AddEntityButton(v, num, F4Menu_EntityLists, tm)
						elseif !hasCheck then
							AddEntityButton(v, num, F4Menu_EntityLists, tm)
						end
					else
						AddEntityButton(v, num, F4Menu_EntityLists, tm)
					end
				end
				num = num + 1
			end
		end
	end
	for id in pairs(F4Menu_EntityLists) do
		if #F4Menu_EntityLists[id]:GetItems() == 0 then
			F4Menu_EntityCategories[id]:Remove()
			F4Menu_EntityCategories[id] = nil
		end
	end
	if scrollbar then
		F4Menu_EntitiesMain.VBar:AnimateTo(scrollbar, 0, 0, 1)
	end
end

function F4Menu_OpenEntities()
	F4Menu_EntitiesPanel = vgui.Create("DFrame", F4Menu_Main)
	F4Menu_EntitiesPanel:SetSize(F4Menu:GetWide() - 260, F4Menu:GetTall() - 50)
	F4Menu_EntitiesPanel:SetPos(30, 30)
	F4Menu_EntitiesPanel:ShowCloseButton(false)
	F4Menu_EntitiesPanel:SetTitle("")
	F4Menu_EntitiesPanel.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 0, w, h, F4Menu_Reskin.Colors[12])
	end
	F4Menu_AddRefreshedEntities()
	F4Menu_EntitiesPanel:SetVisible(false)
end