local function AddFoodButton(ent)
	local FoodPanel = vgui.Create("DFrame")
	FoodPanel:SetSize(F4Menu_FoodList:GetWide(), 54)
	FoodPanel:SetTitle("")
	FoodPanel:ShowCloseButton(false)
	FoodPanel:SetDraggable(false)
	FoodPanel.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 0, w, h + 20, F4Menu_Reskin.Colors[1])
		draw.RoundedBox(0, 1, 1, w - 2, h - 2, F4Menu_Reskin.Colors[2])
		local x2, y2 = F4Menu_FoodList:LocalToScreen(0, 0)
		local w2, h2 = F4Menu_FoodList:GetSize()
		render.SetScissorRect(x2, y2, x2 + w2, y2 + h2, true)
		render.SetScissorRect(0, 0, 0, 0, false)
	end
	local Name = vgui.Create("DLabel", FoodPanel)
	Name:SetPos(10, 6)
	Name:SetText(ent.name)
	Name:SetFont("F4Menu_JobFont")
	Name:SetTextColor(color_black)
	Name:SizeToContents()
	local Desc = vgui.Create("DLabel", FoodPanel)
	Desc:SetPos(15, 30)
	Desc:SetSize(FoodPanel:GetWide() - 200, FoodPanel:GetTall())
	Desc:SetTextColor(Color(0, 0, 0, 200))
	Desc:SetWrap(true)
	Desc:SetFont("F4Menu_EntityFont")
	local price = ent.price
	Desc:SetText("Preis: $"..string.Comma(price)..", Sättigung: "..ent.energy.."%")
	Desc:SetAutoStretchVertical(true)
	local Icon = vgui.Create("SpawnIcon", FoodPanel)
	Icon:SetPos(FoodPanel:GetWide() - 208, 0)
	local model = ent.model
	if type(model) == "table" then
		model = model[math.random(#model)]
	end
	Icon:SetModel(model)
	Icon:SetSize(50, 50)
	Icon:SetMouseInputEnabled(false)
	local Buy = vgui.Create("DButton", FoodPanel)
	Buy:SetSize(110, 20)
	Buy:SetPos(FoodPanel:GetWide() - 142, 17)
	Buy:SetText("Artikel kaufen")
	Buy:SetFont("F4Menu_BuyItemFont")
	Buy:SetTextColor(color_white)
	local ply = LocalPlayer()
	local unavailable
	Buy.Paint = function(self, w, h)
		local col
		local col2 = F4Menu_Reskin.Colors[3]
		local col3 = F4Menu_Reskin.Colors[4]
		if self:IsHovered() then
			col = F4Menu_Reskin.Colors[5]
		else
			col = F4Menu_Reskin.Colors[6]
		end
		if unavailable or !ply:canAfford(price) then
			if self:IsHovered() then
				col = F4Menu_Reskin.Colors[7]
			else
				col = F4Menu_Reskin.Colors[8]
			end
			col2 = F4Menu_Reskin.Colors[9]
			col3 = F4Menu_Reskin.Colors[10]
		end
		draw.RoundedBox(0, 0, 0, w, h, col2)
		draw.RoundedBox(0, 1, 1, w - 2, h - 2, col)
		surface.SetDrawColor(col3)
		surface.DrawLine(1, 1, w - 2, 1)
		surface.DrawLine(1, 1, 1, 18)
		surface.DrawLine(1, 18, w - 2, 18)
		surface.DrawLine(w - 2, 1, w - 2, 18)
	end
	local customCheck = ent.customCheck
	local nextcheck2 = CurTime()
	Buy.Think = function(self, w, h)
		if nextcheck2 >= CurTime() then return end
		nextcheck2 = CurTime() + 0.25
		if customCheck then
			local check = customCheck(ply)
			if check == false then
				if ent.CustomCheckFailMsg then
					self:SetTooltip(ent.CustomCheckFailMsg(ply))
				end
				unavailable = true
			else
				unavailable = false
			end
		else
			self:SetTooltip(nil)
		end
	end
	Buy.DoClick = function()
		RunConsoleCommand("darkrp", "buyfood", ent.name)
	end
	F4Menu_FoodList:AddItem(FoodPanel)
end

function F4Menu_AddRefreshedFoodItems()
	local scrollbar = false
	if IsValid(F4Menu_FoodMain) then
		scrollbar = F4Menu_FoodMain.VBar:GetScroll()
		F4Menu_FoodMain:Remove()
	end
	F4Menu_FoodMain = vgui.Create("DPanelList", F4Menu_FoodPanel)
	F4Menu_FoodMain:SetSize(F4Menu_FoodPanel:GetWide(), F4Menu_FoodPanel:GetTall())
	F4Menu_FoodMain:SetSpacing(0)
	F4Menu_FoodMain:SetPos(0, 0)
	F4Menu_FoodMain:EnableVerticalScrollbar(true)
	F4Menu_FoodMain.Paint = function(s, w, h)
	end
	F4Menu_FoodMain.VBar.Paint = function(s, w, h)
		draw.RoundedBox(4, 3, 13, 8, h - 24, F4Menu_Reskin.Colors[11])
	end
	F4Menu_FoodMain.VBar.btnUp.Paint = function(s, w, h)
	end
	F4Menu_FoodMain.VBar.btnDown.Paint = function(s, w, h)
	end
	F4Menu_FoodMain.VBar.btnGrip.Paint = function(s, w, h)
		draw.RoundedBox(4, 5, 0, 4, h + 22, F4Menu_Reskin.Colors[11])
	end
	F4Menu_FoodList = vgui.Create("DPanelList", F4Menu_FoodMain)
	F4Menu_FoodList:SetWide(F4Menu_FoodMain:GetWide())
	F4Menu_FoodList:SetAutoSize(true)
	F4Menu_FoodList:SetSpacing(0)
	F4Menu_FoodList:SetPos(0, 20)
	F4Menu_FoodList.Paint = function(s, w, h)
		draw.RoundedBox(4, 3, 13, 8, h - 24, F4Menu_Reskin.Colors[11])
	end
	F4Menu_FoodMain:AddItem(F4Menu_FoodList)
	local ply = LocalPlayer()
	for k,v in pairs(FoodItems) do
		if !F4Menu_Reskin.ShowNonAvailableEntitiesToAll then
			local hasCheck
			if v.customCheck then
				hasCheck = true
			end
			if hasCheck and v.customCheck(ply) then
				AddFoodButton(v, k)
			elseif !hasCheck then
				AddFoodButton(v, k)
			end
		else
			AddFoodButton(v, k)
		end
	end
	if scrollbar then
		F4Menu_FoodMain.VBar:AnimateTo(scrollbar, 0, 0, 1)
	end
end

function F4Menu_OpenFoods()
	if !F4Menu_Reskin.FoodTabEnabled then return end
	F4Menu_FoodPanel = vgui.Create("DFrame", F4Menu_Main)
	F4Menu_FoodPanel:SetSize(F4Menu:GetWide() - 260, F4Menu:GetTall() - 50)
	F4Menu_FoodPanel:SetPos(30, 30)
	F4Menu_FoodPanel:ShowCloseButton(false)
	F4Menu_FoodPanel:SetTitle("")
	F4Menu_FoodPanel.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 0, w, h, F4Menu_Reskin.Colors[12])
	end
	F4Menu_AddRefreshedFoodItems()
	F4Menu_FoodPanel:SetVisible(false)
end