local use_font = system.IsWindows() and "Tahoma" or "Verdana"
surface.CreateFont("F4Menu_CloseFont", {font = use_font, size = 13, weight = 1000, blursize = 0, scanlines = 0, antialias = true})
surface.CreateFont("F4Menu_BuyItemFont", {font = use_font, size = 13, weight = 1000, blursize = 0, scanlines = 0, antialias = true})
surface.CreateFont("F4Menu_SideFont", {font = use_font, size = 21, weight = 550, blursize = 0, scanlines = 0, antialias = true, shadow = true})
surface.CreateFont("F4Menu_BoxTitleFont", {font = use_font, size = 18, weight = 1000, blursize = 0, scanlines = 0, antialias = true})
surface.CreateFont("F4Menu_BoxFont", {font = use_font, size = 13, weight = 1000, blursize = 0, scanlines = 0, antialias = true})
surface.CreateFont("F4Menu_ButtonFont", {font = use_font, size = 16, weight = 1000, blursize = 0, scanlines = 0, antialias = true})
surface.CreateFont("F4Menu_JobFont", {font = use_font, size = 23, weight = 550, blursize = 0, scanlines = 0, antialias = true})
surface.CreateFont("F4Menu_MainFont", {font = use_font, size = 13, weight = 200, blursize = 0, scanlines = 0, antialias = true})
surface.CreateFont("F4Menu_EntityFont", {font = use_font, size = 15, weight = 1000,blursize = 0, scanlines = 0, antialias = true})
surface.CreateFont("F4Menu_CategoryTitle", {font = use_font, size = 13, weight = 1000, blursize = 0, scanlines = 0, antialias = true})
surface.CreateFont("F4Menu_DoorTitleFont", {font = use_font, size = 18, weight = 1000, blursize = 0, scanlines = 0, antialias = true})
surface.CreateFont("F4Menu_QuestionTitleFont", {font = use_font, size = 14, weight = 1000, blursize = 0, scanlines = 0, antialias = true})
surface.CreateFont("F4Menu_QuestionFont", {font = use_font, size = 14, weight = 600, blursize = 0, scanlines = 0, antialias = true})
surface.CreateFont("F4Menu_Y/NFont", {font = use_font, size = 13, weight = 10000, blursize = 0, scanlines = 0, antialias = true})
surface.CreateFont("F4Menu_LimitFont", {font = use_font, size = 12, weight = 300, blursize = 0, scanlines = 0, antialias = true})

local function CloseAllTabs()
	F4Menu_Commands:SetVisible(false)
	F4Menu_JobsPanel:SetVisible(false)
	F4Menu_EntitiesPanel:SetVisible(false)
	F4Menu_WeaponsPanel:SetVisible(false)
	F4Menu_AmmoPanel:SetVisible(false)
	if F4Menu_Reskin.FoodTabEnabled then
		F4Menu_FoodPanel:SetVisible(false)
	end
end

local F4Menu_SelectedPanel
local F4Menu_SideTabs = {}
table.insert(F4Menu_SideTabs, {Title = F4Menu_Reskin.CommandsTabTitle, Function = function()
	F4Menu_SelectedPanel = F4Menu_Reskin.CommandsTabTitle
	CloseAllTabs()
	F4Menu_Commands:SetVisible(true)
end,
ShouldCreate = function(ply)
	return true
end
})

table.insert(F4Menu_SideTabs, {Title = F4Menu_Reskin.JobsTabTitle, Function = function()
	F4Menu_SelectedPanel = F4Menu_Reskin.JobsTabTitle
	CloseAllTabs()
	F4Menu_JobsPanel:SetVisible(true)
end,
ShouldCreate = function(ply)
	return true
end
})

local function CountCategory(ply, cat1, cat2)
	local num = 0
	local tm = ply:Team()
	if cat1 then
		cat1 = DarkRP.getCategories()[cat1]
		for _, data in ipairs(cat1) do
			if data["canSee"] and data["canSee"](ply) then
				local members = data["members"]
				if #members > 0 then
					for _,v in ipairs(members) do
						local check = v.allowed
						if !check then check = {tm} end
						if table.HasValue(check, tm) then
							num = num + 1
						end
					end
				end
			end
		end
	end
	if cat2 then
		cat2 = DarkRP.getCategories()[cat2]
		for _, data in ipairs(cat2) do
			if data["canSee"] and data["canSee"](ply) then
				local members = data["members"]
				if #members > 0 then
					for _,v in ipairs(members) do
						local check = v.allowed
						if !check then check = {tm} end
						if table.HasValue(check, tm) then
							num = num + 1
						end
					end
				end
			end
		end
	end
	return num
end

table.insert(F4Menu_SideTabs, {Title = F4Menu_Reskin.EntitiesTabTitle, Function = function()
	F4Menu_SelectedPanel = F4Menu_Reskin.EntitiesTabTitle
	CloseAllTabs()
	F4Menu_EntitiesPanel:SetVisible(true)
end,
ShouldCreate = function(ply)
	return CountCategory(ply, "entities") > 0
end
})

table.insert(F4Menu_SideTabs, {Title = F4Menu_Reskin.WeaponsTabTitle, Function = function()
	F4Menu_SelectedPanel = F4Menu_Reskin.WeaponsTabTitle
	CloseAllTabs()
	F4Menu_WeaponsPanel:SetVisible(true)
end,
ShouldCreate = function(ply)
	return CountCategory(ply, "weapons", "shipments") > 0
end
})

table.insert(F4Menu_SideTabs, {Title = F4Menu_Reskin.AmmoTabTitle, Function = function()
	F4Menu_SelectedPanel = F4Menu_Reskin.AmmoTabTitle
	CloseAllTabs()
	F4Menu_AmmoPanel:SetVisible(true)
end,
ShouldCreate = function(ply)
	return CountCategory(ply, "ammo") > 0
end
})

table.insert(F4Menu_SideTabs, {Title = F4Menu_Reskin.FoodTabTitle, Function = function()
	F4Menu_SelectedPanel = F4Menu_Reskin.FoodTabTitle
	CloseAllTabs()
	if F4Menu_Reskin.FoodTabEnabled then
		F4Menu_FoodPanel:SetVisible(true)
	end
end,
ShouldCreate = function(ply)
	local tm = RPExtraTeams[LocalPlayer():Team()]
	return (tm and tm.cook == true)
end
})

function F4Menu_AddRefreshedMainElements()
	local ply = LocalPlayer()
	if IsValid(F4Menu_AvatarName) then
		F4Menu_AvatarName:Remove()
	end
	F4Menu_AvatarName = vgui.Create("DLabel", F4Menu_Title)
	F4Menu_AvatarName:SetPos(54, 14)
	F4Menu_AvatarName:SetSize(140, 32)
	F4Menu_AvatarName:SetFont("F4Menu_SideFont")
	F4Menu_AvatarName:SetText(ply:Name())
	F4Menu_AvatarName:SetTextColor(color_white)
	if IsValid(F4Menu_AvatarImage) then
		F4Menu_AvatarImage:Remove()
	end
	F4Menu_AvatarImage = vgui.Create("AvatarImage", F4Menu_Title)
	F4Menu_AvatarImage:SetPos(16, 14)
	F4Menu_AvatarImage:SetSize(32, 32)
	F4Menu_AvatarImage:SetPlayer(ply, 32)
	if IsValid(F4Menu_Sidelist) then
		F4Menu_Sidelist:Remove()
	end
	F4Menu_Sidelist = vgui.Create("DPanelList", F4Menu)
	F4Menu_Sidelist:SetSize(200, F4Menu:GetTall())
	F4Menu_Sidelist:SetPos(1, 63)
	if F4Menu_SelectedPanel then
		local commandstab
		local disallowed
		for _, v in ipairs(F4Menu_SideTabs) do
			local title = v.Title
			if title == F4Menu_Reskin.CommandsTabTitle then
				commandstab = v
			end
			if title == F4Menu_SelectedPanel then
				local should_create = v.ShouldCreate(ply)
				if should_create then
					if v.Function then
						v.Function()
					end
				else
					F4Menu_SelectedPanel = nil
					disallowed = true
				end
				break
			end
		end
		if disallowed and commandstab and commandstab.Function then
			commandstab.Function()
		end
	else
		local commandstab
		for _, v in ipairs(F4Menu_SideTabs) do
			if v.Title == F4Menu_Reskin.CommandsTabTitle then
				commandstab = v
			end
			if commandstab and commandstab.Function then
				commandstab.Function()
				break
			end
		end
	end
	local last_tab
	for k, v in ipairs(F4Menu_SideTabs) do
		if v.ShouldCreate(ply) then
			local title = v.Title
			local SideButton = vgui.Create("DButton", F4Menu_Sidelist)
			SideButton:SetSize(F4Menu_Main:GetWide(), 54)
			SideButton:SetText("")
			SideButton.Paint = function(self, w, h)
				if self:IsHovered() or self.Click then
					draw.RoundedBox(0, 0, 0, w, h, Color(87, 92, 104))
					surface.SetDrawColor(Color(73, 78, 87, 255))
					surface.DrawLine(1, 0, w, 0)
					surface.SetDrawColor(Color(79, 83, 93, 255))
					surface.DrawLine(1, 1, w, 1)
					surface.SetDrawColor(Color(83, 88, 99, 255))
					surface.DrawLine(1, 2, w, 2)
				else
					draw.RoundedBox(0, 0, 0, w, h, Color(80, 84, 96))
					surface.SetDrawColor(Color(92, 98, 109, 255))
					surface.DrawLine(0, 0, 0, 54)
				end
				draw.SimpleText(title, "F4Menu_SideFont", 22, 17, color_white)
				if !self.LastTab then
					surface.SetDrawColor(F4Menu_Reskin.Colors[13])
					surface.DrawLine(0, 53, w, 53)
				end
			end
			SideButton.DoClick = function(self)
				if v.Function then
					for _, v in ipairs(F4Menu_Sidelist:GetItems()) do
						v.Click = nil
					end
					self.Click = true
					v.Function()
				end
			end
			if F4Menu_SelectedPanel and title == F4Menu_SelectedPanel or !F4Menu_SelectedPanel and title == F4Menu_Reskin.CommandsTabTitle then
				SideButton.Click = true
			end
			last_tab = SideButton
			F4Menu_Sidelist:AddItem(SideButton)
		end
	end
	if last_tab then
		for _, v in ipairs(F4Menu_Sidelist:GetItems()) do
			v.LastTab = nil
		end
		last_tab.LastTab = true
	end
	local Space = vgui.Create("Panel", F4Menu_Sidelist)
	Space:SetSize(F4Menu_Main:GetWide(), 24)
	Space:SetPos(0, 224)
	Space.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 0, w, h, Color(60, 63, 71))
		surface.SetDrawColor(F4Menu_Reskin.Colors[13])
		surface.DrawLine(0, 0, w, 0)
		surface.DrawLine(0, h - 1, w, h - 1)
	end
	F4Menu_Sidelist:AddItem(Space)
	for _,v in ipairs(F4Menu_Reskin.WEB_BUTTONS) do
		local SideButton = vgui.Create("DButton", F4Menu_Sidelist)
		SideButton:SetSize(F4Menu_Main:GetWide(), 54)
		SideButton:SetText("")
		SideButton.Paint = function(self, w, h)
			if self:IsHovered() then
				draw.RoundedBox(0, 0, 0, w, h, Color(87, 92, 104))
				surface.SetDrawColor(Color(73, 78, 87, 255))
				surface.DrawLine(1, 0, w, 0)
				surface.SetDrawColor(Color(79, 83, 93, 255))
				surface.DrawLine(1, 1, w, 1)
				surface.SetDrawColor(Color(83, 88, 99, 255))
				surface.DrawLine(1, 2, w, 2)
			else
				draw.RoundedBox(0, 0, 0, w, h, Color(80, 84, 96))
				surface.SetDrawColor(Color(92, 98, 109, 255))
				surface.DrawLine(0, 0, 0, 54)
			end
			draw.SimpleText(v.Title, "F4Menu_SideFont", 22, 17, color_white)
			surface.SetDrawColor(F4Menu_Reskin.Colors[13])
			surface.DrawLine(0, 53, w, 53)
		end
		SideButton.DoClick = function()
			if v.Function then
				v.Function()
			end
		end
		F4Menu_Sidelist:AddItem(SideButton)
	end
end

function F4Menu_CreateMenu()
	local scrw, scrh = ScrW(), ScrH()
	if IsValid(F4Menu) then
		F4Menu:Close()
	end
	F4Menu = vgui.Create("DFrame")
	F4Menu:SetSize(scrw * 0.7, scrh * 0.7)
	F4Menu:Center()
	F4Menu:ShowCloseButton(false)
	F4Menu:SetDraggable(false)
	F4Menu:SetSizable(false)
	F4Menu.btnMaxim:SetVisible(false)
	F4Menu.btnMinim:SetVisible(false)
	F4Menu:MakePopup()
	F4Menu:ParentToHUD()
	F4Menu:SetTitle("")
	F4Menu.Init = function(self)
		self.StartTime = SysTime()
	end
	F4Menu.CreatedTime = SysTime()
	F4Menu.Paint = function(self, w, h)
		Derma_DrawBackgroundBlur(self, self.StartTime)
		if input.IsKeyDown(KEY_F4) then
			if self.ReadyToClose then
				self.ReadyToClose = false
				self:SetVisible(false)
				CloseDermaMenus()
			end
		else
			if !self.ReadyToClose and SysTime() - self.CreatedTime > 0.1 then
				self.ReadyToClose = true
			end
		end
	end
	F4Menu.OnScreenSizeChanged = function(self)
		F4Menu:Remove()
		F4Menu_BuildF4Menu()
	end
	local SideBar = vgui.Create("Panel", F4Menu)
	SideBar:SetPos(0, 0)
	SideBar:SetSize(200, F4Menu:GetTall())
	SideBar.Paint = function(self, w, h)
		draw.RoundedBoxEx(4, 0, 0, w - 1, h - 1, Color(83, 88, 100, 255), false, false, false, false)
		draw.RoundedBoxEx(0, 0, 0, w, h, F4Menu_Reskin.Colors[13], false, false, false, false)
		draw.RoundedBoxEx(4, 1, 224, w - 1, h - 225, Color(83, 88, 100, 255), false, false, false, false)
		surface.SetDrawColor(Color(92, 98, 109, 255))
		surface.DrawLine(1, 224, 1, h - 2)
		surface.DrawLine(1, h - 2, w, h - 2)
	end
	F4Menu_Main = vgui.Create("DFrame", F4Menu)
	F4Menu_Main:SetSize(F4Menu:GetWide() - 200, F4Menu:GetTall())
	F4Menu_Main:SetPos(200, 0)
	F4Menu_Main:ShowCloseButton(false)
	F4Menu_Main:SetDraggable(false)
	F4Menu_Main:SetSizable(false)
	F4Menu_Main:SetTitle("")
	F4Menu_Main.Paint = function(self, w, h)
		draw.RoundedBoxEx(4, 1, 0, w - 1, h - 1, F4Menu_Reskin.Colors[12], false, true, false, true)
		surface.SetDrawColor(Color(61, 65, 73, 255))
		surface.DrawLine(0, 0, 0, h - 2)
		surface.SetDrawColor(Color(168, 170, 171, 255))
		surface.DrawLine(1, 0, 1, h - 2)
		surface.SetDrawColor(Color(181, 183, 184, 255))
		surface.DrawLine(2, 0, 2, h - 2)
		surface.SetDrawColor(Color(191, 193, 194, 255))
		surface.DrawLine(3, 0, 3, h - 2)
		surface.SetDrawColor(Color(199, 201, 203, 255))
		surface.DrawLine(4, 0, 4, h - 2)
		surface.SetDrawColor(Color(169, 171, 177, 255))
		surface.DrawLine(5, 0, 5, h - 2)
	end
	F4Menu_Title = vgui.Create("Panel", SideBar)
	F4Menu_Title:SetPos(1, 1)
	F4Menu_Title:SetSize(SideBar:GetWide(), 62)
	F4Menu_Title.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 0, w, h, Color(64, 69, 78))
		surface.SetDrawColor(F4Menu_Reskin.Colors[16])
		surface.DrawLine(0, 0, 200, 0)
		surface.DrawLine(0, 0, 0, 64)
		surface.SetDrawColor(F4Menu_Reskin.Colors[13])
		surface.DrawLine(0, 61, 200, 61)
	end
	local Close = vgui.Create("DButton", F4Menu_Main)
	Close:SetSize(50, 20)
	Close:SetPos(F4Menu_Main:GetWide() - 60, 0)
	Close:SetText("X")
	Close:SetFont("F4Menu_CloseFont")
	Close:SetTextColor(color_white)
	Close.Paint = function(self, w, h)
		local col
		if self:IsHovered() then
			col = Color(255, 150, 150, 255)
		else
			col = Color(175, 100, 100)
		end
		draw.RoundedBoxEx(0, 0, 0, w, h, Color(255, 150, 150, 255), false, false, true, true)
		draw.RoundedBoxEx(0, 1, 0, w - 2, h - 1, col, false, false, true, true)
	end
	Close.DoClick = function()
		F4Menu.ReadyToClose = false
		F4Menu:SetVisible(false)
		CloseDermaMenus()
		surface.PlaySound("ui/buttonclick.wav")
	end
end

local function ReloadElements(small)
	F4Menu_AddRefreshedMainElements()
	if small then return end
	F4Menu_AddRefreshedCommandsList()
	F4Menu_AddRefreshedJobs()
	F4Menu_AddRefreshedEntities()
	F4Menu_AddRefreshedWeapons()
	F4Menu_AddRefreshedAmmoItems()
	if F4Menu_Reskin.FoodTabEnabled then
		F4Menu_AddRefreshedFoodItems()
	end
end

function F4Menu_BuildF4Menu()
	if !IsValid(F4Menu) then
		F4Menu_CreateMenu()
		F4Menu_OpenCmds()
		F4Menu_OpenJobs()
		F4Menu_OpenEntities()
		F4Menu_OpenWeapons()
		F4Menu_OpenAmmo()
		if F4Menu_Reskin.FoodTabEnabled then
			F4Menu_OpenFoods()
		end
		F4Menu_AddRefreshedMainElements()
	else
		if F4Menu:IsVisible() then
			F4Menu:SetVisible(false)
		else
			F4Menu.ReadyToClose = false
			if F4Menu.NeedsRefresh then
				F4Menu.NeedsRefresh = false
				F4Menu.NeedsSmallRefresh = false
				ReloadElements()
			elseif F4Menu.NeedsSmallRefresh then
				F4Menu.NeedsSmallRefresh = false
				ReloadElements(true)
			end
			F4Menu.CreatedTime = SysTime()
			F4Menu:SetVisible(true)
		end
	end
end

concommand.Add("f4menu_reload", function()
	if IsValid(F4Menu) then
		F4Menu:Remove()
		F4Menu_BuildF4Menu()
	end
end)

concommand.Add("f4menu_refresh", function()
	if IsValid(F4Menu) then
		ReloadElements(true)
	end
end)

local nextcheck = CurTime() + 0.1
local ply, cur_job, cur_name, cur_time
local function F4Menu_Refresh()
	cur_time = CurTime()
	if nextcheck > cur_time then return end
	nextcheck = cur_time + 0.1
	ply = LocalPlayer()
	if !IsValid(F4Menu) or !IsValid(ply) then return end
	local tm = ply:Team()
	local name = ply:Name()
	if (cur_job != tm) then
		if !F4Menu:IsVisible() then
			F4Menu.NeedsRefresh = true
		else
			ReloadElements()
		end
	end
	if (cur_name != name) then
		if !F4Menu:IsVisible() then
			F4Menu.NeedsSmallRefresh = true
		else
			ReloadElements(true)
		end
	end
	cur_job = tm
	cur_name = name
end
hook.Add("Think", "F4Menu_Refresh", F4Menu_Refresh)

timer.Create("F4_F4Menu", 1, 0, function()
	GAMEMODE.ShowSpare2 = F4Menu_BuildF4Menu
end)