local use_font = system.IsWindows() and "Tahoma" or "Verdana"
surface.CreateFont("F4Menu_DoorButton", {font = use_font, size = 16, weight = 1000, blursize = 0, scanlines = 0, antialias = true})

local function F4Menu_AddButtonToFrame(frame)
	frame:SetTall(frame:GetTall() + 45)
	local Button = vgui.Create("DButton", frame)
	Button:SetPos(frame:GetWide() / 2 - 91, frame:GetTall() - 50)
	Button:SetSize(182, 40)
	Button:SetFont("F4Menu_DoorButton")
	Button:SetTextColor(color_white)
	Button.Paint = function(self, w, h)
		local col
		if self:IsHovered() then
			col = F4Menu_Reskin.Colors[5]
		else
			col = F4Menu_Reskin.Colors[6]
		end
		draw.RoundedBox(0, 0, 0, w, h, F4Menu_Reskin.Colors[3])
		draw.RoundedBox(0, 1, 1, w - 2, h - 2, col)
		surface.SetDrawColor(F4Menu_Reskin.Colors[17])
		surface.DrawLine(1, 1, w - 2, 1)
		surface.DrawLine(1, 1, 1, 40)
		surface.DrawLine(1, 38, w - 2, 38)
		surface.DrawLine(w - 2, 1, w - 2, 40)
	end
	return Button
end

local function F4Menu_AdminMenuAdditions(frame, ent, e_type)
	local DisableOwnage = F4Menu_AddButtonToFrame(frame)
	DisableOwnage:SetText(DarkRP.getPhrase(ent:getKeysNonOwnable() and "allow_ownership" or "disallow_ownership"))
	DisableOwnage.DoClick = function()
		if IsValid(frame) then
			frame:Close()
		end
		RunConsoleCommand("darkrp", "toggleownable")
	end
	if ent:getKeysNonOwnable() and e_type then
		local DoorTitle = F4Menu_AddButtonToFrame(frame)
		DoorTitle:SetText(DarkRP.getPhrase("set_x_title", e_type))
		DoorTitle.DoClick = function()
			F4Menu_OpenTextBox("Türtitel setzen", "Wie soll der Titel dieser Tür lauten?", "title", 2)
		end
	else
		local EditGroups = F4Menu_AddButtonToFrame(frame)
		EditGroups:SetText(DarkRP.getPhrase("edit_door_group"))
		EditGroups.DoClick = function()
			local KeyMenu = DermaMenu()
			local Groups = KeyMenu:AddSubMenu(DarkRP.getPhrase("door_groups"))
			local Teams = KeyMenu:AddSubMenu(DarkRP.getPhrase("jobs"))
			local Add = Teams:AddSubMenu(DarkRP.getPhrase("add"))
			local Remove = Teams:AddSubMenu(DarkRP.getPhrase("remove"))
			KeyMenu:AddOption(DarkRP.getPhrase("none"), function()
				RunConsoleCommand("darkrp", "togglegroupownable")
				if IsValid(frame) then
					frame:Close()
				end
			end)
			for k in SortedPairs(RPExtraTeamDoors) do
				Groups:AddOption(k, function()
					RunConsoleCommand("darkrp", "togglegroupownable", k)
					if IsValid(frame) then
						frame:Close()
					end
				end)
			end
			local DoorTeams = ent:getKeysDoorTeams()
			for k,v in SortedPairs(RPExtraTeams) do
				if !DoorTeams or !DoorTeams[k] then
					Add:AddOption(v.name, function()
						RunConsoleCommand("darkrp", "toggleteamownable", k)
						if IsValid(frame) then
							frame:Close()
						end
					end)
				else
					Remove:AddOption(v.name, function()
						RunConsoleCommand("darkrp", "toggleteamownable", k)
						if IsValid(frame) then
							frame:Close()
						end
					end)
				end
			end
			KeyMenu:Open()
		end
	end
end

function F4Menu_F2_KeysMenu()
	local ply = LocalPlayer()
	if ply:InVehicle() then return end
	if IsValid(F2_KeysMenu) then
		F2_KeysMenu:Close()
	end
	local ent = ply:GetEyeTrace().Entity
	if !IsValid(ent) or !ent:isKeysOwnable() or ent:GetPos():DistToSqr(ply:GetPos()) > 40000 then return end
	local e_type = DarkRP.getPhrase(ent:IsVehicle() and "vehicle" or "door")
	F2_KeysMenu = vgui.Create("DFrame")
	F2_KeysMenu:SetSize(200, 52)
	F2_KeysMenu:SetVisible(true)
	F2_KeysMenu:ShowCloseButton(false)
	F2_KeysMenu:MakePopup()
	F2_KeysMenu:ParentToHUD()
	F2_KeysMenu.CreatedTime = SysTime()
	F2_KeysMenu.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 0, w, h, F4Menu_Reskin.Colors[1])
		draw.RoundedBox(0, 1, 1, w - 2, h - 2, F4Menu_Reskin.Colors[2])
		draw.RoundedBox(0, 0, 0, w, 36, F4Menu_Reskin.Colors[14])
		draw.SimpleText(e_type.."-Optionen", "F4Menu_DoorTitleFont", 10, 7, color_white)
		surface.SetDrawColor(F4Menu_Reskin.Colors[16])
		surface.DrawLine(1, 1, w - 1, 1)
		surface.DrawLine(1, 1, 1, 34)
		surface.DrawLine(1, 34, w - 1, 34)
		surface.DrawLine(w - 1, 1, w - 1, 34)
		if input.IsKeyDown(KEY_F2) then
			if self.ReadyToClose then
				self:Close()
				CloseDermaMenus()
			end
		else
			if !self.ReadyToClose and SysTime() - self.CreatedTime > 0.1 then
				self.ReadyToClose = true
			end
		end
	end
	function F2_KeysMenu:Think()
		local ent = ply:GetEyeTrace().Entity
		if !IsValid(ent) or !ent:isKeysOwnable() or ent:GetPos():DistToSqr(ply:GetPos()) > 40000 then
			self:Close()
			CloseDermaMenus()
		end
		if !self.Dragging then return end
		local x = gui.MouseX() - self.Dragging[1]
		local y = gui.MouseY() - self.Dragging[2]
		x = math.Clamp(x, 0, ScrW() - self:GetWide())
		y = math.Clamp(y, 0, ScrH() - self:GetTall())
		self:SetPos(x, y)
	end
	F2_KeysMenu:SetTitle("")
	function F2_KeysMenu:Close()
		self:SetVisible(false)
		self:Remove()
	end
	local Close = vgui.Create("DButton", F2_KeysMenu)
	Close:SetSize(50, 20)
	Close:SetPos(F2_KeysMenu:GetWide() - 60, 0)
	Close:SetText("X")
	Close:SetFont("F4Menu_CloseFont")
	Close:SetTextColor(color_white)
	Close.Paint = function(self, w, h)
		local col
		if self:IsHovered() then
			col = Color(255, 150, 150, 255)
		else
			col = Color(175, 100, 100)
		end
		draw.RoundedBoxEx(0, 0, 0, w, h, Color(255, 150, 150, 255), false, false, true, true)
		draw.RoundedBoxEx(0, 1, 0, w - 2, h - 1, col, false, false, true, true)
	end
	Close.DoClick = function()
		F2_KeysMenu:Close()
	end
	local isowned = ent:isKeysOwnedBy(ply)
	if isowned then
		local SellDoor = F4Menu_AddButtonToFrame(F2_KeysMenu)
		SellDoor:SetText(DarkRP.getPhrase("sell_x", e_type))
		SellDoor.DoClick = function()
			RunConsoleCommand("darkrp", "toggleown")
			F2_KeysMenu:Close()
		end
		local AddOwner = F4Menu_AddButtonToFrame(F2_KeysMenu)
		AddOwner:SetText(DarkRP.getPhrase("add_owner"))
		AddOwner.DoClick = function()
			local KeyMenu = DermaMenu()
			KeyMenu.found = false
			local players = player.GetAll()
			table.sort(players, function(a, b) return a:Name() < b:Name() end)
			for _,v in ipairs(players) do
				if !ent:isKeysOwnedBy(v) and !ent:isKeysAllowedToOwn(v) then
					KeyMenu.found = true
					KeyMenu:AddOption(v:Name(), function()
						if !IsValid(v) then return end
						RunConsoleCommand("darkrp", "ao", v:SteamID())
					end)
				end
			end
			if !KeyMenu.found then
				KeyMenu:AddOption(DarkRP.getPhrase("noone_available"))
			end
			KeyMenu:Open()
		end
		if PartySystem and ply:GetParty() then
			local AddPartyOwner = F4Menu_AddButtonToFrame(F2_KeysMenu)
			AddPartyOwner:SetText("Party hinzufügen")
			AddPartyOwner.DoClick = function()
				RunConsoleCommand("darkrp", "addpartyowner")
			end
		end
		local RemoveOwner = F4Menu_AddButtonToFrame(F2_KeysMenu)
		RemoveOwner:SetText(DarkRP.getPhrase("remove_owner"))
		RemoveOwner.DoClick = function()
			local KeyMenu = DermaMenu()
			local players = player.GetAll()
			table.sort(players, function(a, b) return a:Name() < b:Name() end)
			for _,v in ipairs(players) do
				if (ent:isKeysOwnedBy(v) and !ent:isMasterOwner(v)) or ent:isKeysAllowedToOwn(v) then
					KeyMenu.found = true
					KeyMenu:AddOption(v:Name(), function()
						if !IsValid(v) then return end
						RunConsoleCommand("darkrp", "ro", v:SteamID())
					end)
				end
			end
			if !KeyMenu.found then
				KeyMenu:AddOption(DarkRP.getPhrase("noone_available"), function()
				end)
			end
			KeyMenu:Open()
		end
		if !ent:isMasterOwner(ply) then
			RemoveOwner:SetDisabled(true)
		end
		local ChangeTitle = F4Menu_AddButtonToFrame(F2_KeysMenu)
		ChangeTitle:SetText(DarkRP.getPhrase("set_x_title", e_type))
		ChangeTitle.DoClick = function()
			local format = "dieser Tür"
			if ent:IsVehicle() then
				format = "dieses Autos"
			end
			F4Menu_OpenTextBox(e_type.."titel setzen", "Wie soll der Titel "..format.." lauten?", "title", 2)
		end
	elseif !isowned and !ent:isKeysOwned() and !ent:getKeysNonOwnable() and !ent:getKeysDoorGroup() and !ent:getKeysDoorTeams() then
		if ply:hasDarkRPPrivilege("rp_doorManipulation") then
			local ToggleOwn = F4Menu_AddButtonToFrame(F2_KeysMenu)
			ToggleOwn:SetText(DarkRP.getPhrase("buy_x", e_type))
			ToggleOwn.DoClick = function()
				RunConsoleCommand("darkrp", "toggleown")
				F2_KeysMenu:Close()
			end
			F4Menu_AdminMenuAdditions(F2_KeysMenu, ent, e_type)
		else
			RunConsoleCommand("darkrp", "toggleown")
			F2_KeysMenu:Close()
		end
	elseif !isowned and ent:isKeysAllowedToOwn(ply) then
		if ply:hasDarkRPPrivilege("rp_doorManipulation") then
			local ToggleOwner = F4Menu_AddButtonToFrame(F2_KeysMenu)
			ToggleOwner:SetText(DarkRP.getPhrase("coown_x", e_type))
			ToggleOwner.DoClick = function()
				RunConsoleCommand("darkrp", "toggleown")
				F2_KeysMenu:Close()
			end
			F4Menu_AdminMenuAdditions(F2_KeysMenu, ent, e_type)
		else
			RunConsoleCommand("darkrp", "toggleown")
			F2_KeysMenu:Close()
		end
	elseif ply:hasDarkRPPrivilege("rp_doorManipulation") then
		F4Menu_AdminMenuAdditions(F2_KeysMenu, ent, e_type)
	else
		F2_KeysMenu:Close()
	end
	F2_KeysMenu:Center()
end

timer.Create("F4_KeysMenu", 1, 0, function()
	GAMEMODE.ShowTeam = F4Menu_F2_KeysMenu
end)