hook.Add("loadCustomDarkRPItems", "F4Menu_AddVoting", function()
local QuestionVGUI = {}
local PanelNum = 0
local VoteVGUI = {}
local function MsgDoVote(msg)
	if not IsValid(LocalPlayer()) then return end -- Sent right before player initialisation

	local _, chatY = chat.GetChatBoxPos()

	local question = msg:ReadString()
	local voteid = msg:ReadShort()
	local timeleft = msg:ReadFloat()
	if timeleft == 0 then
		timeleft = 100
	end
	local OldTime = CurTime()

	surface.PlaySound("plats/elevbell1.wav")

	local panel = vgui.Create("DFrame")
	panel:SetPos(5 + PanelNum, chatY - 150)
	panel:SetTitle("")
	panel.Title = DarkRP.getPhrase("vote")
	panel:SetSize(140, 150)
	panel:SetSizable(false)
	panel:ShowCloseButton(false)
	panel:SetDraggable(false)

	function panel:Close()
		PanelNum = PanelNum - 142
		VoteVGUI[voteid .. "vote"] = nil

		local num = 0
		for _, v in SortedPairs(VoteVGUI) do
			v:SetPos(num, chatY - 150)
			num = num + 142
		end

		for _, v in SortedPairs(QuestionVGUI) do
			v:SetPos(num, chatY - 150)
			num = num + 302
		end
		self:Remove()
	end

	function panel:Think()
		self.Title = DarkRP.getPhrase("time", math.Clamp(math.ceil(timeleft - (CurTime() - OldTime)), 0, 9999))
		if timeleft - (CurTime() - OldTime) <= 0 then
			panel:Close()
		end
	end

	function panel:Paint(w, h)
		surface.SetFont("F4Menu_QuestionTitleFont")
		local _, y = surface.GetTextSize("")
		draw.RoundedBox(4, 0, 0, w, h, Color(50, 50, 50, 255))
		draw.RoundedBoxEx(4, 0, 0, w, y + 6, Color(45, 45, 45, 255), true, true, false, false)
		draw.RoundedBox(0, 0, y + 6, w, 1, Color(35, 35, 35, 255))
		draw.DrawText(self.Title, "F4Menu_QuestionTitleFont", 5, 3, color_white)
	end

	panel:SetKeyboardInputEnabled(false)
	panel:SetMouseInputEnabled(true)
	panel:SetVisible(true)

	local Close = vgui.Create("DButton", panel)
	Close:SetSize(32, 16)
	Close:SetPos(panel:GetWide() - 34, 2)
	Close:SetText("X")
	Close:SetFont("F4Menu_QuestionFont")
	Close:SetTextColor(color_white)
	Close.Paint = function(self, w, h)
		local col
		if self:IsHovered() then
			col = Color(255, 100, 100)
		else
			col = Color(200, 50, 50)
		end
		draw.RoundedBox(4, 0, 0, w, h, col)
	end
	Close.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		panel:Close()
	end

	local label = vgui.Create("DLabel")
	label:SetParent(panel)
	label:SetPos(5, 25)
	label:SetFont("F4Menu_QuestionFont")
	label:SetText(DarkRP.textWrap(DarkRP.deLocalise(question), "F4Menu_QuestionFont", 130))
	label:SizeToContents()
	label:SetVisible(true)

	local nextHeight = label:GetTall() > 78 and label:GetTall() - 78 or 0 -- Make panel taller for divider and buttons
	panel:SetTall(panel:GetTall() + nextHeight)

	local divider = vgui.Create("Divider")
	divider:SetParent(panel)
	divider:SetPos(2, panel:GetTall() - 30)
	divider:SetSize(180, 2)
	divider:SetVisible(true)

	local ybutton = vgui.Create("Button")
	ybutton:SetParent(panel)
	ybutton:SetPos(25, panel:GetTall() - 25)
	ybutton:SetSize(40, 20)
	ybutton:SetCommand("!")
	ybutton:SetFont("F4Menu_QuestionFont")
	ybutton:SetText(DarkRP.getPhrase("yes"))
	ybutton:SetVisible(true)
	ybutton.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		LocalPlayer():ConCommand("vote " .. voteid .. " yea\n")
		panel:Close()
	end
	ybutton.Paint = function(self, w, h)
		draw.RoundedBox(4, 0, 0, w, h, Color(35, 35, 35, 250))
		if self:IsHovered() then
			if self:IsDown() then
				self:SetTextColor(Color(150, 150, 150, 200))
			else
				self:SetTextColor(Color(200, 200, 200, 200))
			end
		else
			self:SetTextColor(Color(255, 255, 255, 200))
		end
	end

	local nbutton = vgui.Create("Button")
	nbutton:SetParent(panel)
	nbutton:SetPos(70, panel:GetTall() - 25)
	nbutton:SetSize(40, 20)
	nbutton:SetCommand("!")
	nbutton:SetFont("F4Menu_QuestionFont")
	nbutton:SetText(DarkRP.getPhrase("no"))
	nbutton:SetVisible(true)
	nbutton.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		LocalPlayer():ConCommand("vote " .. voteid .. " nay\n")
		panel:Close()
	end
	nbutton.Paint = function(self, w, h)
		draw.RoundedBox(4, 0, 0, w, h, Color(35, 35, 35, 250))
		if self:IsHovered() then
			if self:IsDown() then
				self:SetTextColor(Color(150, 150, 150, 200))
			else
				self:SetTextColor(Color(200, 200, 200, 200))
			end
		else
			self:SetTextColor(Color(255, 255, 255, 200))
		end
	end

	PanelNum = PanelNum + 142
	VoteVGUI[voteid .. "vote"] = panel
end
usermessage.Hook("DoVote", MsgDoVote)

local function KillVoteVGUI(msg)
	local id = msg:ReadShort()

	if VoteVGUI[id .. "vote"] and VoteVGUI[id .. "vote"]:IsValid() then
		VoteVGUI[id .. "vote"]:Close()
	end
end
usermessage.Hook("KillVoteVGUI", KillVoteVGUI)

local function MsgDoQuestion(msg)
	if not IsValid(LocalPlayer()) then return end

	local _, chatY = chat.GetChatBoxPos()

	local question = msg:ReadString()
	local quesid = msg:ReadString()
	local timeleft = msg:ReadFloat()
	if timeleft == 0 then
		timeleft = 100
	end
	local OldTime = CurTime()
	
	surface.PlaySound("plats/elevbell1.wav")

	local panel = vgui.Create("DFrame")
	panel:SetPos(5 + PanelNum, chatY - 150) -- Times 142 because if the question is the second screen, the first screen is always a vote screen.
	panel:SetTitle("")
	panel.Title = DarkRP.getPhrase("vote")
	panel:SetSize(300, 130)
	panel:SetSizable(false)
	panel:ShowCloseButton(false)
	panel:SetKeyboardInputEnabled(false)
	panel:SetMouseInputEnabled(true)
	panel:SetVisible(true)

	function panel:Close()
		PanelNum = PanelNum - 302
		QuestionVGUI[quesid .. "ques"] = nil
		local num = 0
		for _, v in SortedPairs(VoteVGUI) do
			v:SetPos(num, chatY - 150)
			num = num + 142
		end

		for _, v in SortedPairs(QuestionVGUI) do
			v:SetPos(num, chatY - 150)
			num = num + 302
		end

		self:Remove()
	end

	function panel:Think()
		self.Title = DarkRP.getPhrase("time", math.Clamp(math.ceil(timeleft - (CurTime() - OldTime)), 0, 9999))
		if timeleft - (CurTime() - OldTime) <= 0 then
			panel:Close()
		end
	end

	function panel:Paint(w, h)
		surface.SetFont("F4Menu_QuestionTitleFont")
		local _, y = surface.GetTextSize("")
		draw.RoundedBox(4, 0, 0, w, h, Color(50, 50, 50, 255))
		draw.RoundedBoxEx(4, 0, 0, w, y + 6, Color(45, 45, 45, 255), true, true, false, false)
		draw.RoundedBox(0, 0, y + 6, w, 1, Color(35, 35, 35, 255))
		draw.DrawText(self.Title, "F4Menu_QuestionTitleFont", 5, 3, color_white)
	end

	local label = vgui.Create("DLabel")
	label:SetParent(panel)
	label:SetPos(5, 25)
	label:SetFont("F4Menu_QuestionFont")
	label:SetText(DarkRP.textWrap(DarkRP.deLocalise(question), "F4Menu_QuestionFont", 290))
	label:SizeToContents()
	label:SetVisible(true)

	local divider = vgui.Create("Divider")
	divider:SetParent(panel)
	divider:SetPos(2, 80)
	divider:SetSize(380, 2)
	divider:SetVisible(true)

	local ybutton = vgui.Create("DButton")
	ybutton:SetParent(panel)
	ybutton:SetPos(105, 100)
	ybutton:SetSize(40, 20)
	ybutton:SetText(DarkRP.getPhrase("yes"))
	ybutton:SetVisible(true)
	ybutton.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		LocalPlayer():ConCommand("ans " .. quesid .. " 1\n")
		panel:Close()
	end
	ybutton.Paint = function(self, w, h)
		draw.RoundedBox(4, 0, 0, w, h, Color(35, 35, 35, 250))
		if self:IsHovered() then
			if self:IsDown() then
				self:SetTextColor(Color(150, 150, 150, 200))
			else
				self:SetTextColor(Color(200, 200, 200, 200))
			end
		else
			self:SetTextColor(Color(255, 255, 255, 200))
		end
	end

	local nbutton = vgui.Create("DButton")
	nbutton:SetParent(panel)
	nbutton:SetPos(155, 100)
	nbutton:SetSize(40, 20)
	nbutton:SetText(DarkRP.getPhrase("no"))
	nbutton:SetVisible(true)
	nbutton.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		LocalPlayer():ConCommand("ans " .. quesid .. " 2\n")
		panel:Close()
	end
	nbutton.Paint = function(self, w, h)
		draw.RoundedBox(4, 0, 0, w, h, Color(35, 35, 35, 250))
		if self:IsHovered() then
			if self:IsDown() then
				self:SetTextColor(Color(150, 150, 150, 200))
			else
				self:SetTextColor(Color(200, 200, 200, 200))
			end
		else
			self:SetTextColor(Color(255, 255, 255, 200))
		end
	end

	PanelNum = PanelNum + 302
	QuestionVGUI[quesid .. "ques"] = panel
end
usermessage.Hook("DoQuestion", MsgDoQuestion)

local function KillQuestionVGUI(msg)
	local id = msg:ReadString()

	if QuestionVGUI[id .. "ques"] and QuestionVGUI[id .. "ques"]:IsValid() then
		QuestionVGUI[id .. "ques"]:Close()
	end
end
usermessage.Hook("KillQuestionVGUI", KillQuestionVGUI)

local function DoVoteAnswerQuestion(ply, cmd, args)
	if not args[1] then return end

	local vote = 0
	if tonumber(args[1]) == 1 or string.lower(args[1]) == "yes" or string.lower(args[1]) == "true" then vote = 1 end

	for k, v in pairs(VoteVGUI) do
		if IsValid(v) then
			local ID = string.sub(k, 1, -5)
			VoteVGUI[k]:Close()
			RunConsoleCommand("vote", ID, vote)
			return
		end
	end

	for k, v in pairs(QuestionVGUI) do
		if IsValid(v) then
			local ID = string.sub(k, 1, -5)
			QuestionVGUI[k]:Close()
			RunConsoleCommand("ans", ID, vote)
			return
		end
	end
end
concommand.Add("rp_vote", DoVoteAnswerQuestion)
end)