local function AddWeaponButton(ent, panel, tm)
	if ent.allowed and !table.HasValue(ent.allowed, tm) then return end
	local WeaponPanel = vgui.Create("DFrame")
	WeaponPanel:SetSize(F4Menu_WeaponsMain:GetWide(), 54)
	WeaponPanel:SetTitle("")
	WeaponPanel:ShowCloseButton(false)
	WeaponPanel:SetDraggable(false)
	WeaponPanel.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 0, w, h + 20, F4Menu_Reskin.Colors[1])
		draw.RoundedBox(0, 1, 1, w - 2, h - 2, F4Menu_Reskin.Colors[2])
		local x2, y2 = F4Menu_WeaponsMain:LocalToScreen(0, 0)
		local w2, h2 = F4Menu_WeaponsMain:GetSize()
		render.SetScissorRect(x2, y2, x2 + w2, y2 + h2, true)
		render.SetScissorRect(0, 0, 0, 0, false)
	end
	local noship = ent.noship
	local seperate = ent.seperate
	local ent_name = ent.name
	local Name = vgui.Create("DLabel", WeaponPanel)
	Name:SetPos(10, 6)
	Name:SetText(ent_name)
	Name:SetFont("F4Menu_JobFont")
	Name:SetTextColor(color_black)
	Name:SizeToContents()
	local Desc = vgui.Create("DLabel", WeaponPanel)
	Desc:SetPos(15, 30)
	Desc:SetSize(WeaponPanel:GetWide() - 200, WeaponPanel:GetTall())
	Desc:SetTextColor(Color(0, 0, 0, 200))
	Desc:SetWrap(true)
	Desc:SetFont("F4Menu_EntityFont")
	local price = ent.price
	local price_sep = ent.pricesep
	if !noship and seperate then
		Desc:SetText("Shipment (x3): $"..string.Comma(price)..", Einzelnt: $"..string.Comma(price_sep))
	else
		Desc:SetText("Preis: $"..string.Comma(price_sep))
	end
	Desc:SetAutoStretchVertical(true)
	local Icon = vgui.Create("SpawnIcon", WeaponPanel)
	Icon:SetPos(WeaponPanel:GetWide() - 208, 0)
	local model = ent.model
	if istable(model) then
		model = model[math.random(#model)]
	end
	Icon:SetModel(model)
	Icon:SetSize(50, 50)
	local wep = weapons.GetStored(ent.entity)
	if wep then
		local primary = wep.Primary
		local dmg = primary and primary.Damage and primary.Damage >= 0 and math.ceil(primary.Damage * (primary.NumShots or 1)) or "N/A"
		local clip = primary and primary.ClipSize and primary.ClipSize >= 0 and primary.ClipSize or "N/A"
		local automatic = primary and primary.Automatic and "Ja" or "Nein"
		local rpm = primary and primary.RPM or "N/A"
		local spread = primary and primary.Spread or "N/A"
		local recoil = primary and primary.KickUp or "N/A"
		local ammo = primary and primary.Ammo and language.GetPhrase(primary.Ammo.."_ammo") != primary.Ammo.."_ammo" and language.GetPhrase(primary.Ammo.."_ammo") or "N/A"
		Icon:SetTooltip("-> Waffen-Statistiken <-\nSchaden: "..dmg.."\nMagazin: "..clip.."\nAutomatisch: "..automatic.."\nRPM: "..rpm.."\nPräzision: "..spread.."\nRückstoß: "..recoil.."\nMunition: "..ammo.."\nTyp: "..(MG_IsExplosive(wep.ClassName) and "Explosiv" or MG_IsMelee(wep.ClassName) and "Nahkampf" or MG_IsLight(wep.Category) and "Leicht" or MG_IsHeavy(wep.Category) and "Schwer" or "Spezial"))
	else
		Icon:SetMouseInputEnabled(false)
	end
	local ply = LocalPlayer()
	local Blocked = vgui.Create("DPanel", WeaponPanel)
	Blocked:SetSize(70, 10)
	Blocked:SetPos(WeaponPanel:GetWide() - 217, WeaponPanel:GetTall() - 15)

	local blockcheck = CurTime()
	local vip, level
	Blocked.Think = function(self)
		if blockcheck >= CurTime() then return end
		blockcheck = CurTime() + 1

		vip = ent.vip and !MG_VIPGroups[ply:GetUserGroup()]
		level = ent.level and ply:getLevel() < ent.level
	end

	Blocked.Paint = function(self, w, h)
		if vip or level then
			if vip then
				draw.RoundedBox(0, 0, 0, w, h, F4Menu_Reskin.Colors[15])
				draw.SimpleText("VIP", "F4Menu_BuyItemFont", w / 2, h / 2 - 1, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
			else
				draw.RoundedBox(0, 0, 0, w, h, F4Menu_Reskin.Colors[15])
				draw.SimpleText("Level "..ent.level, "F4Menu_BuyItemFont", w / 2, h / 2 - 1, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
			end
		end
	end
	Blocked:SetMouseInputEnabled(false)

	local Buy = vgui.Create("DButton", WeaponPanel)
	Buy:SetSize(110, 20)
	if !noship and seperate then
		Buy:SetPos(WeaponPanel:GetWide() - 142, 6)
		Buy:SetText("Shipment kaufen")
	else
		Buy:SetPos(WeaponPanel:GetWide() - 142, 17)
		Buy:SetText("Artikel kaufen")
	end
	Buy:SetFont("F4Menu_BuyItemFont")
	Buy:SetTextColor(color_white)
	local unavailable
	Buy.Paint = function(self, w, h)
		local col
		local col2 = F4Menu_Reskin.Colors[3]
		local col3 = F4Menu_Reskin.Colors[4]
		if self:IsHovered() then
			col = F4Menu_Reskin.Colors[5]
		else
			col = F4Menu_Reskin.Colors[6]
		end
		if unavailable or !ply:canAfford(price) then
			if self:IsHovered() then
				col = F4Menu_Reskin.Colors[7]
			else
				col = F4Menu_Reskin.Colors[8]
			end
			col2 = F4Menu_Reskin.Colors[9]
			col3 = F4Menu_Reskin.Colors[10]
		end
		draw.RoundedBox(0, 0, 0, w, h, col2)
		draw.RoundedBox(0, 1, 1, w - 2, h - 2, col)
		surface.SetDrawColor(col3)
		surface.DrawLine(1, 1, w - 1, 1)
		surface.DrawLine(1, 1, 1, 18)
		surface.DrawLine(1, 18, w - 1, 18)
		surface.DrawLine(w - 2, 1, w - 2, 18)
	end
	local customCheck = ent.customCheck
	local nextcheck2 = CurTime()
	Buy.Think = function(self, w, h)
		if nextcheck2 >= CurTime() then return end
		nextcheck2 = CurTime() + 0.25
		if customCheck then
			local check = customCheck(ply)
			if check == false then
				if ent.CustomCheckFailMsg then
					self:SetTooltip(ent.CustomCheckFailMsg(ply))
				end
				unavailable = true
			else
				unavailable = false
			end
		else
			self:SetTooltip(nil)
		end
	end
	Buy.DoClick = function()
		if !noship then
			RunConsoleCommand("darkrp", "buyshipment", ent_name)
		else
			RunConsoleCommand("darkrp", "buy", ent_name)
		end
	end
	if !noship and seperate then
		local single = vgui.Create("DButton", WeaponPanel)
		single:SetSize(110, 20)
		single:SetPos(WeaponPanel:GetWide() - 142, 28)
		single:SetText("Einzelnt kaufen")
		single:SetFont("F4Menu_BuyItemFont")
		single:SetTextColor(color_white)
		single.Paint = function(self, w, h)
			local col
			local col2 = F4Menu_Reskin.Colors[3]
			local col3 = F4Menu_Reskin.Colors[4]
			if self:IsHovered() then
				col = F4Menu_Reskin.Colors[5]
			else
				col = F4Menu_Reskin.Colors[6]
			end
			if unavailable or !ply:canAfford(price_sep) then
				if self:IsHovered() then
					col = F4Menu_Reskin.Colors[7]
				else
					col = F4Menu_Reskin.Colors[8]
				end
				col2 = F4Menu_Reskin.Colors[9]
				col3 = F4Menu_Reskin.Colors[10]
			end
			draw.RoundedBox(0, 0, 0, w, h, col2)
			draw.RoundedBox(0, 1, 1, w - 2, h - 2, col)
			surface.SetDrawColor(col3)
			surface.DrawLine(1, 1, w - 2, 1)
			surface.DrawLine(1, 1, 1, 18)
			surface.DrawLine(1, 18, w - 2, 18)
			surface.DrawLine(w - 2, 1, w - 2, 18)
		end
		single.DoClick = function()
			RunConsoleCommand("darkrp", "buy", ent.name)
		end
	end
	panel:AddItem(WeaponPanel)
end

function F4Menu_AddRefreshedWeapons()
	local scrollbar = false
	local closedcats = {}
	if IsValid(F4Menu_WeaponsMain) then
		scrollbar = F4Menu_WeaponsMain.VBar:GetScroll()
		for k,v in ipairs(F4Menu_WeaponsMain:GetItems()) do
			if !v:GetExpanded() then
				closedcats[k] = true
			end
		end
		F4Menu_WeaponsMain:Remove()
	end
	F4Menu_WeaponsMain = vgui.Create("DPanelList", F4Menu_WeaponsPanel)
	F4Menu_WeaponsMain:SetSize(F4Menu_WeaponsPanel:GetWide(), F4Menu_WeaponsPanel:GetTall())
	F4Menu_WeaponsMain:SetPos(0, 0)
	F4Menu_WeaponsMain:EnableVerticalScrollbar(true)
	F4Menu_WeaponsMain.Paint = function(s, w, h)
		draw.RoundedBox(4, 3, 13, 8, h - 24, F4Menu_Reskin.Colors[11])
		draw.RoundedBox(4, 0, 0, w, h, F4Menu_Reskin.Colors[12])
	end
	F4Menu_WeaponsMain.VBar.Paint = function(s, w, h)
		draw.RoundedBox(4, 3, 13, 8, h - 24, F4Menu_Reskin.Colors[11])
	end
	F4Menu_WeaponsMain.VBar.btnUp.Paint = function(s, w, h)
	end
	F4Menu_WeaponsMain.VBar.btnDown.Paint = function(s, w, h)
	end
	F4Menu_WeaponsMain.VBar.btnGrip.Paint = function(s, w, h)
		draw.RoundedBox(4, 5, 0, 4, h + 22, F4Menu_Reskin.Colors[11])
	end
	local F4Menu_WeaponCategories = {}
	local F4Menu_WeaponLists = {}
	local cats = DarkRP.getCategories()["weapons"]
	local num = 1
	local ply = LocalPlayer()
	local tm = ply:Team()
	for key,data in pairs(cats) do
		if data["canSee"] and data["canSee"](ply) then
			local members = data["members"]
			if #members > 0 then
				if !F4Menu_WeaponCategories[num] then
					for _,v in pairs(members) do
						local check = v.allowed
						if !check then check = {tm} end
						if table.HasValue(check, tm) then
							break
						end
					end
					F4Menu_WeaponCategories[num] = vgui.Create("DCollapsibleCategory", F4Menu_WeaponsMain)
					local weaponcat = F4Menu_WeaponCategories[num]
					weaponcat:SetSize(F4Menu_WeaponsMain:GetWide(), 100)
					if (closedcats[key] == true) then
						weaponcat:SetExpanded(false)
					else
						weaponcat:SetExpanded(true)
					end
					weaponcat:SetLabel("")
					weaponcat.PaintOver = function(self, w, h)
						surface.SetDrawColor(F4Menu_Reskin.Colors[1])
						surface.DrawLine(0, 20, w, 20)
						draw.RoundedBox(0, 0, 0, w, 20, F4Menu_Reskin.Colors[13])
						draw.RoundedBox(0, 1, 1, w - 2, 20 - 2, F4Menu_Reskin.Colors[14])
						surface.SetDrawColor(F4Menu_Reskin.Colors[16])
						surface.DrawLine(1, 1, w - 2, 1)
						surface.DrawLine(1, 1, 1, 18)
						surface.DrawLine(1, 18, w - 2, 18)
						surface.DrawLine(w - 2, 1, w - 2, 18)
						draw.SimpleText(data["name"], "F4Menu_CategoryTitle", 10, 3, color_white, TEXT_ALIGN_LEFT)
					end
					F4Menu_WeaponLists[num] = vgui.Create("DPanelList", weaponcat)
					local weplist = F4Menu_WeaponLists[num]
					weplist:SetWide(F4Menu_WeaponsMain:GetWide())
					weplist:SetAutoSize(true)
					weplist:SetPadding(2)
					weplist:SetSpacing(0)
					weplist:SetPos(0, 20)
					weplist:EnableVerticalScrollbar(false)
					weplist.Paint = function(s, w, h)
						draw.RoundedBox(4, 3, 13, 8, h - 24, F4Menu_Reskin.Colors[11])
						draw.RoundedBox(0, 0, 0, w, h, F4Menu_Reskin.Colors[12])
					end
					F4Menu_WeaponsMain:AddItem(F4Menu_WeaponCategories[num])
				end
				for _,v in SortedPairsByMemberValue(members, "price", false) do
					if !F4Menu_Reskin.ShowNonAvailableEntitiesToAll then
						local hasCheck
						if v.customCheck then
							hasCheck = true
						end
						if hasCheck and v.customCheck(ply) then
							AddWeaponButton(v, F4Menu_WeaponLists[num], tm)
						elseif !hasCheck then
							AddWeaponButton(v, F4Menu_WeaponLists[num], tm)
						end
					else
						AddWeaponButton(v, F4Menu_WeaponLists[num], tm)
					end
				end
				num = num + 1
			end
		end
	end
	for id in pairs(F4Menu_WeaponLists) do
		if #F4Menu_WeaponLists[id]:GetItems() == 0 then
			F4Menu_WeaponCategories[id]:Remove()
			F4Menu_WeaponCategories[id] = nil
		end
	end
	if scrollbar then
		F4Menu_WeaponsMain.VBar:AnimateTo(scrollbar, 0, 0, 1)
	end
end

function F4Menu_OpenWeapons()
	F4Menu_WeaponsPanel = vgui.Create("DFrame", F4Menu_Main)
	F4Menu_WeaponsPanel:SetSize(F4Menu:GetWide() - 260, F4Menu:GetTall() - 50)
	F4Menu_WeaponsPanel:SetPos(30, 30)
	F4Menu_WeaponsPanel:ShowCloseButton(false)
	F4Menu_WeaponsPanel:SetTitle("")
	F4Menu_WeaponsPanel.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 0, w, h, F4Menu_Reskin.Colors[12])
	end
	F4Menu_AddRefreshedWeapons()
	F4Menu_WeaponsPanel:SetVisible(false)
end