include("shared.lua")

local use_font = system.IsWindows() and "Tahoma" or "Verdana"
surface.CreateFont("FamilySystem_NPC", {font = use_font, size = 45, weight = 1000, blursize = 0, scanlines = 0})

local local_ply, dist
local vector_1 = Vector(0, 0, 1)
function ENT:Draw()
	self:DrawModel()
end

function ENT:DrawTranslucent()
	local_ply = local_ply or LocalPlayer()
	dist = local_ply:EyePos():DistToSqr(self:GetPos())
	if dist > 100000 then return end
	local ang = self:GetAngles()	
	local pos = self:GetPos() + (vector_1 * (self:OBBMaxs().z + 5 + math.sin(SysTime() * 2)))
	ang:RotateAroundAxis(ang:Forward(), 90)
	ang:RotateAroundAxis(ang:Right(), -90)
	ang:RotateAroundAxis(ang:Up(), 0)
	cam.Start3D2D(pos, Angle(0, EyeAngles().y - 90, 90), 0.15)
		draw.SimpleTextOutlined(self.PrintName, "FamilySystem_NPC", 0, -50, Color(55, 200, 220), TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
	cam.End3D2D()
end

surface.CreateFont("FamilySystem_Dialogue", {font = "Roboto", size = 16, weight = 500, antialias = true})

local NPCFrame
net.Receive("FamilySystem_Dialogue", function()
	local npc = net.ReadEntity()
	if !IsValid(npc) or IsValid(NPCFrame) then return end
	NPCFrame = vgui.Create("DFrame")
	NPCFrame:SetSize(500, 250)
	NPCFrame:SetPos(ScrW() / 2 - 250, ScrH() / 1.6)
	NPCFrame:SetDraggable(true)
	NPCFrame:MakePopup()
	NPCFrame:ParentToHUD()
	NPCFrame:ShowCloseButton(false)
	NPCFrame:SetTitle("Familienmenü")
	NPCFrame.Paint = function(panel)
		draw.RoundedBox(0, 0, 0, panel:GetWide(), 25, Color(52, 73, 94))
		draw.RoundedBox(0, 0, 25, panel:GetWide(), panel:GetTall() - 25, Color(226, 226, 226))
	end
	local ply = LocalPlayer()
	NPCFrame.Think = function()
		if !IsValid(npc) or !ply:Alive() or ply:GetPos():DistToSqr(npc:GetPos()) > 62500 then
			NPCFrame:Close()
		end
	end
	local Close = vgui.Create("DButton", NPCFrame)
	Close:SetSize(75, 25)
	Close:SetPos(425,0)
	Close:SetColor(color_white)
	Close:SetText("X")
	Close.Paint = function(slf, w, h)
		if Close:IsHovered() then
			draw.RoundedBox(0, 0, 0, w, h, Color(192, 57, 43))
		else
			draw.RoundedBox(0, 0, 0, w, h, Color(231, 76, 60))
		end
	end
	Close.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		NPCFrame:Close()
	end
	local NPCPanel = vgui.Create("DPanel", NPCFrame)
	NPCPanel:SetSize(488, 155)
	NPCPanel:SetPos(6, 30)
	local DialogueTextLabel = vgui.Create("DLabel", NPCFrame)
	DialogueTextLabel:SizeToContents()
	DialogueTextLabel:SetPos(10, 38)
	DialogueTextLabel:SetColor(Color(50, 50, 50))
	DialogueTextLabel:SetFont("FamilySystem_Dialogue")
	DialogueTextLabel:SetText(FamilySystem_Config.NPCText)
	DialogueTextLabel:SetWrap(true)
	DialogueTextLabel:SetWide(470)
	DialogueTextLabel:SetAutoStretchVertical(true)
	local DialogueButton2 = vgui.Create("DFlatButton", NPCFrame)
	DialogueButton2:SetSize(488, 25)
	DialogueButton2:SetPos(6, 220)
	DialogueButton2:SetText("Ich möchte meine derzeitige Familie verlassen.")
	DialogueButton2.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		Derma_Query("Möchtest du deine Familie wirklich verlassen?", "Familie verlassen.", "Ja", function()
			surface.PlaySound("ui/buttonclick.wav")
			RunConsoleCommand("family_leave")
		end, "Nein")
		NPCFrame:Close()
	end
	local DialogueButton1 = vgui.Create("DFlatButton", NPCFrame)
	DialogueButton1:SetSize(488, 25)
	DialogueButton1:SetPos(6, 190)
	DialogueButton1:SetText("Ich möchte eine neue Familie gründen. (Kosten $"..string.Comma(FamilySystem_Config.CreationPrice)..")")
	DialogueButton1.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		DialogueTextLabel:SetText(FamilySystem_Config.NPCText2)
		DialogueTextLabel:SizeToContents()
		DialogueButton1:Hide()
		local NameText = vgui.Create("DTextEntry", NPCFrame)
		NameText:SetSize(488, 25)
		NameText:SetPos(6, 190)
		NameText:SetText("Familiennamen eintragen")
		NameText.OldMousePressed = NameText.OnMousePressed
		function NameText:OnMousePressed(...)
			self:OldMousePressed(...)
			if (self:GetValue() == "Familiennamen eintragen") then
				self:SetValue("")
			end
		end
		DialogueButton2:SetText("Familie erstellen")
		DialogueButton2:SetState(false)
		DialogueButton2:SetTooltip("Dieser Name ist unzulässig!")
		DialogueButton2:SetDisabled(true)
		NameText:SetFont("FamilySystem_FlatButton")
		NameText.OnTextChanged = function(text)
			local value = NameText:GetValue()
			value = string.TrimRight(value)
			value = string.TrimLeft(value)
			local leng = #value
			if NameText:GetValue() == "Familie erstellen" or leng < FamilySystem_Config.MinNameLength or leng > FamilySystem_Config.MaxNameLength and string.Trim(value) != "" then
				DialogueButton2:SetDisabled(true)
				DialogueButton2:SetState(false)
				DialogueButton2:SetTooltip("Dieser Name ist unzulässig!")
			else
				DialogueButton2:SetDisabled(false)
				DialogueButton2:SetState(true)
				DialogueButton2:SetTooltip("Dieser Name ist akzeptabel!")
			end
		end
		NameText.Paint = function(slf, w, h)
			draw.RoundedBox(0, 0, 0, w, h, color_white)
			surface.SetDrawColor(189, 195, 199, 255)
			surface.DrawOutlinedRect(0, 0, w, h)
			NameText:DrawTextEntryText(Color(52, 73, 94, 255), Color(52, 73, 94, 255), Color(52, 73, 94, 255))
		end
		DialogueButton2.DoClick = function()
			surface.PlaySound("ui/buttonclick.wav")
			net.Start("FamilySystem_CheckName")
				net.WriteEntity(npc)
				net.WriteString(NameText:GetValue())
			net.SendToServer()
		end
		net.Receive("FamilySystem_ReturnCheckName", function()
			if net.ReadBool() then
				NPCFrame:Close()
			else
				Derma_Query("Name wird bereits verwendet!", "Dieser Name wird bereits von einer anderen Familie verwendet!", "Zurück")
			end
		end)
	end
end)