surface.CreateFont("FamilySystem_Marker", {font = "Roboto Cn", size = 18, weight = 1000, antialias = true})
surface.CreateFont("FamilySystem_Marker_Small", {font = "Roboto Cn", size = 16, weight = 400, antialias = true})

local disablechat = CreateClientConVar("cl_family_disablechat", 0, FCVAR_ARCHIVE)
local disablechatranks = CreateClientConVar("cl_family_disablechatranks", 1, FCVAR_ARCHIVE)
local disablemarkers = CreateClientConVar("cl_family_disablemarkers", 0, FCVAR_ARCHIVE)
local minimizemarkers = CreateClientConVar("cl_family_minimizemarkers", 1, FCVAR_ARCHIVE)
local disablechatnotifications = CreateClientConVar("cl_family_disablechatnotifications", 0, FCVAR_ARCHIVE)

FS_FamilyChat = true
FS_FamilyMarkers = true
function FamilySystem.ToggleChat(bool)
	FS_FamilyChat = bool
end

function FamilySystem.ToggleMarkers(bool)
	FS_FamilyMarkers = bool
end

net.Receive("FamilySystem_Chat", function()
	if FS_FamilyChat and !disablechat:GetBool() then
		local ply = net.ReadEntity()
		if !IsValid(ply) then return end
		local rankname = net.ReadString()
		local msg = net.ReadString()
		chat.AddText(Color(59, 174, 218), "(Familie) ", team.GetColor(ply:Team()), ply:Name(), Color(0, 102, 204), (disablechatranks:GetBool() and "" or " ["..rankname.."]"), color_white, ": ", msg)
	end
end)

local FS_Markers = {}

local marker = Material("fsystem/marker.png")

local function IsOnScreen(pos)
	local pos_x = pos.x
	local pos_y = pos.y
	return pos_x > 0 and pos_x < ScrW() and pos_y > 0 and pos_y < ScrH()
end

local function DrawMarkers()
	local ply = LocalPlayer()
	for k, v in pairs(FS_Markers) do
		local time = v["time"]
		local cur_time = CurTime()
		if time <= cur_time then
			FS_Markers[k] = nil
			continue
		end
		local single = v["single"]
		if !single and (!FS_FamilyMarkers or disablemarkers:GetBool()) then return end
		local pos = v["pos"]
		local dist = ply:EyePos():Distance(pos) * 0.0254
		local minimized = minimizemarkers:GetBool()
		local marker_txt = string.Comma(math.Round(dist)).."m"
		local marker_txt2 = "Familien-Marker"
		local name = v["name"]
		local marker_txt3 = minimized and name or single == true and "Nur für dich sichtbar!" or "Erstellt von: "..name
		local marker_txt4 = minimized and string.ToMinutesSeconds(time - cur_time) or "Verschwindet in: "..string.ToMinutesSeconds(time - cur_time)
		surface.SetFont("FamilySystem_Marker")
		local size2 = surface.GetTextSize(marker_txt2)
		surface.SetFont("FamilySystem_Marker_Small")
		local size = surface.GetTextSize(marker_txt)
		local size3 = surface.GetTextSize(marker_txt3)
		local size4 = surface.GetTextSize(marker_txt4)
		local toscreen = pos:ToScreen()
		if IsOnScreen(toscreen) then
			local toscreen_x = toscreen.x
			local toscreen_y = toscreen.y
			local offset = toscreen_x - (size / 2)
			local offset2 = toscreen_x - (size2 / 2)
			local offset3 = toscreen_x - (size3 / 2)
			local offset4 = toscreen_x - (size4 / 2)
			local color = v["color"]
			surface.SetDrawColor(color)
			surface.SetMaterial(marker)
			surface.DrawTexturedRect(toscreen_x - 18, toscreen_y - 12 , 42, 42)
			surface.SetDrawColor(color_white)
			draw.SimpleTextOutlined(marker_txt, "FamilySystem_Marker_Small", offset, toscreen_y + 2, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP, 1, color_black)
			if !minimized then
				draw.SimpleTextOutlined(marker_txt2, "FamilySystem_Marker", offset2, toscreen_y + 30, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP, 1, color_black)
			end
			draw.SimpleTextOutlined(marker_txt3, "FamilySystem_Marker_Small", offset3, minimized and toscreen_y + 25 or toscreen_y + 45, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP, 1, color_black)
			draw.SimpleTextOutlined(marker_txt4, "FamilySystem_Marker_Small", offset4, minimized and toscreen_y + 40 or toscreen_y + 60, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP, 1, color_black)
		end
	end
end

net.Receive("FamilySystem_AddMarker", function()
	local ply = net.ReadEntity()
	if !IsValid(ply) then return end
	local pos = net.ReadVector()
	local length = net.ReadInt(16)
	local color = net.ReadColor()
	local single = net.ReadBool()
	local name = ply:Name()
	if !disablechatnotifications:GetBool() then
		if single then
			chat.AddText(Color(59, 174, 218), "(Familie)", color_white, " Du hast eine Markierung, nur für dich sichtbar, platziert.")
		else
			chat.AddText(Color(59, 174, 218), "(Familie) ", team.GetColor(ply:Team()), name, color_white, " hat eine Markierung platziert.")
		end
	end
	if table.IsEmpty(FS_Markers) then
		hook.Add("HUDPaint", "FamilySystem_DrawMarkers", DrawMarkers)
	end
	FS_Markers = FS_Markers or {}
	FS_Markers[ply:SteamID()] = {["name"] = name, ["pos"] = pos, ["color"] = color, ["single"] = single, ["time"] = CurTime() + length}
end)

net.Receive("FamilySystem_RemoveMarker", function()
	local ply = net.ReadEntity()
	if !IsValid(ply) then return end
	local single = net.ReadBool()
	if !disablechatnotifications:GetBool() then
		if single then
			chat.AddText(Color(59, 174, 218), "(Familie) ", color_white, "Du hast deine private Markierung entfernt.")
		else
			chat.AddText(Color(59, 174, 218), "(Familie) ", team.GetColor(ply:Team()), ply:Name(), color_white, " hat seine Markierung entfernt.")
		end
	end
	FS_Markers = FS_Markers or {}
	FS_Markers[ply:SteamID()] = nil
	if table.IsEmpty(FS_Markers) then
		hook.Remove("HUDPaint", "FamilySystem_DrawMarkers")
	end
end)

net.Receive("FamilySystem_Leave", function()
	FS_FamilyChat = true
	FS_Markers = {}
	hook.Remove("HUDPaint", "FamilySystem_DrawMarkers")
end)