CROPTYPES = {
	{crops = 8, model = "models/props/eryk/farmingmod/bone_crop.mdl", range = {x = {-3, 3}, y = {-3, 3}, z = {10, 40}}, scale = 10},
	{crops = 6, model = "models/props/eryk/farmingmod/bone_crop02.mdl", range = {x = {-10, 10}, y = {-10, 10}, z = {10, 40}}, scale = 10},
	{crops = 4, model = "models/props/eryk/farmingmod/bone_crop03.mdl", range = {x = {-15, 15}, y = {-15, 15}, z = {1, 2}}, scale = 10},
	{crops = 10, model = "models/props/eryk/farmingmod/bone_crop04.mdl", range = {x = {-15, 15}, y = {-15, 15}, z = {40, 65}}, scale = 9}
}

CROPTYPE_NORMAL = 1
CROPTYPE_VINE = 2
CROPTYPE_SMALL = 3
CROPTYPE_TREE = 4

FarmingCFG = {
	NPC_Name = "Cameron",

	MaxPlots = 6,
	MaxSpace = 40,

	MoneyMultiplier = 1,
	SellMultiplier = 0.6,

	Crops = {
		{
			name = "Chiliranke", -- 0.5
			cropname = "Chili",
			seedname = "Chilisamen",
			cropmodel = "models/props/eryk/farmingmod/chili.mdl",
			modelscale = 0.5,
			price = 500, -- Um $100 teurer, weil sonst zu billig
			sellprice = 100 + 30, -- Extrageld für erhöhter Durst
			growth = {10, 12},
			thirst = {2, 4},
			typ = CROPTYPE_VINE,
		},
		{
			name = "Paprikaranke", -- 0.75
			cropname = "Paprika",
			seedname = "Paprikasamen",
			cropmodel = "models/props/eryk/farmingmod/pepper.mdl",
			modelscale = 0.5,
			price = 600,
			sellprice = 150 + 20, -- Extrageld für erhöhter Durst
			growth = {15, 17},
			thirst = {3, 5},
			typ = CROPTYPE_VINE,
		},
		{
			name = "Tomatenranke", -- 1
			cropname = "Tomate",
			seedname = "Tomatensamen",
			cropmodel = "models/props/eryk/farmingmod/tomato.mdl",
			modelscale = 0.5,
			price = 800,
			sellprice = 200,
			growth = {20, 22},
			thirst = {4, 6},
			typ = CROPTYPE_VINE,
		},
		{
			name = "Kiwiranke", -- 1.25
			cropname = "Kiwi",
			seedname = "Kiwisamen",
			cropmodel = "models/props/eryk/farmingmod/kiwi.mdl",
			modelscale = 0.5,
			price = 1000,
			sellprice = 250,
			growth = {25, 27},
			thirst = {5, 7},
			typ = CROPTYPE_VINE,
		},
		{
			name = "Gurkenranke", -- 1.5
			cropname = "Gurke",
			seedname = "Gurkensamen",
			cropmodel = "models/props/eryk/farmingmod/cucumber.mdl",
			modelscale = 0.5,
			price = 1200,
			sellprice = 300,
			growth = {30, 32},
			thirst = {4, 6},
			typ = CROPTYPE_VINE,
		},
		{
			name = "Maiskolben", -- 1.75
			cropname = "Mais",
			seedname = "Maissamen",
			cropmodel = "models/props/eryk/farmingmod/corn.mdl",
			modelscale = 0.5,
			price = 1000,
			sellprice = 350 + 20, -- Extrageld für verringerte Kapazität
			growth = {35, 37},
			thirst = {4, 6},
			typ = CROPTYPE_NORMAL,
		},
		{
			name = "Kartoffelgewächs", -- 1 (1.4 von Tomate)
			cropname = "Kartoffel",
			seedname = "Kartoffelsamen",
			cropmodel = "models/props/eryk/farmingmod/potato.mdl",
			modelscale = 0.5,
			price = 1000, -- Verringerter Preis wegen verringerter Kapazität (1120)
			sellprice = 280 + 30, -- Extrageld für verringerte Kapazität
			growth = {28, 30},
			thirst = {5, 7},
			typ = CROPTYPE_SMALL,
		},
		{
			name = "Zwiebelgewächs", -- 0.75
			cropname = "Zwiebel",
			seedname = "Zwiebelsamen",
			cropmodel = "models/props/eryk/farmingmod/onion.mdl",
			modelscale = 0.5,
			price = 750,
			sellprice = 210 + 30, -- Extrageld für verringerte Kapazität
			growth = {21, 23},
			thirst = {4, 6},
			typ = CROPTYPE_SMALL,
		},
		{
			name = "Knoblauchgewächs", -- 1.25
			cropname = "Knoblauch",
			seedname = "Knoblauchsamen",
			cropmodel = "models/props/eryk/farmingmod/garlic.mdl",
			modelscale = 0.5,
			price = 1250,
			sellprice = 350 + 30, -- Extrageld für verringerte Kapazität
			growth = {35, 37},
			thirst = {4, 6},
			typ = CROPTYPE_SMALL,
		},
		{
			name = "Melonengewächs", -- 1.5
			cropname = "Melone",
			seedname = "Melonensamen",
			cropmodel = "models/props/eryk/farmingmod/melon.mdl",
			modelscale = 0.5,
			price = 1500,
			sellprice = 420 + 30, -- Extrageld für verringerte Kapazität
			growth = {42, 44},
			thirst = {5, 7},
			typ = CROPTYPE_SMALL,
		},
		{
			name = "Kürbisgewächs", -- 1.75
			cropname = "Kürbis",
			seedname = "Kürbissamen",
			cropmodel = "models/props/eryk/farmingmod/gourd.mdl",
			modelscale = 0.5,
			price = 1750,
			sellprice = 490 + 30, -- Extrageld für verringerte Kapazität
			growth = {48, 50},
			thirst = {6, 8},
			typ = CROPTYPE_SMALL,
		},
		{
			name = "Orangenbaum", -- 1 (3 von Tomate)
			cropname = "Orange",
			seedname = "Orangenbaumsamen",
			cropmodel = "models/props/eryk/farmingmod/orange.mdl",
			modelscale = 0.5,
			price = 2400, -- Höhere Kosten, weil Bäume mehr Kapazität haben
			sellprice = 600 - 20, -- Weniger Geld für erhöhte Kapazität
			growth = {60, 62},
			thirst = {8, 10},
			typ = CROPTYPE_TREE,
		},
		{
			name = "Apfelbaum", -- 1.25
			cropname = "Apfel",
			seedname = "Apfelbaumsamen",
			cropmodel = "models/props/eryk/farmingmod/apple.mdl",
			modelscale = 0.5,
			price = 3000,
			sellprice = 700 - 20, -- Weniger Geld für erhöhte Kapazität
			growth = {70, 72},
			thirst = {8, 10},
			typ = CROPTYPE_TREE,
		},
		{
			name = "Pfirsichbaum", -- 1.5
			cropname = "Pfirsich",
			seedname = "Pfirsichbaumsamen",
			cropmodel = "models/props/eryk/farmingmod/peach.mdl",
			modelscale = 0.5,
			price = 3600,
			sellprice = 800 - 20 + 20, -- Weniger Geld für erhöhte Kapazität, Extrageld für verringerter Durst
			growth = {80, 82},
			thirst = {7, 9},
			typ = CROPTYPE_TREE,
		},
		{
			name = "Bananenbaum", -- 1.75
			cropname = "Banane",
			seedname = "Bananenbaumsamen",
			cropmodel = "models/props/cs_italy/bananna.mdl",
			modelscale = 0.5,
			price = 4200,
			sellprice = 1000 - 20 + 30, -- Weniger Geld für erhöhte Kapazität, Extrageld für verringerter Durst
			growth = {100, 102},
			thirst = {6, 8},
			typ = CROPTYPE_TREE,
		},
	},

	ThirstSpeedMult = 0.75,
	MinPriceScale = 0.75,
	MaxPriceScale = 1.25,

	MoneyMult = 0.7,

	GrowingSpeedMult = 0.2,

	JobOnly = true,

	RandomInterval = 600,
}

timer.Simple(0, function()
	FarmingCFG.AllowedJob = TEAM_GARDENER
end)
