ENT.Type = "anim"
ENT.Base = "base_anim"
ENT.PrintName = "Beet"
ENT.Category = "Gärtnerei"
ENT.Spawnable = true
ENT.IsPlant = true
ENT.RenderGroup = RENDERGROUP_BOTH

FarmingAddon = {}

function FarmingAddon.GetPlantName(i)
	if !i or i <= 0 then
		return "Leeres Beet"
	end
	return FarmingCFG.Crops[i].name
end

function FarmingAddon.GetCropName(i)
	if !i or i <= 0 then
		return "Leerer Platz"
	end
	return FarmingCFG.Crops[i].cropname
end

function FarmingAddon.GetSeedName(i)
	if !i or i <= 0 then
		return "Kein Samen"
	end
	return FarmingCFG.Crops[i].seedname
end

function ENT:SetupDataTables()
	self:NetworkVar("Entity", 0, "owning_ent")
	self:NetworkVar("Int", 0, "ID")
	self:NetworkVar("Int", 1, "Water")
	self:NetworkVar("Int", 2, "Size")
	self:NetworkVar("Int", 3, "Size")
	self:NetworkVar("Int", 4, "Crops")
end

function ENT:GetVisualSize()
	return 1 + ((self:GetSize() / 100) * CROPTYPES[FarmingCFG.Crops[self:GetID()].typ].scale)
end

local vector1, vector2 = Vector(-50, -50, 0), Vector(50, 50, 250)
	
FarmingAddon.PlantPlots = {}
function ENT:Initialize()
	if SERVER then
		self:SetModel("models/props/eryk/farmingmod/cropplot.mdl")
		self:PhysicsInit(SOLID_VPHYSICS)
		self:SetMoveType(MOVETYPE_NONE)
		self:SetUseType(SIMPLE_USE)
		self:DrawShadow(false)
		local phys = self:GetPhysicsObject()
		if IsValid(phys) then
			phys:Wake()
		end
		self:SetHealth(150)
		self:SetWater(75)
		self:SetCrops(0)
		self.NextGrow = 0
		local phys = self:GetPhysicsObject()
		if IsValid(phys) then
			phys:EnableMotion(false)
		end
	end
	if CLIENT then
		self:SetRenderBounds(vector1, vector2)
		self.Plant = NULL
		self.Crops = {}
	end
end

function ENT:OnRemove()
	if SERVER then
		local owning_ent = self:Getowning_ent()
		if IsValid(owning_ent) and owning_ent:IsPlayer() and owning_ent.Plants then
			owning_ent.Plants = math.max(0, owning_ent.Plants - 1)
		end
	end
	if CLIENT then
		self:ClearModels()
	end
end

hook.Add(SERVER and "OnEntityCreated" or "NetworkEntityCreated", "FarmingAddon.PlantPlotsTable", function(ent)
	if ent:GetClass() == "plant_plot" then
		FarmingAddon.PlantPlots[ent:EntIndex()] = ent
	end
end)

hook.Add("EntityRemoved", "FarmingAddon.PlantPlotsTable", function(ent)
	FarmingAddon.PlantPlots[ent:EntIndex()] = nil
end)

function ENT:PhysgunPickup(ply)
	return ply:IsAdmin()
end

function ENT:CanTool(ply, trace, mode)
	return mode == "remover" and ply:IsAdmin()
end