 include("shared.lua")

local use_font = system.IsWindows() and "Tahoma" or "Verdana"
surface.CreateFont("Farming_SellContainer", {font = use_font, size = 40, weight = 600, blursize = 0, scanlines = 0, antialias = true})
surface.CreateFont("Farming_SellContainer2", {font = use_font, size = 25, weight = 600, blursize = 0, scanlines = 0, antialias = true})

local ContainerMenu
net.Receive("Farming_OpenMenu", function(len)
	local Container = net.ReadEntity()
	if !IsValid(Container) then return end
	if IsValid(ContainerMenu) then return end
	ContainerMenu = vgui.Create("DFrame")
	ContainerMenu:SetTitle("Verkaufsbehälter")
	ContainerMenu:SetSize(230, 40)
	ContainerMenu:ShowCloseButton(false)
	ContainerMenu:MakePopup()
	ContainerMenu.Paint = function()
		draw.RoundedBox(4, 0, 0, ContainerMenu:GetWide(), ContainerMenu:GetTall(), Color(45, 45, 45, 255))
	end
	ContainerMenu:SetPos(ScrW() / 2 - ContainerMenu:GetWide() / 2, ScrH())
	ContainerMenu:MoveTo(ScrW() / 2 - ContainerMenu:GetWide() / 2, ScrH() / 2 - ContainerMenu:GetTall() / 2, 0.25, 0, 0.5)
	ContainerMenu:ParentToHUD()
	local ply = LocalPlayer()
	ContainerMenu.Think = function()
		if !IsValid(Container) or Container:GetNoDraw() or ply:EyePos():DistToSqr(Container:GetPos()) > 62500 then
			ContainerMenu:Close()
		end
	end
	local Close = vgui.Create("DButton", ContainerMenu)
	Close:SetSize(50, 20)
	Close:SetPos(ContainerMenu:GetWide() - 52, 2)
	Close:SetText("X")
	Close:SetFont("Farming_Close")
	Close:SetTextColor(color_white)
	Close.Paint = function(self, w, h)
		local col
		if self:IsHovered() then
			col = Color(255, 100, 100)
		else
			col = Color(200, 50, 50)
		end
		draw.RoundedBox(4, 0, 0, w, h, col)
	end
	Close.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		ContainerMenu:Remove()
	end
	local time = 0
	if !table.IsEmpty(Container.Crops) then
		for i=1, #FarmingCFG.Crops do
			if Container.Crops[i] and Container.Crops[i] > 0 then
				surface.PlaySound("ui/buttonclick.wav")
				time = time + 23
				ContainerMenu:SetSize(230, 40 + time)
				local RemoveCropButton = vgui.Create("DButton", ContainerMenu)
				RemoveCropButton:SetPos(10, 10 + time)
				RemoveCropButton:SetText(FarmingAddon.GetCropName(i).." (x"..Container.Crops[i]..") entfernen")
				RemoveCropButton:SetSize(210, 20)
				RemoveCropButton.DoClick = function()
					if !IsValid(Container) then return end
					surface.PlaySound("ui/buttonclick.wav")
					if IsValid(ContainerMenu) then
						ContainerMenu:Close()
					end
					local CanDestroy = vgui.Create("DFrame")
					CanDestroy:SetTitle("Bestätigen?")
					CanDestroy:SetSize(270, 85)
					CanDestroy:ShowCloseButton(false)
					CanDestroy:MakePopup()
					CanDestroy.Paint = function()
						draw.RoundedBox(4, 0, 0, CanDestroy:GetWide(), CanDestroy:GetTall(), Color(45, 45, 45, 255))
					end
					CanDestroy:SetPos(ScrW() / 2 - CanDestroy:GetWide() / 2, ScrH())
					CanDestroy:MoveTo(ScrW() / 2 - CanDestroy:GetWide() / 2, ScrH() / 2 - CanDestroy:GetTall() / 2, 0.25, 0, 0.5)
					CanDestroy.Think = function()
						if !IsValid(Container) then
							CanDestroy:Close()
						end
					end
					local Close = vgui.Create("DButton", CanDestroy)
					Close:SetSize(50, 20)
					Close:SetPos(CanDestroy:GetWide() - 52, 2)
					Close:SetText("X")
					Close:SetFont("Farming_Close")
					Close:SetTextColor(color_white)
					Close.Paint = function(self, w, h)
						local col
						if self:IsHovered() then
							col = Color(255, 100, 100)
						else
							col = Color(200, 50, 50)
						end
						draw.RoundedBox(4, 0, 0, w, h, col)
					end
					Close.DoClick = function()
						surface.PlaySound("ui/buttonclick.wav")
						CanDestroy:Remove()
					end
					local Agree_Destroy_Button = vgui.Create("DButton", CanDestroy)
					Agree_Destroy_Button:SetPos(35, 35)
					Agree_Destroy_Button:SetText("Fortfahren")
					Agree_Destroy_Button:SetSize(200, 20)
					Agree_Destroy_Button.DoClick = function()
						if IsValid(Container) then
							net.Start("Farming_Discard")
								net.WriteEntity(Container)
								net.WriteInt(i, 16)
							net.SendToServer()
						end
						if IsValid(CanDestroy) then
							surface.PlaySound("ui/buttonclick.wav")
							CanDestroy:Close()
						end
					end
					local Deny_Destroy_Button = vgui.Create("DButton", CanDestroy)
					Deny_Destroy_Button:SetPos(35, 60)
					Deny_Destroy_Button:SetText("Abbrechen")
					Deny_Destroy_Button:SetSize(200, 20)
					Deny_Destroy_Button.DoClick = function()
						if IsValid(CanDestroy) then
							surface.PlaySound("ui/buttonclick.wav")
							CanDestroy:Close()
						end
					end
				end
			end
		end
	end
end)

function ENT:Draw()
	self:DrawModel()
end

local local_ply, dist
local vector_1 = Vector(0, 0, 1)
function ENT:DrawTranslucent()
	local_ply = local_ply or LocalPlayer()
	dist = local_ply:EyePos():DistToSqr(self:GetPos())
	if dist < 40000 then
		local ang = self:GetAngles()	
		local pos = self:GetPos() + (vector_1 * (self:OBBMaxs().z + 15 + math.sin(SysTime() * 2)))
		ang:RotateAroundAxis(ang:Forward(), 90)
		ang:RotateAroundAxis(ang:Right(), -90)
		ang:RotateAroundAxis(ang:Up(), 0)
		cam.Start3D2D(pos + self:GetForward() * 5 + self:GetRight() * -1, Angle(0, EyeAngles().y - 90, 90), 0.05)
			local Width = 500
			local Height = 180
			local Amt = 0
			local Crops = {}
			for i=1, #FarmingCFG.Crops do
				local num = self.Crops[i]
				if num then
					table.insert(Crops, {FarmingAddon.GetCropName(i).." (x"..num..")", Amt * 25})
					Amt = Amt + 1
				end
			end
			Height = Height + Amt * 25
			draw.RoundedBox(5, -(Width / 2), -(Height / 2), Width, Height, Color(50, 50, 50, 225))
			draw.SimpleTextOutlined("Verkaufsbehälter", "Farming_SellContainer", 0, -(Height / 2 - 3), color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, color_black)
			draw.SimpleTextOutlined("Besitzer: "..(IsValid(self:Getowning_ent()) and self:Getowning_ent():Name() or "Niemand"), "Farming_SellContainer2", 0, -(Height / 2 - 50), color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, color_black)
			local space = self:GetSpace()
			draw.SimpleTextOutlined("Kapazität:", "Farming_SellContainer2", 0, -(Height / 2 - 90), color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, color_black)
			surface.SetDrawColor(200, 200, 200, Alpha)
			surface.DrawRect(-150, -(Height / 2 - 120), 300 * space / FarmingCFG.MaxSpace, 25)
			surface.SetDrawColor(color_white)
			surface.DrawOutlinedRect(-150, -(Height / 2 - 120), 300, 25)
			draw.SimpleTextOutlined(space.." / "..FarmingCFG.MaxSpace, "Farming_SellContainer2", 0, -(Height / 2 - 120), color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, color_black)
			for _, v in ipairs(Crops) do
				draw.SimpleTextOutlined(v[1], "Farming_SellContainer2", 0, -(Height / 2 - 170 - v[2]), color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
			end
		cam.End3D2D()
	end
end

local PrecachedCrops = {}
net.Receive("Farming_SendCrops", function(len)
	local num = net.ReadUInt(32)
	local ent = ents.GetByIndex(num)
	if IsValid(ent) then
		ent.Crops = net.ReadTable()
	else
		PrecachedCrops[num] = net.ReadTable()
	end
end)

net.Receive("Farming_SendCropsSpawn", function(len)
	local size = net.ReadUInt(32)
	for i=1, size do
		local num = net.ReadUInt(32)
		local ent = ents.GetByIndex(num)
		if IsValid(ent) then
			ent.Crops = net.ReadTable()
		else
			PrecachedCrops[num] = net.ReadTable()
		end
	end
end)

function ENT:Initialize()
	local ind = self:EntIndex()
	local crops = PrecachedCrops[ind]
	if crops then
		self.Crops = crops
		PrecachedCrops[ind] = nil
	else
		self.Crops = {}
	end
end