local use_font = system.IsWindowed() and "Calibri" or "Verdana"
surface.CreateFont("MGFinesystem_Font30", {font = use_font, size = 30, antialias = true})
surface.CreateFont("MGFinesystem_Font20", {font = use_font, size = 20, antialias = true})
surface.CreateFont("MGFinesystem_Font20B", {font = use_font, size = 20, weight = 600, antialias = true})
surface.CreateFont("MGFinesystem_Font17B", {font = use_font, size = 17, weight = 600, antialias = true})

function MGFinesystem.OpenIssueMenu(target)
	local targetName = target:Name() or "Unbekannt"
	local base = vgui.Create("DFrame")
	base:SetSize(500, 355)
	base.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 0, w, h, color_white)
		draw.RoundedBox(0, 5, 5, w - 10, h - 10, color_black)
		draw.RoundedBox(0, 10, 10, w - 20, h - 20, color_white)
		draw.SimpleText("STRAFZETTEL", "MGFinesystem_Font30", w * 0.5, 15, color_black, TEXT_ALIGN_CENTER)
	end
	base:SetTitle("")
	base:ShowCloseButton(false)
	base:SetPos(ScrW() - 550, (ScrH() - 405) * 0.5)
	base:MakePopup()
	base:ParentToHUD()
	base.Think = function()
		if !LocalPlayer():Alive() then
			base:Close()
		end
	end

	local contentBase = vgui.Create("DPanel", base)
	contentBase:DockMargin(10, 15, 10, 10)
	contentBase:SetPaintBackground(false)
	contentBase:Dock(FILL)

	local content1 = vgui.Create("DPanel", contentBase)
	content1:DockMargin(0, 10, 0, 0)
	content1:SetTall(40)
	content1:Dock(TOP)
	content1.Paint = function(self, w, h)
		--draw.RoundedBox(0, 0, 0, w, h, Color(173, 165, 165))
		draw.SimpleText("AN:", "MGFinesystem_Font20B", 5, h * 0.5, color_black, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
		draw.RoundedBox(0, 90, 5, w - 100, h - 10, color_black)
		draw.RoundedBox(0, 92, 7, w - 104, h - 14, color_white)
		draw.SimpleText(targetName, "MGFinesystem_Font20", 94, h * 0.5, color_black, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
	end

	local content2 = vgui.Create("DPanel", contentBase)
	content2:DockMargin(0, 10, 0, 0)
	content2:SetTall(40)
	content2:Dock(TOP)
	content2.Paint = function(self, w, h)
		--draw.RoundedBox(0, 0, 0, w, h, Color(173, 165, 165))
		draw.SimpleText("BERUF:", "MGFinesystem_Font20B", 5, h * 0.5, color_black, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
		draw.RoundedBox(0, 90, 5, w - 100, h - 10, color_black)
		draw.RoundedBox(0, 92, 7, w - 104, h - 14, color_white)
		draw.SimpleText(IsValid(target) and team.GetName(target:Team()) or "Unbekannt", "MGFinesystem_Font20", 94, h * 0.5, color_black, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
	end

	local content4 = vgui.Create("DPanel", contentBase)
	content4:DockMargin(0, 10, 0, 0)
	content4:SetTall(40)
	content4:Dock(TOP)
	content4.Paint = function(self, w, h)
		--draw.RoundedBox(0, 0, 0, w, h, Color(173, 165, 165))
		draw.SimpleText("DATUM:", "MGFinesystem_Font20B", 5, h * 0.5, color_black, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
		draw.RoundedBox(0, 90, 5, w - 100, h - 10, color_black)
		draw.RoundedBox(0, 92, 7, w - 104, h - 14, color_white)
		draw.SimpleText(os.date("%H:%M:%S - %d.%m.%Y", os.time()), "MGFinesystem_Font20", 94, h * 0.5, color_black, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
	end

	local content5 = vgui.Create("DPanel", contentBase)
	content5:DockMargin(0, 10, 0, 0)
	content5:SetTall(3)
	content5:Dock(TOP)
	content5.Paint = function(self, w, h)
		draw.RoundedBox(0, 3, 0, w - 6, h, color_black)
	end

	local content6 = vgui.Create("DPanel", contentBase)
	content6:DockMargin(0, 10, 0, 0)
	content6:SetTall(40)
	content6:Dock(TOP)
	content6.Paint = function(self, w, h)
		--draw.RoundedBox(0, 0, 0, w, h, Color(173, 165, 165))
		draw.SimpleText("GRUND:", "MGFinesystem_Font20B", 5, h * 0.5, color_black, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
		draw.RoundedBox(0, 90, 5, w - 100, h - 10, color_black)
		draw.RoundedBox(0, 92, 7, w - 104, h - 14, color_white)
	end
	local reasonCombo = vgui.Create("DComboBox", content6)
	reasonCombo:SetPos(92, 7)
	reasonCombo:SetSize(366, 26)
	reasonCombo:SetValue("Bitte wähle einen Grund aus")
	for k, v in pairs(MGFinesystem.Config.Reasons) do
		reasonCombo:AddChoice(k, v)
	end

	local content7 = vgui.Create("DPanel", contentBase)
	content7:DockMargin(0, 15, 0, 0)
	content7:SetTall(40)
	content7:Dock(TOP)
	content7.Paint = function(self, w, h)
		--draw.RoundedBox(0, 0, 0, w, h, Color(173, 165, 165))
		draw.SimpleText("SUMME:", "MGFinesystem_Font20B", 5, h * 0.5, color_black, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
		draw.RoundedBox(0, 90, 5, w - 100, h - 10, color_black)
		draw.RoundedBox(0, 92, 7, w - 104, h - 14, color_white)
		draw.SimpleText(reasonCombo:GetSelected() and ("$"..string.Comma(select(2, reasonCombo:GetSelected()))) or "", "MGFinesystem_Font20", 94, h * 0.5, color_black, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
	end

	local buttonBase = vgui.Create("DPanel", contentBase)
	buttonBase:Dock(BOTTOM)

	local issueButton = vgui.Create("DButton", buttonBase)
	issueButton:SetPos(0, 0)
	issueButton:SetSize(235, 24)
	issueButton:SetText("")
	issueButton.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 0, w, h, self:IsHovered() and Color(32, 191, 107) or Color(38, 222, 129))
		draw.SimpleText("Ausstellen", "MGFinesystem_Font20", w * 0.5, h * 0.5, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
	end
	issueButton.DoClick = function()
		if !IsValid(target) then
			notification.AddLegacy("Der Spieler nicht online.", 1, 4)
			surface.PlaySound("buttons/lightswitch2.wav")
			return
		elseif !target:Alive() then
			notification.AddLegacy("Der Spieler ist tot.", 1, 4)
			surface.PlaySound("buttons/lightswitch2.wav")
			return
		elseif !LocalPlayer():Alive() then
			notification.AddLegacy("Du musst am Leben sein, um einen Strafzettel ausstellen zu können.", 1, 4)
			surface.PlaySound("buttons/lightswitch2.wav")
			return
		elseif !reasonCombo:GetSelected() then
			notification.AddLegacy("Du musst einen Grund auswählen.", 1, 4)
			surface.PlaySound("buttons/lightswitch2.wav")
			return
		end
		MGFinesystem.IssueFine(target, reasonCombo:GetSelected())
		base:Close()
		surface.PlaySound("ui/buttonclick.wav")
	end

	local closeButton = vgui.Create("DButton", buttonBase)
	closeButton:SetPos(235, 0)
	closeButton:SetSize(235, 24)
	closeButton:SetText("")
	closeButton.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 0, w, h, self:IsHovered() and Color(235, 59, 90) or Color(252, 92, 101))
		draw.SimpleText("Abbrechen", "MGFinesystem_Font20", w * 0.5, h * 0.5, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
	end
	closeButton.DoClick = function()
		base:Close()
		surface.PlaySound("ui/buttonclick.wav")
	end
end

function MGFinesystem.OpenIssuedMenu(actor, reason)
	local actorName = actor:Name() or "Unbekannt"
	local time = os.time()
	local base = vgui.Create("DFrame")
	base:SetSize(500, 410)
	base.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 0, w, h, color_white)
		draw.RoundedBox(0, 5, 5, w - 10, h - 10, color_black)
		draw.RoundedBox(0, 10, 10, w - 20, h - 20, color_white)
		draw.SimpleText("STRAFZETTEL", "MGFinesystem_Font30", w * 0.5, 15, color_black, TEXT_ALIGN_CENTER)
	end
	base:SetTitle("")
	base:ShowCloseButton(false)
	base:SetPos(ScrW() - 550, (ScrH() - 460) * 0.5)
	base:MakePopup()
	base.Think = function()
		if !LocalPlayer():Alive() then
			base:Close()
		end
	end

	local contentBase = vgui.Create("DPanel", base)
	contentBase:DockMargin(10, 15, 10, 10)
	contentBase:SetPaintBackground(false)
	contentBase:Dock(FILL)

	local content1 = vgui.Create("DPanel", contentBase)
	content1:DockMargin(0, 10, 0, 0)
	content1:SetTall(40)
	content1:Dock(TOP)
	content1.Paint = function(self, w, h)
		--draw.RoundedBox(0, 0, 0, w, h, Color(173, 165, 165))
		draw.SimpleText("VON:", "MGFinesystem_Font20B", 5, h * 0.5, color_black, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
		draw.RoundedBox(0, 90, 5, w - 100, h - 10, color_black)
		draw.RoundedBox(0, 92, 7, w - 104, h - 14, color_white)
		draw.SimpleText(actorName, "MGFinesystem_Font20", 94, h * 0.5, color_black, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
	end

	local content2 = vgui.Create("DPanel", contentBase)
	content2:DockMargin(0, 10, 0, 0)
	content2:SetTall(40)
	content2:Dock(TOP)
	content2.Paint = function(self, w, h)
		--draw.RoundedBox(0, 0, 0, w, h, Color(173, 165, 165))
		draw.SimpleText("BERUF:", "MGFinesystem_Font20B", 5, h * 0.5, color_black, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
		draw.RoundedBox(0, 90, 5, w - 100, h - 10, color_black)
		draw.RoundedBox(0, 92, 7, w - 104, h - 14, color_white)
		draw.SimpleText(IsValid(actor) and team.GetName(actor:Team()) or "Unbekannt", "MGFinesystem_Font20", 94, h * 0.5, color_black, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
	end

	local content3 = vgui.Create("DPanel", contentBase)
	content3:DockMargin(0, 10, 0, 0)
	content3:SetTall(40)
	content3:Dock(TOP)
	content3.Paint = function(self, w, h)
		--draw.RoundedBox(0, 0, 0, w, h, Color(173, 165, 165))
		draw.SimpleText("GELD:", "MGFinesystem_Font20B", 5, h * 0.5, color_black, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
		draw.RoundedBox(0, 90, 5, w - 100, h - 10, color_black)
		draw.RoundedBox(0, 92, 7, w - 104, h - 14, color_white)
		draw.SimpleText("$"..string.Comma(LocalPlayer():getDarkRPVar("money")), "MGFinesystem_Font20", 94, h * 0.5, color_black, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
	end

	local content4 = vgui.Create("DPanel", contentBase)
	content4:DockMargin(0, 10, 0, 0)
	content4:SetTall(40)
	content4:Dock(TOP)
	content4.Paint = function(self, w, h)
		--draw.RoundedBox(0, 0, 0, w, h, Color(173, 165, 165))
		draw.SimpleText("DATUM:", "MGFinesystem_Font20B", 5, h * 0.5, color_black, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
		draw.RoundedBox(0, 90, 5, w - 100, h - 10, color_black)
		draw.RoundedBox(0, 92, 7, w - 104, h - 14, color_white)
		draw.SimpleText(os.date("%H:%M:%S - %d.%m.%Y", time), "MGFinesystem_Font20", 94, h * 0.5, color_black, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
	end

	local content5 = vgui.Create("DPanel", contentBase)
	content5:DockMargin(0, 10, 0, 0)
	content5:SetTall(3)
	content5:Dock(TOP)
	content5.Paint = function(self, w, h)
		draw.RoundedBox(0, 3, 0, w - 6, h, color_black)
	end

	local content6 = vgui.Create("DPanel", contentBase)
	content6:DockMargin(0, 10, 0, 0)
	content6:SetTall(40)
	content6:Dock(TOP)
	content6.Paint = function(self, w, h)
		--draw.RoundedBox(0, 0, 0, w, h, Color(173, 165, 165))
		draw.SimpleText("GRUND:", "MGFinesystem_Font20B", 5, h * 0.5, color_black, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
		draw.RoundedBox(0, 90, 5, w - 100, h - 10, color_black)
		draw.RoundedBox(0, 92, 7, w - 104, h - 14, color_white)
		draw.SimpleText(reason, "MGFinesystem_Font20", 94, h * 0.5, color_black, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
	end

	local content7 = vgui.Create("DPanel", contentBase)
	content7:DockMargin(0, 15, 0, 0)
	content7:SetTall(40)
	content7:Dock(TOP)
	content7.Paint = function(self, w, h)
		--draw.RoundedBox(0, 0, 0, w, h, Color(173, 165, 165))
		draw.SimpleText("SUMME:", "MGFinesystem_Font20B", 5, h * 0.5, color_black, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
		draw.RoundedBox(0, 90, 5, w - 100, h - 10, color_black)
		draw.RoundedBox(0, 92, 7, w - 104, h - 14, color_white)
		draw.SimpleText("$"..string.Comma(MGFinesystem.Config.Reasons[reason]), "MGFinesystem_Font20", 94, h * 0.5, color_black, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
	end

	local buttonBase = vgui.Create("DPanel", contentBase)
	buttonBase:Dock(BOTTOM)

	local issueButton = vgui.Create("DButton", buttonBase)
	issueButton:SetPos(0, 0)
	issueButton:SetSize(235, 24)
	issueButton:SetText("")
	issueButton.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 0, w, h, self:IsHovered() and Color(32, 191, 107) or Color(38, 222, 129))
		draw.SimpleText("Bezahlen", "MGFinesystem_Font20", w * 0.5, h * 0.5, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
	end
	issueButton.DoClick = function()
		if !IsValid(actor) then
			notification.AddLegacy("Der Staatsbeamte ist nicht online.", 1, 4)
			surface.PlaySound("buttons/lightswitch2.wav")
			return
		elseif !actor:Alive() then
			notification.AddLegacy("Der Staatsbeamte ist tot.", 1, 4)
			surface.PlaySound("buttons/lightswitch2.wav")
			return
		elseif !LocalPlayer():Alive() then
			notification.AddLegacy("Du musst am Leben sein, um den Strafzettel bezahlen zu können.", 1, 4)
			surface.PlaySound("buttons/lightswitch2.wav")
			return
		elseif LocalPlayer():getDarkRPVar("money") < MGFinesystem.Config.Reasons[reason] then
			notification.AddLegacy("Du hast zu wenig Geld um den Strafzettel zu begleichen.", 1, 4)
			surface.PlaySound("buttons/lightswitch2.wav")
			return
		end
		MGFinesystem.AnswerFine(true)
		base:Close()
		surface.PlaySound("buttons/lightswitch2.wav")
	end

	local closeButton = vgui.Create("DButton", buttonBase)
	closeButton:SetPos(235, 0)
	closeButton:SetSize(235, 24)
	closeButton:SetText("")
	closeButton.Paint = function(self, w, h)
		draw.RoundedBox(0, 0, 0, w, h, self:IsHovered() and Color(235, 59, 90) or Color(252, 92, 101))
		draw.SimpleText("Verwerfen", "MGFinesystem_Font20", w * 0.5, h * 0.5, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
	closeButton.DoClick = function()
		MGFinesystem.AnswerFine(false)
		base:Close()
		surface.PlaySound("buttons/lightswitch2.wav")
	end
	end
end

function MGFinesystem.IssueFine(target, reason)
	net.Start("MGFinesystem_IssueFine")
		net.WriteEntity(target)
		net.WriteString(reason)
	net.SendToServer()
end

function MGFinesystem.AnswerFine(answer)
	net.Start("MGFinesystem_AnswerFine")
		net.WriteBool(answer)
	net.SendToServer()
end

net.Receive("MGFinesystem_SendFine", function()
	MGFinesystem.OpenIssuedMenu(net.ReadEntity(), net.ReadString())
end)