if SERVER then AddCSLuaFile() end
if CLIENT then
	local use_font = system.IsWindows() and "Tahoma" or "Verdana"
	surface.CreateFont("MGFineMenu_Title", {font = use_font, size = 30, weight = 1000, antialias = true})
	surface.CreateFont("MGFineMenu_Close", {font = use_font, size = 20, weight = 1000, antialias = true})
	surface.CreateFont("MGFineMenu_Body", {font = use_font, size = 20, weight = 500, antialias = true})
	SWEP.Slot = 3
	SWEP.SlotPos = 1
	SWEP.DrawAmmo = false
	SWEP.DrawCrosshair = false
end
local blacklist
timer.Simple(0, function() blacklist = MGFinesystem.Config.Blacklist end)

SWEP.Base = "weapon_basekit"
SWEP.PrintName = "Strafzettel"
SWEP.Author = "Modern Gaming"
SWEP.Instructions = "Linksklick, um Strafzettel auszustellen."
SWEP.Spawnable = true
SWEP.UseHands = true
SWEP.ViewModel = Model("models/freeman/c_police_citation.mdl")
SWEP.WorldModel = Model("models/freeman/w_police_citation.mdl")
SWEP.ShowWorldModel = false
SWEP.HoldType = "slam"
SWEP.Primary.Ammo = "none"
SWEP.Secondary.Ammo = "none"
SWEP.Range = 10000

SWEP.WElements = {
	["w_ticketbook"] = {type = "Model", model = "models/freeman/w_police_citation.mdl", bone = "ValveBiped.Bip01_R_Hand", rel = "", pos = Vector(3.635, 4.675, 0), angle = Angle(-17.532, 178, 0), size = Vector(1.34, 1.34, 1.34), color = Color(255, 255, 255, 255), surpresslightning = false, material = "", skin = 0, bodygroup = {}}
}

DEFINE_BASECLASS("weapon_basekit")

function SWEP:SetupDataTables()
	self:NetworkVar("Float", 0, "WritingDown")
	self:NetworkVar("Float", 1, "PullingOut")
end

function SWEP:Initialize()
	self:SetHoldType(self.HoldType)

	return BaseClass.Initialize(self)
end

function SWEP:Deploy()
	self:SetPullingOut(CurTime() + 0.3)
	self:SetWritingDown(0)

	return BaseClass.Deploy(self)
end

function SWEP:PrimaryAttack()
	self:SetNextPrimaryFire(CurTime() + 1)

	local owner = self:GetOwner()

	owner:LagCompensation(true)
	local plytr = owner:GetEyeTrace()
	owner:LagCompensation(false)

	local ent = plytr.Entity

	if !IsValid(ent) or !ent:IsPlayer() or ent:isArrested() or ent:isCP() or ent:IsFrozen() or blacklist[ent:Team()] then return end

	if owner:GetShootPos():DistToSqr(plytr.HitPos) > self.Range then return end

	owner:GetViewModel():SendViewModelMatchingSequence(owner:GetViewModel():LookupSequence("write"))

	if CLIENT and IsFirstTimePredicted() then
		MGFinesystem.OpenIssueMenu(ent)
	end

	self:SetWritingDown(CurTime() + 4.5)
end

function SWEP:SecondaryAttack()
end

function SWEP:DrawHUD()
	local owner = self:GetOwner()

	if owner:InVehicle() and !owner:GetAllowWeaponsInVehicle() then return end

	if !self.Target or self.next_tr < CurTime() then
		self.Target = util.TraceLine(util.GetPlayerTrace(owner))
		self.next_tr = CurTime() + 0.05
	end

	local ent = self.Target.Entity
	local hit = self.Target.HitPos:DistToSqr(owner:GetShootPos()) <= self.Range

	if !hit or !IsValid(ent) or !ent:IsPlayer() then return end

	local scrw, scrh = ScrW() / 2, ScrH() - 110

	draw.SimpleTextOutlined(ent:Name(), "mg_instructions", scrw, scrh, team.GetColor(ent:Team()), TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, color_black)
	if ent:isArrested() then
		draw.SimpleTextOutlined("Diese Person ist in Haft.", "mg_instructions2", scrw, scrh + 25, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, color_black)
		return
	elseif ent:isCP() then 
		draw.SimpleTextOutlined("Diese Person ist Staatsbeamter.", "mg_instructions2", scrw, scrh + 25, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, color_black)
		return
	elseif ent:IsFrozen() or blacklist[ent:Team()] then
		draw.SimpleTextOutlined("Diese Person ist immun gegen Strafzettel.", "mg_instructions2", scrw, scrh + 25, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, color_black)
		return
	end
	draw.SimpleTextOutlined("Linksklick, um Strafzettel auszustellen.", "mg_instructions2", scrw, scrh + 25, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, color_black)
end

if CLIENT then
	SWEP.MoveToPos = vector_origin + Vector(0, 0, 4)
	SWEP.LastMultiX = 0
	SWEP.LastSysTime = 0

	function SWEP:GetViewModelPosition(pos, ang)
		pos = pos - ang:Up() * 6
		pos = pos - (ang:Up() * (24 * math.Clamp(self:GetPullingOut() - CurTime(), 0, 0.3)))

		local writingdown = self:GetWritingDown()
		local sys_time = SysTime()
		local multx
		if writingdown >= CurTime() then
			multx = (self.LastMultiX == 1 and 1) or Lerp((sys_time - self.LastSysTime) * 20, self.LastMultiX, 1)
		else
			multx = (self.LastMultiX == 0 and 0) or Lerp((sys_time - self.LastSysTime) * 20, self.LastMultiX, 0)
		end
		self.LastSysTime = sys_time
		if self.MoveToPos then
			local Offset = self.MoveToPos
			pos = pos + Offset.x * ang:Right() * multx
			pos = pos + Offset.y * ang:Forward() * multx
			pos = pos + Offset.z * ang:Up() * multx
			self.LastMultiX = multx
		end
		return pos, ang
	end
end