ENT.Type = "anim"
ENT.RenderGroup = RENDERGROUP_BOTH

ENT.PrintName = "Lager"

ENT.Spawnable = true
ENT.Category = "Mapobjekte"

function ENT:PhysgunPickup(ply)
	return !GetConVar("mg_movemode") or GetConVar("mg_movemode"):GetInt() > 1 and ply:IsAdmin() or GetConVar("mg_movemode") and GetConVar("mg_movemode"):GetInt() > 0 and ply:IsSuperAdmin()
end

function ENT:CanTool(ply, trace, mode)
	return !GetConVar("mg_movemode") or GetConVar("mg_movemode"):GetInt() > 1 and ply:IsAdmin() or GetConVar("mg_movemode") and GetConVar("mg_movemode"):GetInt() > 0 and ply:IsSuperAdmin()
end

if SERVER then
	AddCSLuaFile()

	function ENT:Initialize()
		self:SetModel("models/props/de_prodigy/ammo_can_03.mdl")
		self:PhysicsInit(SOLID_VPHYSICS)
		self:SetMoveType(MOVETYPE_VPHYSICS)
		self:SetSolid(SOLID_VPHYSICS)
		self:SetUseType(SIMPLE_USE)
		local phys = self:GetPhysicsObject()
		if IsValid(phys) then
			phys:EnableMotion(false)
		end
	end

	function ENT:Use(ply)
		if !ply:IsPlayer() or !ply.Bank then return end
		if ((ply.UsedBank or 0) > CurTime()) then return end
		ply.UsedBank = CurTime() + 0.25
		ply.Bank:Sync()
		ply:OpenContainer(ply.Bank:GetID(), itemstore.Translate("bank"))
	end

	concommand.Add("inventory_save", function(ply, cmd, args)
		if !IsValid(ply) then return end
		if !MG_DeveloperGroups[ply:GetUserGroup()] then 
			DarkRP.notify(ply, 1, 4, "Du hast keine Berechtigung dazu, die Bank-Positionen zu speichern!")
			return
		end
		local save = {}
		for _,v in ipairs(ents.FindByClass("itemstore_bank")) do
			local pos = {}
			pos.Pos = v:GetPos()
			pos.Ang = v:GetAngles()
			table.insert(save, pos)
		end
		file.CreateDir("spawns/banks")
		file.Write("spawns/banks/"..string.lower(game.GetMap())..".txt", util.TableToJSON(save))
		DarkRP.notify(ply, 0, 4, "Bänke erfolgreich gespeichert!")
	end)

	local function SpawnBanks()
		local map = string.lower(game.GetMap())
		local data = {}
		if file.Exists("spawns/banks/"..map..".txt", "DATA") then
			data = util.JSONToTable(file.Read("spawns/banks/"..map..".txt"))
		end
		for _,v in pairs(data) do
			local bank = ents.Create("itemstore_bank")
			if !IsValid(bank) then continue end
			bank:SetPos(v.Pos)
			bank:SetAngles(v.Ang)
			bank:Spawn()
		end
		MsgN("[Bank] Alle Bänke wurden erfolgreich erstellt.")
	end

	hook.Add("InitPostEntity", "Banks_Spawn", SpawnBanks)
	hook.Add("PostCleanupMap", "Banks_Spawn", SpawnBanks)
end

if CLIENT then
	local use_font = system.IsWindows() and "Tahoma" or "Verdana"
	surface.CreateFont("itemstore_headinfo", {font = use_font, size = 50, weight = 0, blursize = 0, scanlines = 0})

	local local_ply, distance
	function ENT:Draw()
		self:DrawModel()
	end

	function ENT:DrawTranslucent()
		local_ply = local_ply or LocalPlayer()
		distance = local_ply:EyePos():DistToSqr(self:GetPos())
		if distance > 2890000 then return end
		local text = itemstore.Translate("bank")
		local font = "itemstore_headinfo"
		surface.SetFont(font)
		local textw, texth = surface.GetTextSize(text)
		local w = 5 + textw + 5
		local h = 2 + texth + 2
		local x, y = -w / 2, -h / 2
		local camangle = Angle(0, CurTime() * 45, 90)
		cam.Start3D2D(self:GetPos() + self:GetAngles():Up() * 85, camangle, 0.15)
			surface.SetDrawColor(Color(0, 0, 0, 200))
			surface.DrawRect(x, y, w, h)
			draw.SimpleTextOutlined(text, font, 0, 0, Color(255, 255, 255), TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, Color(0, 0, 0))
		cam.End3D2D()
		camangle:RotateAroundAxis(camangle:Right(), 180)
		cam.Start3D2D(self:GetPos() + self:GetAngles():Up() * 85, camangle, 0.15)
			draw.SimpleTextOutlined(text, font, 0, 0, Color(255, 255, 255), TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, Color(0, 0, 0))
		cam.End3D2D()
	end
end