ENT.Type = "anim"

ENT.PrintName = "Behälter"
ENT.Category = "Inventar"
ENT.Spawnable = false
ENT.RenderGroup = RENDERGROUP_BOTH

function ENT:SetupDataTables()
	self:NetworkVar("Entity", 0, "owning_ent")
end

function ENT:PhysgunPickup(ply)
	return ply:IsAdmin()
end

function ENT:CanTool(ply, trace, mode)
	return mode == "remover" and ply:IsAdmin()
end

if CLIENT then
	local use_font = system.IsWindows() and "Tahoma" or "Verdana"
	surface.CreateFont("mg_entfont", {font = use_font, size = 40, weight = 1000, blursize = 0, antialias = true, shadow = false})
	surface.CreateFont("mg_entfont2", {font = use_font, size = 25, weight = 600, blursize = 0, antialias = true, shadow = false})

	function ENT:Draw()
		self:DrawModel()
	end

	local vector_1 = Vector(0, 0, 1)
	function ENT:DrawTranslucent()
		local ply = LocalPlayer()
		local dist = ply:GetPos():DistToSqr(self:GetPos())
		if dist > 40000 then return end
		local ang = self:GetAngles()	
		local pos = self:GetPos() + (vector_1 * (self:OBBMaxs().z + 5 + math.sin(SysTime() * 2) * 2))
		ang:RotateAroundAxis(ang:Forward(), 90)
		ang:RotateAroundAxis(ang:Right(), -90)
		ang:RotateAroundAxis(ang:Up(), 0)
		cam.Start3D2D(pos, Angle(0, EyeAngles().y - 90, 90), 0.1)
			draw.SimpleTextOutlined(self.PrintName, "mg_entfont", 0, -100, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
			draw.SimpleTextOutlined("Drücke "..((input.LookupBinding("+use") or "[BENUTZEN]"):upper()).." um die Inhalte zu prüfen!", "mg_entfont2", 0, -70, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
		cam.End3D2D()
	end
end

if SERVER then
	AddCSLuaFile()

	ENT.DefaultHealth = itemstore.config.BoxHealth
	ENT.Model = "models/props_c17/FurnitureDrawer001a_Chunk02.mdl"
	ENT.BigEffect = 0
	ENT.EffectHeight = 0
	ENT.ContainerWidth = 1
	ENT.ContainerHeight = 1
	ENT.ContainerPages = 1

	function ENT:Initialize()
		self:SetModel(self.Model)
		self:PhysicsInit(SOLID_VPHYSICS)
		self:SetMoveType(MOVETYPE_VPHYSICS)
		self:SetSolid(SOLID_VPHYSICS)
		self:SetUseType(SIMPLE_USE)
		local phys = self:GetPhysicsObject()
		if IsValid(phys) then
			phys:Wake()
		end
		self.Container = itemstore.Container(self.ContainerWidth, self.ContainerHeight, self.ContainerPages)
		self.Container:SetOwner(self)
		if self.Items then
			for _, item in ipairs(self.Items) do
				self.Container:AddItem(item:Copy())
			end
		end
		local function callback(con, ply)
			return !ply:GetNoDraw() and ply:GetPos():DistToSqr(self:GetPos()) < 62500
		end
		self.Container:AddCallback("read", callback)
		self.Container:AddCallback("write", callback)
		self:SetHealth(self.DefaultHealth)
	end

	function ENT:Use(ply)
		if !ply:IsPlayer() then return end
		if ply.LastUsedEntity then
			if ply.LastUsedEntity[2] > CurTime() then
				return
			end
		end
		ply.LastUsedEntity = {self, CurTime() + 0.25}
		self.Container:Sync()
		ply:OpenContainer(self.Container:GetID(), itemstore.Translate("box"))
	end

	function ENT:Break()
		self:Remove()
	end

	function ENT:OnTakeDamage(dmginfo)
		if !itemstore.config.BoxBreakable then return end
		self:TakePhysicsDamage(dmginfo)
		self:SetHealth(self:Health() - dmginfo:GetDamage())
		if self:Health() <= 0 then
			local ed = EffectData()
			ed:SetOrigin(self:GetPos() + self:GetUp() * self.EffectHeight)
			ed:SetFlags(self.BigEffect)
			util.Effect("effect_box_destroy", ed, true, true)
			self:EmitSound("physics/cardboard/cardboard_box_break"..math.random(1, 3)..".wav")
			self:Break()
		end
	end

	function ENT:OnRemove()
		self.Container:Remove()
	end
end