ENT.Type = "anim"
ENT.RenderGroup = RENDERGROUP_TRANSLUCENT

function ENT:SetItem(item)
	self.Item = item
	if SERVER then
		self:Sync()
	end
end

function ENT:GetItem()
	return self.Item
end

if SERVER then
	AddCSLuaFile()

	function ENT:Initialize()
		local item = self:GetItem()
		if !item then self:Remove() end
		self:SetModel(item:GetModel())
		self:PhysicsInit(SOLID_VPHYSICS)
		self:SetSolid(SOLID_VPHYSICS)
		self:SetMoveType(MOVETYPE_VPHYSICS)
		self:SetCollisionGroup(COLLISION_GROUP_WEAPON)
		self:SetUseType(SIMPLE_USE)
		self:SetColor(item:GetColor() or color_white)
		self:SetMaterial(item:GetMaterial())
		local phys = self:GetPhysicsObject()
		if !IsValid(phys) then
			self:PhysicsInitSphere(16, "default")
			phys = self:GetPhysicsObject()
		end
		phys:Wake()
	end

	function ENT:Use(ply)
		if !ply:IsPlayer() then return end
		local item = self:GetItem()
		if !item then return end
		if ply.Inventory and ply.Inventory:AddItem(item) then
			ply:EmitSound("items/itempickup.wav")
			self:Remove()
		else
			ply:SendError("Dein Inventar ist voll.")
		end
	end

	function ENT:Sync(ply)
		local item = self:GetItem()
		if !item then return end
		net.Start("ItemStore_SyncItem")
			net.WriteEntity(self)
			net.WriteString(item.Class)
			net.WriteTable(item.Data)
		net.Send(ply or player.GetAll())
	end

	util.AddNetworkString("ItemStore_SyncItem")
	net.Receive("ItemStore_SyncItem", function(len, ply)
		local ent = net.ReadEntity()
		if !IsValid(ent) then return end
		ent:Sync(ply)
	end)
end

if CLIENT then
	function ENT:Initialize()
		net.Start("ItemStore_SyncItem")
			net.WriteEntity(self)
		net.SendToServer()
	end

	function ENT:DrawTranslucent()
		local item = self:GetItem()
		if !item then return end
		item:PreRender(self)
		self:DrawModel()
		item:PostRender(self)
	end

	net.Receive("ItemStore_SyncItem", function()
		local ent = net.ReadEntity()
		if !IsValid(ent) then return end
		if !ent.SetItem then return end
		local class = net.ReadString()
		local data = net.ReadTable()
		ent:SetItem(itemstore.Item(class, data))
	end)
end