if SERVER then
	util.AddNetworkString("ItemStore_AdminInventory")
	net.Receive("ItemStore_AdminInventory", function(len, admin)
		if !admin:IsSuperAdmin() then return end
		local ply = net.ReadEntity()
		if !IsValid(ply) or !ply:IsPlayer() or !ply.InventoryLoaded then return end
		ply.Inventory:SetPermissions(admin, true, true)
		ply.Inventory:Sync(admin)
		admin:OpenContainer(ply.Inventory:GetID(), itemstore.Translate("players_inventory", ply:Name()), false, true)
	end)

	util.AddNetworkString("ItemStore_AdminBank")
	net.Receive("ItemStore_AdminBank", function(len, admin)
		if !admin:IsSuperAdmin() then return end
		local ply = net.ReadEntity()
		if !IsValid(ply) or !ply:IsPlayer() or !ply.BankLoaded then return end
		ply.Bank:SetPermissions(admin, true, true)
		ply.Bank:Sync(admin)
		admin:OpenContainer(ply.Bank:GetID(), itemstore.Translate("players_bank", ply:Name()), false, true)
	end)

	util.AddNetworkString("ItemStore_AdminOfflineInventory")
	net.Receive("ItemStore_AdminOfflineInventory", function(len, admin)
		if !admin:IsSuperAdmin() then return end
		local steamid = net.ReadString()
		itemstore.data.GetInventory(steamid, function(data)
			if !IsValid(admin) then return end
			admin:PrintMessage(HUD_PRINTCONSOLE, "Inventar von: "..steamid)
			admin:PrintMessage(HUD_PRINTCONSOLE, "\n")
			if data then
				for k, v in ipairs(data) do
					admin:PrintMessage(HUD_PRINTCONSOLE, "Slot "..(v.slot or 0)..": "..v.class)
					admin:PrintMessage(HUD_PRINTCONSOLE, "Dat: "..v.data)
				end
			else
				admin:PrintMessage(HUD_PRINTCONSOLE, "LEER")
			end
			admin:ChatPrint("Gehe in deine Konsole.")
		end)
	end)

	util.AddNetworkString("ItemStore_AdminOfflineBank")
	net.Receive("ItemStore_AdminOfflineBank", function(len, admin)
		if !admin:IsSuperAdmin() then return end
		local steamid = net.ReadString()
		itemstore.data.GetBank(steamid, function(data)
			if !IsValid(admin) then return end
			admin:PrintMessage(HUD_PRINTCONSOLE, "Lager von: "..steamid)
			admin:PrintMessage(HUD_PRINTCONSOLE, "\n")
			if data then
				for k, v in ipairs(data) do
					admin:PrintMessage(HUD_PRINTCONSOLE, "Slot "..(v.slot or 0)..": "..v.class)
					admin:PrintMessage(HUD_PRINTCONSOLE, "Dat: "..v.data)
				end
			else
				admin:PrintMessage(HUD_PRINTCONSOLE, "LEER")
			end
			admin:ChatPrint("Gehe in deine Konsole.")
		end)
	end)

	local function ResetPlayer(ply)
		if !IsValid(ply) or !ply:IsPlayer() or !ply.InventoryLoaded or !ply.BankLoaded then return end
		for k, v in pairs(ply.Inventory:GetItems()) do
			ply.Inventory:SetItem(k, nil)
		end
		for k, v in pairs(ply.Bank:GetItems()) do
			ply.Bank:SetItem(k, nil)
		end
		itemstore.data.Save(ply)
	end

	util.AddNetworkString("ItemStore_ResetPlayer")
	net.Receive("ItemStore_ResetPlayer", function(len, admin)
		if !admin:IsSuperAdmin() then return end
		ResetPlayer(net.ReadEntity())
		DarkRP.notify(admin, 0, 3, "Spieler erfolgreich zurückgesetzt!")
	end)

	util.AddNetworkString("ItemStore_ResetSteamID")
	net.Receive("ItemStore_ResetSteamID", function(len, admin)
		if !admin:IsSuperAdmin() then return end
		local sid = net.ReadString()
		sid = string.upper(string.Trim(sid))
		if sid:match("^(STEAM_[0-9]+:[0-9]+:[0-9]+)$") then
			local ply = player.GetBySteamID(sid)
			if ply then
				ResetPlayer(ply)
			else
				itemstore.data.Run("ResetInventory", sid)
				itemstore.data.Run("ResetBank", sid)
			end
			DarkRP.notify(admin, 0, 3, "Spieler erfolgreich zurückgesetzt!")
		else
			DarkRP.notify(admin, 1, 3, "Diese SteamID ist ungültig!")
		end
	end)
end

if CLIENT then
	local adminmenu
	concommand.Add("inventory_admin", function(ply)
		if !ply:IsSuperAdmin() then return end
		if IsValid(adminmenu) then adminmenu:Close() end
		adminmenu = vgui.Create("ItemStoreAdmin")
		adminmenu:SetSize(200, 300)
		adminmenu:Center()
		adminmenu:MakePopup()
	end)
end