local commands = {}
if SERVER then
	function PROVIDER:AddCommand(command, info, func)
		table.insert(commands, {Name = command, Function = func})
	end

	if itemstore.config.EnableInvholster then
		PROVIDER:AddCommand("invholster", nil, function(ply, args)
			if !ply.InventoryLoaded then return end
			if (ply.ItemStore_HurtLastTime or 0) + itemstore.config.HurtPreventPickupTime > CurTime() then DarkRP.notify(ply, 1, 5, "Du musst "..math.ceil(ply.ItemStore_HurtLastTime + itemstore.config.HurtPreventPickupTime - CurTime()).." Sekunden warten, bevor du etwas ins Inventar stecken kannst!\nDu bist in einem Kampf verwickelt.") return end
			if ply.ItemStore_InvHolster then DarkRP.notify(ply, 1, 5, "Du legst deine derzeitige Waffe gerade ins Inventar!") return end
			local wep = ply:GetActiveWeapon()
			if !wep:IsValid() then DarkRP.notify(ply, 1, 4, "Du hast keine Waffe ausgerüstet!") return end
			local class = wep:GetClass()
			if GAMEMODE.Config.restrictdrop then
				local found = false
				for _,v in pairs(CustomShipments) do
					if v.entity == class then
						found = true
						break
					end
				end
				if !found then DarkRP.notify(ply, 1, 4, DarkRP.getPhrase("cannot_drop_weapon")) return end
			end
			local canDrop = hook.Call("canDropWeapon", GAMEMODE, ply, wep)
			if !canDrop then
				DarkRP.notify(ply, 1, 4, DarkRP.getPhrase("cannot_drop_weapon"))
				return ""
			end
			local con = ply.Inventory
			local item = itemstore.Item("spawned_weapon")
			item:SetData("Class", class)
			item:SetData("Amount", 1)
			if !con:CanFit(item) then DarkRP.notify(ply, 1, 4, "Dein Inventar ist voll!") return end
			if ply:isWanted() then DarkRP.notify(ply, 1, 5, "Du kannst nichts in dein Inventar aufnehmen, wenn du gesucht bist!") return end
			if !ply:OnGround() and ply:GetMoveType() != MOVETYPE_WALK then DarkRP.notify(ply, 1, 5, "Du musst dich auf dem Boden befinden, um etwas in dein Inventar aufzunehmen!") return end
			if hook.Run("ItemStoreCanPickup", ply, item) == false then return end
			ply.ItemStore_InvHolster = true
			if itemstore.config.DeveloperTools then
				ply:SetNWInt("ItemStore_DoAction", 2)
			end
			ply:DelayItemStoreAction(itemstore.config.InvHolsterSpeed, itemstore.config.ActionSpeed, itemstore.Translate("invholster")..": "..(wep:GetPrintName() or wep:GetClass()), function()
				ply.ItemStore_InvHolster = nil
				if !con:CanFit(item) then DarkRP.notify(ply, 1, 4, "Dein Inventar ist voll!") return end
				if ply:isWanted() then DarkRP.notify(ply, 1, 5, "Du kannst nichts in dein Inventar aufnehmen, wenn du gesucht bist!") return end
				if hook.Run("ItemStoreCanPickup", ply, item) == false then return end
				local wep2 = ply:GetActiveWeapon()
				if !wep2:IsValid() then DarkRP.notify(ply, 1, 4, "Du hast keine Waffe ausgerüstet!") return end
				if wep != wep2 then DarkRP.notify(ply, 1, 4, "Waffe gewechselt. Prozess abgebrochen!") return end
				item:SetData("Model", wep:GetModel())
				item:SetData("Clip1", wep:Clip1())
				item:SetData("Clip2", wep:Clip2())
				if itemstore.config.InvHolsterTakesAmmo then
					local ammotype = wep:GetPrimaryAmmoType()
					if ammotype != -1 then
						if hook.Run("ItemStoreCustomAmmoSplit", ply, wep, item) != true then
							local ammo = ply:GetAmmoCount(ammotype)
							item:SetData("Ammo", ammo)
							ply:RemoveAmmo(ammo, ammotype)
						end
					end
				end
				ply:EmitSound("items/gunpickup2.wav", 70)
				DarkRP.notify(ply, 0, 4, "Waffe ins Inventar gelegt.")
				hook.Run("ItemStorePickUpWeapon", ply, wep, item)
				con:AddItem(item)
				ply:StripWeapon(wep2:GetClass())
			end, function()
				ply.ItemStore_InvHolster = nil
			end)
		end)

		hook.Add("PlayerSwitchWeapon", "ItemStore_InvHolster",  function(ply, old, new)
			if old != new and ply.ItemStore_InvHolster then
				ply:AbortItemStoreActions()
			end
		end)
	end
end

function PROVIDER:Load()
	DarkRP.declareChatCommand({command = "pickup", description = "Picks up the item in front of you.", delay = 1})
	DarkRP.declareChatCommand({command = "inv", description = "Shows the inventory.", delay = 1})
	if itemstore.config.EnableInvholster then
		DarkRP.declareChatCommand({command = "invholster", description = "Holsters your current weapon in the inventory.", delay = 1.5})
	end
	if SERVER then
		for _,v in ipairs(commands) do
			DarkRP.defineChatCommand(v.Name, v.Function)
		end
	end
end