itemstore.gamemodes = {}

PROVIDER = {}

include("gamemodeproviders/"..itemstore.config.GamemodeProvider..".lua")

if SERVER then
	AddCSLuaFile("gamemodeproviders/"..itemstore.config.GamemodeProvider..".lua")
end

itemstore.gamemodes.Provider = PROVIDER

PROVIDER = nil

assert(itemstore.gamemodes.Provider, "[Inventory] Gamemode not found!")

function itemstore.gamemodes.Run(func_name, ...)
	local func = itemstore.gamemodes.Provider[func_name]
	if !func then return end

	return func(itemstore.gamemodes.Provider, ...)
end

if SERVER then
	function itemstore.gamemodes.AddCommand(command, info, func)
		return itemstore.gamemodes.Run("AddCommand", command, info, func)
	end

	itemstore.gamemodes.AddCommand("inv", "Opens your inventory.", function(ply)
		ply:OpenContainer(ply.Inventory:GetID(), itemstore.Translate("inventory"), true)
		return ""
	end)

	itemstore.gamemodes.AddCommand("pickup", "Picks up an item.", function(ply)
		ply:PickupItem()
		return ""
	end)
end

hook.Add("PostGamemodeLoaded", "ItemStore_GamemodeLoad", function()
	itemstore.gamemodes.Run("Load")
end)