ITEM.Name = "DarkRP Item"
ITEM.Model = "models/error.mdl"
ITEM.Base = "base_entity"
ITEM.UseSpeed = 1
ITEM.DropSpeed = 1

ITEM.DontNetwork = {
	EntityData = true
}

function ITEM:SaveData(ent)
	self:SetModel(ent:GetModel())
	self:SetData("EntityData", ent.DarkRPItem)
end

function ITEM:CanPickup(ply, ent)
	if !ent.Getowning_ent then return true end
	if !itemstore.config.IgnoreOwner and ent:Getowning_ent() != ply then
		ply:ChatPrint("Du kannst das nicht aufheben, da es nicht dir gehört!")
		return false
	end
	return true
end

function ITEM:CanDrop(ply)
	local tbl = self:GetData("EntityData")
	if !tbl then return end
	if ply:customEntityLimitReached(tbl) then
		DarkRP.notify(ply, 1, 4, DarkRP.getPhrase("limit", tbl.name))
		return false
	end
end

function ITEM:LoadData(ent, ply)
	ent.DarkRPItem = self:GetData("EntityData")
	if ent.DarkRPItem and IsValid(ply) then
		ent.SID = ply.SID
		ply:addCustomEntity(ent.DarkRPItem)
	end
end